#include <QtGui>
#include <QtCore>
#include <QDebug>
#include <math.h>
#include "glwidget.h"
#include <GLES2/gl2.h>
#include <vector>
#include <stdlib.h>
#include <mce/dbus-names.h>
#include <mce/mode-names.h>
#include <fstream>
#include <string>
#include <sstream>
#include "helper.h"
#define FLOAT2X(f)      ((int) ( (f) * (65536)))
#define X2FLOAT(x)      ((float)(x) / 65536.0f)
#define f2vt(f)     FLOAT2X(f)
#define vt2f(x)     X2FLOAT(x)
#define q_vertexType GLfloat
#define q_vertexTypeEnum GL_FLOAT
using namespace std;

static QDBusConnection dBusConnection = QDBusConnection::systemBus();

void GLWidget::mousePressEvent(QMouseEvent *event) {
	showQuitButton = !showQuitButton;
	if(showQuitButton) {
		quitButton->hide();
	}
	else quitButton->show();	
}

void GLWidget::mouseReleaseEvent(QMouseEvent *event) {
	yRot = -1 * mx - event->globalX();
	xRot = my - event->globalY();
}

void GLWidget::mouseMoveEvent(QMouseEvent *event) {
	yRot = -1 * mx - event->globalX();
   	xRot = my - event->globalY();
}

void GLWidget::getOrientation() {
	QFile f("/sys/class/i2c-adapter/i2c-3/3-001d/coord");
	if(f.exists() &&  f.open(QIODevice::ReadOnly | QIODevice::Text)) {
		QByteArray line = f.readLine();
		QRegExp re("([0-9-]+) ([0-9-]+) ([0-9-]+)");
		re.indexIn(line);
		int x = re.cap(1).toInt();
		int y = re.cap(2).toInt();
		xax = x ; //atan2((float) x, (float) -y);
		yax = y ;//atan2((float) y, (float) -z);
		//pitch = (pitch * 180/M_PI)*-1;
		//roll = (roll * 180/M_PI) + 90;
		f.close();
	}
	
}


void GLWidget::keyPressEvent(QKeyEvent *event) {
	if(!event->isAutoRepeat()) {
		if(event->text() == "w")
			kaasupohjassa = true;
		if(event->text() == "e") {
			noukkiminen = true;
			keyIndex = 15;
		}
		if(lopussa && (event->text() == "q")) {
			keskeytetty = false;
			pauseGame();
			hideGame();
		}
	}
}

void GLWidget::keyReleaseEvent(QKeyEvent *event) {
	if(!event->isAutoRepeat()) {
		if(event->text() == "w")
			kaasupohjassa = false;
		if(event->text() == "e")
			noukkiminen = false;
	}
}


GLWidget::GLWidget(QMainWindow *parent) : QGLWidget(parent) {
	tempArray = new GLfloat[16];
	first_draw = true;
	setAutoFillBackground(false);
	setAutoBufferSwap(false);
	isAlussa = true;
	qDBusInterface = new QDBusInterface(MCE_SERVICE, MCE_REQUEST_PATH, 
			MCE_REQUEST_IF, dBusConnection, this);	
	dBusConnection.connect(MCE_SERVICE, MCE_SIGNAL_PATH, MCE_SIGNAL_IF,
			MCE_DISPLAY_SIG, this, SLOT(displayStateChanged(const QDBusMessage &)));
	qDBusInterface->callWithCallback(MCE_DISPLAY_STATUS_GET, QList<QVariant>(), this,
			SLOT(setDisplayState(QString)), SLOT(displayStateError(QDBusError)));	

	timer = new QTimer(this);
	connect(timer, SIGNAL(timeout()), this, SLOT(paivita()));
	QTimer *avoiding = new QTimer(this);
	aikaKello = new QTimer(this);
	connect(avoiding, SIGNAL(timeout()), this, SLOT(avoidScreensaver()));
	connect(aikaKello, SIGNAL(timeout()), this, SLOT(lisaaAikaa()));
	
	avoiding->start(30000);
	bestlap = 999.999;
	keyIndex = 0;
	QHBoxLayout *layout = new QHBoxLayout(this);
	quitButton = new QPushButton("Back to Menu", this);
	layout->addWidget(quitButton);
	this->setLayout(layout);
	quitButton->hide();
	showQuitButton = false;	
	connect(quitButton, SIGNAL(clicked()), this, SLOT(hideGame()));		
	frames = 0;	
}

void GLWidget::newGame() {
	isAlussa = false;
	keskeytetty = true;	
	showQuitButton = false;
	quitButton->hide();
	grabKeyboard();	
	keyIndex = 0;
	lopussa = true;
	frames = 0;
	kaasupohjassa = false;
	noukkiminen = false;
	speed = 0;
	aX = aZ = 40.0f;
	aY = 5.0f;
	eta = 20.0f;
	xPos = zPos = suuntaX = suuntaY = xRot = yRot = zRot = 0.0f;
	//xPos = 60.0;
	//zPos = 60.0;
	suuntaX = 40.0f;
	s1 = s2 = 0.0f;
	lopussa = false;	
	//sienien arvonnat ja lisays
	sienipaikat.clear();
	for(int i = 0; i<22;i++) {
		sPaikka tmp;
		tmp.x = (float)(qrand() % 380+10.0f);
		tmp.z = (float)(qrand() % 380+10.0f);
		tmp.y = qRed(qim.pixel(tmp.x, tmp.z))/255.0f*100+5.0f;
		tmp.s = (float)(qrand() % 800 / 100.0f+1.8f);
		sienipaikat.push_back(tmp);
	}
	ajankesto = 0;
	resumeGame();
}



GLWidget::~GLWidget() {
	md2->FreeModel(&modelfile);
	free(timer);	
	free(sieni);
	glDeleteBuffers(2, tbuffers);
	glDeleteTextures(1, textures);
}

void GLWidget::avoidScreensaver() {
	dBusConnection.call(QDBusMessage::createMethodCall(MCE_SERVICE, MCE_REQUEST_PATH,
		MCE_REQUEST_IF, MCE_PREVENT_BLANK_REQ)); 
}

void GLWidget::paivita() {
	getOrientation();
	s1 += 0.1f;
	s2 -= 0.3f;
		
	suuntaX -= xax*0.01;
	kaasupohjassa ? speed = 1.3f : speed *= 0.7f;
	try {
		 aY = qRed(qim.pixel(aX, aZ))/255.0f*100+5.0f;
	}	
	catch (exception ex) {
		aY = yPos = 6.0f;
	}
	aX -= cos(-suuntaX*M_PI/180)*speed;
	aZ -= sin(-suuntaX*M_PI/180)*speed;

	update();


	//sienien tarkistus
	
	
	for(list<sPaikka>::iterator pos = sienipaikat.begin(); pos!=sienipaikat.end(); ++pos) {
		if(noukkiminen && keyIndex == 20 && aX-8.0f < pos->x && aX + 8.0f > pos->x && aZ - 8.0f < pos->z && aZ + 8.0f > pos->z) {
			sienipaikat.erase(pos);
			break;
		}
	}

}

void GLWidget::initializeGL()
    {
	qDebug() << "initialize()";
	Vertex *vpc = new Vertex[40*40];
	QString fname = ":/textures/dpng.png";
	qim = QImage(fname);
	QString nfname = ":/textures/dpngn.png";
	QImage qnmap = QImage(nfname);
	textures = new GLuint[2];		
	tbuffers = new GLuint[2];
	glGenBuffers(2, &tbuffers[0]);
	string nammi = "/opt/mushrooms/md2model.md2";
	string nammitexture = ":/textures/nainen.jpg";
	md2 = new MD2Model();
	md2->ReadMD2Model(nammi.c_str(), nammitexture.c_str(), &modelfile);
	md2->DumpData(&modelfile);
	
	
	
	for(int z=0;z<40;z++) {
		for(int x=0; x<40; x++) {
			vpc[z*40+x].x = (float)x*10;
			vpc[z*40+x].y = qRed(qim.pixel(x*10, z*10))/255.0f*100;
			vpc[z*40+x].z = (float)z*10;
			vpc[z*40+x].u = (x*10)/80.0f;
			vpc[z*40+x].v = (z*10)/80.0f;
			vpc[z*40+x].nx = qRed(qnmap.pixel(x*10, z*10));
			vpc[z*40+x].ny = qGreen(qnmap.pixel(x*10, z*10));
			vpc[z*40+x].nz = qBlue(qnmap.pixel(x*10, z*10));
		}
	}
	
	uint *indices = new uint[(40*2)*(40-1)+(40-2)];
	int index = 0;
	for ( int z = 0; z < (40 - 1); z++ ) {	
		if ( z % 2 == 0 ) {
			int x;
			for ( x = 0; x < 40; x++ ) {
				indices[index++] = x + (z * 40); 
				indices[index++] = x + (z * 40) + 40;
			}
			if ( z != (40 - 2)) {
				indices[index++] = --x + (z * 40);
			}																
		}
		else {
			int x;
			for ( x = (40-1); x >= 0; x-- ) {
				indices[index++] = x + (z * 40);
				indices[index++] = x + (z * 40) + 40;
			}
			if ( z != (40-2)) {
				indices[index++] = ++x + (z * 40);
			}
		}
	}

	glBindBuffer(GL_ARRAY_BUFFER, tbuffers[0]);
	glBufferData(GL_ARRAY_BUFFER, 40*40*sizeof(Vertex), vpc, GL_STATIC_DRAW);
	glBindBuffer(GL_ARRAY_BUFFER, 0);
	free(vpc);

	
	glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, tbuffers[1]);
	glBufferData(GL_ELEMENT_ARRAY_BUFFER, sizeof(uint)*index, indices, GL_STATIC_DRAW);
	glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, 0);
	free(indices);	
		
	QImage bufi;
	bufi.load(QString(":/textures/grass.jpg"));
	textImage = QGLWidget::convertToGLFormat(bufi);	
	glGenTextures(2, textures);
	glBindTexture(GL_TEXTURE_2D, textures[0]);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
	glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, textImage.height(), textImage.width(), 0, GL_RGBA, GL_UNSIGNED_BYTE, textImage.bits());
	glBindTexture(GL_TEXTURE_2D, 0);	
	
	/*toinen textuuri*/
	bufi.load(QString(";/textures/sieni.png"));
	textImage = QGLWidget::convertToGLFormat(bufi);
	glBindTexture(GL_TEXTURE_2D, textures[1]);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, textImage.height(), textImage.width(), 0, GL_RGBA, GL_UNSIGNED_BYTE, textImage.bits());
	glBindTexture(GL_TEXTURE_2D, 0);	
	


	
	string name = ":/models/sieni.obj";
	string textname = ":/textures/sieni.png";
	sieni = new Model(name.c_str(), textname.c_str());
	
	pmitta = index;

	glEnable(GL_DEPTH_TEST);
	
	GLuint vshader = glCreateShader(GL_VERTEX_SHADER);
		const char *vsrc[1] = {
			"attribute mediump vec4 vertex;\n"
			"attribute mediump vec2 texture; \n"
			"attribute mediump vec3 normaali; \n"
			
			"varying mediump vec2 v_tex; \n"
			"uniform mediump mat4 matrix;\n"
			"uniform mediump mat4 projection; \n"
			"uniform mediump float scale; \n"
			
       		"void main()                 \n"
       		"{                           \n"
       		"   	mat4 paikka = projection*matrix; \n"
		"	vec4 apu = vertex;		\n"
		"	apu.xyz *= scale;			\n"
		"					\n"
		"	gl_Position =paikka*apu;		\n"
		"			\n"
		"	\n"
		" 	v_tex = texture;				\n"
       		"}                           \n"
		};

		glShaderSource(vshader, 1, vsrc, 0);
		glCompileShader(vshader);
		GLuint fshader = glCreateShader(GL_FRAGMENT_SHADER);
		const char *fsrc[1] = {
		"varying mediump vec2 v_tex;                    \n"
		"       uniform sampler2D sampler;                      \n"
		"void main()                                \n"
		"{                                          \n"
		" mediump vec4 color = texture2D(sampler, v_tex); \n"
                " gl_FragColor = color;     \n"
		"}\n"
		};
		glShaderSource(fshader, 1, fsrc, 0);
		glCompileShader(fshader);
		program = glCreateProgram();
		glAttachShader(program, vshader);
		glAttachShader(program, fshader);
		glLinkProgram(program);
		
		
		GLint compiled;
		glGetShaderiv(vshader, GL_COMPILE_STATUS, &compiled);
		if(!compiled)
		{
			GLint infoLen = 0;
			glGetShaderiv(vshader, GL_INFO_LOG_LENGTH, &infoLen);
			if(infoLen > 1)
			{
				char* infoLog = (char*)malloc(sizeof(char) * infoLen);
				glGetShaderInfoLog(vshader, infoLen, NULL, infoLog);
				qDebug() << infoLog;
				free(infoLog);
			}
		}
	

		glGetShaderiv(fshader, GL_COMPILE_STATUS, &compiled);
		if(!compiled)
		{
			GLint infoLen = 0;
			glGetShaderiv(fshader, GL_INFO_LOG_LENGTH, &infoLen);
			if(infoLen > 1)
			{
				char* infoLog = (char*)malloc(sizeof(char) * infoLen);
				glGetShaderInfoLog(fshader, infoLen, NULL, infoLog);
				qDebug() << infoLog;
				free(infoLog);
			}
		}
	
		
		GLint linked;
		glGetProgramiv(program, GL_LINK_STATUS, &linked);
		if(!linked)
		{
			GLint infoLen = 0;
			glGetProgramiv(program, GL_INFO_LOG_LENGTH, &infoLen);
			if(infoLen > 1)
			{
				char* infoLog = (char*)malloc(sizeof(char) * infoLen);
				glGetProgramInfoLog(program, infoLen, NULL, infoLog);
				qDebug() << infoLog;
				free(infoLog);
			}
		}
		
		
		
		matrix = glGetUniformLocation(program, "matrix");
		projectionU = glGetUniformLocation(program, "projection");
		scale = glGetUniformLocation(program, "scale");	
		
		QTime ftime(0,0,0);
		qsrand(ftime.secsTo(QTime::currentTime()));


		//sienien arvonnat ja lisays
		for(int i = 0; i<50;i++) {
			sPaikka tmp;
			tmp.x = (float)(qrand() % 380+10.0f);
			tmp.z = (float)(qrand() % 380+10.0f);
			tmp.y = qRed(qim.pixel(tmp.x, tmp.z))/255.0f*100+5.0f;
			tmp.s = (float)(qrand() % 800 / 100.0f+1.8f);
			sienipaikat.push_back(tmp);
		}
	
		qDebug() << "glwidget";
			
    }



void GLWidget::resizeGL(int w, int h) {
	glViewport(0,0, (GLint)w, (GLint)h); 
	projection = new GLfloat[16];
	BuildPerspProjMat(projection, 3.141/4.0f, this->width()/this->height(), -1.0f, 1000.0f);
	}

void GLWidget::paintEvent(QPaintEvent *event) {
	QPainter painter;
	painter.begin(this);
	makeCurrent();
	glClearColor(0.2f, 0.2f, 0.8f, 1.0f);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glEnable(GL_DEPTH_TEST);
	GLfloat modelview[16];
	LookAt(modelview, 0, 0, 0, 60, 50, 0, 0, 1, 0);
	glUseProgram(program);
//projection
	glUniformMatrix4fv(projectionU, 1, GL_FALSE, projection);
	RotateMatrix(modelview, -12, 0, 0, 1);
	TranslateMatrix(modelview, -40,-30,0);	
	RotateMatrix(modelview, -suuntaX, 0,1,0);
	TranslateMatrix(modelview, -aX, -aY-10, -aZ);
		
	glUniformMatrix4fv(matrix, 1, GL_FALSE, modelview);
	glUniform1f(scale, 1.0);

	Plane();
		
  {GLenum error = glGetError();
	   if(error != GL_NO_ERROR) {
	        qDebug() << error << "toka";
	  }}
		
	for(list<sPaikka>::iterator pos = sienipaikat.begin(); pos!=sienipaikat.end(); ++pos ) {
		memcpy(tempArray, modelview, sizeof(GLfloat)*16);
		TranslateMatrix(modelview, pos->x, pos->y,pos->z);
		RotateMatrix(modelview, -0.0f, 1, 0, 0);
		glUniform1f(scale, pos->s);
		glUniformMatrix4fv(matrix, 1, GL_FALSE, modelview);	
		sieni->render(program);
		memcpy(modelview, tempArray, sizeof(GLfloat)*16);
	}
	
	
	TranslateMatrix(modelview, aX,aY,aZ);
	RotateMatrix(modelview, 90+suuntaX, 0.0, 1.0, 0.0);
	RotateMatrix(modelview, -90, 1, 0, 0);
	glUniform1f(scale, 0.6);
	glUniformMatrix4fv(matrix, 1, GL_FALSE, modelview);
	md2->RenderBuffers(keyIndex, program);
			
	

	if (!(frames % 100)) {
	       	time.start();
        	frames = 0;
    	}
	if(!(frames % 3)) {
		if(kaasupohjassa) {
			if(keyIndex < 13) {
				keyIndex++;
			}
			else keyIndex = 0;
		}
		if(noukkiminen) {
			if(keyIndex < modelfile.header.num_frames-1) {
				keyIndex++;
			}
			else keyIndex = 15;
		}
	}
	
	frames++;	
  
	glDisable(GL_DEPTH_TEST);	
	QString framesPerSecond;
	QString keratyt;
	QString aikas;
	
	framesPerSecond.setNum(frames /(time.elapsed() / 1000.0), 'f', 2);
	keratyt.setNum(22-sienipaikat.size());
	aikas.setNum(ajankesto);
	painter.drawText(QPointF(550, 30), keratyt + "/20");
	painter.drawText(QPointF(400, 30), aikas+ "s"); 
	painter.drawText(QPointF(20, 30), framesPerSecond + " fps");
	
	
	if(sienipaikat.size() <= 2) {
		if(!lopussa) {
			pauseGame();
			lopussa = true;
		}
		QString teodi;
		teodi.setNum(ajankesto);		
		painter.drawText(QPoint(80, 220), "Game Over");
		painter.drawText(QPoint(80, 250), "Press 'q' to return");
		painter.drawText(QPoint(80, 300), "Time "+ teodi);

	}
	painter.end();
	swapBuffers();
}
	


void GLWidget::Plane() {
	glBindTexture(GL_TEXTURE_2D, textures[0]);
	glEnableVertexAttribArray(0);
	glEnableVertexAttribArray(1);	
	glEnableVertexAttribArray(2);
	glBindBuffer(GL_ARRAY_BUFFER, tbuffers[0]);
	glVertexAttribPointer(0, 3, GL_FLOAT, GL_FALSE, sizeof(Vertex), ((char *)NULL + (0)));
	glVertexAttribPointer(1, 2, GL_FLOAT, GL_FALSE, sizeof(Vertex), ((char *)NULL + (sizeof(float)*3)));
	glVertexAttribPointer(2, 3, GL_FLOAT, GL_FALSE, sizeof(Vertex), ((char *)NULL + (sizeof(float)*5)));

	glBindAttribLocation(program, 0, "vertex");
	glBindAttribLocation(program, 1, "texture");
	glBindAttribLocation(program, 2, "normaali");
	glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, tbuffers[1]);
	
	glDrawElements(GL_TRIANGLE_STRIP, pmitta, GL_UNSIGNED_INT, (GLvoid *)((char *)NULL));
	glBindTexture(GL_TEXTURE_2D, 0);
	glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, 0);
	glBindBuffer(GL_ARRAY_BUFFER, 0);
	glDisableVertexAttribArray(0);
	glDisableVertexAttribArray(1);
	glDisableVertexAttribArray(2);
	
}
	

void GLWidget::hideGame() {
	releaseKeyboard();
	pauseGame();
	emit onClose();
}

void GLWidget::displayStateError(const QDBusError &error) {
	return;
}

void GLWidget::displayStateChanged(const QDBusMessage &message) {
	QString state = message.arguments().at(0).toString();
	setDisplayState(state);
}

void GLWidget::setDisplayState(const QString &state) {
	if(!state.isEmpty()) {
		if(state == MCE_DISPLAY_ON_STRING) {
			if(!isAlussa) resumeGame();
		}
		else if(state == MCE_DISPLAY_OFF_STRING) {
			pauseGame();
		}
	}
}

void GLWidget::resumeGame() {
	timer->start(20);	
	aikaKello->start(1000);
	
}
void GLWidget::pauseGame() {
	timer->stop();
	aikaKello->stop();
}

void GLWidget::lisaaAikaa() {
	ajankesto++;
}
bool GLWidget::event(QEvent *event) {
	if(event->type() == QEvent::Leave) {
		if(!this->isHidden()) pauseGame();
	}
	else if(event->type() == QEvent::Enter) {
		resumeGame();
	}
	return QGLWidget::event(event);
}

