#include <QtCore>
#include <QtGui>
#include <QDebug>
#include "mushhigh.h"
#include <QtSql>

MushHigh::MushHigh(QWidget *parent) : QWidget(parent, Qt::Window) {
	setupUi(this);

	tableView->setColumnWidth(0, 200);
	tableView->setColumnWidth(1, 400);
	connect(backButton, SIGNAL(clicked()), this, SLOT(close()));

}

void MushHigh::showResults() {
	
	QSqlQueryModel *model = new QSqlTableModel;
	QSqlDatabase db = QSqlDatabase::addDatabase("QSQLITE", "tulokset");
	db.setDatabaseName("/home/user/.config/mushroomhigh.db");
	if(!db.open()) {
	}
	model->setQuery("select * from tulokset order by pisteet ASC", db);
	model->setHeaderData(0, Qt::Horizontal, "Time");
	model->setHeaderData(1, Qt::Horizontal, "Name");
	QSqlError err = db.lastError().text();
	//qDebug() << err << "doo";
	tableView->setModel(model);	
	db.close();
	
}

MushHigh::~MushHigh() {
	QSqlDatabase::database("tulokset").close();
	QSqlDatabase::removeDatabase("tulokset");
}

