#include <QtCore>
#include <QtGui>
#include "mushmain.h"


MushMain::MushMain(QMainWindow *parent) {
	setupUi(this);
	this->setAttribute(Qt::WA_Maemo5StackedWindow);
	connect(startButton, SIGNAL(clicked()), this, SLOT(start()));
	connect(quitButton, SIGNAL(clicked()), this, SLOT(close()));
	connect(highButton, SIGNAL(clicked()), this, SLOT(openHighScores()));
	w = new QMainWindow();
	g = new GLWidget();
	w->setAttribute(Qt::WA_DeleteOnClose);	
	w->setAttribute(Qt::WA_Maemo5StackedWindow);
	w->setCentralWidget(g);


	w->setMinimumSize(QSize(800, 460));
	//g->show();	
	connect(g, SIGNAL(onClose()), this, SLOT(gameEnd()));
	mh = new MushHigh(this);
	mh->setAttribute(Qt::WA_Maemo5StackedWindow);
	md = new MushDialog(this, Qt::Dialog);
	connect(md->okButton, SIGNAL(clicked()), this, SLOT(saveScore()));

	QSqlDatabase db = QSqlDatabase::addDatabase("QSQLITE", "tulosdb");
	db.setDatabaseName("/home/user/.config/mushroomhigh.db");
	if(!db.open()) {
		//qDebug() << "unable to open database";
	}
	QSqlQuery query(db);
	QSqlError err;
	query.exec("select name from sqlite_master where type='table' and name='tulokset';");
	err = query.lastError().text();
	if(query.size() < 1) {
		query.exec("create table tulokset (pisteet INT, nimi TEXT);");
		//qDebug() << query.lastError().text();
	}
	db.close();
}

MushMain::~MushMain() {
	QSqlDatabase::database("tulos").close();
	QSqlDatabase::removeDatabase("tulos");
}

void MushMain::start() {
	g->show();
	w->showFullScreen();
	g->newGame();
}

void MushMain::gameEnd() {
	//qDebug() << "end";
	this->repaint();	
	openDialog();
}

void MushMain::insertScore(QString name, int pisteet) {	
	QSqlDatabase db = QSqlDatabase::addDatabase("QSQLITE", "tulosdb");
	db.setDatabaseName("/home/user/.config/mushroomhigh.db");
	if(!db.open()) {
		//qDebug() << "unable to open database";
	}
	QSqlQuery query(db);
	QString pis;
	QSqlError err;
	pis.setNum(pisteet);
	query.exec("INSERT INTO tulokset values ("+pis + ", '"+ name + "');");	
	err = query.lastError().text();
	//qDebug() << err << "insert socre";
	db.commit();
	err = query.lastError().text();
	//qDebug() << err << "commit";
	
	db.close();
}

void MushMain::openDialog() {
	QString ajankesto;
	ajankesto.setNum(g->ajankesto);
	md->timeLabel->setText(ajankesto);
	md->show();

}

void MushMain::saveScore() {
	w->hide();
	md->close();
	this->show();
	insertScore(md->lineEdit->text(), g->ajankesto);
}
void MushMain::openHighScores() {
	mh->show();
	mh->showResults();
	
}
