#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "settings.h"
#include <QTime>

MainWindow::MainWindow(QWidget *parent)
    :
      QMainWindow(parent),
      ui(new Ui::MainWindow),
      closeWindow(false),
      addCity(0)
{
    //setAttribute(Qt::WA_Maemo5AutoOrientation, true);
    ui->setupUi(this);

    munadi = new MunadiEngine(this);
    this->setGeometry(munadi->settings->getScreenGeo());

    if(munadi->settings->showHadith)
    {
        ui->actionShow_Hadith->activate(QAction::Trigger);
    }
    else
    {
       ui->gbHadithContainer->hide();
    }

    if(munadi->settings->showOnAthan)
    {
        ui->actionShow_On_Athan->setChecked(true);
        connect(munadi, SIGNAL(athanTriggered()), this, SLOT(show()));
    }

    connect(munadi, SIGNAL(stateChanged()), this, SLOT(updateDisplay()));
    connect(munadi, SIGNAL(athanTriggered()), this, SLOT(on_pbRandHadith_clicked()));

    updateDisplay();

#ifndef maemo5

    trayMenu = new QMenu("trayMenu", this);
    createTrayMenu();


    tray = new QSystemTrayIcon(QIcon(":/icons/app"), this);
    tray->setContextMenu(trayMenu);
    tray->show();

    connect(tray, SIGNAL(activated(QSystemTrayIcon::ActivationReason)),
            this, SLOT(iconActivated(QSystemTrayIcon::ActivationReason)));
#endif
}

MainWindow::~MainWindow()
{
    munadi->settings->setScreenGeo(this->geometry());
    munadi->settings->showHadith = ui->actionShow_Hadith->isChecked();

    if(munadi)  delete munadi;
    if(ui)      delete ui;
}
#ifndef maemo5
void MainWindow::createTrayMenu()
{
    trayMenu->addAction(QIcon(":/icons/play"), "Play Athan", munadi, SLOT(playAthan()));
    trayMenu->addAction(QIcon(":/icons/stop"), "Stop Athan", munadi, SLOT(stopAthan()));
    trayMenu->addSeparator();
    trayMenu->addAction("Hide/Show Window", this, SLOT(toggleView()));
    trayMenu->addAction(QIcon(":/icons/exit"), "Close Munadi", this, SLOT(on_actionE_xit_triggered()));
}
#endif

//************************************************
//                       SLOTS                   *
//************************************************

void MainWindow::updateDisplay()
{
    QString format = "hh:mm ap";
    ui->lblFajr->setText(munadi->getFajr().toString(format));
    ui->lblSunrise->setText(munadi->getSunrise().toString(format));
    ui->lblDuhr->setText(munadi->getDuhr().toString(format));
    ui->lblAsr->setText(munadi->getAsr().toString(format));
    ui->lblMagrib->setText(munadi->getMagrib().toString(format));
    ui->lblIsha->setText(munadi->getIsha().toString(format));
    ui->lblCity->setText(munadi->settings->getCity().name);

    if(munadi->isAthanPlaying())
        ui->lblInfo->setText(munadi->getCurrPrayerLabel() + " prayer time ...");
    else
        ui->lblInfo->setText(munadi->getNextPrayerLabel() + " in " + munadi->getTimeDifference());

    dout << "Display updated.";
}
#ifndef maemo5
void MainWindow::iconActivated(QSystemTrayIcon::ActivationReason reason)
{
    switch(reason)
    {
        case QSystemTrayIcon::Trigger :
        case QSystemTrayIcon::DoubleClick:
        case QSystemTrayIcon::MiddleClick:
        (isVisible() == true) ? hide() : show();
        break;
    }
}
#endif
void MainWindow::closeEvent(QCloseEvent * event)
{
    if(closeWindow)
    {
        event->accept();
    }
    else
    {
        event->ignore();
        hide();
    }
}

void MainWindow::hideEvent(QHideEvent * event)
{
    event->accept();
}

void MainWindow::showEvent(QShowEvent * event)
{
    event->accept();
}
void MainWindow::on_actionE_xit_triggered()
{
    closeWindow = true;
    close();
}

int MainWindow::top_application()
{
    show();
    return 0;
}

void MainWindow::on_actionNew_City_triggered()
{
    if(addCity == 0)
    {
        addCity = new addCityDialog(munadi, this);
        addCity->show();
    }
    else
    {
        addCity->show();
    }
}

void MainWindow::on_actionShow_Hadith_triggered()
{
    munadi->initHadithList();
    ui->gbHadithContainer->setShown(ui->actionShow_Hadith->isChecked());
    this->on_pbRandHadith_clicked();
}

void MainWindow::on_pbRandHadith_clicked()
{
    ui->lblHadith->setText(munadi->getRandomHadith());
}

void MainWindow::on_pbCloseHadith_clicked()
{
    ui->gbHadithContainer->setShown(false);
    ui->actionShow_Hadith->setChecked(false);
}

void MainWindow::on_actionAbout_Munadi_triggered()
{
    QMessageBox::information(this, "About Munadi",
                             "<h3>About Munadi</h3>"
                             "<p>Munadi is a cross-platform Athan program.<br/>"
                             "For more info, visit <a href=\"http://www.sourceforge.net/projects/munadi\">Project page</a></p>"
                             "Author:   A.Abbad<br/>"
                             "Email:    <a href=\"mailto:haqman@gmail.com\">haqman@gmail.com</a><br/><br/>"
                             "Version:  0.1 (testing)<br/>", QMessageBox::Ok);
}

void MainWindow::on_btnHadithNext_clicked()
{
    ui->lblHadith->setText(munadi->getNextHadith());
}

void MainWindow::on_btnHadithPrev_clicked()
{
    ui->lblHadith->setText(munadi->getPrevHadith());
}

void MainWindow::on_actionPlay_Stop_Athan_triggered()
{
    if(munadi->isAthanPlaying())
        munadi->stopAthan();
    else
        munadi->playAthan();
}
#ifdef TESTING
void MainWindow::on_actionTEST_PRAYER_triggered()
{
    munadi->testTime.setHMS(QTime::currentTime().hour(), QTime::currentTime().minute()+1, 0);
    updateDisplay();
}
#endif

void MainWindow::on_actionShow_On_Athan_triggered()
{
    if(ui->actionShow_On_Athan->isChecked())
    {
        munadi->settings->showOnAthan = true;
        connect(munadi, SIGNAL(athanTriggered()), this, SLOT(show()));
    }
    else
    {
        munadi->settings->showOnAthan = false;
        disconnect(munadi, SIGNAL(athanTriggered()), this, SLOT(show()));
    }
}
