/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include "remoteloader.h"
#include "../base/settings.h"
#include "../base/scriptengine.h"
#include "../base/remotelistmodel.h"
#include "../base/selectionmodel.h"
#include "../base/definitions.h"
#include <QApplication>
#include <QDeclarativeView>
#include <QDeclarativeContext>
#include <qdeclarative.h>
#include <QGLWidget>
#include <MDeclarativeCache>

int main(int argc, char *argv[]) {
    QScopedPointer<QApplication> app(MDeclarativeCache::qApplication(argc, argv));
    app.data()->setOrganizationName("MultiMote");
    app.data()->setApplicationName("MultiMote");

    RemoteLoader loader;
    Settings settings;
    ScriptEngine engine;

    qmlRegisterType<RemoteListModel>("com.marxoft.models", 1, 0, "RemoteListModel");
    qmlRegisterType<SelectionModel>("com.marxoft.models", 1, 0, "SelectionModel");

    QScopedPointer<QDeclarativeView> view(MDeclarativeCache::qDeclarativeView());
    QDeclarativeContext *context = view.data()->rootContext();
    context->setContextProperty("RemoteLoader", &loader);
    context->setContextProperty("Settings", &settings);
    context->setContextProperty("ScriptEngine", &engine);
    context->setContextProperty("versionNumber", VERSION_NUMBER);

    view.data()->setViewport(new QGLWidget);
    view.data()->setSource(QUrl("qrc:/main.qml"));
    view.data()->showFullScreen();

    return app.data()->exec();
}
