/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

import QtQuick 1.1
import com.nokia.meego 1.0

TabGroup {
    id: root

    property string title
    property string description
    property variant pages: []
    property alias currentPage: root.currentTab
    property int currentIndex: 0
    property int count: pages.length

    function addPage(page) {
        var p = pages;
        p.push(page);
        pages = p;

        page.parent = root;

        if (!currentTab) {
            currentTab = page;
        }
    }

    function previousPage() {
        console.log("Previous page");
        if (currentIndex > 0) {
            currentIndex -= 1;
        }
        else {
            currentIndex = (count - 1);
        }
    }

    function nextPage() {
        console.log("Next page");
        if (currentIndex < (count - 1)) {
            currentIndex += 1;
        }
        else {
            currentIndex = 0;
        }
    }

    anchors {
        fill: parent
        topMargin: 72
    }
    onCurrentIndexChanged: {
        currentTab = pages[currentIndex];
    }

    MouseArea {
        id: mouseArea

        property int oldX
        property int oldY

        anchors.fill: parent
        onPressed: {
            oldX = mouse.x;
            oldY = mouse.y;
            mouse.accepted = false;
        }
        onReleased: {
            var xDiff = mouse.x - oldX;
            var yDiff = mouse.y - oldY;

            if ((Math.abs(yDiff)) < (Math.abs(xDiff) * 0.2)) {
                if (xDiff > 100) {
                    mouse.accepted = true;
                    previousPage();
                    return;
                }
                else if (xDiff < -100) {
                    mouse.accepted = true;
                    nextPage();
                    return;
                }
            }

            mouse.accepted = false;
        }
    }
}
