/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

import QtQuick 1.1
import com.nokia.meego 1.0
import com.marxoft.models 1.0
import ".."

ValueListItem {
    id: root

    property int rowPortrait: 0
    property int rowLandscape: 0

    property int columnPortrait: 0
    property int columnLandscape: 0

    property int rowSpanPortrait: 1
    property int rowSpanLandscape: 1

    property int colSpanPortrait: 1
    property int colSpanLandscape: 1

    property int alignmentPortrait: 0
    property int alignmentLandscape: 0

    property variant value
    property variant model

    onClicked: {
        loader.sourceComponent = dialog;
        loader.item.open();
    }

    Loader {
        id: loader
    }

    Component {
        id: dialog

        ValueDialog {
            titleText: root.title
            model: root.model
            value: root.value
            onNameChanged: root.subTitle = name
            onValueChanged: root.value = value
        }
    }

    Component.onCompleted: {
        if ((value) && (model)) {
            for (var i = 0; i < model.count; i++) {
                if (model.data(i, "value") === value) {
                    subTitle = model.data(i, "name");

                    return;
                }
            }
        }
    }
}
