/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

import QtQuick 1.1
import com.nokia.meego 1.0
import com.marxoft.models 1.0

ValueListItem {
    id: root

    property string key
    property variant value
    property string handler

    function setList(key, defaultValue, list) {
        root.key = key;

        var value = Settings.setting(key);

        if (value === undefined) {
            value = defaultValue;
            Settings.setSetting(key, value);
        }

        for (var i = 0; i < list.length; i++) {
            selectionModel.addItem(list[i].name, list[i].value);

            if (list[i].value === value) {
                root.value = value;
                root.subTitle = list[i].name;
            }
        }
    }

    onClicked: {
        loader.sourceComponent = dialog;
        loader.item.open();
    }

    SelectionModel {
        id: selectionModel
    }

    Loader {
        id: loader
    }

    Component {
        id: dialog

        ValueDialog {
            titleText: root.title
            model: selectionModel
            value: root.value
            onNameChanged: root.subTitle = name
            onValueChanged: {
                root.value = value;
                Settings.setSetting(root.key, value);

                if (root.handler) {
                    ScriptEngine.eval(root.handler);
                }
            }
        }
    }
}
