#include "socket.h"
#include <QtPlugin>
#include <QDebug>

const int MAX_RETRIES = 5;

Socket::Socket(QObject *parent) :
    QObject(parent),
    m_retries(0)
{
    this->setObjectName("socket");
    this->connect(&m_socket, SIGNAL(connected()), this, SLOT(onConnected()));
    this->connect(&m_socket, SIGNAL(disconnected()), this, SLOT(onDisconnected()));
    this->connect(&m_socket, SIGNAL(readyRead()), this, SLOT(onReadyRead()));
    this->connect(&m_socket, SIGNAL(stateChanged(QAbstractSocket::SocketState)), this, SLOT(onStateChanged(QAbstractSocket::SocketState)));
    this->connect(&m_socket, SIGNAL(error(QAbstractSocket::SocketError)), this, SLOT(onError(QAbstractSocket::SocketError)));

    QHostAddress address("239.255.255.250");
    qDebug() << "Binding: " << m_socket.bind(address, 1901, QUdpSocket::ShareAddress);
}

Socket::~Socket() {}

void Socket::getIPAddress() {
    QByteArray data = "M-SEARCH * HTTP/1.1\r\n" \
            "HOST: 239.255.255.250\r\n" \
            "MAN: ssdp:discover\r\n" \
            "MX: 4\r\n" \
//            "ST: urn:schemas-upnp-org:device:MediaRenderer:1\r\n\r\n";
            "ST: ssdp:all";

    QHostAddress address("239.255.255.250");

    qDebug() << "Bytes sent:" << m_socket.writeDatagram(data, address, 1900);
}

void Socket::onConnected() {
    qDebug() << "Connected";
}

void Socket::onDisconnected() {
    qDebug() << "Disconnected";
}

void Socket::onReadyRead() {
    qDebug() << "Ready read";
    qDebug() << m_socket.readAll();
}

void Socket::onStateChanged(QAbstractSocket::SocketState state) {
    qDebug() << state;
}

void Socket::onError(QAbstractSocket::SocketError error) {
    qDebug() << error;
    qDebug() << m_socket.errorString();
}

Q_EXPORT_PLUGIN2(socket, Socket)
