/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef CONTROLLOADER_H
#define CONTROLLOADER_H

class QDomElement;
class QObject;
class QDeclarativeItem;
class Keyboard;
class VolumeKeys;
class Timer;

class ControlLoader {

public:
    static QObject* loadControl(const QDomElement &el, bool registerHandlers, QObject *parent = 0);
    static QDeclarativeItem* loadPageStack(const QDomElement &el, bool registerHandlers, QObject *parent = 0);
    static QDeclarativeItem* loadPage(const QDomElement &el, bool registerHandlers, QObject *parent = 0);
    static QDeclarativeItem* loadDialog(const QDomElement &el, bool registerHandlers, QObject *parent = 0);
    static Keyboard* loadKeyboard(const QDomElement &el, bool registerHandlers, QObject *parent = 0);
    static VolumeKeys* loadVolumeKeys(const QDomElement &el, bool registerHandlers, QObject *parent = 0);
    static QDeclarativeItem* loadAction(const QDomElement &el, bool registerHandlers, QObject *parent = 0);
    static QDeclarativeItem* loadButton(const QDomElement &el, bool registerHandlers, QObject *parent = 0);
    static QDeclarativeItem* loadDpad(const QDomElement &el, bool registerHandlers, QObject *parent = 0);
    static QDeclarativeItem* loadImage(const QDomElement &el, bool registerHandlers, QObject *parent = 0);
    static QDeclarativeItem* loadLabel(const QDomElement &el, bool registerHandlers, QObject *parent = 0);
    static QDeclarativeItem* loadListSelector(const QDomElement &el, bool registerHandlers, QObject *parent = 0);
    static QDeclarativeItem* loadListView(const QDomElement &el, bool registerHandlers, QObject *parent = 0);
    static QDeclarativeItem* loadNumberpad(const QDomElement &el, bool registerHandlers, QObject *parent = 0);
    static QDeclarativeItem* loadSheet(const QDomElement &el, bool registerHandlers, QObject *parent = 0);
    static QDeclarativeItem* loadSlider(const QDomElement &el, bool registerHandlers, QObject *parent = 0);
    static QDeclarativeItem* loadTextField(const QDomElement &el, bool registerHandlers, QObject *parent = 0);
    static Timer* loadTimer(const QDomElement &el, bool registerHandlers, QObject *parent = 0);
    static QDeclarativeItem* loadToolBar(const QDomElement &el, bool registerHandlers, QObject *parent = 0);
    static QDeclarativeItem* loadToolButton(const QDomElement &el, bool registerHandlers, QObject *parent = 0);
    static QDeclarativeItem* loadTouchpad(const QDomElement &el, bool registerHandlers, QObject *parent = 0);

private:
    static void loadProperties(QObject *obj, const QDomElement &el);

    static void loadItemLayout(QDeclarativeItem *item, const QDomElement &el);

    static void registerHandlersWithScriptEngine(QObject *obj, const QDomElement &el);
};

#endif // CONTROLLOADER_H
