/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

import QtQuick 1.1
import com.nokia.meego 1.0
import "file:///usr/lib/qt4/imports/com/nokia/meego/UIConstants.js" as UI

Item {
    id: root

    anchors {
        fill: parent
        margins: UI.PADDING_DOUBLE
    }

    Column {
        id: column

        anchors {
            left: parent.left
            right: parent.right
            verticalCenter: parent.verticalCenter
        }
        spacing: UI.PADDING_DOUBLE

        Row {
            spacing: UI.PADDING_DOUBLE

            Image {
                id: icon

                width: 80
                height: 80
                source: "file://usr/share/icons/hicolor/80x80/apps/multimote.png"
            }

            Label {
                width: column.width - icon.width - UI.PADDING_DOUBLE
                height: 80
                font.bold: true
                font.pixelSize: 32
                verticalAlignment: Text.AlignVCenter
                text: "MultiMote " + versionNumber
            }
        }

        Label {
            width: parent.width
            horizontalAlignment: Text.AlignHCenter
            text: qsTr("No remote loaded. Please choose a remote from the menu")
        }
    }
}
