#include "qpushbuttonscaledfont.h"
#include <QDebug>

QPushButtonScaledFont::QPushButtonScaledFont(QWidget *parent) :
        QPushButton(parent)
{
    timer = new QTimer();    
    timer->setSingleShot(true);

    changeAmountTimer = new QTimer();
    changeAmountTimer->setInterval(150);

    foreach(QObject *object, qApp->topLevelWidgets())
    {
        QMainWindow * mainWindow = qobject_cast<QMainWindow*>(object);
        if(mainWindow != NULL)
        {
            connect(mainWindow,SIGNAL(StartTimerSignal(int)), this, SLOT(StartTimer(int)));
            break;
        }
    }

    connect(timer,SIGNAL(timeout()),this,SLOT(TimerTick()));
    setAutoRepeat(true);
    setAutoRepeatDelay(1000);
    setAutoRepeatInterval(200);

    grabGesture(Qt::TapAndHoldGesture);

    connect(changeAmountTimer,SIGNAL(timeout()),this,SLOT(changeLife()));
    playerSheet = qobject_cast<PlayerSheet*>(parentWidget()->parentWidget());
}

QPushButtonScaledFont::~QPushButtonScaledFont()
{    
}

void QPushButtonScaledFont::TimerTick()
{
    int padding = 10;
    QFont font = this->font();
    fontMetrics = new QFontMetrics(font);

    while( width() > (fontMetrics->width(text()) + padding) && height() > (fontMetrics->height() + padding))
    {
        font.setPointSize(font.pointSize() + 1);
        setFont(font);

        font = this->font();
        fontMetrics = new QFontMetrics(font);

    }
}

void QPushButtonScaledFont::StartTimer(int delay)
{
    QFont font = this->font();
    font.setPointSize(1);
    this->setFont(font);
    timer->setInterval(delay);
    timer->start();
}

bool QPushButtonScaledFont::event(QEvent *event)
{
    if (event->type() == QEvent::Gesture)
        return gestureEvent(static_cast<QGestureEvent*>(event));
    else if(event->type() == QEvent::MouseButtonRelease)
    {
        changeAmountTimer->stop();
    }
    return QPushButton::event(event);
}

bool QPushButtonScaledFont::gestureEvent(QGestureEvent *event)
{
    if(QGesture *tapAndHold = event->gesture(Qt::TapAndHoldGesture))
    {
        tapAndHoldTriggered(static_cast<QSwipeGesture *>(tapAndHold));
    }
    return true;
}

void QPushButtonScaledFont::tapAndHoldTriggered(QSwipeGesture *gesture)
{
    if(gesture->state() == Qt::GestureStarted)
    {
        changeAmountTimer->start();
    }
}

void QPushButtonScaledFont::changeLife()
{
    playerSheet->changeLife(changeAmountValue);
}

void QPushButtonScaledFont::setChangeAmount(int amount)
{
    changeAmountValue = amount;
}
