#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QtGui>
#include "PlayerSheet.h"

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

private:
    Ui::MainWindow *ui;
    QList<PlayerSheet*> *list;
    virtual void mousePressEvent(QMouseEvent *);
    virtual bool event(QEvent *event);
    QLabel *coinLabel;
    QLabel *aboutLabel;
    QFrame *aboutFrame;
    QVBoxLayout *aboutLayout;

signals:
    void StartTimerSignal(int);

public slots:
    void AddPlayer();
    void FlipOrientation();
    void SheetClose(PlayerSheet*);
    void ResetSheets();

private slots:
    void FlipCoin();
    void About();
};

#endif // MAINWINDOW_H
