#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "PlayerSheet.h"
#include <QDebug>
#include <QtGui>

MainWindow::MainWindow(QWidget *parent) :
        QMainWindow(parent),
        ui(new Ui::MainWindow),
        list(new QList<PlayerSheet*>)
{
    ui->setupUi(this);

    connect(ui->actionAdd_Player,SIGNAL(triggered()),this,SLOT(AddPlayer()));
    connect(ui->actionFlip_Orientation,SIGNAL(triggered()),this,SLOT(FlipOrientation()));
    connect(ui->actionFlip_Coin,SIGNAL(triggered()),this,SLOT(FlipCoin()));
    connect(ui->actionReset, SIGNAL(triggered()), this,SLOT(ResetSheets()));
    connect(ui->actionAbout, SIGNAL(triggered()), this, SLOT(About()));

    AddPlayer();
    AddPlayer();

    coinLabel = new QLabel(this);


    aboutFrame = new QFrame(this);
    aboutLayout = new QVBoxLayout(aboutFrame);
    aboutLabel = new QLabel(aboutFrame);

    aboutFrame->setLayout(aboutLayout);
    aboutLayout->addWidget(aboutLabel);

    aboutFrame->resize(100,60);
    aboutFrame->setAutoFillBackground(true);
    aboutFrame->setFrameShape(QFrame::Box);
    aboutFrame->hide();
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::FlipOrientation()
{

#ifdef Q_WS_MAEMO_5
    static bool portraitMode = false;
    if(portraitMode == false)
    {
        setAttribute(Qt::WA_Maemo5PortraitOrientation,true);
        portraitMode = true;
    }
    else
    {
        setAttribute(Qt::WA_Maemo5PortraitOrientation,false);
        portraitMode = false;
    }
    emit StartTimerSignal(1000);
#endif
}



void MainWindow::AddPlayer()
{
    PlayerSheet * sheet = new PlayerSheet(this);
    list->append(sheet);
    connect(sheet,SIGNAL(closeSheetSignal(PlayerSheet*)),this,SLOT(SheetClose(PlayerSheet*)));
    ui->horizontalLayout->addWidget(sheet);
    emit StartTimerSignal(100);
}

void MainWindow::SheetClose(PlayerSheet* sheet)
{
    for(int i = 0; i < list->count() ; i++)
    {
        if(list->at(i) == sheet)
        {
            list->at(i)->close();
            list->removeAt(i);
            break;
        }
    }
    emit StartTimerSignal(100);
}

void MainWindow::FlipCoin()
{
    int roll = qrand() % ((1 + 1) - 0) + 0;
    if(roll == 0)
    {
        QPixmap pixmap(":/images/heads.png");
        coinLabel->setPixmap(pixmap);
        coinLabel->setGeometry(pixmap.rect());
        coinLabel->move((this->width()/2) - coinLabel->width()/2,(this->height()/2) - coinLabel->height()/2);
        coinLabel->show();
    }
    else
    {
        QPixmap pixmap(":/images/tails.png");
        coinLabel->setPixmap(pixmap);
        coinLabel->setGeometry(pixmap.rect());
        coinLabel->move((this->width()/2) - coinLabel->width()/2,(this->height()/2) - coinLabel->height()/2);
        coinLabel->show();
    }
    coinLabel->show();
}

void MainWindow::mousePressEvent(QMouseEvent *)
{    
    if(coinLabel->isVisible())
    {
        coinLabel->hide();
    }
    if(aboutFrame->isVisible())
    {
        aboutFrame->hide();
    }
}

bool MainWindow::event(QEvent *event)
{
    if(event->type() == QEvent::KeyPress || event->type() == QEvent::ShortcutOverride)
    {
        if(coinLabel->isVisible())
        {
            coinLabel->hide();
        }
        if(aboutFrame->isVisible())
        {
            aboutFrame->hide();
        }
    }
    return QMainWindow::event(event);
}

void MainWindow::ResetSheets()
{
    for(int i = 0; i < list->count() ; i++)
    {
        list->at(i)->Reset();
    }

}

void MainWindow::About()
{
    aboutLabel->setText("Version 0.0.1-4\n@Jarmo Kaataja");
    aboutFrame->move((this->width()/2) - aboutFrame->width()/2,(this->height()/2) - aboutFrame->height()/2);
    aboutFrame->show();
}
