#include "qlineeditscaledfont.h"

QLineEditScaledFont::QLineEditScaledFont(QWidget *parent) :
        QLineEdit(parent)
{    
    timer = new QTimer();    
    timer->setSingleShot(true);

    foreach(QObject *object, qApp->topLevelWidgets())
    {
        QMainWindow * mainWindow = qobject_cast<QMainWindow*>(object);
        if(mainWindow != NULL)
        {
            connect(mainWindow,SIGNAL(StartTimerSignal(int)), this, SLOT(StartTimer(int)));
            break;
        }
    }

    connect(timer,SIGNAL(timeout()),this,SLOT(TimerTick()));
    connect(this,SIGNAL(textChanged(QString)),this,SLOT(textChanged(QString)));

    //for symbian 3x. otherwise font color is white

    QPalette pal = this->palette();
    pal.setColor(this->foregroundRole(), Qt::black);
    this->setPalette(pal);
}

void QLineEditScaledFont::resizeEvent(QResizeEvent *)
{

}

void QLineEditScaledFont::TimerTick()
{
    int padding = 15;
    QFont font = this->font();
    fontMetrics = new QFontMetrics(font);

    while( width() > (fontMetrics->width(text()) + padding + 10) && height() > (fontMetrics->height()))
    {
        font.setPointSize(font.pointSize() + 1);
        setFont(font);

        font = this->font();
        fontMetrics = new QFontMetrics(font);

    }
}

void QLineEditScaledFont::StartTimer(int delay)
{
    QFont font = this->font();
    font.setPointSize(1);
    this->setFont(font);
    timer->setInterval(delay);
    timer->start();
}

void QLineEditScaledFont::textChanged(QString newText)
{
    static QString oldValue;
    if(oldValue.length() != newText.length())
    {
        StartTimer(100);
    }
    oldValue = text();
}

//void QLineEditScaledFont::paintEvent(QPaintEvent *event)
//{
////    QPainter p(this);

////    QFont font = this->font();
////    fontMetrics = new QFontMetrics(font);

////    p.save();
////    p.translate(width(), height());
////    p.rotate(270);
////    p.drawText(0, 0, text());
////    p.restore();

//}
