#include "ui_PlayerSheet.h"
#include "PlayerSheet.h"

#include <QDebug>
PlayerSheet::PlayerSheet(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::PlayerSheet)
{
    ui->setupUi(this);

    connect(ui->add1Button,SIGNAL(clicked()),this,SLOT(increaseLife1()));
    connect(ui->reduce1Button,SIGNAL(clicked()),this,SLOT(reduceLife1()));
    connect(ui->add5Button,SIGNAL(clicked()),this,SLOT(increaseLife5()));
    connect(ui->reduce5Button,SIGNAL(clicked()),this,SLOT(reduceLife5()));
    connect(ui->closeButton,SIGNAL(clicked()),this,SLOT(closeSheet()));    

    ui->add1Button->setChangeAmount(1);
    ui->add5Button->setChangeAmount(5);
    ui->reduce1Button->setChangeAmount(-1);
    ui->reduce5Button->setChangeAmount(-5);
}

PlayerSheet::~PlayerSheet()
{
    delete ui;
}

void PlayerSheet::closeSheet()
{
    emit closeSheetSignal(this);
}

void PlayerSheet::changeLife(int value)
{
    bool error;
    QString textValue = ui->lifeLineEdit->text();
    int currentValue = textValue.toInt(&error,10);

    currentValue += value;

    ui->lifeLineEdit->setText(QString::number(currentValue));
}

void PlayerSheet::increaseLife1()
{
    bool error;
    QString textValue = ui->lifeLineEdit->text();
    int currentValue = textValue.toInt(&error,10);    

    currentValue += 1;

    ui->lifeLineEdit->setText(QString::number(currentValue));
}

void PlayerSheet::reduceLife1()
{
    bool error;
    QString textValue = ui->lifeLineEdit->text();
    int currentValue = textValue.toInt(&error,10);

    currentValue -= 1;

    ui->lifeLineEdit->setText(QString::number(currentValue));
}

void PlayerSheet::increaseLife5()
{
    bool error;
    QString textValue = ui->lifeLineEdit->text();
    int currentValue = textValue.toInt(&error,10);

    currentValue += 5;

    ui->lifeLineEdit->setText(QString::number(currentValue));

}

void PlayerSheet::reduceLife5()
{
    bool error;
    QString textValue = ui->lifeLineEdit->text();
    int currentValue = textValue.toInt(&error,10);

    currentValue -= 5;

    ui->lifeLineEdit->setText(QString::number(currentValue));
}

void PlayerSheet::SetPlayerName(QString name)
{
    ui->playerLineEdit->setText(name);
}

void PlayerSheet::Reset()
{
    ui->lifeLineEdit->setText("20");
}

