#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QtGui>
#include "PlayerSheet.h"

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

private:
    virtual void mousePressEvent(QMouseEvent *);
    virtual void keyPressEvent(QKeyEvent *);

    QLabel *coinLabel;

signals:
    void StartTimerSignal();

public slots:
    void AddPlayer();
    void FlipOrientation();
    void SheetClose(PlayerSheet*);
    void ResetSheets();

private slots:
    void FlipCoin();

private:
    Ui::MainWindow *ui;
    QList<PlayerSheet*> *list;
};

#endif // MAINWINDOW_H
