#include "qpushbuttonscaledfont.h"
#include <QDebug>
QPushButtonScaledFont::QPushButtonScaledFont(QWidget *parent) :
        QPushButton(parent)
{
    timer = new QTimer();
    timer->setInterval(100);
    timer->setSingleShot(true);

    foreach(QObject *object, qApp->topLevelWidgets())
    {
        QMainWindow * mainWindow = qobject_cast<QMainWindow*>(object);
        if(mainWindow != NULL)
        {
            connect(mainWindow,SIGNAL(StartTimerSignal()), this, SLOT(StartTimer()));
            break;
        }
    }

    connect(timer,SIGNAL(timeout()),this,SLOT(TimerTick()));
}

void QPushButtonScaledFont::resizeEvent(QResizeEvent *)
{

}

void QPushButtonScaledFont::TimerTick()
{
    int padding = 10;
    QFont font = this->font();
    fontMetrics = new QFontMetrics(font);

    while( width() > (fontMetrics->width(text()) + padding) && height() > (fontMetrics->height() + padding))
    {
        font.setPointSize(font.pointSize() + 1);
        setFont(font);

        font = this->font();
        fontMetrics = new QFontMetrics(font);

    }
}

void QPushButtonScaledFont::StartTimer()
{
    QFont font = this->font();
    font.setPointSize(1);
    this->setFont(font);
    timer->start();
}
