#include "ui_PlayerSheet.h"
#include "PlayerSheet.h"

#include <QDebug>
PlayerSheet::PlayerSheet(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::PlayerSheet)
{
    ui->setupUi(this);

    connect(ui->add1Button,SIGNAL(clicked()),this,SLOT(increaseLife1()));
    connect(ui->reduce1Button,SIGNAL(clicked()),this,SLOT(reduceLife1()));
    connect(ui->add5Button,SIGNAL(clicked()),this,SLOT(increaseLife5()));
    connect(ui->reduce5Button,SIGNAL(clicked()),this,SLOT(reduceLife5()));
    connect(ui->closeButton,SIGNAL(clicked()),this,SLOT(closeSheet()));    

    grabGesture(Qt::TapAndHoldGesture);
}

PlayerSheet::~PlayerSheet()
{
    delete ui;
}

void PlayerSheet::closeSheet()
{
    emit closeSheetSignal(this);
}

bool PlayerSheet::event(QEvent *event)
{
    if (event->type() == QEvent::Gesture)
        return gestureEvent(static_cast<QGestureEvent*>(event));
    return QWidget::event(event);
}

bool PlayerSheet::gestureEvent(QGestureEvent *event)
{
    if(QGesture *tapAndHold = event->gesture(Qt::TapAndHoldGesture))
    {
        tapAndHoldTriggered(static_cast<QSwipeGesture *>(tapAndHold));
    }
    return true;
}

 void PlayerSheet::tapAndHoldTriggered(QSwipeGesture *gesture)
 {
     if(gesture->state() == Qt::GestureStarted)
     {
        closeSheet();
     }
 }

void PlayerSheet::increaseLife1()
{
    bool error;
    QString textValue = ui->lifeLineEdit->text();
    int currentValue = textValue.toInt(&error,10);    

    currentValue += 1;

    ui->lifeLineEdit->setText(QString::number(currentValue));
}

void PlayerSheet::reduceLife1()
{
    bool error;
    QString textValue = ui->lifeLineEdit->text();
    int currentValue = textValue.toInt(&error,10);

    currentValue -= 1;

    ui->lifeLineEdit->setText(QString::number(currentValue));
}

void PlayerSheet::increaseLife5()
{
    bool error;
    QString textValue = ui->lifeLineEdit->text();
    int currentValue = textValue.toInt(&error,10);

    currentValue += 5;

    ui->lifeLineEdit->setText(QString::number(currentValue));

}

void PlayerSheet::reduceLife5()
{
    bool error;
    QString textValue = ui->lifeLineEdit->text();
    int currentValue = textValue.toInt(&error,10);

    currentValue -= 5;

    ui->lifeLineEdit->setText(QString::number(currentValue));
}

void PlayerSheet::SetPlayerName(QString name)
{
    ui->playerLineEdit->setText(name);
}

void PlayerSheet::Reset()
{
    ui->lifeLineEdit->setText("20");
}

