/*
 * Copyright (C) 2007 Milosz Wasilewski.
 *
 * This file is part of Stopwatch.
 *
 * Stopwatch is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * Stopwatch is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Stopwatch.  If not, see <http://www.gnu.org/licenses/>.
 */

#define _STOPWATCH_SPLIT "Split timing"
#define _STOPWATCH_LAP "Lap timing"

/* represents the stopwatch mode */
enum StopwatchType {
	STOPWATCH_SPLIT,
	STOPWATCH_LAP
};

/* represents the stat of the stopwatch */
enum StopwatchState {
	STOPWATCH_ZERO, /* before first run */
	STOPWATCH_RUNNING, /* running in split or lap mode */
	STOPWATCH_STOPPED /* stopped after it was running */
};

/* contains application state */
struct ApplicationState {
	enum StopwatchType type;
	enum StopwatchState state;
	GTimer *main_timer;
	guint func_id;
	gdouble elapsed;
	gdouble total_elapsed;
	gdouble stop_value;
	gint num_rows;
} current_state;

/* Create needed variables */
HildonProgram *stopwatch_program;
HildonWindow *stopwatch_window;

/* Containers */
GtkWidget *container;
GtkWidget *box;
GtkWidget *buttonbox;
GtkWidget *stopwatch_table;
GtkWidget *scrolled_win;
GtkWidget *right_box;
/* table model */
GtkTreeStore *stopwatch_table_model;
GtkListStore *stopwatch_type_combo_model;

GtkTreeViewColumn *stopwatch_table_column0;
GtkTreeViewColumn *stopwatch_table_column1;

GtkCellRenderer *stopwatch_table_column0_cell_renderer;
GtkCellRenderer *stopwatch_table_column1_cell_renderer;
/* buttons and other ui elements */
GtkWidget *stopwatch_clock;
GtkWidget *start_button;
GtkWidget *stop_button;
GtkWidget *reset_button;
GtkWidget *stopwatch_type_combo;
GtkWidget *selector;
/* GtkWidget *start_image; */
GdkColor color;
/* timing stuff */
/* GTimer *main_timer;
guint func_id; */

/* numeric clock rendering with pango */
PangoFontDescription *font_desc;
