#include <stdio.h>
#include <string.h>
#include <glib.h>
 
#include <curl/curl.h>
#include <curl/types.h>
#include <curl/easy.h>

#include "mstatus.h"


gboolean
post ( gchar *method, gchar *key, gchar *post_method, gchar *body )
{
/*
	xml rsp example :
	<?xml version="1.0"?>
	<rsp status="OK">
	  <transaction>12345</transaction>
	  <method>user.post</method>
	</rsp>
*/

	
	get ( method, key, NULL, post_method, body );

	gchar *check;
	check = execute_xpath_expression(XML_FILE, BAD_CAST "//rsp", NULL, "status" );
	if ( check != NULL && g_strcmp0(check,"OK") == 0 ) return TRUE;
	else return FALSE;
	
}

gchar *
get_last_status( gchar *method, gchar *key )
{
/*
	xml resp example:
	<?xml version="1.0"?>
	<rsp status="OK">
	  <transaction>12345</transaction>
	  <method>user.latest</method>
	  <messages>

	    <message id="12345" method="blog">
	      <date rfc="Tue, 15 Apr 2008 13:56:18 -0500" unix="1234567890" />
	      <services>
		<service id="blogger" name="Blogger"/>
	      </services>
	      <content>
		<title>SnVzdCBoYW5naW4nIG91dCE=</title>
		<body>R29pbmcgdG8gdGhlIHN0b3JlLg==</body>
	      </content>
	    </message>
	    <message id="12345" method="microblog">
	      <date rfc="Tue, 15 Apr 2008 13:56:18 -0500" unix="1234567890" />
	      <services>
		<service id="twitter" name="Twitter"/>
	      </services>
	      <content>
		<body>R29pbmcgdG8gdGhlIHN0b3JlLg==</body>
	      </content>
	    </message>
	    <message id="12345" method="status">
	      <date rfc="Tue, 15 Apr 2008 13:56:18 -0500" unix="1234567890" />
	      <services>
		<service id="twitter" name="Twitter"/>
		<service id="facebook" name="Facebook"/>
	      </services>
	      <content>
		<body>aXMgdGVzdGluZyBQaW5nLmZtIQ==</body>
	      </content>

	      <location>VHVsc2EsIE9L</location>
	    </message>
	    ...
	  </messages>
	</rsp>
*/
	
	get ( method, key, "1", NULL, NULL );
	
	if ( g_file_test(XML_FILE, G_FILE_TEST_IS_REGULAR) ) {
		xmlInitParser();
		gchar *check;
		check = execute_xpath_expression(XML_FILE, BAD_CAST "//rsp", NULL, "status" );
		if ( check != NULL && g_strcmp0(check,"OK") == 0 ) { //fetched xml is good 
			gchar *msg;
			msg = execute_xpath_expression(XML_FILE, BAD_CAST "//rsp/messages/message/content/body", NULL, NULL);
			gsize len = 0;
			return (gchar *)g_base64_decode(msg, &len);
		} else return NULL;
	} else return NULL;
}

gboolean
verify ( gchar *method, gchar *key )
{
/*
	xml resp example:
	<?xml version="1.0"?>
	<rsp status="OK">
	  <transaction>12345</transaction>
	  <method>user.validate</method>
	</rsp> 
*/
	FILE *t;
	t = fopen("/tmp/mstatus-ver", "a+");
	fprintf(t,"verify(%s,%s);\n",method,key);

	get ( method, key, NULL, NULL, NULL );

	if ( g_file_test(XML_FILE, G_FILE_TEST_IS_REGULAR) ) {
		/* Init libxml */     
		xmlInitParser();
		gchar *out;
		out = execute_xpath_expression(XML_FILE, BAD_CAST "//rsp", NULL, "status" );
		fprintf(t,"out is %s\n",out);
			fclose(t);
		/* Shutdown libxml */
		xmlCleanupParser();
		xmlMemoryDump();
		if ( out != NULL ) {
			if ( g_strcmp0(out,"OK") == 0 ) return TRUE;
			else return FALSE;
		} else return FALSE;

		
	} return FALSE;
	
}

static size_t
write_response(void *ptr, size_t size, size_t nmemb, void *data)
{
  FILE *writehere = (FILE *)data;
  return fwrite(ptr, size, nmemb, writehere);
}

 
void
get ( gchar *url , gchar *user_key, gchar *limit, gchar *post_method, gchar *body )
{
  CURL *curl;
  CURLcode res;
  FILE *respfile;

 
  struct curl_httppost *formpost=NULL;
  struct curl_httppost *lastptr=NULL;
  struct curl_slist *headerlist=NULL;
  static const char buf[] = "Expect:";
 
  curl_global_init(CURL_GLOBAL_ALL);
  
  respfile = fopen(XML_FILE, "w");
 
  /* Fill in the filename field */ 
  curl_formadd(&formpost,
               &lastptr,
               CURLFORM_COPYNAME, "api_key",
               CURLFORM_COPYCONTENTS, API_KEY,
               CURLFORM_END);
 
 
  /* Fill in the submit field too, even if this is rarely needed */ 
  curl_formadd(&formpost,
               &lastptr,
               CURLFORM_COPYNAME, "user_app_key",
               CURLFORM_COPYCONTENTS, user_key,
               CURLFORM_END);
               
  if ( limit != NULL ) {
	  curl_formadd(&formpost,
		       &lastptr,
		       CURLFORM_COPYNAME, "limit",
		       CURLFORM_COPYCONTENTS, "1",
		       CURLFORM_END);
  }
  
  if ( post_method != NULL ) {
  	curl_formadd(&formpost,
		       &lastptr,
		       CURLFORM_COPYNAME, "post_method",
		       CURLFORM_COPYCONTENTS, g_strdup_printf(post_method),
		       CURLFORM_END);
  }
  
  if ( body != NULL ) {
  	curl_formadd(&formpost,
		       &lastptr,
		       CURLFORM_COPYNAME, "body",
		       CURLFORM_COPYCONTENTS, g_strdup_printf(body),
		       CURLFORM_END);
  }
  curl = curl_easy_init();
  /* initalize custom header list (stating that Expect: 100-continue is not
     wanted */ 
  headerlist = curl_slist_append(headerlist, buf);
  if(curl) {
    /* what URL that receives this POST */ 
    curl_easy_setopt(curl, CURLOPT_URL, url);
    curl_easy_setopt(curl, CURLOPT_HTTPHEADER, headerlist);
    curl_easy_setopt(curl, CURLOPT_HTTPPOST, formpost);
    curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, write_response);
    /* Set a pointer to our struct to pass to the callback */ 
    curl_easy_setopt(curl, CURLOPT_WRITEDATA, respfile);

    //curl_easy_setopt(curl, CURLOPT_VERBOSE, 2);
    res = curl_easy_perform(curl);
 
    /* always cleanup */ 
    curl_easy_cleanup(curl);
 
    /* then cleanup the formpost chain */ 
    curl_formfree(formpost);
    /* free slist */ 
    curl_slist_free_all (headerlist);
  }
  
  fclose(respfile);

}

