#include "colorbutton.h"

ColorButton::ColorButton(Color color) :
        color_(color)
{
    QPixmap tmp;
    // Load right pictures according to color
    switch (color) {
    case BLUE:
        tmp = QPixmap(":/gfx/blue_off.png", "PNG");
        pixes_.append(tmp);
        tmp = QPixmap(":/gfx/blue_on.png", "PNG");
        pixes_.append(tmp);
        break;
    case GREEN:
        tmp = QPixmap(":/gfx/green_off.png", "PNG");
        pixes_.append(tmp);
        tmp = QPixmap(":/gfx/green_on.png", "PNG");
        pixes_.append(tmp);
        break;
    case RED:
        tmp = QPixmap(":/gfx/red_off.png", "PNG");
        pixes_.append(tmp);
        tmp = QPixmap(":/gfx/red_on.png", "PNG");
        pixes_.append(tmp);
        break;
    case ORANGE:
        tmp = QPixmap(":/gfx/orange_off.png", "PNG");
        pixes_.append(tmp);
        tmp = QPixmap(":/gfx/orange_on.png", "PNG");
        pixes_.append(tmp);
        break;
    default:
        break;
    }

    showingpix_ = pixes_.at(0);
}

QRectF ColorButton::boundingRect() const {
    return QRectF(0,0,showingpix_.width(),showingpix_.height());
}

void ColorButton::paint(QPainter *painter, const QStyleOptionGraphicsItem *, QWidget *)
{
    painter->drawPixmap(0, 0, showingpix_);
}

// getter
bool ColorButton::isIlluminated() const {
    return illuminated_;
}

// Light on/off
void ColorButton::toggle(bool light) {
    illuminated_ = light;

    if ( light ) {
        showingpix_ = pixes_.at(1);
    }
    else {
        showingpix_ = pixes_.at(0);
    }
}
