#include "myview.h"

MyView::MyView(QWidget *parent) :
    QGraphicsView(parent),
    scene_(new QGraphicsScene),
    bgpix_(QPixmap(":/gfx/bg.png", "PNG"))
{
    this->setGeometry(0,0,800,480);
    this->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);

    this->setScene(scene_);
    scene_->setSceneRect(QRectF(QPointF(0,0), this->size()));
    bgbrush_ = new QBrush(bgpix_);
    scene_->setBackgroundBrush(*bgbrush_);
}

void MyView::mousePressEvent(QMouseEvent *event) {
    int mx = event->x();
    int my = event->y();

    // Close button
    if ( mx > 736 && my < 64 ) {
        emit closeClicked();
    }
    // Dashboard
    else if ( mx < 64 && my < 64 ) {
        emit dashboardClicked();
    }
    // Buttons
    else if ( my > 280 && my < 460 ) {
        // Blue
        if ( mx > 14 && mx < 194 ) {
            emit colorClicked(ColorButton::BLUE);
        }
        // Orange
        else if ( mx > 208 && mx < 388 ) {
            emit colorClicked(ColorButton::ORANGE);
        }
        // Green
        else if ( mx > 407 && mx < 587 ) {
            emit colorClicked(ColorButton::GREEN);
        }
        // Red
        else if ( mx > 604 && mx < 784 ) {
            emit colorClicked(ColorButton::RED);
        }
        else {
            event->ignore();
        }
    }
    else {
        event->ignore();
    }
}
