#include "mainwindow.h"
#include "ui_mainwindow.h"

#include <QtGlobal>
#include <QTime>
#include <QtDBus>

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow),
    view_(new MyView(this)),
    timer_(new QTimer),
    score_(0),
    hiscore_(0),
    nscore_(new Number),
    nhiscore_(new Number),
    running_(false),
    gameover_(new QGraphicsPixmapItem(QPixmap(":/gfx/gameover.png", "PNG")))
{
    ui->setupUi(this);

    // Random
    QTime time = QTime::currentTime();
    qsrand((uint)time.msec());

    // Shutdown timer for each color button
    shutdowntimers_.append(new QTimer());
    shutdowntimers_.append(new QTimer());
    shutdowntimers_.append(new QTimer());
    shutdowntimers_.append(new QTimer());

    // Set view
    view_->setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    view_->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    this->setCentralWidget(view_);

    // Connects
    connect(view_, SIGNAL(closeClicked()), this, SLOT(close()));
    connect(view_, SIGNAL(dashboardClicked()), this, SLOT(onDashboardClick()));
    connect(view_, SIGNAL(colorClicked(ColorButton::Color)), this, SLOT(onColorClick(ColorButton::Color)));
    connect(timer_, SIGNAL(timeout()), this, SLOT(onTimer()));
    connect(shutdowntimers_.at(0), SIGNAL(timeout()), this, SLOT(onBlueTimer()));
    connect(shutdowntimers_.at(1), SIGNAL(timeout()), this, SLOT(onOrangeTimer()));
    connect(shutdowntimers_.at(2), SIGNAL(timeout()), this, SLOT(onGreenTimer()));
    connect(shutdowntimers_.at(3), SIGNAL(timeout()), this, SLOT(onRedTimer()));

    loadHiscore();
    createButtons();
    initScene();
    this->showFullScreen();

    newGame();
}

MainWindow::~MainWindow()
{
    saveHiscore();
    delete ui;
}

void MainWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

// Show dashboard
void MainWindow::onDashboardClick() {
    QDBusConnection c = QDBusConnection::sessionBus();
    QDBusMessage m = QDBusMessage::createSignal("/", "com.nokia.hildon_desktop", "exit_app_view");
    c.send(m);
}

// Create buttons
void MainWindow::createButtons() {
    ColorButton* tmp = new ColorButton(ColorButton::BLUE);
    tmp->setPos(14, 280);
//    view_->scene()->addItem(tmp);
    colbuttons_.append(tmp);
    tmp = new ColorButton(ColorButton::ORANGE);
    tmp->setPos(208, 280);
//    view_->scene()->addItem(tmp);
    colbuttons_.append(tmp);
    tmp = new ColorButton(ColorButton::GREEN);
    tmp->setPos(407, 280);
//    view_->scene()->addItem(tmp);
    colbuttons_.append(tmp);
    tmp = new ColorButton(ColorButton::RED);
    tmp->setPos(604, 280);
//    view_->scene()->addItem(tmp);
    colbuttons_.append(tmp);
}

// Color button clicked
void MainWindow::onColorClick(ColorButton::Color color) {

    if ( !running_ ) {
        newGame();
        return;
    }

    //qDebug() << "Color: " << color;
    if ( buffer_.size() ) {
        if ( color == buffer_.at(0) ) {
           score_++;
           nscore_->setValue(score_);

           if ( score_ > hiscore_ ) {
               hiscore_ = score_;
               nhiscore_->setValue(hiscore_);
           }

           view_->scene()->update(0,100,800,100);
           buffer_.pop_front();
           return;
        }
    }
    gameOver();
    return;
}

// Illuminate color button
void MainWindow::onTimer() {
    ColorButton::Color col = (ColorButton::Color)randInt(0, 3);

    buffer_.append(col);
    if ( buffer_.size() > 5 ) {
        gameOver();
        return;
    }

    colbuttons_.at( (int)col )->toggle(true);
    view_->scene()->update(0,240,800,240);
    timer_->setInterval(timer_->interval() * 0.98);

    shutdowntimers_.at(col)->setInterval(timer_->interval() / 3);
    shutdowntimers_.at(col)->setSingleShot(true);
    shutdowntimers_.at(col)->start();

}

// New game
void MainWindow::newGame() {
    buffer_.clear();

    // If game over screen is shown, remove it
    view_->scene()->removeItem(gameover_);

    score_ = 0;
    nscore_->setValue(0);

    // Turn off all button lights
    foreach (ColorButton* tmp, colbuttons_) {
        tmp->toggle(false);
    }

    // Add stuff to scene
    //initScene();

    running_ = true;
    timer_->start(INITIAL_TIMER_TIMEOUT);
}

// Game over
void MainWindow::gameOver() {
    timer_->stop();

    foreach(QTimer* tmp, shutdowntimers_) {
        tmp->stop();
    }

    // Turn on all button lights
    foreach (ColorButton* tmp, colbuttons_) {
        tmp->toggle(true);
    }

    running_ = false;

    // Show game over message
    gameover_->setZValue(65535);
    view_->scene()->addItem(gameover_);
}

// Random integer
int MainWindow::randInt(int min, int max) {
    if ( max < min ) return 0;
    return qrand() % ((max + 1) - min) + min;
}

// Color button shut down timers
void MainWindow::onBlueTimer() {
    colbuttons_.at(0)->toggle(false);
    view_->scene()->update(0,240,800,240);
}
void MainWindow::onOrangeTimer() {
    colbuttons_.at(1)->toggle(false);
    view_->scene()->update(0,240,800,240);
}
void MainWindow::onGreenTimer() {
    colbuttons_.at(2)->toggle(false);
    view_->scene()->update(0,240,800,240);
}
void MainWindow::onRedTimer() {
    colbuttons_.at(3)->toggle(false);
    view_->scene()->update(0,240,800,240);
}


void MainWindow::initScene() {
    // Buttons
    foreach (ColorButton* tmp, colbuttons_) {
        view_->scene()->addItem(tmp);
    }

    // Scores
    view_->scene()->addItem(nscore_);
    view_->scene()->addItem(nhiscore_);
    nscore_->setPos(140, 130);
    nhiscore_->setPos(535, 130);
    nhiscore_->setValue(hiscore_);

    // Update the scene
    view_->scene()->update(0,0,800,480);
}



void MainWindow::saveHiscore() const {
    QSettings sett("mspede/config");
    sett.setValue("hiscore", hiscore_);
}
void MainWindow::loadHiscore() {
    QSettings sett("mspede/config");
    bool bOK;
    hiscore_ = sett.value("hiscore", QVariant(0)).toInt(&bOK);
}
