#ifndef COLORBUTTON_H
#define COLORBUTTON_H

#include <QGraphicsItem>
#include <QtGui>

class ColorButton : public QGraphicsItem
{
public:
    // Colors
    enum Color {BLUE, ORANGE, GREEN, RED};

    ColorButton(Color color);

    QRectF boundingRect() const;
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget);

    bool isIlluminated() const;
    void toggle(bool light);

private:
    Color color_;
    bool illuminated_;
    QPixmap showingpix_;
    QVector<QPixmap> pixes_;

};

#endif // COLORBUTTON_H
