#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#define INITIAL_TIMER_TIMEOUT 1500

#include <QMainWindow>
#include <QVector>
#include <QTimer>

#include "myview.h"
#include "colorbutton.h"
#include "number.h"

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow {
    Q_OBJECT
public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

    int randInt(int min, int max);

public slots:
    void onDashboardClick();
    void onColorClick(ColorButton::Color color);
    void onTimer();

    void onBlueTimer();
    void onOrangeTimer();
    void onGreenTimer();
    void onRedTimer();

protected:
    void changeEvent(QEvent *e);

private:
    // Button creator
    void createButtons();

    // Add stuff to scene
    void initScene();

    // New game
    void newGame();

    // Game over
    void gameOver();

    // Save/load hiscore
    void saveHiscore() const;
    void loadHiscore();

    Ui::MainWindow *ui;
    MyView* view_;

    QVector<ColorButton*> colbuttons_;
    QVector<ColorButton::Color> buffer_;

    QTimer* timer_;
    int score_;
    int hiscore_;

    // Timers to shut down lights
    QVector<QTimer*> shutdowntimers_;

    // Scores
    Number* nscore_;
    Number* nhiscore_;

    // Is game running?
    bool running_;

    // Game over screen
    QGraphicsPixmapItem* gameover_;
};

#endif // MAINWINDOW_H
