#include "number.h"

Number::Number() :
        value_(0)
{
    QPixmap tmp = QPixmap(":/gfx/num0.png", "PNG");
    pixes_.append(tmp);
    tmp = QPixmap(":/gfx/num1.png", "PNG");
    pixes_.append(tmp);
    tmp = QPixmap(":/gfx/num2.png", "PNG");
    pixes_.append(tmp);
    tmp = QPixmap(":/gfx/num3.png", "PNG");
    pixes_.append(tmp);
    tmp = QPixmap(":/gfx/num4.png", "PNG");
    pixes_.append(tmp);
    tmp = QPixmap(":/gfx/num5.png", "PNG");
    pixes_.append(tmp);
    tmp = QPixmap(":/gfx/num6.png", "PNG");
    pixes_.append(tmp);
    tmp = QPixmap(":/gfx/num7.png", "PNG");
    pixes_.append(tmp);
    tmp = QPixmap(":/gfx/num8.png", "PNG");
    pixes_.append(tmp);
    tmp = QPixmap(":/gfx/num9.png", "PNG");
    pixes_.append(tmp);

    onepix_ = pixes_.at(0);
    tenpix_ = pixes_.at(0);
    hundredpix_ = pixes_.at(0);
}

QRectF Number::boundingRect() const {
    return QRectF(0,0,onepix_.width()*3,onepix_.height());
}

void Number::paint(QPainter *painter, const QStyleOptionGraphicsItem *, QWidget *)
{
    painter->drawPixmap(0, 0, hundredpix_);
    painter->drawPixmap(onepix_.width(), 0, tenpix_);
    painter->drawPixmap(onepix_.width() * 2, 0, onepix_);
}

void Number::setValue(int val) {
    value_ = val;
    hundredpix_ = pixes_.at(value_ / 100);
    int tmp = value_ - (value_ / 100) * 100;
    tenpix_ = pixes_.at(tmp / 10);
    onepix_ = pixes_.at(tmp % 10);
}
