#ifndef CHANNELSFORM_H
#define CHANNELSFORM_H

#include <QWidget>
#include <QByteArray>
#include <QSettings>

#include "msomachannels.h"

namespace Ui {
    class ChannelsForm;
}

class QSignalMapper;
class QNetworkAccessManager;
class QNetworkReply;
class QListWidgetItem;

class ChannelPlayer;

class ChannelsForm : public QWidget
{
    Q_OBJECT

public:
    explicit ChannelsForm(QWidget *parent = 0);
    ~ChannelsForm();

    void readSettings(QSettings &settings);
    void writeSettings(QSettings &settings);

    void fillChannelList();

    void setChannelsFeedUrl(const QString &url) { channelsFeedUrl = url; }
    QString getChannelsFeedUrl() const { return channelsFeedUrl; }

    void setShowRecentlyPlayedSongs(bool b);
    bool isShowRecentlyPlayedSongs() const;

protected:
    void startUpdating();
    void endUpdating();

    /**
      * Enables the play buttons corresponding to playlists
      * in the specified channel
      */
    void enablePlayButtons(const MSomaChannel &channel);
    void disablePlayButtons();

private slots:
    void updateChannels();

    void finishReadingChannelsFeed(QNetworkReply *reply);

    void setStatus(const QString &s = "");
    void setErrorStatus(const QString &s);
    void setErrorStatus(const QString &s, int error);
    void updateStatus(const QString &s);

    void updateChannelInfo(int position);
    void updateChannelInfo(QListWidgetItem *item);

    void abortFetching();

    void playPlaylist(const QString &url);
    void stopPlaylist();

    void channelsFeedDownloadProgress( qint64 bytesReceived, qint64 bytesTotal );

private:
    Ui::ChannelsForm *ui;

    /// the channel feed data
    QByteArray channelsFeedData;

    /// the current channels
    MSomaChannels channels;

    /// the current chosen channel
    MSomaChannel channel;

    /// the current chosen playlist
    MSomaPlaylist playlist;

    /// the url of the channels feed
    QString channelsFeedUrl;

    /// for mapping playlist buttons
    QSignalMapper *signalMapper;

    /// for reading the channels feed
    QNetworkAccessManager *channelsFeedNetworkReader;

    /// for dealing with the connection for reading the channels feed
    QNetworkReply *channelsFeedReply;

};

#endif // CHANNELSFORM_H
