#include <QFile>
#include <QDebug>

#include "channelsreader.h"

ChannelsReader::ChannelsReader(QObject *parent) :
    QObject(parent)
{
}

bool ChannelsReader::readFile(const QString &file)
{
    QFile File(file);
    if (!File.open(QIODevice::ReadOnly | QIODevice::Text))
        return false;

    data = File.readAll();
    setData(data);

    File.close();

    return true;
}

void ChannelsReader::setData(const char *data_)
{
    xml.clear();
    data = data_;
    xml.addData(data);
}

void ChannelsReader::addData(const QByteArray &data_)
{
    data.append(data_);
    xml.addData(data);
}

static bool isPlayList(const QString &elem)
{
    return elem.endsWith("pls");
}

static bool isPlayList(const QStringRef &elem)
{
    return isPlayList(elem.toString());
}

const MSomaChannels ChannelsReader::readChannels()
{
    mSomaChannels.clear(); // resets the channels
    MSomaChannel channel;
    QString currentTag;
    QString currentElement; // the current element of a channel
    MSomaPlaylist currentPlaylist; // the current playlist element of a channel
    while (!xml.atEnd()) {
        xml.readNext();
        if (xml.isStartElement()) {
            if (xml.name() == "channel") {
                channel = MSomaChannel();
                channel.id = xml.attributes().value("id").toString();
            } else if (isPlayList(xml.name())) {
                currentPlaylist = MSomaPlaylist(xml.attributes().value("format").toString());
                currentPlaylist.name = xml.name().toString();
            } else {
                currentElement = xml.name().toString();
            }
            currentTag = xml.name().toString();
        } else if (xml.isEndElement()) {
            if (xml.name() == "channel") {
                mSomaChannels << channel;
            }
        } else if (xml.isCharacters() && !xml.isWhitespace()) {
            if (isPlayList(currentTag)) {
                currentPlaylist.url = xml.text().toString();
                // now we have all the info about the playlist
                // and we can store it in the channel
                channel.playlists << currentPlaylist;
            } else {
                channel.values[currentElement] = xml.text().toString();
            }
        }
        //qDebug() << "name: " << xml.name();
        //qDebug() << "value: " << xml.text().toString();
    }
    if (xml.error() && xml.error() != QXmlStreamReader::PrematureEndOfDocumentError) {
        qWarning() << "XML ERROR:" << xml.lineNumber() << ": " << xml.errorString();
    }

    return mSomaChannels;
}
