
#include "sid_test.h"

unsigned int
create_sid_path (const char *path)
{
  /* path exists, yippee ... */
  if (g_file_test (path, G_FILE_TEST_IS_DIR))
  {
    return 1;
  }

  /* does not exist, let's try to create one */
  if (g_mkdir (path,  0777) == 0)
    return 1;
  else
    return 0;
}

#ifdef HILDON
unsigned int
mmc_ok ()
{
  char path[] = "/home/user/MyDocs/sidmusic";

  if (g_file_test (path, G_FILE_TEST_IS_DIR))
  {
    return 1;
  }

  /*
   * does not exist, let's try to create one
   */
  if (g_mkdir (path,  0777) == 0)
    return 1;
  else
    return 0;
}
#endif

unsigned int
sidpath_ok ()
{
  char path[256];

  snprintf (path, 256, "%s/sidmusic", getenv("HOME"));

  if (g_file_test (path, G_FILE_TEST_IS_DIR))
  {
    return 1;
  }

  /*
   * does not exist, let's try to create one
   */

  if (g_mkdir (path,  0777) == 0)
    return 1;
  else
    return 0;
}

unsigned int
sidtune_is_ok (const gchar *path)
{
  struct sidTuneInfo info;
  GnomeVFSFileInfo file_info;

  if (!strstr(path, ".sid"))
  {
    return 0;
  }

  memset(&info, 0, sizeof(sidTuneInfo));

  /*
   * check filesize - maybe a download has failed
   */
  gnome_vfs_get_file_info (path, &file_info,
                           GNOME_VFS_FILE_INFO_DEFAULT);
  if (file_info.size < 1)
  {
    if (g_file_test (path, G_FILE_TEST_IS_REGULAR) &&
	!g_file_test (path, G_FILE_TEST_IS_SYMLINK))
    {
      unlink (path);
    }
    return 0;
  }

  sidTune tune (path);

  if (tune.getInfo(info) != true)
  {
    return 0;
  }

  if (info.authorString == 0)
  {
    return 0;
  }

  if (info.nameString == 0)
  {
    return 0;
  }

  if (info.songs <= 0)
  {
    return 0;
  }

  if (g_ascii_strcasecmp(info.nameString, "") == 0)
  {
    return 0;
  }

  return 1;
}
