#!/usr/bin/env python

#
# MSCIM switcher status menu applet for Nokia N900 smartphone
# Copyright (c) 2011-05-10 Ashley Hooper <ashleyghooper@gmail.com>
# License: GPLv3 or (at your option) any later version
#

import hildondesktop

import gobject
import gtk
import hildon

from os import kill, path
from subprocess import Popen, PIPE, call
from string import split
import signal
import logging
                                                          

ETC_GTK2_PATH = '/etc/gtk-2.0/'
GTK_IMMODULES = 'gtk.immodules'
ON_SUFFIX     = '_mscim_on'
OFF_SUFFIX    = '_mscim_off'



def name_to_pids(process_name):
    p = Popen (['pidof', process_name], stdout=PIPE) 
    out, err = p.communicate()
    return out.rstrip()



def readlink(target_path):
    p = Popen (['readlink', target_path], stdout=PIPE) 
    out, err = p.communicate()
    return out.rstrip()



def scim_is_active():
    link_path = readlink ( ETC_GTK2_PATH + GTK_IMMODULES )
    if link_path == "":
        return True
    if link_path == ETC_GTK2_PATH + GTK_IMMODULES + ON_SUFFIX or link_path == GTK_IMMODULES + ON_SUFFIX:
        return True
    else:
        return False



def create_link(link_target_path, link_location):        
    try:
        return call (['sudo', 'ln', '-sf', link_target_path, link_location])
    except:
        return False



def signal_processes (process_name, sendsignal):
    running_pids = name_to_pids(process_name)
    try:
        if running_pids != '':
            arr_pids = split ( running_pids )
            for each_pid in arr_pids:
                if sendsignal == 'suspend':
                    kill (int (each_pid), signal.SIGSTOP) 
                elif sendsignal == 'wake':
                    kill (int (each_pid), signal.SIGCONT) 
    except:
        return False


                                                                       
def suspend_processes_if_running(process_name):        
    signal_processes (process_name, 'suspend')


                                                                       
def wake_processes_if_running(process_name):                                         
    signal_processes (process_name, 'wake')


                                                                       
def killall_processes_if_running(process_name):                                         
    running_pids = name_to_pids(process_name)
    try:
        if running_pids != '':
            call (['/usr/bin/killall', process_name])
    except:
        return False






class MSCIMSwitcherWidget(hildondesktop.StatusMenuItem):

    genLogger = logging.getLogger ('general')
    hdlr = logging.FileHandler('/tmp/mscimswitcherstatus.log')
    formatter = logging.Formatter('%(asctime)s %(levelname)s %(message)s')
    hdlr.setFormatter(formatter)
    genLogger.addHandler(hdlr)
    #genLogger.setLevel(logging.INFO)
    genLogger.setLevel(logging.DEBUG)
    genLogger.debug("mscimswitcher_status.py: program start")


    conf_dir  = '/home/user/.config/mscimswitcherstatus'
    conf_file = 'mscimswitcherstatus.conf'
    my_conf = conf_dir + '/' + conf_file
   

    conf_keys = ('suspend_scim_panel', 'kill_rtcom_on_susp', 'scim_active_on_boot')
    run_conf = {}



    hb = gtk.HBox()

    rb1 = hildon.GtkRadioButton(gtk.HILDON_SIZE_FINGER_HEIGHT |
            gtk.HILDON_SIZE_AUTO_WIDTH)
    rb2 = hildon.GtkRadioButton(gtk.HILDON_SIZE_FINGER_HEIGHT |
            gtk.HILDON_SIZE_AUTO_WIDTH, rb1)
    b3  = hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT |
            gtk.HILDON_SIZE_AUTO_WIDTH, hildon.BUTTON_ARRANGEMENT_VERTICAL)


    def __init__(self):
        hildondesktop.StatusMenuItem.__init__(self)

        self.genLogger.debug ("Using configuration file %s", self.my_conf)

        self.read_config()


        scim_active = scim_is_active ()

        if scim_active:
            state = 'on'
        else:
            state = 'off'
        self.genLogger.debug ("SCIM seems to be %s", state)

     
        self.rb1.set_property('label', 'Hildon')
        self.rb1.set_mode(False)
        self.hb.add(self.rb1)

        self.rb2.set_property('label', 'MSCIM')
        self.rb2.set_mode(False)
        self.hb.add(self.rb2)

        icon_theme = gtk.icon_theme_get_default()
        pixbuf = icon_theme.load_icon("general_settings", 48, gtk.ICON_LOOKUP_USE_BUILTIN )
        image = gtk.Image()                                      
        image.set_from_pixbuf(pixbuf)                           
        self.b3.set_image(image)               
        self.b3.set_image_position(gtk.POS_LEFT)
        self.hb.add(self.b3)

        self.add(self.hb)
        self.show_all()

        self.rb2.set_active ( scim_active )
        self.rb1.connect('clicked', self.hildon_input)
        self.rb2.connect('clicked', self.mscim_input)
        self.b3.connect('clicked', self.config_dialog)



    def read_config(self):
        self.genLogger.debug ("Reading configuration file %s", self.my_conf)

        if not path.exists (self.my_conf):
            for this_key in self.conf_keys:
                self.run_conf[this_key] = 1
            return False

        fh = open (self.my_conf,'r')

        conf_items = {}
            
        for line in fh:
            words = line.split ("=")
            if len(words) > 1:
                property = words[0]
                value    = words[1].rstrip()
 
                self.genLogger.debug ("Config entry %s = %s", property, value)
        
                if property in self.conf_keys:
                    conf_items[property] = value


        for this_key in self.conf_keys:
            if this_key in conf_items and conf_items[this_key] == '1':
                self.run_conf[this_key] = 1
            else:
                self.run_conf[this_key] = 0

        # print self.run_conf



    def write_config(self):
        self.genLogger.debug ("Writing configuration file %s", self.my_conf)

        if not path.exists (self.conf_dir):
            self.genLogger.debug ("Config dir %s not fond - attempting to create it")
            call (['/bin/mkdir','-p',self.conf_dir])

        fh = open (self.my_conf, 'w')
        self.genLogger.debug ("Config file opened for write")

        for key in self.run_conf.keys():
            print self.run_conf[key]
            value = str(self.run_conf[key])
            conf_line = key + '=' + value + '\n'
            print conf_line
            self.genLogger.debug ("Config: write: %s=%s", key, value)
            fh.write (conf_line)

        fh.close()
        self.genLogger.debug ("Config file closed")




    def hildon_input(self, widget):

        self.genLogger.debug ("Hildon Input selected")
        if self.run_conf['suspend_scim_panel'] == 1:
            self.genLogger.debug ("Suspending scim-panel-gtk process")
            suspend_processes_if_running ("scim-panel-gtk")

            if self.run_conf['kill_rtcom_on_susp'] == 1:
                self.genLogger.debug ("Killing rtcom-messaging-ui")
                killall_processes_if_running ('rtcom-messaging-ui')

        self.genLogger.debug ("Creating symlink %s to %s%s", GTK_IMMODULES, GTK_IMMODULES, OFF_SUFFIX)
        create_link (ETC_GTK2_PATH + GTK_IMMODULES + OFF_SUFFIX, ETC_GTK2_PATH + GTK_IMMODULES)

        banner = hildon.hildon_banner_show_information(self, "None", "MSCIM disabled")
        # Hide the status menu after the buttons have been toggled
        widget.get_toplevel().hide()



    def mscim_input(self, widget):

        self.genLogger.debug ("MSCIM Input selected")
        if self.run_conf['suspend_scim_panel'] == 1:

            if self.run_conf['kill_rtcom_on_susp'] == 1:
                self.genLogger.debug ("Killing rtcom-messaging-ui")
                killall_processes_if_running ('rtcom-messaging-ui')

        self.genLogger.debug ("Creating symlink %s to %s%s", GTK_IMMODULES, GTK_IMMODULES, ON_SUFFIX)
        create_link (ETC_GTK2_PATH + GTK_IMMODULES + ON_SUFFIX, ETC_GTK2_PATH + GTK_IMMODULES)

        self.genLogger.debug ("Waking scim-panel-gtk process")
        wake_processes_if_running ("scim-panel-gtk")
        banner = hildon.hildon_banner_show_information(self, "None", "MSCIM enabled")
        # Hide the status menu after the buttons have been toggled
        widget.get_toplevel().hide()



    def config_dialog(self, widget):
        self.genLogger.debug ("Displaying config dialog")
        widget.get_toplevel().hide()
        dialog = gtk.Dialog("MSCIM Switcher config", None, gtk.DIALOG_DESTROY_WITH_PARENT)

        b1 = hildon.CheckButton(gtk.HILDON_SIZE_AUTO)
        b1.set_label("Suspend SCIM process when Hildon active")
        if self.run_conf['suspend_scim_panel'] == 1:
            b1.set_active(True)

        b2 = hildon.CheckButton(gtk.HILDON_SIZE_AUTO)
        b2.set_label("Restart Conversations on SCIM suspend/unsuspend")
        if self.run_conf['kill_rtcom_on_susp'] == 1:
            b2.set_active(True)

        b3 = hildon.CheckButton(gtk.HILDON_SIZE_AUTO)
        b3.set_label("SCIM active on boot")
        if self.run_conf['scim_active_on_boot'] == 1:
            b3.set_active(True)

        b4 = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH |
            gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
        b4.set_label("Save")

        dialog.vbox.pack_start(b1, False, False, 0)
        dialog.vbox.pack_start(b2, False, False, 0)
        dialog.vbox.pack_start(b3, False, False, 0)
        dialog.vbox.pack_start(b4, False, False, 0)

        dialog.show_all()
        b1.connect("toggled", self.suspend_toggled)
        b2.connect("toggled", self.kill_rtcom_toggled)
        b3.connect("toggled", self.scim_active_on_boot_toggled)
        b4.connect("clicked", self.close_config)
        dialog.run()
        dialog.destroy()
        widget.get_toplevel().show()



    def suspend_toggled(self, widget):
        self.genLogger.debug ("User toggled suspend_scim_panel")
        try:
            self.run_conf['suspend_scim_panel'] = int (not self.run_conf['suspend_scim_panel'])
        except:
            print "Warning: self.suspend_scim_panel non-Boolean - set to 0"
            self.run_conf['suspend_scim_panel'] = 0
        self.genLogger.debug ("New value of suspend_scim_panel is %s", self.run_conf['suspend_scim_panel'])



    def kill_rtcom_toggled(self, widget):
        self.genLogger.debug ("User toggled kill_rtcom_on_susp")
        try:
            self.run_conf['kill_rtcom_on_susp'] = int (not self.run_conf['kill_rtcom_on_susp'])
        except:
            print "Warning: self.kill_rtcom_on_susp non-Boolean - set to 0"
            self.run_conf['kill_rtcom_on_susp'] = 0
        self.genLogger.debug ("New value of kill_rtcom_on_susp is %s", self.run_conf['kill_rtcom_on_susp'])



    def scim_active_on_boot_toggled(self, widget):
        self.genLogger.debug ("User toggled scim_active_on_boot")
        try:
            self.run_conf['scim_active_on_boot'] = int (not self.run_conf['scim_active_on_boot'])
        except:
            print "Warning: self.scim_active_on_boot non-Boolean - set to 0"
            self.run_conf['scim_active_on_boot'] = 0
        self.genLogger.debug ("New value of scim_active_on_boot is %s", self.run_conf['scim_active_on_boot'])



    def close_config(self, widget):
        self.genLogger.debug ("Closing config window: user clicked Save")
        self.write_config()
        widget.get_toplevel().hide()







hd_plugin_type = MSCIMSwitcherWidget

if __name__ == "__main__":

    gobject.type_register(hd_plugin_type)
    obj = gobject.new(hd_plugin_type, plugin_id="mscim_switcher")
    obj.show_all()
    gtk.main()
