// KeyEvent code mapping pairs.
//     From                          To
static __Uint16Pair __belgian_to_us_normal [] = {
  { SCIM_KEY_exclam,              SCIM_KEY_8 },
  { SCIM_KEY_quotedbl,            SCIM_KEY_3 },
  { SCIM_KEY_dollar,              SCIM_KEY_bracketright },
  { SCIM_KEY_ampersand,           SCIM_KEY_1 },
  { SCIM_KEY_apostrophe,          SCIM_KEY_4 },
  { SCIM_KEY_parenleft,           SCIM_KEY_5 },
  { SCIM_KEY_parenright,          SCIM_KEY_minus },
  { SCIM_KEY_comma,               SCIM_KEY_m },
  { SCIM_KEY_minus,               SCIM_KEY_equal },
  { SCIM_KEY_colon,               SCIM_KEY_period },
  { SCIM_KEY_semicolon,           SCIM_KEY_comma },
  { SCIM_KEY_equal,               SCIM_KEY_slash },
  { SCIM_KEY_a,                   SCIM_KEY_q },
  { SCIM_KEY_m,                   SCIM_KEY_semicolon },
  { SCIM_KEY_q,                   SCIM_KEY_a },
  { SCIM_KEY_w,                   SCIM_KEY_z },
  { SCIM_KEY_z,                   SCIM_KEY_w },
  { SCIM_KEY_section,             SCIM_KEY_6 },
  { SCIM_KEY_twosuperior,         SCIM_KEY_grave },
  { SCIM_KEY_mu,                  SCIM_KEY_backslash },
  { SCIM_KEY_agrave,              SCIM_KEY_0 },
  { SCIM_KEY_ccedilla,            SCIM_KEY_9 },
  { SCIM_KEY_egrave,              SCIM_KEY_7 },
  { SCIM_KEY_eacute,              SCIM_KEY_2 },
  { SCIM_KEY_ugrave,              SCIM_KEY_apostrophe },
  { SCIM_KEY_dead_circumflex,     SCIM_KEY_bracketleft },
};

static __Uint16Pair __us_to_belgian_normal [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_ugrave },
  { SCIM_KEY_comma,               SCIM_KEY_semicolon },
  { SCIM_KEY_minus,               SCIM_KEY_parenright },
  { SCIM_KEY_period,              SCIM_KEY_colon },
  { SCIM_KEY_slash,               SCIM_KEY_equal },
  { SCIM_KEY_0,                   SCIM_KEY_agrave },
  { SCIM_KEY_1,                   SCIM_KEY_ampersand },
  { SCIM_KEY_2,                   SCIM_KEY_eacute },
  { SCIM_KEY_3,                   SCIM_KEY_quotedbl },
  { SCIM_KEY_4,                   SCIM_KEY_apostrophe },
  { SCIM_KEY_5,                   SCIM_KEY_parenleft },
  { SCIM_KEY_6,                   SCIM_KEY_section },
  { SCIM_KEY_7,                   SCIM_KEY_egrave },
  { SCIM_KEY_8,                   SCIM_KEY_exclam },
  { SCIM_KEY_9,                   SCIM_KEY_ccedilla },
  { SCIM_KEY_semicolon,           SCIM_KEY_m },
  { SCIM_KEY_equal,               SCIM_KEY_minus },
  { SCIM_KEY_bracketleft,         SCIM_KEY_dead_circumflex },
  { SCIM_KEY_backslash,           SCIM_KEY_mu },
  { SCIM_KEY_bracketright,        SCIM_KEY_dollar },
  { SCIM_KEY_grave,               SCIM_KEY_twosuperior },
  { SCIM_KEY_a,                   SCIM_KEY_q },
  { SCIM_KEY_m,                   SCIM_KEY_comma },
  { SCIM_KEY_q,                   SCIM_KEY_a },
  { SCIM_KEY_w,                   SCIM_KEY_z },
  { SCIM_KEY_z,                   SCIM_KEY_w },
};

static __Uint16Pair __belgian_to_us_caps [] = {
  { SCIM_KEY_exclam,              SCIM_KEY_8 },
  { SCIM_KEY_quotedbl,            SCIM_KEY_3 },
  { SCIM_KEY_dollar,              SCIM_KEY_bracketright },
  { SCIM_KEY_ampersand,           SCIM_KEY_1 },
  { SCIM_KEY_apostrophe,          SCIM_KEY_4 },
  { SCIM_KEY_parenleft,           SCIM_KEY_5 },
  { SCIM_KEY_parenright,          SCIM_KEY_minus },
  { SCIM_KEY_comma,               SCIM_KEY_M },
  { SCIM_KEY_minus,               SCIM_KEY_equal },
  { SCIM_KEY_colon,               SCIM_KEY_period },
  { SCIM_KEY_semicolon,           SCIM_KEY_comma },
  { SCIM_KEY_equal,               SCIM_KEY_slash },
  { SCIM_KEY_A,                   SCIM_KEY_Q },
  { SCIM_KEY_M,                   SCIM_KEY_semicolon },
  { SCIM_KEY_Q,                   SCIM_KEY_A },
  { SCIM_KEY_W,                   SCIM_KEY_Z },
  { SCIM_KEY_Z,                   SCIM_KEY_W },
  { SCIM_KEY_section,             SCIM_KEY_6 },
  { SCIM_KEY_twosuperior,         SCIM_KEY_grave },
  { SCIM_KEY_mu,                  SCIM_KEY_backslash },
  { SCIM_KEY_Agrave,              SCIM_KEY_0 },
  { SCIM_KEY_Ccedilla,            SCIM_KEY_9 },
  { SCIM_KEY_Egrave,              SCIM_KEY_7 },
  { SCIM_KEY_Eacute,              SCIM_KEY_2 },
  { SCIM_KEY_Ugrave,              SCIM_KEY_apostrophe },
  { SCIM_KEY_dead_circumflex,     SCIM_KEY_bracketleft },
};

static __Uint16Pair __us_to_belgian_caps [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_Ugrave },
  { SCIM_KEY_comma,               SCIM_KEY_semicolon },
  { SCIM_KEY_minus,               SCIM_KEY_parenright },
  { SCIM_KEY_period,              SCIM_KEY_colon },
  { SCIM_KEY_slash,               SCIM_KEY_equal },
  { SCIM_KEY_0,                   SCIM_KEY_Agrave },
  { SCIM_KEY_1,                   SCIM_KEY_ampersand },
  { SCIM_KEY_2,                   SCIM_KEY_Eacute },
  { SCIM_KEY_3,                   SCIM_KEY_quotedbl },
  { SCIM_KEY_4,                   SCIM_KEY_apostrophe },
  { SCIM_KEY_5,                   SCIM_KEY_parenleft },
  { SCIM_KEY_6,                   SCIM_KEY_section },
  { SCIM_KEY_7,                   SCIM_KEY_Egrave },
  { SCIM_KEY_8,                   SCIM_KEY_exclam },
  { SCIM_KEY_9,                   SCIM_KEY_Ccedilla },
  { SCIM_KEY_semicolon,           SCIM_KEY_M },
  { SCIM_KEY_equal,               SCIM_KEY_minus },
  { SCIM_KEY_A,                   SCIM_KEY_Q },
  { SCIM_KEY_M,                   SCIM_KEY_comma },
  { SCIM_KEY_Q,                   SCIM_KEY_A },
  { SCIM_KEY_W,                   SCIM_KEY_Z },
  { SCIM_KEY_Z,                   SCIM_KEY_W },
  { SCIM_KEY_bracketleft,         SCIM_KEY_dead_circumflex },
  { SCIM_KEY_backslash,           SCIM_KEY_mu },
  { SCIM_KEY_bracketright,        SCIM_KEY_dollar },
  { SCIM_KEY_grave,               SCIM_KEY_twosuperior },
};

static __Uint16Pair __belgian_to_us_shift [] = {
  { SCIM_KEY_percent,             SCIM_KEY_quotedbl },
  { SCIM_KEY_asterisk,            SCIM_KEY_braceright },
  { SCIM_KEY_plus,                SCIM_KEY_question },
  { SCIM_KEY_period,              SCIM_KEY_less },
  { SCIM_KEY_slash,               SCIM_KEY_greater },
  { SCIM_KEY_0,                   SCIM_KEY_parenright },
  { SCIM_KEY_1,                   SCIM_KEY_exclam },
  { SCIM_KEY_2,                   SCIM_KEY_at },
  { SCIM_KEY_3,                   SCIM_KEY_numbersign },
  { SCIM_KEY_4,                   SCIM_KEY_dollar },
  { SCIM_KEY_5,                   SCIM_KEY_percent },
  { SCIM_KEY_6,                   SCIM_KEY_asciicircum },
  { SCIM_KEY_7,                   SCIM_KEY_ampersand },
  { SCIM_KEY_8,                   SCIM_KEY_asterisk },
  { SCIM_KEY_9,                   SCIM_KEY_parenleft },
  { SCIM_KEY_question,            SCIM_KEY_M },
  { SCIM_KEY_A,                   SCIM_KEY_Q },
  { SCIM_KEY_M,                   SCIM_KEY_colon },
  { SCIM_KEY_Q,                   SCIM_KEY_A },
  { SCIM_KEY_W,                   SCIM_KEY_Z },
  { SCIM_KEY_Z,                   SCIM_KEY_W },
  { SCIM_KEY_underscore,          SCIM_KEY_plus },
  { SCIM_KEY_sterling,            SCIM_KEY_bar },
  { SCIM_KEY_degree,              SCIM_KEY_underscore },
  { SCIM_KEY_threesuperior,       SCIM_KEY_asciitilde },
  { SCIM_KEY_dead_diaeresis,      SCIM_KEY_braceleft },
};

static __Uint16Pair __us_to_belgian_shift [] = {
  { SCIM_KEY_exclam,              SCIM_KEY_1 },
  { SCIM_KEY_quotedbl,            SCIM_KEY_percent },
  { SCIM_KEY_numbersign,          SCIM_KEY_3 },
  { SCIM_KEY_dollar,              SCIM_KEY_4 },
  { SCIM_KEY_percent,             SCIM_KEY_5 },
  { SCIM_KEY_ampersand,           SCIM_KEY_7 },
  { SCIM_KEY_parenleft,           SCIM_KEY_9 },
  { SCIM_KEY_parenright,          SCIM_KEY_0 },
  { SCIM_KEY_asterisk,            SCIM_KEY_8 },
  { SCIM_KEY_plus,                SCIM_KEY_underscore },
  { SCIM_KEY_colon,               SCIM_KEY_M },
  { SCIM_KEY_less,                SCIM_KEY_period },
  { SCIM_KEY_greater,             SCIM_KEY_slash },
  { SCIM_KEY_question,            SCIM_KEY_plus },
  { SCIM_KEY_at,                  SCIM_KEY_2 },
  { SCIM_KEY_A,                   SCIM_KEY_Q },
  { SCIM_KEY_M,                   SCIM_KEY_question },
  { SCIM_KEY_Q,                   SCIM_KEY_A },
  { SCIM_KEY_W,                   SCIM_KEY_Z },
  { SCIM_KEY_Z,                   SCIM_KEY_W },
  { SCIM_KEY_asciicircum,         SCIM_KEY_6 },
  { SCIM_KEY_underscore,          SCIM_KEY_degree },
  { SCIM_KEY_braceleft,           SCIM_KEY_dead_diaeresis },
  { SCIM_KEY_bar,                 SCIM_KEY_sterling },
  { SCIM_KEY_braceright,          SCIM_KEY_asterisk },
  { SCIM_KEY_asciitilde,          SCIM_KEY_threesuperior },
};

static __Uint16Pair __belgian_to_us_caps_shift [] = {
  { SCIM_KEY_percent,             SCIM_KEY_quotedbl },
  { SCIM_KEY_asterisk,            SCIM_KEY_braceright },
  { SCIM_KEY_plus,                SCIM_KEY_question },
  { SCIM_KEY_period,              SCIM_KEY_less },
  { SCIM_KEY_slash,               SCIM_KEY_greater },
  { SCIM_KEY_0,                   SCIM_KEY_parenright },
  { SCIM_KEY_1,                   SCIM_KEY_exclam },
  { SCIM_KEY_2,                   SCIM_KEY_at },
  { SCIM_KEY_3,                   SCIM_KEY_numbersign },
  { SCIM_KEY_4,                   SCIM_KEY_dollar },
  { SCIM_KEY_5,                   SCIM_KEY_percent },
  { SCIM_KEY_6,                   SCIM_KEY_asciicircum },
  { SCIM_KEY_7,                   SCIM_KEY_ampersand },
  { SCIM_KEY_8,                   SCIM_KEY_asterisk },
  { SCIM_KEY_9,                   SCIM_KEY_parenleft },
  { SCIM_KEY_question,            SCIM_KEY_m },
  { SCIM_KEY_underscore,          SCIM_KEY_plus },
  { SCIM_KEY_a,                   SCIM_KEY_q },
  { SCIM_KEY_m,                   SCIM_KEY_colon },
  { SCIM_KEY_q,                   SCIM_KEY_a },
  { SCIM_KEY_w,                   SCIM_KEY_z },
  { SCIM_KEY_z,                   SCIM_KEY_w },
  { SCIM_KEY_sterling,            SCIM_KEY_bar },
  { SCIM_KEY_degree,              SCIM_KEY_underscore },
  { SCIM_KEY_threesuperior,       SCIM_KEY_asciitilde },
  { SCIM_KEY_dead_diaeresis,      SCIM_KEY_braceleft },
};

static __Uint16Pair __us_to_belgian_caps_shift [] = {
  { SCIM_KEY_exclam,              SCIM_KEY_1 },
  { SCIM_KEY_quotedbl,            SCIM_KEY_percent },
  { SCIM_KEY_numbersign,          SCIM_KEY_3 },
  { SCIM_KEY_dollar,              SCIM_KEY_4 },
  { SCIM_KEY_percent,             SCIM_KEY_5 },
  { SCIM_KEY_ampersand,           SCIM_KEY_7 },
  { SCIM_KEY_parenleft,           SCIM_KEY_9 },
  { SCIM_KEY_parenright,          SCIM_KEY_0 },
  { SCIM_KEY_asterisk,            SCIM_KEY_8 },
  { SCIM_KEY_plus,                SCIM_KEY_underscore },
  { SCIM_KEY_colon,               SCIM_KEY_m },
  { SCIM_KEY_less,                SCIM_KEY_period },
  { SCIM_KEY_greater,             SCIM_KEY_slash },
  { SCIM_KEY_question,            SCIM_KEY_plus },
  { SCIM_KEY_at,                  SCIM_KEY_2 },
  { SCIM_KEY_asciicircum,         SCIM_KEY_6 },
  { SCIM_KEY_underscore,          SCIM_KEY_degree },
  { SCIM_KEY_a,                   SCIM_KEY_q },
  { SCIM_KEY_m,                   SCIM_KEY_question },
  { SCIM_KEY_q,                   SCIM_KEY_a },
  { SCIM_KEY_w,                   SCIM_KEY_z },
  { SCIM_KEY_z,                   SCIM_KEY_w },
  { SCIM_KEY_braceleft,           SCIM_KEY_dead_diaeresis },
  { SCIM_KEY_bar,                 SCIM_KEY_sterling },
  { SCIM_KEY_braceright,          SCIM_KEY_asterisk },
  { SCIM_KEY_asciitilde,          SCIM_KEY_threesuperior },
};

static __Uint16Pair __czech_to_us_normal [] = {
  { SCIM_KEY_parenright,          SCIM_KEY_bracketright },
  { SCIM_KEY_plus,                SCIM_KEY_1 },
  { SCIM_KEY_minus,               SCIM_KEY_slash },
  { SCIM_KEY_semicolon,           SCIM_KEY_grave },
  { SCIM_KEY_equal,               SCIM_KEY_minus },
  { SCIM_KEY_y,                   SCIM_KEY_z },
  { SCIM_KEY_z,                   SCIM_KEY_y },
  { SCIM_KEY_section,             SCIM_KEY_apostrophe },
  { SCIM_KEY_aacute,              SCIM_KEY_8 },
  { SCIM_KEY_eacute,              SCIM_KEY_0 },
  { SCIM_KEY_iacute,              SCIM_KEY_9 },
  { SCIM_KEY_uacute,              SCIM_KEY_bracketleft },
  { SCIM_KEY_yacute,              SCIM_KEY_7 },
  { SCIM_KEY_scaron,              SCIM_KEY_3 },
  { SCIM_KEY_zcaron,              SCIM_KEY_6 },
  { SCIM_KEY_ccaron,              SCIM_KEY_4 },
  { SCIM_KEY_ecaron,              SCIM_KEY_2 },
  { SCIM_KEY_rcaron,              SCIM_KEY_5 },
  { SCIM_KEY_uring,               SCIM_KEY_semicolon },
  { SCIM_KEY_dead_acute,          SCIM_KEY_equal },
  { SCIM_KEY_dead_diaeresis,      SCIM_KEY_backslash },
};

static __Uint16Pair __us_to_czech_normal [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_section },
  { SCIM_KEY_minus,               SCIM_KEY_equal },
  { SCIM_KEY_slash,               SCIM_KEY_minus },
  { SCIM_KEY_0,                   SCIM_KEY_eacute },
  { SCIM_KEY_1,                   SCIM_KEY_plus },
  { SCIM_KEY_2,                   SCIM_KEY_ecaron },
  { SCIM_KEY_3,                   SCIM_KEY_scaron },
  { SCIM_KEY_4,                   SCIM_KEY_ccaron },
  { SCIM_KEY_5,                   SCIM_KEY_rcaron },
  { SCIM_KEY_6,                   SCIM_KEY_zcaron },
  { SCIM_KEY_7,                   SCIM_KEY_yacute },
  { SCIM_KEY_8,                   SCIM_KEY_aacute },
  { SCIM_KEY_9,                   SCIM_KEY_iacute },
  { SCIM_KEY_semicolon,           SCIM_KEY_uring },
  { SCIM_KEY_equal,               SCIM_KEY_dead_acute },
  { SCIM_KEY_bracketleft,         SCIM_KEY_uacute },
  { SCIM_KEY_backslash,           SCIM_KEY_dead_diaeresis },
  { SCIM_KEY_bracketright,        SCIM_KEY_parenright },
  { SCIM_KEY_grave,               SCIM_KEY_semicolon },
  { SCIM_KEY_y,                   SCIM_KEY_z },
  { SCIM_KEY_z,                   SCIM_KEY_y },
};

static __Uint16Pair __czech_to_us_caps [] = {
  { SCIM_KEY_parenright,          SCIM_KEY_bracketright },
  { SCIM_KEY_plus,                SCIM_KEY_1 },
  { SCIM_KEY_minus,               SCIM_KEY_slash },
  { SCIM_KEY_semicolon,           SCIM_KEY_grave },
  { SCIM_KEY_equal,               SCIM_KEY_minus },
  { SCIM_KEY_Y,                   SCIM_KEY_Z },
  { SCIM_KEY_Z,                   SCIM_KEY_Y },
  { SCIM_KEY_section,             SCIM_KEY_apostrophe },
  { SCIM_KEY_Aacute,              SCIM_KEY_8 },
  { SCIM_KEY_Eacute,              SCIM_KEY_0 },
  { SCIM_KEY_Iacute,              SCIM_KEY_9 },
  { SCIM_KEY_Uacute,              SCIM_KEY_bracketleft },
  { SCIM_KEY_Yacute,              SCIM_KEY_7 },
  { SCIM_KEY_Scaron,              SCIM_KEY_3 },
  { SCIM_KEY_Zcaron,              SCIM_KEY_6 },
  { SCIM_KEY_Ccaron,              SCIM_KEY_4 },
  { SCIM_KEY_Ecaron,              SCIM_KEY_2 },
  { SCIM_KEY_Rcaron,              SCIM_KEY_5 },
  { SCIM_KEY_Uring,               SCIM_KEY_semicolon },
  { SCIM_KEY_dead_acute,          SCIM_KEY_equal },
  { SCIM_KEY_dead_diaeresis,      SCIM_KEY_backslash },
};

static __Uint16Pair __us_to_czech_caps [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_section },
  { SCIM_KEY_minus,               SCIM_KEY_equal },
  { SCIM_KEY_slash,               SCIM_KEY_minus },
  { SCIM_KEY_0,                   SCIM_KEY_Eacute },
  { SCIM_KEY_1,                   SCIM_KEY_plus },
  { SCIM_KEY_2,                   SCIM_KEY_Ecaron },
  { SCIM_KEY_3,                   SCIM_KEY_Scaron },
  { SCIM_KEY_4,                   SCIM_KEY_Ccaron },
  { SCIM_KEY_5,                   SCIM_KEY_Rcaron },
  { SCIM_KEY_6,                   SCIM_KEY_Zcaron },
  { SCIM_KEY_7,                   SCIM_KEY_Yacute },
  { SCIM_KEY_8,                   SCIM_KEY_Aacute },
  { SCIM_KEY_9,                   SCIM_KEY_Iacute },
  { SCIM_KEY_semicolon,           SCIM_KEY_Uring },
  { SCIM_KEY_equal,               SCIM_KEY_dead_acute },
  { SCIM_KEY_Y,                   SCIM_KEY_Z },
  { SCIM_KEY_Z,                   SCIM_KEY_Y },
  { SCIM_KEY_bracketleft,         SCIM_KEY_Uacute },
  { SCIM_KEY_backslash,           SCIM_KEY_dead_diaeresis },
  { SCIM_KEY_bracketright,        SCIM_KEY_parenright },
  { SCIM_KEY_grave,               SCIM_KEY_semicolon },
};

static __Uint16Pair __czech_to_us_shift [] = {
  { SCIM_KEY_exclam,              SCIM_KEY_quotedbl },
  { SCIM_KEY_quotedbl,            SCIM_KEY_colon },
  { SCIM_KEY_percent,             SCIM_KEY_underscore },
  { SCIM_KEY_apostrophe,          SCIM_KEY_bar },
  { SCIM_KEY_parenleft,           SCIM_KEY_braceright },
  { SCIM_KEY_slash,               SCIM_KEY_braceleft },
  { SCIM_KEY_0,                   SCIM_KEY_parenright },
  { SCIM_KEY_1,                   SCIM_KEY_exclam },
  { SCIM_KEY_2,                   SCIM_KEY_at },
  { SCIM_KEY_3,                   SCIM_KEY_numbersign },
  { SCIM_KEY_4,                   SCIM_KEY_dollar },
  { SCIM_KEY_5,                   SCIM_KEY_percent },
  { SCIM_KEY_6,                   SCIM_KEY_asciicircum },
  { SCIM_KEY_7,                   SCIM_KEY_ampersand },
  { SCIM_KEY_8,                   SCIM_KEY_asterisk },
  { SCIM_KEY_9,                   SCIM_KEY_parenleft },
  { SCIM_KEY_colon,               SCIM_KEY_greater },
  { SCIM_KEY_question,            SCIM_KEY_less },
  { SCIM_KEY_Y,                   SCIM_KEY_Z },
  { SCIM_KEY_Z,                   SCIM_KEY_Y },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_dead_abovering,      SCIM_KEY_asciitilde },
  { SCIM_KEY_dead_caron,          SCIM_KEY_plus },
};

static __Uint16Pair __us_to_czech_shift [] = {
  { SCIM_KEY_exclam,              SCIM_KEY_1 },
  { SCIM_KEY_quotedbl,            SCIM_KEY_exclam },
  { SCIM_KEY_numbersign,          SCIM_KEY_3 },
  { SCIM_KEY_dollar,              SCIM_KEY_4 },
  { SCIM_KEY_percent,             SCIM_KEY_5 },
  { SCIM_KEY_ampersand,           SCIM_KEY_7 },
  { SCIM_KEY_parenleft,           SCIM_KEY_9 },
  { SCIM_KEY_parenright,          SCIM_KEY_0 },
  { SCIM_KEY_asterisk,            SCIM_KEY_8 },
  { SCIM_KEY_plus,                SCIM_KEY_dead_caron },
  { SCIM_KEY_colon,               SCIM_KEY_quotedbl },
  { SCIM_KEY_less,                SCIM_KEY_question },
  { SCIM_KEY_greater,             SCIM_KEY_colon },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_at,                  SCIM_KEY_2 },
  { SCIM_KEY_Y,                   SCIM_KEY_Z },
  { SCIM_KEY_Z,                   SCIM_KEY_Y },
  { SCIM_KEY_asciicircum,         SCIM_KEY_6 },
  { SCIM_KEY_underscore,          SCIM_KEY_percent },
  { SCIM_KEY_braceleft,           SCIM_KEY_slash },
  { SCIM_KEY_bar,                 SCIM_KEY_apostrophe },
  { SCIM_KEY_braceright,          SCIM_KEY_parenleft },
  { SCIM_KEY_asciitilde,          SCIM_KEY_dead_abovering },
};

static __Uint16Pair __czech_to_us_caps_shift [] = {
  { SCIM_KEY_exclam,              SCIM_KEY_quotedbl },
  { SCIM_KEY_quotedbl,            SCIM_KEY_colon },
  { SCIM_KEY_percent,             SCIM_KEY_underscore },
  { SCIM_KEY_apostrophe,          SCIM_KEY_bar },
  { SCIM_KEY_parenleft,           SCIM_KEY_braceright },
  { SCIM_KEY_slash,               SCIM_KEY_braceleft },
  { SCIM_KEY_0,                   SCIM_KEY_parenright },
  { SCIM_KEY_1,                   SCIM_KEY_exclam },
  { SCIM_KEY_2,                   SCIM_KEY_at },
  { SCIM_KEY_3,                   SCIM_KEY_numbersign },
  { SCIM_KEY_4,                   SCIM_KEY_dollar },
  { SCIM_KEY_5,                   SCIM_KEY_percent },
  { SCIM_KEY_6,                   SCIM_KEY_asciicircum },
  { SCIM_KEY_7,                   SCIM_KEY_ampersand },
  { SCIM_KEY_8,                   SCIM_KEY_asterisk },
  { SCIM_KEY_9,                   SCIM_KEY_parenleft },
  { SCIM_KEY_colon,               SCIM_KEY_greater },
  { SCIM_KEY_question,            SCIM_KEY_less },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_y,                   SCIM_KEY_z },
  { SCIM_KEY_z,                   SCIM_KEY_y },
  { SCIM_KEY_dead_abovering,      SCIM_KEY_asciitilde },
  { SCIM_KEY_dead_caron,          SCIM_KEY_plus },
};

static __Uint16Pair __us_to_czech_caps_shift [] = {
  { SCIM_KEY_exclam,              SCIM_KEY_1 },
  { SCIM_KEY_quotedbl,            SCIM_KEY_exclam },
  { SCIM_KEY_numbersign,          SCIM_KEY_3 },
  { SCIM_KEY_dollar,              SCIM_KEY_4 },
  { SCIM_KEY_percent,             SCIM_KEY_5 },
  { SCIM_KEY_ampersand,           SCIM_KEY_7 },
  { SCIM_KEY_parenleft,           SCIM_KEY_9 },
  { SCIM_KEY_parenright,          SCIM_KEY_0 },
  { SCIM_KEY_asterisk,            SCIM_KEY_8 },
  { SCIM_KEY_plus,                SCIM_KEY_dead_caron },
  { SCIM_KEY_colon,               SCIM_KEY_quotedbl },
  { SCIM_KEY_less,                SCIM_KEY_question },
  { SCIM_KEY_greater,             SCIM_KEY_colon },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_at,                  SCIM_KEY_2 },
  { SCIM_KEY_asciicircum,         SCIM_KEY_6 },
  { SCIM_KEY_underscore,          SCIM_KEY_percent },
  { SCIM_KEY_y,                   SCIM_KEY_z },
  { SCIM_KEY_z,                   SCIM_KEY_y },
  { SCIM_KEY_braceleft,           SCIM_KEY_slash },
  { SCIM_KEY_bar,                 SCIM_KEY_apostrophe },
  { SCIM_KEY_braceright,          SCIM_KEY_parenleft },
  { SCIM_KEY_asciitilde,          SCIM_KEY_dead_abovering },
};

static __Uint16Pair __czech_qwerty_to_us_normal [] = {
  { SCIM_KEY_parenright,          SCIM_KEY_bracketright },
  { SCIM_KEY_plus,                SCIM_KEY_1 },
  { SCIM_KEY_minus,               SCIM_KEY_slash },
  { SCIM_KEY_semicolon,           SCIM_KEY_grave },
  { SCIM_KEY_equal,               SCIM_KEY_minus },
  { SCIM_KEY_section,             SCIM_KEY_apostrophe },
  { SCIM_KEY_aacute,              SCIM_KEY_8 },
  { SCIM_KEY_eacute,              SCIM_KEY_0 },
  { SCIM_KEY_iacute,              SCIM_KEY_9 },
  { SCIM_KEY_uacute,              SCIM_KEY_bracketleft },
  { SCIM_KEY_yacute,              SCIM_KEY_7 },
  { SCIM_KEY_scaron,              SCIM_KEY_3 },
  { SCIM_KEY_zcaron,              SCIM_KEY_6 },
  { SCIM_KEY_ccaron,              SCIM_KEY_4 },
  { SCIM_KEY_ecaron,              SCIM_KEY_2 },
  { SCIM_KEY_rcaron,              SCIM_KEY_5 },
  { SCIM_KEY_uring,               SCIM_KEY_semicolon },
  { SCIM_KEY_dead_acute,          SCIM_KEY_equal },
  { SCIM_KEY_dead_diaeresis,      SCIM_KEY_backslash },
};

static __Uint16Pair __us_to_czech_qwerty_normal [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_section },
  { SCIM_KEY_minus,               SCIM_KEY_equal },
  { SCIM_KEY_slash,               SCIM_KEY_minus },
  { SCIM_KEY_0,                   SCIM_KEY_eacute },
  { SCIM_KEY_1,                   SCIM_KEY_plus },
  { SCIM_KEY_2,                   SCIM_KEY_ecaron },
  { SCIM_KEY_3,                   SCIM_KEY_scaron },
  { SCIM_KEY_4,                   SCIM_KEY_ccaron },
  { SCIM_KEY_5,                   SCIM_KEY_rcaron },
  { SCIM_KEY_6,                   SCIM_KEY_zcaron },
  { SCIM_KEY_7,                   SCIM_KEY_yacute },
  { SCIM_KEY_8,                   SCIM_KEY_aacute },
  { SCIM_KEY_9,                   SCIM_KEY_iacute },
  { SCIM_KEY_semicolon,           SCIM_KEY_uring },
  { SCIM_KEY_equal,               SCIM_KEY_dead_acute },
  { SCIM_KEY_bracketleft,         SCIM_KEY_uacute },
  { SCIM_KEY_backslash,           SCIM_KEY_dead_diaeresis },
  { SCIM_KEY_bracketright,        SCIM_KEY_parenright },
  { SCIM_KEY_grave,               SCIM_KEY_semicolon },
};

static __Uint16Pair __czech_qwerty_to_us_caps [] = {
  { SCIM_KEY_parenright,          SCIM_KEY_bracketright },
  { SCIM_KEY_plus,                SCIM_KEY_1 },
  { SCIM_KEY_minus,               SCIM_KEY_slash },
  { SCIM_KEY_semicolon,           SCIM_KEY_grave },
  { SCIM_KEY_equal,               SCIM_KEY_minus },
  { SCIM_KEY_section,             SCIM_KEY_apostrophe },
  { SCIM_KEY_Aacute,              SCIM_KEY_8 },
  { SCIM_KEY_Eacute,              SCIM_KEY_0 },
  { SCIM_KEY_Iacute,              SCIM_KEY_9 },
  { SCIM_KEY_Uacute,              SCIM_KEY_bracketleft },
  { SCIM_KEY_Yacute,              SCIM_KEY_7 },
  { SCIM_KEY_Scaron,              SCIM_KEY_3 },
  { SCIM_KEY_Zcaron,              SCIM_KEY_6 },
  { SCIM_KEY_Ccaron,              SCIM_KEY_4 },
  { SCIM_KEY_Ecaron,              SCIM_KEY_2 },
  { SCIM_KEY_Rcaron,              SCIM_KEY_5 },
  { SCIM_KEY_Uring,               SCIM_KEY_semicolon },
  { SCIM_KEY_dead_acute,          SCIM_KEY_equal },
  { SCIM_KEY_dead_diaeresis,      SCIM_KEY_backslash },
};

static __Uint16Pair __us_to_czech_qwerty_caps [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_section },
  { SCIM_KEY_minus,               SCIM_KEY_equal },
  { SCIM_KEY_slash,               SCIM_KEY_minus },
  { SCIM_KEY_0,                   SCIM_KEY_Eacute },
  { SCIM_KEY_1,                   SCIM_KEY_plus },
  { SCIM_KEY_2,                   SCIM_KEY_Ecaron },
  { SCIM_KEY_3,                   SCIM_KEY_Scaron },
  { SCIM_KEY_4,                   SCIM_KEY_Ccaron },
  { SCIM_KEY_5,                   SCIM_KEY_Rcaron },
  { SCIM_KEY_6,                   SCIM_KEY_Zcaron },
  { SCIM_KEY_7,                   SCIM_KEY_Yacute },
  { SCIM_KEY_8,                   SCIM_KEY_Aacute },
  { SCIM_KEY_9,                   SCIM_KEY_Iacute },
  { SCIM_KEY_semicolon,           SCIM_KEY_Uring },
  { SCIM_KEY_equal,               SCIM_KEY_dead_acute },
  { SCIM_KEY_bracketleft,         SCIM_KEY_Uacute },
  { SCIM_KEY_backslash,           SCIM_KEY_dead_diaeresis },
  { SCIM_KEY_bracketright,        SCIM_KEY_parenright },
  { SCIM_KEY_grave,               SCIM_KEY_semicolon },
};

static __Uint16Pair __czech_qwerty_to_us_shift [] = {
  { SCIM_KEY_exclam,              SCIM_KEY_quotedbl },
  { SCIM_KEY_quotedbl,            SCIM_KEY_colon },
  { SCIM_KEY_percent,             SCIM_KEY_underscore },
  { SCIM_KEY_apostrophe,          SCIM_KEY_bar },
  { SCIM_KEY_parenleft,           SCIM_KEY_braceright },
  { SCIM_KEY_slash,               SCIM_KEY_braceleft },
  { SCIM_KEY_0,                   SCIM_KEY_parenright },
  { SCIM_KEY_1,                   SCIM_KEY_exclam },
  { SCIM_KEY_2,                   SCIM_KEY_at },
  { SCIM_KEY_3,                   SCIM_KEY_numbersign },
  { SCIM_KEY_4,                   SCIM_KEY_dollar },
  { SCIM_KEY_5,                   SCIM_KEY_percent },
  { SCIM_KEY_6,                   SCIM_KEY_asciicircum },
  { SCIM_KEY_7,                   SCIM_KEY_ampersand },
  { SCIM_KEY_8,                   SCIM_KEY_asterisk },
  { SCIM_KEY_9,                   SCIM_KEY_parenleft },
  { SCIM_KEY_colon,               SCIM_KEY_greater },
  { SCIM_KEY_question,            SCIM_KEY_less },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_dead_abovering,      SCIM_KEY_asciitilde },
  { SCIM_KEY_dead_caron,          SCIM_KEY_plus },
};

static __Uint16Pair __us_to_czech_qwerty_shift [] = {
  { SCIM_KEY_exclam,              SCIM_KEY_1 },
  { SCIM_KEY_quotedbl,            SCIM_KEY_exclam },
  { SCIM_KEY_numbersign,          SCIM_KEY_3 },
  { SCIM_KEY_dollar,              SCIM_KEY_4 },
  { SCIM_KEY_percent,             SCIM_KEY_5 },
  { SCIM_KEY_ampersand,           SCIM_KEY_7 },
  { SCIM_KEY_parenleft,           SCIM_KEY_9 },
  { SCIM_KEY_parenright,          SCIM_KEY_0 },
  { SCIM_KEY_asterisk,            SCIM_KEY_8 },
  { SCIM_KEY_plus,                SCIM_KEY_dead_caron },
  { SCIM_KEY_colon,               SCIM_KEY_quotedbl },
  { SCIM_KEY_less,                SCIM_KEY_question },
  { SCIM_KEY_greater,             SCIM_KEY_colon },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_at,                  SCIM_KEY_2 },
  { SCIM_KEY_asciicircum,         SCIM_KEY_6 },
  { SCIM_KEY_underscore,          SCIM_KEY_percent },
  { SCIM_KEY_braceleft,           SCIM_KEY_slash },
  { SCIM_KEY_bar,                 SCIM_KEY_apostrophe },
  { SCIM_KEY_braceright,          SCIM_KEY_parenleft },
  { SCIM_KEY_asciitilde,          SCIM_KEY_dead_abovering },
};

static __Uint16Pair __czech_qwerty_to_us_caps_shift [] = {
  { SCIM_KEY_exclam,              SCIM_KEY_quotedbl },
  { SCIM_KEY_quotedbl,            SCIM_KEY_colon },
  { SCIM_KEY_percent,             SCIM_KEY_underscore },
  { SCIM_KEY_apostrophe,          SCIM_KEY_bar },
  { SCIM_KEY_parenleft,           SCIM_KEY_braceright },
  { SCIM_KEY_slash,               SCIM_KEY_braceleft },
  { SCIM_KEY_0,                   SCIM_KEY_parenright },
  { SCIM_KEY_1,                   SCIM_KEY_exclam },
  { SCIM_KEY_2,                   SCIM_KEY_at },
  { SCIM_KEY_3,                   SCIM_KEY_numbersign },
  { SCIM_KEY_4,                   SCIM_KEY_dollar },
  { SCIM_KEY_5,                   SCIM_KEY_percent },
  { SCIM_KEY_6,                   SCIM_KEY_asciicircum },
  { SCIM_KEY_7,                   SCIM_KEY_ampersand },
  { SCIM_KEY_8,                   SCIM_KEY_asterisk },
  { SCIM_KEY_9,                   SCIM_KEY_parenleft },
  { SCIM_KEY_colon,               SCIM_KEY_greater },
  { SCIM_KEY_question,            SCIM_KEY_less },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_dead_abovering,      SCIM_KEY_asciitilde },
  { SCIM_KEY_dead_caron,          SCIM_KEY_plus },
};

static __Uint16Pair __us_to_czech_qwerty_caps_shift [] = {
  { SCIM_KEY_exclam,              SCIM_KEY_1 },
  { SCIM_KEY_quotedbl,            SCIM_KEY_exclam },
  { SCIM_KEY_numbersign,          SCIM_KEY_3 },
  { SCIM_KEY_dollar,              SCIM_KEY_4 },
  { SCIM_KEY_percent,             SCIM_KEY_5 },
  { SCIM_KEY_ampersand,           SCIM_KEY_7 },
  { SCIM_KEY_parenleft,           SCIM_KEY_9 },
  { SCIM_KEY_parenright,          SCIM_KEY_0 },
  { SCIM_KEY_asterisk,            SCIM_KEY_8 },
  { SCIM_KEY_plus,                SCIM_KEY_dead_caron },
  { SCIM_KEY_colon,               SCIM_KEY_quotedbl },
  { SCIM_KEY_less,                SCIM_KEY_question },
  { SCIM_KEY_greater,             SCIM_KEY_colon },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_at,                  SCIM_KEY_2 },
  { SCIM_KEY_asciicircum,         SCIM_KEY_6 },
  { SCIM_KEY_underscore,          SCIM_KEY_percent },
  { SCIM_KEY_braceleft,           SCIM_KEY_slash },
  { SCIM_KEY_bar,                 SCIM_KEY_apostrophe },
  { SCIM_KEY_braceright,          SCIM_KEY_parenleft },
  { SCIM_KEY_asciitilde,          SCIM_KEY_dead_abovering },
};

static __Uint16Pair __danish_to_us_normal [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_backslash },
  { SCIM_KEY_plus,                SCIM_KEY_minus },
  { SCIM_KEY_minus,               SCIM_KEY_slash },
  { SCIM_KEY_onehalf,             SCIM_KEY_grave },
  { SCIM_KEY_aring,               SCIM_KEY_bracketleft },
  { SCIM_KEY_ae,                  SCIM_KEY_semicolon },
  { SCIM_KEY_oslash,              SCIM_KEY_apostrophe },
  { SCIM_KEY_dead_acute,          SCIM_KEY_equal },
  { SCIM_KEY_dead_diaeresis,      SCIM_KEY_bracketright },
};

static __Uint16Pair __us_to_danish_normal [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_oslash },
  { SCIM_KEY_minus,               SCIM_KEY_plus },
  { SCIM_KEY_slash,               SCIM_KEY_minus },
  { SCIM_KEY_semicolon,           SCIM_KEY_ae },
  { SCIM_KEY_equal,               SCIM_KEY_dead_acute },
  { SCIM_KEY_bracketleft,         SCIM_KEY_aring },
  { SCIM_KEY_backslash,           SCIM_KEY_apostrophe },
  { SCIM_KEY_bracketright,        SCIM_KEY_dead_diaeresis },
  { SCIM_KEY_grave,               SCIM_KEY_onehalf },
};

static __Uint16Pair __danish_to_us_caps [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_backslash },
  { SCIM_KEY_plus,                SCIM_KEY_minus },
  { SCIM_KEY_minus,               SCIM_KEY_slash },
  { SCIM_KEY_onehalf,             SCIM_KEY_grave },
  { SCIM_KEY_Aring,               SCIM_KEY_bracketleft },
  { SCIM_KEY_AE,                  SCIM_KEY_semicolon },
  { SCIM_KEY_Ooblique,            SCIM_KEY_apostrophe },
  { SCIM_KEY_dead_acute,          SCIM_KEY_equal },
  { SCIM_KEY_dead_diaeresis,      SCIM_KEY_bracketright },
};

static __Uint16Pair __us_to_danish_caps [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_Ooblique },
  { SCIM_KEY_minus,               SCIM_KEY_plus },
  { SCIM_KEY_slash,               SCIM_KEY_minus },
  { SCIM_KEY_semicolon,           SCIM_KEY_AE },
  { SCIM_KEY_equal,               SCIM_KEY_dead_acute },
  { SCIM_KEY_bracketleft,         SCIM_KEY_Aring },
  { SCIM_KEY_backslash,           SCIM_KEY_apostrophe },
  { SCIM_KEY_bracketright,        SCIM_KEY_dead_diaeresis },
  { SCIM_KEY_grave,               SCIM_KEY_onehalf },
};

static __Uint16Pair __danish_to_us_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_at },
  { SCIM_KEY_ampersand,           SCIM_KEY_asciicircum },
  { SCIM_KEY_parenleft,           SCIM_KEY_asterisk },
  { SCIM_KEY_parenright,          SCIM_KEY_parenleft },
  { SCIM_KEY_asterisk,            SCIM_KEY_bar },
  { SCIM_KEY_slash,               SCIM_KEY_ampersand },
  { SCIM_KEY_colon,               SCIM_KEY_greater },
  { SCIM_KEY_semicolon,           SCIM_KEY_less },
  { SCIM_KEY_equal,               SCIM_KEY_parenright },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_currency,            SCIM_KEY_dollar },
  { SCIM_KEY_section,             SCIM_KEY_asciitilde },
  { SCIM_KEY_Aring,               SCIM_KEY_braceleft },
  { SCIM_KEY_AE,                  SCIM_KEY_colon },
  { SCIM_KEY_Ooblique,            SCIM_KEY_quotedbl },
  { SCIM_KEY_dead_grave,          SCIM_KEY_plus },
  { SCIM_KEY_dead_circumflex,     SCIM_KEY_braceright },
};

static __Uint16Pair __us_to_danish_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_Ooblique },
  { SCIM_KEY_dollar,              SCIM_KEY_currency },
  { SCIM_KEY_ampersand,           SCIM_KEY_slash },
  { SCIM_KEY_parenleft,           SCIM_KEY_parenright },
  { SCIM_KEY_parenright,          SCIM_KEY_equal },
  { SCIM_KEY_asterisk,            SCIM_KEY_parenleft },
  { SCIM_KEY_plus,                SCIM_KEY_dead_grave },
  { SCIM_KEY_colon,               SCIM_KEY_AE },
  { SCIM_KEY_less,                SCIM_KEY_semicolon },
  { SCIM_KEY_greater,             SCIM_KEY_colon },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_at,                  SCIM_KEY_quotedbl },
  { SCIM_KEY_asciicircum,         SCIM_KEY_ampersand },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_braceleft,           SCIM_KEY_Aring },
  { SCIM_KEY_bar,                 SCIM_KEY_asterisk },
  { SCIM_KEY_braceright,          SCIM_KEY_dead_circumflex },
  { SCIM_KEY_asciitilde,          SCIM_KEY_section },
};

static __Uint16Pair __danish_to_us_caps_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_at },
  { SCIM_KEY_ampersand,           SCIM_KEY_asciicircum },
  { SCIM_KEY_parenleft,           SCIM_KEY_asterisk },
  { SCIM_KEY_parenright,          SCIM_KEY_parenleft },
  { SCIM_KEY_asterisk,            SCIM_KEY_bar },
  { SCIM_KEY_slash,               SCIM_KEY_ampersand },
  { SCIM_KEY_colon,               SCIM_KEY_greater },
  { SCIM_KEY_semicolon,           SCIM_KEY_less },
  { SCIM_KEY_equal,               SCIM_KEY_parenright },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_currency,            SCIM_KEY_dollar },
  { SCIM_KEY_section,             SCIM_KEY_asciitilde },
  { SCIM_KEY_aring,               SCIM_KEY_braceleft },
  { SCIM_KEY_ae,                  SCIM_KEY_colon },
  { SCIM_KEY_oslash,              SCIM_KEY_quotedbl },
  { SCIM_KEY_dead_grave,          SCIM_KEY_plus },
  { SCIM_KEY_dead_circumflex,     SCIM_KEY_braceright },
};

static __Uint16Pair __us_to_danish_caps_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_oslash },
  { SCIM_KEY_dollar,              SCIM_KEY_currency },
  { SCIM_KEY_ampersand,           SCIM_KEY_slash },
  { SCIM_KEY_parenleft,           SCIM_KEY_parenright },
  { SCIM_KEY_parenright,          SCIM_KEY_equal },
  { SCIM_KEY_asterisk,            SCIM_KEY_parenleft },
  { SCIM_KEY_plus,                SCIM_KEY_dead_grave },
  { SCIM_KEY_colon,               SCIM_KEY_ae },
  { SCIM_KEY_less,                SCIM_KEY_semicolon },
  { SCIM_KEY_greater,             SCIM_KEY_colon },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_at,                  SCIM_KEY_quotedbl },
  { SCIM_KEY_asciicircum,         SCIM_KEY_ampersand },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_braceleft,           SCIM_KEY_aring },
  { SCIM_KEY_bar,                 SCIM_KEY_asterisk },
  { SCIM_KEY_braceright,          SCIM_KEY_dead_circumflex },
  { SCIM_KEY_asciitilde,          SCIM_KEY_section },
};

static __Uint16Pair __dvorak_to_us_normal [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_q },
  { SCIM_KEY_comma,               SCIM_KEY_w },
  { SCIM_KEY_minus,               SCIM_KEY_apostrophe },
  { SCIM_KEY_period,              SCIM_KEY_e },
  { SCIM_KEY_slash,               SCIM_KEY_bracketleft },
  { SCIM_KEY_semicolon,           SCIM_KEY_z },
  { SCIM_KEY_equal,               SCIM_KEY_bracketright },
  { SCIM_KEY_bracketleft,         SCIM_KEY_minus },
  { SCIM_KEY_bracketright,        SCIM_KEY_equal },
  { SCIM_KEY_b,                   SCIM_KEY_n },
  { SCIM_KEY_c,                   SCIM_KEY_i },
  { SCIM_KEY_d,                   SCIM_KEY_h },
  { SCIM_KEY_e,                   SCIM_KEY_d },
  { SCIM_KEY_f,                   SCIM_KEY_y },
  { SCIM_KEY_g,                   SCIM_KEY_u },
  { SCIM_KEY_h,                   SCIM_KEY_j },
  { SCIM_KEY_i,                   SCIM_KEY_g },
  { SCIM_KEY_j,                   SCIM_KEY_c },
  { SCIM_KEY_k,                   SCIM_KEY_v },
  { SCIM_KEY_l,                   SCIM_KEY_p },
  { SCIM_KEY_n,                   SCIM_KEY_l },
  { SCIM_KEY_o,                   SCIM_KEY_s },
  { SCIM_KEY_p,                   SCIM_KEY_r },
  { SCIM_KEY_q,                   SCIM_KEY_x },
  { SCIM_KEY_r,                   SCIM_KEY_o },
  { SCIM_KEY_s,                   SCIM_KEY_semicolon },
  { SCIM_KEY_t,                   SCIM_KEY_k },
  { SCIM_KEY_u,                   SCIM_KEY_f },
  { SCIM_KEY_v,                   SCIM_KEY_period },
  { SCIM_KEY_w,                   SCIM_KEY_comma },
  { SCIM_KEY_x,                   SCIM_KEY_b },
  { SCIM_KEY_y,                   SCIM_KEY_t },
  { SCIM_KEY_z,                   SCIM_KEY_slash },
};

static __Uint16Pair __us_to_dvorak_normal [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_minus },
  { SCIM_KEY_comma,               SCIM_KEY_w },
  { SCIM_KEY_minus,               SCIM_KEY_bracketleft },
  { SCIM_KEY_period,              SCIM_KEY_v },
  { SCIM_KEY_slash,               SCIM_KEY_z },
  { SCIM_KEY_semicolon,           SCIM_KEY_s },
  { SCIM_KEY_equal,               SCIM_KEY_bracketright },
  { SCIM_KEY_bracketleft,         SCIM_KEY_slash },
  { SCIM_KEY_bracketright,        SCIM_KEY_equal },
  { SCIM_KEY_b,                   SCIM_KEY_x },
  { SCIM_KEY_c,                   SCIM_KEY_j },
  { SCIM_KEY_d,                   SCIM_KEY_e },
  { SCIM_KEY_e,                   SCIM_KEY_period },
  { SCIM_KEY_f,                   SCIM_KEY_u },
  { SCIM_KEY_g,                   SCIM_KEY_i },
  { SCIM_KEY_h,                   SCIM_KEY_d },
  { SCIM_KEY_i,                   SCIM_KEY_c },
  { SCIM_KEY_j,                   SCIM_KEY_h },
  { SCIM_KEY_k,                   SCIM_KEY_t },
  { SCIM_KEY_l,                   SCIM_KEY_n },
  { SCIM_KEY_n,                   SCIM_KEY_b },
  { SCIM_KEY_o,                   SCIM_KEY_r },
  { SCIM_KEY_p,                   SCIM_KEY_l },
  { SCIM_KEY_q,                   SCIM_KEY_apostrophe },
  { SCIM_KEY_r,                   SCIM_KEY_p },
  { SCIM_KEY_s,                   SCIM_KEY_o },
  { SCIM_KEY_t,                   SCIM_KEY_y },
  { SCIM_KEY_u,                   SCIM_KEY_g },
  { SCIM_KEY_v,                   SCIM_KEY_k },
  { SCIM_KEY_w,                   SCIM_KEY_comma },
  { SCIM_KEY_x,                   SCIM_KEY_q },
  { SCIM_KEY_y,                   SCIM_KEY_f },
  { SCIM_KEY_z,                   SCIM_KEY_semicolon },
};

static __Uint16Pair __dvorak_to_us_caps [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_Q },
  { SCIM_KEY_comma,               SCIM_KEY_W },
  { SCIM_KEY_minus,               SCIM_KEY_apostrophe },
  { SCIM_KEY_period,              SCIM_KEY_E },
  { SCIM_KEY_slash,               SCIM_KEY_bracketleft },
  { SCIM_KEY_semicolon,           SCIM_KEY_Z },
  { SCIM_KEY_equal,               SCIM_KEY_bracketright },
  { SCIM_KEY_B,                   SCIM_KEY_N },
  { SCIM_KEY_C,                   SCIM_KEY_I },
  { SCIM_KEY_D,                   SCIM_KEY_H },
  { SCIM_KEY_E,                   SCIM_KEY_D },
  { SCIM_KEY_F,                   SCIM_KEY_Y },
  { SCIM_KEY_G,                   SCIM_KEY_U },
  { SCIM_KEY_H,                   SCIM_KEY_J },
  { SCIM_KEY_I,                   SCIM_KEY_G },
  { SCIM_KEY_J,                   SCIM_KEY_C },
  { SCIM_KEY_K,                   SCIM_KEY_V },
  { SCIM_KEY_L,                   SCIM_KEY_P },
  { SCIM_KEY_N,                   SCIM_KEY_L },
  { SCIM_KEY_O,                   SCIM_KEY_S },
  { SCIM_KEY_P,                   SCIM_KEY_R },
  { SCIM_KEY_Q,                   SCIM_KEY_X },
  { SCIM_KEY_R,                   SCIM_KEY_O },
  { SCIM_KEY_S,                   SCIM_KEY_semicolon },
  { SCIM_KEY_T,                   SCIM_KEY_K },
  { SCIM_KEY_U,                   SCIM_KEY_F },
  { SCIM_KEY_V,                   SCIM_KEY_period },
  { SCIM_KEY_W,                   SCIM_KEY_comma },
  { SCIM_KEY_X,                   SCIM_KEY_B },
  { SCIM_KEY_Y,                   SCIM_KEY_T },
  { SCIM_KEY_Z,                   SCIM_KEY_slash },
  { SCIM_KEY_bracketleft,         SCIM_KEY_minus },
  { SCIM_KEY_bracketright,        SCIM_KEY_equal },
};

static __Uint16Pair __us_to_dvorak_caps [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_minus },
  { SCIM_KEY_comma,               SCIM_KEY_W },
  { SCIM_KEY_minus,               SCIM_KEY_bracketleft },
  { SCIM_KEY_period,              SCIM_KEY_V },
  { SCIM_KEY_slash,               SCIM_KEY_Z },
  { SCIM_KEY_semicolon,           SCIM_KEY_S },
  { SCIM_KEY_equal,               SCIM_KEY_bracketright },
  { SCIM_KEY_B,                   SCIM_KEY_X },
  { SCIM_KEY_C,                   SCIM_KEY_J },
  { SCIM_KEY_D,                   SCIM_KEY_E },
  { SCIM_KEY_E,                   SCIM_KEY_period },
  { SCIM_KEY_F,                   SCIM_KEY_U },
  { SCIM_KEY_G,                   SCIM_KEY_I },
  { SCIM_KEY_H,                   SCIM_KEY_D },
  { SCIM_KEY_I,                   SCIM_KEY_C },
  { SCIM_KEY_J,                   SCIM_KEY_H },
  { SCIM_KEY_K,                   SCIM_KEY_T },
  { SCIM_KEY_L,                   SCIM_KEY_N },
  { SCIM_KEY_N,                   SCIM_KEY_B },
  { SCIM_KEY_O,                   SCIM_KEY_R },
  { SCIM_KEY_P,                   SCIM_KEY_L },
  { SCIM_KEY_Q,                   SCIM_KEY_apostrophe },
  { SCIM_KEY_R,                   SCIM_KEY_P },
  { SCIM_KEY_S,                   SCIM_KEY_O },
  { SCIM_KEY_T,                   SCIM_KEY_Y },
  { SCIM_KEY_U,                   SCIM_KEY_G },
  { SCIM_KEY_V,                   SCIM_KEY_K },
  { SCIM_KEY_W,                   SCIM_KEY_comma },
  { SCIM_KEY_X,                   SCIM_KEY_Q },
  { SCIM_KEY_Y,                   SCIM_KEY_F },
  { SCIM_KEY_Z,                   SCIM_KEY_semicolon },
  { SCIM_KEY_bracketleft,         SCIM_KEY_slash },
  { SCIM_KEY_bracketright,        SCIM_KEY_equal },
};

static __Uint16Pair __dvorak_to_us_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_Q },
  { SCIM_KEY_plus,                SCIM_KEY_braceright },
  { SCIM_KEY_colon,               SCIM_KEY_Z },
  { SCIM_KEY_less,                SCIM_KEY_W },
  { SCIM_KEY_greater,             SCIM_KEY_E },
  { SCIM_KEY_question,            SCIM_KEY_braceleft },
  { SCIM_KEY_B,                   SCIM_KEY_N },
  { SCIM_KEY_C,                   SCIM_KEY_I },
  { SCIM_KEY_D,                   SCIM_KEY_H },
  { SCIM_KEY_E,                   SCIM_KEY_D },
  { SCIM_KEY_F,                   SCIM_KEY_Y },
  { SCIM_KEY_G,                   SCIM_KEY_U },
  { SCIM_KEY_H,                   SCIM_KEY_J },
  { SCIM_KEY_I,                   SCIM_KEY_G },
  { SCIM_KEY_J,                   SCIM_KEY_C },
  { SCIM_KEY_K,                   SCIM_KEY_V },
  { SCIM_KEY_L,                   SCIM_KEY_P },
  { SCIM_KEY_N,                   SCIM_KEY_L },
  { SCIM_KEY_O,                   SCIM_KEY_S },
  { SCIM_KEY_P,                   SCIM_KEY_R },
  { SCIM_KEY_Q,                   SCIM_KEY_X },
  { SCIM_KEY_R,                   SCIM_KEY_O },
  { SCIM_KEY_S,                   SCIM_KEY_colon },
  { SCIM_KEY_T,                   SCIM_KEY_K },
  { SCIM_KEY_U,                   SCIM_KEY_F },
  { SCIM_KEY_V,                   SCIM_KEY_greater },
  { SCIM_KEY_W,                   SCIM_KEY_less },
  { SCIM_KEY_X,                   SCIM_KEY_B },
  { SCIM_KEY_Y,                   SCIM_KEY_T },
  { SCIM_KEY_Z,                   SCIM_KEY_question },
  { SCIM_KEY_underscore,          SCIM_KEY_quotedbl },
  { SCIM_KEY_braceleft,           SCIM_KEY_underscore },
  { SCIM_KEY_braceright,          SCIM_KEY_plus },
};

static __Uint16Pair __us_to_dvorak_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_underscore },
  { SCIM_KEY_plus,                SCIM_KEY_braceright },
  { SCIM_KEY_colon,               SCIM_KEY_S },
  { SCIM_KEY_less,                SCIM_KEY_W },
  { SCIM_KEY_greater,             SCIM_KEY_V },
  { SCIM_KEY_question,            SCIM_KEY_Z },
  { SCIM_KEY_B,                   SCIM_KEY_X },
  { SCIM_KEY_C,                   SCIM_KEY_J },
  { SCIM_KEY_D,                   SCIM_KEY_E },
  { SCIM_KEY_E,                   SCIM_KEY_greater },
  { SCIM_KEY_F,                   SCIM_KEY_U },
  { SCIM_KEY_G,                   SCIM_KEY_I },
  { SCIM_KEY_H,                   SCIM_KEY_D },
  { SCIM_KEY_I,                   SCIM_KEY_C },
  { SCIM_KEY_J,                   SCIM_KEY_H },
  { SCIM_KEY_K,                   SCIM_KEY_T },
  { SCIM_KEY_L,                   SCIM_KEY_N },
  { SCIM_KEY_N,                   SCIM_KEY_B },
  { SCIM_KEY_O,                   SCIM_KEY_R },
  { SCIM_KEY_P,                   SCIM_KEY_L },
  { SCIM_KEY_Q,                   SCIM_KEY_quotedbl },
  { SCIM_KEY_R,                   SCIM_KEY_P },
  { SCIM_KEY_S,                   SCIM_KEY_O },
  { SCIM_KEY_T,                   SCIM_KEY_Y },
  { SCIM_KEY_U,                   SCIM_KEY_G },
  { SCIM_KEY_V,                   SCIM_KEY_K },
  { SCIM_KEY_W,                   SCIM_KEY_less },
  { SCIM_KEY_X,                   SCIM_KEY_Q },
  { SCIM_KEY_Y,                   SCIM_KEY_F },
  { SCIM_KEY_Z,                   SCIM_KEY_colon },
  { SCIM_KEY_underscore,          SCIM_KEY_braceleft },
  { SCIM_KEY_braceleft,           SCIM_KEY_question },
  { SCIM_KEY_braceright,          SCIM_KEY_plus },
};

static __Uint16Pair __dvorak_to_us_caps_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_q },
  { SCIM_KEY_plus,                SCIM_KEY_braceright },
  { SCIM_KEY_colon,               SCIM_KEY_z },
  { SCIM_KEY_less,                SCIM_KEY_w },
  { SCIM_KEY_greater,             SCIM_KEY_e },
  { SCIM_KEY_question,            SCIM_KEY_braceleft },
  { SCIM_KEY_underscore,          SCIM_KEY_quotedbl },
  { SCIM_KEY_b,                   SCIM_KEY_n },
  { SCIM_KEY_c,                   SCIM_KEY_i },
  { SCIM_KEY_d,                   SCIM_KEY_h },
  { SCIM_KEY_e,                   SCIM_KEY_d },
  { SCIM_KEY_f,                   SCIM_KEY_y },
  { SCIM_KEY_g,                   SCIM_KEY_u },
  { SCIM_KEY_h,                   SCIM_KEY_j },
  { SCIM_KEY_i,                   SCIM_KEY_g },
  { SCIM_KEY_j,                   SCIM_KEY_c },
  { SCIM_KEY_k,                   SCIM_KEY_v },
  { SCIM_KEY_l,                   SCIM_KEY_p },
  { SCIM_KEY_n,                   SCIM_KEY_l },
  { SCIM_KEY_o,                   SCIM_KEY_s },
  { SCIM_KEY_p,                   SCIM_KEY_r },
  { SCIM_KEY_q,                   SCIM_KEY_x },
  { SCIM_KEY_r,                   SCIM_KEY_o },
  { SCIM_KEY_s,                   SCIM_KEY_colon },
  { SCIM_KEY_t,                   SCIM_KEY_k },
  { SCIM_KEY_u,                   SCIM_KEY_f },
  { SCIM_KEY_v,                   SCIM_KEY_greater },
  { SCIM_KEY_w,                   SCIM_KEY_less },
  { SCIM_KEY_x,                   SCIM_KEY_b },
  { SCIM_KEY_y,                   SCIM_KEY_t },
  { SCIM_KEY_z,                   SCIM_KEY_question },
  { SCIM_KEY_braceleft,           SCIM_KEY_underscore },
  { SCIM_KEY_braceright,          SCIM_KEY_plus },
};

static __Uint16Pair __us_to_dvorak_caps_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_underscore },
  { SCIM_KEY_plus,                SCIM_KEY_braceright },
  { SCIM_KEY_colon,               SCIM_KEY_s },
  { SCIM_KEY_less,                SCIM_KEY_w },
  { SCIM_KEY_greater,             SCIM_KEY_v },
  { SCIM_KEY_question,            SCIM_KEY_z },
  { SCIM_KEY_underscore,          SCIM_KEY_braceleft },
  { SCIM_KEY_b,                   SCIM_KEY_x },
  { SCIM_KEY_c,                   SCIM_KEY_j },
  { SCIM_KEY_d,                   SCIM_KEY_e },
  { SCIM_KEY_e,                   SCIM_KEY_greater },
  { SCIM_KEY_f,                   SCIM_KEY_u },
  { SCIM_KEY_g,                   SCIM_KEY_i },
  { SCIM_KEY_h,                   SCIM_KEY_d },
  { SCIM_KEY_i,                   SCIM_KEY_c },
  { SCIM_KEY_j,                   SCIM_KEY_h },
  { SCIM_KEY_k,                   SCIM_KEY_t },
  { SCIM_KEY_l,                   SCIM_KEY_n },
  { SCIM_KEY_n,                   SCIM_KEY_b },
  { SCIM_KEY_o,                   SCIM_KEY_r },
  { SCIM_KEY_p,                   SCIM_KEY_l },
  { SCIM_KEY_q,                   SCIM_KEY_quotedbl },
  { SCIM_KEY_r,                   SCIM_KEY_p },
  { SCIM_KEY_s,                   SCIM_KEY_o },
  { SCIM_KEY_t,                   SCIM_KEY_y },
  { SCIM_KEY_u,                   SCIM_KEY_g },
  { SCIM_KEY_v,                   SCIM_KEY_k },
  { SCIM_KEY_w,                   SCIM_KEY_less },
  { SCIM_KEY_x,                   SCIM_KEY_q },
  { SCIM_KEY_y,                   SCIM_KEY_f },
  { SCIM_KEY_z,                   SCIM_KEY_colon },
  { SCIM_KEY_braceleft,           SCIM_KEY_question },
  { SCIM_KEY_braceright,          SCIM_KEY_plus },
};

static __Uint16Pair __estonian_to_us_normal [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_backslash },
  { SCIM_KEY_plus,                SCIM_KEY_minus },
  { SCIM_KEY_minus,               SCIM_KEY_slash },
  { SCIM_KEY_adiaeresis,          SCIM_KEY_apostrophe },
  { SCIM_KEY_otilde,              SCIM_KEY_bracketright },
  { SCIM_KEY_odiaeresis,          SCIM_KEY_semicolon },
  { SCIM_KEY_udiaeresis,          SCIM_KEY_bracketleft },
  { SCIM_KEY_dead_acute,          SCIM_KEY_equal },
  { SCIM_KEY_dead_caron,          SCIM_KEY_grave },
};

static __Uint16Pair __us_to_estonian_normal [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_adiaeresis },
  { SCIM_KEY_minus,               SCIM_KEY_plus },
  { SCIM_KEY_slash,               SCIM_KEY_minus },
  { SCIM_KEY_semicolon,           SCIM_KEY_odiaeresis },
  { SCIM_KEY_equal,               SCIM_KEY_dead_acute },
  { SCIM_KEY_bracketleft,         SCIM_KEY_udiaeresis },
  { SCIM_KEY_backslash,           SCIM_KEY_apostrophe },
  { SCIM_KEY_bracketright,        SCIM_KEY_otilde },
  { SCIM_KEY_grave,               SCIM_KEY_dead_caron },
};

static __Uint16Pair __estonian_to_us_caps [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_backslash },
  { SCIM_KEY_plus,                SCIM_KEY_minus },
  { SCIM_KEY_minus,               SCIM_KEY_slash },
  { SCIM_KEY_Adiaeresis,          SCIM_KEY_apostrophe },
  { SCIM_KEY_Otilde,              SCIM_KEY_bracketright },
  { SCIM_KEY_Odiaeresis,          SCIM_KEY_semicolon },
  { SCIM_KEY_Udiaeresis,          SCIM_KEY_bracketleft },
  { SCIM_KEY_dead_acute,          SCIM_KEY_equal },
  { SCIM_KEY_dead_caron,          SCIM_KEY_grave },
};

static __Uint16Pair __us_to_estonian_caps [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_Adiaeresis },
  { SCIM_KEY_minus,               SCIM_KEY_plus },
  { SCIM_KEY_slash,               SCIM_KEY_minus },
  { SCIM_KEY_semicolon,           SCIM_KEY_Odiaeresis },
  { SCIM_KEY_equal,               SCIM_KEY_dead_acute },
  { SCIM_KEY_bracketleft,         SCIM_KEY_Udiaeresis },
  { SCIM_KEY_backslash,           SCIM_KEY_apostrophe },
  { SCIM_KEY_bracketright,        SCIM_KEY_Otilde },
  { SCIM_KEY_grave,               SCIM_KEY_dead_caron },
};

static __Uint16Pair __estonian_to_us_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_at },
  { SCIM_KEY_ampersand,           SCIM_KEY_asciicircum },
  { SCIM_KEY_parenleft,           SCIM_KEY_asterisk },
  { SCIM_KEY_parenright,          SCIM_KEY_parenleft },
  { SCIM_KEY_asterisk,            SCIM_KEY_bar },
  { SCIM_KEY_slash,               SCIM_KEY_ampersand },
  { SCIM_KEY_colon,               SCIM_KEY_greater },
  { SCIM_KEY_semicolon,           SCIM_KEY_less },
  { SCIM_KEY_equal,               SCIM_KEY_parenright },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_currency,            SCIM_KEY_dollar },
  { SCIM_KEY_Adiaeresis,          SCIM_KEY_quotedbl },
  { SCIM_KEY_Otilde,              SCIM_KEY_braceright },
  { SCIM_KEY_Odiaeresis,          SCIM_KEY_colon },
  { SCIM_KEY_Udiaeresis,          SCIM_KEY_braceleft },
  { SCIM_KEY_dead_grave,          SCIM_KEY_plus },
  { SCIM_KEY_dead_tilde,          SCIM_KEY_asciitilde },
};

static __Uint16Pair __us_to_estonian_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_Adiaeresis },
  { SCIM_KEY_dollar,              SCIM_KEY_currency },
  { SCIM_KEY_ampersand,           SCIM_KEY_slash },
  { SCIM_KEY_parenleft,           SCIM_KEY_parenright },
  { SCIM_KEY_parenright,          SCIM_KEY_equal },
  { SCIM_KEY_asterisk,            SCIM_KEY_parenleft },
  { SCIM_KEY_plus,                SCIM_KEY_dead_grave },
  { SCIM_KEY_colon,               SCIM_KEY_Odiaeresis },
  { SCIM_KEY_less,                SCIM_KEY_semicolon },
  { SCIM_KEY_greater,             SCIM_KEY_colon },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_at,                  SCIM_KEY_quotedbl },
  { SCIM_KEY_asciicircum,         SCIM_KEY_ampersand },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_braceleft,           SCIM_KEY_Udiaeresis },
  { SCIM_KEY_bar,                 SCIM_KEY_asterisk },
  { SCIM_KEY_braceright,          SCIM_KEY_Otilde },
  { SCIM_KEY_asciitilde,          SCIM_KEY_dead_tilde },
};

static __Uint16Pair __estonian_to_us_caps_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_at },
  { SCIM_KEY_ampersand,           SCIM_KEY_asciicircum },
  { SCIM_KEY_parenleft,           SCIM_KEY_asterisk },
  { SCIM_KEY_parenright,          SCIM_KEY_parenleft },
  { SCIM_KEY_asterisk,            SCIM_KEY_bar },
  { SCIM_KEY_slash,               SCIM_KEY_ampersand },
  { SCIM_KEY_colon,               SCIM_KEY_greater },
  { SCIM_KEY_semicolon,           SCIM_KEY_less },
  { SCIM_KEY_equal,               SCIM_KEY_parenright },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_currency,            SCIM_KEY_dollar },
  { SCIM_KEY_adiaeresis,          SCIM_KEY_quotedbl },
  { SCIM_KEY_otilde,              SCIM_KEY_braceright },
  { SCIM_KEY_odiaeresis,          SCIM_KEY_colon },
  { SCIM_KEY_udiaeresis,          SCIM_KEY_braceleft },
  { SCIM_KEY_dead_grave,          SCIM_KEY_plus },
  { SCIM_KEY_dead_tilde,          SCIM_KEY_asciitilde },
};

static __Uint16Pair __us_to_estonian_caps_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_adiaeresis },
  { SCIM_KEY_dollar,              SCIM_KEY_currency },
  { SCIM_KEY_ampersand,           SCIM_KEY_slash },
  { SCIM_KEY_parenleft,           SCIM_KEY_parenright },
  { SCIM_KEY_parenright,          SCIM_KEY_equal },
  { SCIM_KEY_asterisk,            SCIM_KEY_parenleft },
  { SCIM_KEY_plus,                SCIM_KEY_dead_grave },
  { SCIM_KEY_colon,               SCIM_KEY_odiaeresis },
  { SCIM_KEY_less,                SCIM_KEY_semicolon },
  { SCIM_KEY_greater,             SCIM_KEY_colon },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_at,                  SCIM_KEY_quotedbl },
  { SCIM_KEY_asciicircum,         SCIM_KEY_ampersand },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_braceleft,           SCIM_KEY_udiaeresis },
  { SCIM_KEY_bar,                 SCIM_KEY_asterisk },
  { SCIM_KEY_braceright,          SCIM_KEY_otilde },
  { SCIM_KEY_asciitilde,          SCIM_KEY_dead_tilde },
};

static __Uint16Pair __finnish_to_us_normal [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_backslash },
  { SCIM_KEY_plus,                SCIM_KEY_minus },
  { SCIM_KEY_minus,               SCIM_KEY_slash },
  { SCIM_KEY_section,             SCIM_KEY_grave },
  { SCIM_KEY_adiaeresis,          SCIM_KEY_apostrophe },
  { SCIM_KEY_aring,               SCIM_KEY_bracketleft },
  { SCIM_KEY_odiaeresis,          SCIM_KEY_semicolon },
  { SCIM_KEY_dead_acute,          SCIM_KEY_equal },
  { SCIM_KEY_dead_diaeresis,      SCIM_KEY_bracketright },
};

static __Uint16Pair __us_to_finnish_normal [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_adiaeresis },
  { SCIM_KEY_minus,               SCIM_KEY_plus },
  { SCIM_KEY_slash,               SCIM_KEY_minus },
  { SCIM_KEY_semicolon,           SCIM_KEY_odiaeresis },
  { SCIM_KEY_equal,               SCIM_KEY_dead_acute },
  { SCIM_KEY_bracketleft,         SCIM_KEY_aring },
  { SCIM_KEY_backslash,           SCIM_KEY_apostrophe },
  { SCIM_KEY_bracketright,        SCIM_KEY_dead_diaeresis },
  { SCIM_KEY_grave,               SCIM_KEY_section },
};

static __Uint16Pair __finnish_to_us_caps [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_backslash },
  { SCIM_KEY_plus,                SCIM_KEY_minus },
  { SCIM_KEY_minus,               SCIM_KEY_slash },
  { SCIM_KEY_section,             SCIM_KEY_grave },
  { SCIM_KEY_Adiaeresis,          SCIM_KEY_apostrophe },
  { SCIM_KEY_Aring,               SCIM_KEY_bracketleft },
  { SCIM_KEY_Odiaeresis,          SCIM_KEY_semicolon },
  { SCIM_KEY_dead_acute,          SCIM_KEY_equal },
  { SCIM_KEY_dead_diaeresis,      SCIM_KEY_bracketright },
};

static __Uint16Pair __us_to_finnish_caps [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_Adiaeresis },
  { SCIM_KEY_minus,               SCIM_KEY_plus },
  { SCIM_KEY_slash,               SCIM_KEY_minus },
  { SCIM_KEY_semicolon,           SCIM_KEY_Odiaeresis },
  { SCIM_KEY_equal,               SCIM_KEY_dead_acute },
  { SCIM_KEY_bracketleft,         SCIM_KEY_Aring },
  { SCIM_KEY_backslash,           SCIM_KEY_apostrophe },
  { SCIM_KEY_bracketright,        SCIM_KEY_dead_diaeresis },
  { SCIM_KEY_grave,               SCIM_KEY_section },
};

static __Uint16Pair __finnish_to_us_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_at },
  { SCIM_KEY_ampersand,           SCIM_KEY_asciicircum },
  { SCIM_KEY_parenleft,           SCIM_KEY_asterisk },
  { SCIM_KEY_parenright,          SCIM_KEY_parenleft },
  { SCIM_KEY_asterisk,            SCIM_KEY_bar },
  { SCIM_KEY_slash,               SCIM_KEY_ampersand },
  { SCIM_KEY_colon,               SCIM_KEY_greater },
  { SCIM_KEY_semicolon,           SCIM_KEY_less },
  { SCIM_KEY_equal,               SCIM_KEY_parenright },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_currency,            SCIM_KEY_dollar },
  { SCIM_KEY_onehalf,             SCIM_KEY_asciitilde },
  { SCIM_KEY_Adiaeresis,          SCIM_KEY_quotedbl },
  { SCIM_KEY_Aring,               SCIM_KEY_braceleft },
  { SCIM_KEY_Odiaeresis,          SCIM_KEY_colon },
  { SCIM_KEY_dead_grave,          SCIM_KEY_plus },
  { SCIM_KEY_dead_circumflex,     SCIM_KEY_braceright },
};

static __Uint16Pair __us_to_finnish_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_Adiaeresis },
  { SCIM_KEY_dollar,              SCIM_KEY_currency },
  { SCIM_KEY_ampersand,           SCIM_KEY_slash },
  { SCIM_KEY_parenleft,           SCIM_KEY_parenright },
  { SCIM_KEY_parenright,          SCIM_KEY_equal },
  { SCIM_KEY_asterisk,            SCIM_KEY_parenleft },
  { SCIM_KEY_plus,                SCIM_KEY_dead_grave },
  { SCIM_KEY_colon,               SCIM_KEY_Odiaeresis },
  { SCIM_KEY_less,                SCIM_KEY_semicolon },
  { SCIM_KEY_greater,             SCIM_KEY_colon },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_at,                  SCIM_KEY_quotedbl },
  { SCIM_KEY_asciicircum,         SCIM_KEY_ampersand },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_braceleft,           SCIM_KEY_Aring },
  { SCIM_KEY_bar,                 SCIM_KEY_asterisk },
  { SCIM_KEY_braceright,          SCIM_KEY_dead_circumflex },
  { SCIM_KEY_asciitilde,          SCIM_KEY_onehalf },
};

static __Uint16Pair __finnish_to_us_caps_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_at },
  { SCIM_KEY_ampersand,           SCIM_KEY_asciicircum },
  { SCIM_KEY_parenleft,           SCIM_KEY_asterisk },
  { SCIM_KEY_parenright,          SCIM_KEY_parenleft },
  { SCIM_KEY_asterisk,            SCIM_KEY_bar },
  { SCIM_KEY_slash,               SCIM_KEY_ampersand },
  { SCIM_KEY_colon,               SCIM_KEY_greater },
  { SCIM_KEY_semicolon,           SCIM_KEY_less },
  { SCIM_KEY_equal,               SCIM_KEY_parenright },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_currency,            SCIM_KEY_dollar },
  { SCIM_KEY_onehalf,             SCIM_KEY_asciitilde },
  { SCIM_KEY_adiaeresis,          SCIM_KEY_quotedbl },
  { SCIM_KEY_aring,               SCIM_KEY_braceleft },
  { SCIM_KEY_odiaeresis,          SCIM_KEY_colon },
  { SCIM_KEY_dead_grave,          SCIM_KEY_plus },
  { SCIM_KEY_dead_circumflex,     SCIM_KEY_braceright },
};

static __Uint16Pair __us_to_finnish_caps_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_adiaeresis },
  { SCIM_KEY_dollar,              SCIM_KEY_currency },
  { SCIM_KEY_ampersand,           SCIM_KEY_slash },
  { SCIM_KEY_parenleft,           SCIM_KEY_parenright },
  { SCIM_KEY_parenright,          SCIM_KEY_equal },
  { SCIM_KEY_asterisk,            SCIM_KEY_parenleft },
  { SCIM_KEY_plus,                SCIM_KEY_dead_grave },
  { SCIM_KEY_colon,               SCIM_KEY_odiaeresis },
  { SCIM_KEY_less,                SCIM_KEY_semicolon },
  { SCIM_KEY_greater,             SCIM_KEY_colon },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_at,                  SCIM_KEY_quotedbl },
  { SCIM_KEY_asciicircum,         SCIM_KEY_ampersand },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_braceleft,           SCIM_KEY_aring },
  { SCIM_KEY_bar,                 SCIM_KEY_asterisk },
  { SCIM_KEY_braceright,          SCIM_KEY_dead_circumflex },
  { SCIM_KEY_asciitilde,          SCIM_KEY_onehalf },
};

static __Uint16Pair __french_to_us_normal [] = {
  { SCIM_KEY_exclam,              SCIM_KEY_slash },
  { SCIM_KEY_quotedbl,            SCIM_KEY_3 },
  { SCIM_KEY_dollar,              SCIM_KEY_bracketright },
  { SCIM_KEY_ampersand,           SCIM_KEY_1 },
  { SCIM_KEY_apostrophe,          SCIM_KEY_4 },
  { SCIM_KEY_parenleft,           SCIM_KEY_5 },
  { SCIM_KEY_parenright,          SCIM_KEY_minus },
  { SCIM_KEY_asterisk,            SCIM_KEY_backslash },
  { SCIM_KEY_comma,               SCIM_KEY_m },
  { SCIM_KEY_minus,               SCIM_KEY_6 },
  { SCIM_KEY_colon,               SCIM_KEY_period },
  { SCIM_KEY_semicolon,           SCIM_KEY_comma },
  { SCIM_KEY_underscore,          SCIM_KEY_8 },
  { SCIM_KEY_a,                   SCIM_KEY_q },
  { SCIM_KEY_m,                   SCIM_KEY_semicolon },
  { SCIM_KEY_q,                   SCIM_KEY_a },
  { SCIM_KEY_w,                   SCIM_KEY_z },
  { SCIM_KEY_z,                   SCIM_KEY_w },
  { SCIM_KEY_twosuperior,         SCIM_KEY_grave },
  { SCIM_KEY_agrave,              SCIM_KEY_0 },
  { SCIM_KEY_ccedilla,            SCIM_KEY_9 },
  { SCIM_KEY_egrave,              SCIM_KEY_7 },
  { SCIM_KEY_eacute,              SCIM_KEY_2 },
  { SCIM_KEY_ugrave,              SCIM_KEY_apostrophe },
  { SCIM_KEY_dead_circumflex,     SCIM_KEY_bracketleft },
};

static __Uint16Pair __us_to_french_normal [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_ugrave },
  { SCIM_KEY_comma,               SCIM_KEY_semicolon },
  { SCIM_KEY_minus,               SCIM_KEY_parenright },
  { SCIM_KEY_period,              SCIM_KEY_colon },
  { SCIM_KEY_slash,               SCIM_KEY_exclam },
  { SCIM_KEY_0,                   SCIM_KEY_agrave },
  { SCIM_KEY_1,                   SCIM_KEY_ampersand },
  { SCIM_KEY_2,                   SCIM_KEY_eacute },
  { SCIM_KEY_3,                   SCIM_KEY_quotedbl },
  { SCIM_KEY_4,                   SCIM_KEY_apostrophe },
  { SCIM_KEY_5,                   SCIM_KEY_parenleft },
  { SCIM_KEY_6,                   SCIM_KEY_minus },
  { SCIM_KEY_7,                   SCIM_KEY_egrave },
  { SCIM_KEY_8,                   SCIM_KEY_underscore },
  { SCIM_KEY_9,                   SCIM_KEY_ccedilla },
  { SCIM_KEY_semicolon,           SCIM_KEY_m },
  { SCIM_KEY_bracketleft,         SCIM_KEY_dead_circumflex },
  { SCIM_KEY_backslash,           SCIM_KEY_asterisk },
  { SCIM_KEY_bracketright,        SCIM_KEY_dollar },
  { SCIM_KEY_grave,               SCIM_KEY_twosuperior },
  { SCIM_KEY_a,                   SCIM_KEY_q },
  { SCIM_KEY_m,                   SCIM_KEY_comma },
  { SCIM_KEY_q,                   SCIM_KEY_a },
  { SCIM_KEY_w,                   SCIM_KEY_z },
  { SCIM_KEY_z,                   SCIM_KEY_w },
};

static __Uint16Pair __french_to_us_caps [] = {
  { SCIM_KEY_exclam,              SCIM_KEY_slash },
  { SCIM_KEY_quotedbl,            SCIM_KEY_3 },
  { SCIM_KEY_dollar,              SCIM_KEY_bracketright },
  { SCIM_KEY_ampersand,           SCIM_KEY_1 },
  { SCIM_KEY_apostrophe,          SCIM_KEY_4 },
  { SCIM_KEY_parenleft,           SCIM_KEY_5 },
  { SCIM_KEY_parenright,          SCIM_KEY_minus },
  { SCIM_KEY_asterisk,            SCIM_KEY_backslash },
  { SCIM_KEY_comma,               SCIM_KEY_M },
  { SCIM_KEY_minus,               SCIM_KEY_6 },
  { SCIM_KEY_colon,               SCIM_KEY_period },
  { SCIM_KEY_semicolon,           SCIM_KEY_comma },
  { SCIM_KEY_A,                   SCIM_KEY_Q },
  { SCIM_KEY_M,                   SCIM_KEY_semicolon },
  { SCIM_KEY_Q,                   SCIM_KEY_A },
  { SCIM_KEY_W,                   SCIM_KEY_Z },
  { SCIM_KEY_Z,                   SCIM_KEY_W },
  { SCIM_KEY_underscore,          SCIM_KEY_8 },
  { SCIM_KEY_twosuperior,         SCIM_KEY_grave },
  { SCIM_KEY_Agrave,              SCIM_KEY_0 },
  { SCIM_KEY_Ccedilla,            SCIM_KEY_9 },
  { SCIM_KEY_Egrave,              SCIM_KEY_7 },
  { SCIM_KEY_Eacute,              SCIM_KEY_2 },
  { SCIM_KEY_Ugrave,              SCIM_KEY_apostrophe },
  { SCIM_KEY_dead_circumflex,     SCIM_KEY_bracketleft },
};

static __Uint16Pair __us_to_french_caps [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_Ugrave },
  { SCIM_KEY_comma,               SCIM_KEY_semicolon },
  { SCIM_KEY_minus,               SCIM_KEY_parenright },
  { SCIM_KEY_period,              SCIM_KEY_colon },
  { SCIM_KEY_slash,               SCIM_KEY_exclam },
  { SCIM_KEY_0,                   SCIM_KEY_Agrave },
  { SCIM_KEY_1,                   SCIM_KEY_ampersand },
  { SCIM_KEY_2,                   SCIM_KEY_Eacute },
  { SCIM_KEY_3,                   SCIM_KEY_quotedbl },
  { SCIM_KEY_4,                   SCIM_KEY_apostrophe },
  { SCIM_KEY_5,                   SCIM_KEY_parenleft },
  { SCIM_KEY_6,                   SCIM_KEY_minus },
  { SCIM_KEY_7,                   SCIM_KEY_Egrave },
  { SCIM_KEY_8,                   SCIM_KEY_underscore },
  { SCIM_KEY_9,                   SCIM_KEY_Ccedilla },
  { SCIM_KEY_semicolon,           SCIM_KEY_M },
  { SCIM_KEY_A,                   SCIM_KEY_Q },
  { SCIM_KEY_M,                   SCIM_KEY_comma },
  { SCIM_KEY_Q,                   SCIM_KEY_A },
  { SCIM_KEY_W,                   SCIM_KEY_Z },
  { SCIM_KEY_Z,                   SCIM_KEY_W },
  { SCIM_KEY_bracketleft,         SCIM_KEY_dead_circumflex },
  { SCIM_KEY_backslash,           SCIM_KEY_asterisk },
  { SCIM_KEY_bracketright,        SCIM_KEY_dollar },
  { SCIM_KEY_grave,               SCIM_KEY_twosuperior },
};

static __Uint16Pair __french_to_us_shift [] = {
  { SCIM_KEY_percent,             SCIM_KEY_quotedbl },
  { SCIM_KEY_period,              SCIM_KEY_less },
  { SCIM_KEY_slash,               SCIM_KEY_greater },
  { SCIM_KEY_0,                   SCIM_KEY_parenright },
  { SCIM_KEY_1,                   SCIM_KEY_exclam },
  { SCIM_KEY_2,                   SCIM_KEY_at },
  { SCIM_KEY_3,                   SCIM_KEY_numbersign },
  { SCIM_KEY_4,                   SCIM_KEY_dollar },
  { SCIM_KEY_5,                   SCIM_KEY_percent },
  { SCIM_KEY_6,                   SCIM_KEY_asciicircum },
  { SCIM_KEY_7,                   SCIM_KEY_ampersand },
  { SCIM_KEY_8,                   SCIM_KEY_asterisk },
  { SCIM_KEY_9,                   SCIM_KEY_parenleft },
  { SCIM_KEY_question,            SCIM_KEY_M },
  { SCIM_KEY_A,                   SCIM_KEY_Q },
  { SCIM_KEY_M,                   SCIM_KEY_colon },
  { SCIM_KEY_Q,                   SCIM_KEY_A },
  { SCIM_KEY_W,                   SCIM_KEY_Z },
  { SCIM_KEY_Z,                   SCIM_KEY_W },
  { SCIM_KEY_sterling,            SCIM_KEY_braceright },
  { SCIM_KEY_section,             SCIM_KEY_question },
  { SCIM_KEY_degree,              SCIM_KEY_underscore },
  { SCIM_KEY_mu,                  SCIM_KEY_bar },
  { SCIM_KEY_dead_diaeresis,      SCIM_KEY_braceleft },
};

static __Uint16Pair __us_to_french_shift [] = {
  { SCIM_KEY_exclam,              SCIM_KEY_1 },
  { SCIM_KEY_quotedbl,            SCIM_KEY_percent },
  { SCIM_KEY_numbersign,          SCIM_KEY_3 },
  { SCIM_KEY_dollar,              SCIM_KEY_4 },
  { SCIM_KEY_percent,             SCIM_KEY_5 },
  { SCIM_KEY_ampersand,           SCIM_KEY_7 },
  { SCIM_KEY_parenleft,           SCIM_KEY_9 },
  { SCIM_KEY_parenright,          SCIM_KEY_0 },
  { SCIM_KEY_asterisk,            SCIM_KEY_8 },
  { SCIM_KEY_colon,               SCIM_KEY_M },
  { SCIM_KEY_less,                SCIM_KEY_period },
  { SCIM_KEY_greater,             SCIM_KEY_slash },
  { SCIM_KEY_question,            SCIM_KEY_section },
  { SCIM_KEY_at,                  SCIM_KEY_2 },
  { SCIM_KEY_A,                   SCIM_KEY_Q },
  { SCIM_KEY_M,                   SCIM_KEY_question },
  { SCIM_KEY_Q,                   SCIM_KEY_A },
  { SCIM_KEY_W,                   SCIM_KEY_Z },
  { SCIM_KEY_Z,                   SCIM_KEY_W },
  { SCIM_KEY_asciicircum,         SCIM_KEY_6 },
  { SCIM_KEY_underscore,          SCIM_KEY_degree },
  { SCIM_KEY_braceleft,           SCIM_KEY_dead_diaeresis },
  { SCIM_KEY_bar,                 SCIM_KEY_mu },
  { SCIM_KEY_braceright,          SCIM_KEY_sterling },
};

static __Uint16Pair __french_to_us_caps_shift [] = {
  { SCIM_KEY_percent,             SCIM_KEY_quotedbl },
  { SCIM_KEY_period,              SCIM_KEY_less },
  { SCIM_KEY_slash,               SCIM_KEY_greater },
  { SCIM_KEY_0,                   SCIM_KEY_parenright },
  { SCIM_KEY_1,                   SCIM_KEY_exclam },
  { SCIM_KEY_2,                   SCIM_KEY_at },
  { SCIM_KEY_3,                   SCIM_KEY_numbersign },
  { SCIM_KEY_4,                   SCIM_KEY_dollar },
  { SCIM_KEY_5,                   SCIM_KEY_percent },
  { SCIM_KEY_6,                   SCIM_KEY_asciicircum },
  { SCIM_KEY_7,                   SCIM_KEY_ampersand },
  { SCIM_KEY_8,                   SCIM_KEY_asterisk },
  { SCIM_KEY_9,                   SCIM_KEY_parenleft },
  { SCIM_KEY_question,            SCIM_KEY_m },
  { SCIM_KEY_a,                   SCIM_KEY_q },
  { SCIM_KEY_m,                   SCIM_KEY_colon },
  { SCIM_KEY_q,                   SCIM_KEY_a },
  { SCIM_KEY_w,                   SCIM_KEY_z },
  { SCIM_KEY_z,                   SCIM_KEY_w },
  { SCIM_KEY_sterling,            SCIM_KEY_braceright },
  { SCIM_KEY_section,             SCIM_KEY_question },
  { SCIM_KEY_degree,              SCIM_KEY_underscore },
  { SCIM_KEY_mu,                  SCIM_KEY_bar },
  { SCIM_KEY_dead_diaeresis,      SCIM_KEY_braceleft },
};

static __Uint16Pair __us_to_french_caps_shift [] = {
  { SCIM_KEY_exclam,              SCIM_KEY_1 },
  { SCIM_KEY_quotedbl,            SCIM_KEY_percent },
  { SCIM_KEY_numbersign,          SCIM_KEY_3 },
  { SCIM_KEY_dollar,              SCIM_KEY_4 },
  { SCIM_KEY_percent,             SCIM_KEY_5 },
  { SCIM_KEY_ampersand,           SCIM_KEY_7 },
  { SCIM_KEY_parenleft,           SCIM_KEY_9 },
  { SCIM_KEY_parenright,          SCIM_KEY_0 },
  { SCIM_KEY_asterisk,            SCIM_KEY_8 },
  { SCIM_KEY_colon,               SCIM_KEY_m },
  { SCIM_KEY_less,                SCIM_KEY_period },
  { SCIM_KEY_greater,             SCIM_KEY_slash },
  { SCIM_KEY_question,            SCIM_KEY_section },
  { SCIM_KEY_at,                  SCIM_KEY_2 },
  { SCIM_KEY_asciicircum,         SCIM_KEY_6 },
  { SCIM_KEY_underscore,          SCIM_KEY_degree },
  { SCIM_KEY_a,                   SCIM_KEY_q },
  { SCIM_KEY_m,                   SCIM_KEY_question },
  { SCIM_KEY_q,                   SCIM_KEY_a },
  { SCIM_KEY_w,                   SCIM_KEY_z },
  { SCIM_KEY_z,                   SCIM_KEY_w },
  { SCIM_KEY_braceleft,           SCIM_KEY_dead_diaeresis },
  { SCIM_KEY_bar,                 SCIM_KEY_mu },
  { SCIM_KEY_braceright,          SCIM_KEY_sterling },
};

static __Uint16Pair __french_switzerland_to_us_normal [] = {
  { SCIM_KEY_dollar,              SCIM_KEY_backslash },
  { SCIM_KEY_apostrophe,          SCIM_KEY_minus },
  { SCIM_KEY_minus,               SCIM_KEY_slash },
  { SCIM_KEY_y,                   SCIM_KEY_z },
  { SCIM_KEY_z,                   SCIM_KEY_y },
  { SCIM_KEY_section,             SCIM_KEY_grave },
  { SCIM_KEY_agrave,              SCIM_KEY_apostrophe },
  { SCIM_KEY_egrave,              SCIM_KEY_bracketleft },
  { SCIM_KEY_eacute,              SCIM_KEY_semicolon },
  { SCIM_KEY_dead_circumflex,     SCIM_KEY_equal },
  { SCIM_KEY_dead_diaeresis,      SCIM_KEY_bracketright },
};

static __Uint16Pair __us_to_french_switzerland_normal [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_agrave },
  { SCIM_KEY_minus,               SCIM_KEY_apostrophe },
  { SCIM_KEY_slash,               SCIM_KEY_minus },
  { SCIM_KEY_semicolon,           SCIM_KEY_eacute },
  { SCIM_KEY_equal,               SCIM_KEY_dead_circumflex },
  { SCIM_KEY_bracketleft,         SCIM_KEY_egrave },
  { SCIM_KEY_backslash,           SCIM_KEY_dollar },
  { SCIM_KEY_bracketright,        SCIM_KEY_dead_diaeresis },
  { SCIM_KEY_grave,               SCIM_KEY_section },
  { SCIM_KEY_y,                   SCIM_KEY_z },
  { SCIM_KEY_z,                   SCIM_KEY_y },
};

static __Uint16Pair __french_switzerland_to_us_caps [] = {
  { SCIM_KEY_dollar,              SCIM_KEY_backslash },
  { SCIM_KEY_apostrophe,          SCIM_KEY_minus },
  { SCIM_KEY_minus,               SCIM_KEY_slash },
  { SCIM_KEY_Y,                   SCIM_KEY_Z },
  { SCIM_KEY_Z,                   SCIM_KEY_Y },
  { SCIM_KEY_section,             SCIM_KEY_grave },
  { SCIM_KEY_Agrave,              SCIM_KEY_apostrophe },
  { SCIM_KEY_Egrave,              SCIM_KEY_bracketleft },
  { SCIM_KEY_Eacute,              SCIM_KEY_semicolon },
  { SCIM_KEY_dead_circumflex,     SCIM_KEY_equal },
  { SCIM_KEY_dead_diaeresis,      SCIM_KEY_bracketright },
};

static __Uint16Pair __us_to_french_switzerland_caps [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_Agrave },
  { SCIM_KEY_minus,               SCIM_KEY_apostrophe },
  { SCIM_KEY_slash,               SCIM_KEY_minus },
  { SCIM_KEY_semicolon,           SCIM_KEY_Eacute },
  { SCIM_KEY_equal,               SCIM_KEY_dead_circumflex },
  { SCIM_KEY_Y,                   SCIM_KEY_Z },
  { SCIM_KEY_Z,                   SCIM_KEY_Y },
  { SCIM_KEY_bracketleft,         SCIM_KEY_Egrave },
  { SCIM_KEY_backslash,           SCIM_KEY_dollar },
  { SCIM_KEY_bracketright,        SCIM_KEY_dead_diaeresis },
  { SCIM_KEY_grave,               SCIM_KEY_section },
};

static __Uint16Pair __french_switzerland_to_us_shift [] = {
  { SCIM_KEY_exclam,              SCIM_KEY_braceright },
  { SCIM_KEY_quotedbl,            SCIM_KEY_at },
  { SCIM_KEY_ampersand,           SCIM_KEY_asciicircum },
  { SCIM_KEY_parenleft,           SCIM_KEY_asterisk },
  { SCIM_KEY_parenright,          SCIM_KEY_parenleft },
  { SCIM_KEY_asterisk,            SCIM_KEY_numbersign },
  { SCIM_KEY_plus,                SCIM_KEY_exclam },
  { SCIM_KEY_slash,               SCIM_KEY_ampersand },
  { SCIM_KEY_colon,               SCIM_KEY_greater },
  { SCIM_KEY_semicolon,           SCIM_KEY_less },
  { SCIM_KEY_equal,               SCIM_KEY_parenright },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_Y,                   SCIM_KEY_Z },
  { SCIM_KEY_Z,                   SCIM_KEY_Y },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_sterling,            SCIM_KEY_bar },
  { SCIM_KEY_degree,              SCIM_KEY_asciitilde },
  { SCIM_KEY_adiaeresis,          SCIM_KEY_quotedbl },
  { SCIM_KEY_ccedilla,            SCIM_KEY_dollar },
  { SCIM_KEY_odiaeresis,          SCIM_KEY_colon },
  { SCIM_KEY_udiaeresis,          SCIM_KEY_braceleft },
  { SCIM_KEY_dead_grave,          SCIM_KEY_plus },
};

static __Uint16Pair __us_to_french_switzerland_shift [] = {
  { SCIM_KEY_exclam,              SCIM_KEY_plus },
  { SCIM_KEY_quotedbl,            SCIM_KEY_adiaeresis },
  { SCIM_KEY_numbersign,          SCIM_KEY_asterisk },
  { SCIM_KEY_dollar,              SCIM_KEY_ccedilla },
  { SCIM_KEY_ampersand,           SCIM_KEY_slash },
  { SCIM_KEY_parenleft,           SCIM_KEY_parenright },
  { SCIM_KEY_parenright,          SCIM_KEY_equal },
  { SCIM_KEY_asterisk,            SCIM_KEY_parenleft },
  { SCIM_KEY_plus,                SCIM_KEY_dead_grave },
  { SCIM_KEY_colon,               SCIM_KEY_odiaeresis },
  { SCIM_KEY_less,                SCIM_KEY_semicolon },
  { SCIM_KEY_greater,             SCIM_KEY_colon },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_at,                  SCIM_KEY_quotedbl },
  { SCIM_KEY_Y,                   SCIM_KEY_Z },
  { SCIM_KEY_Z,                   SCIM_KEY_Y },
  { SCIM_KEY_asciicircum,         SCIM_KEY_ampersand },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_braceleft,           SCIM_KEY_udiaeresis },
  { SCIM_KEY_bar,                 SCIM_KEY_sterling },
  { SCIM_KEY_braceright,          SCIM_KEY_exclam },
  { SCIM_KEY_asciitilde,          SCIM_KEY_degree },
};

static __Uint16Pair __french_switzerland_to_us_caps_shift [] = {
  { SCIM_KEY_exclam,              SCIM_KEY_braceright },
  { SCIM_KEY_quotedbl,            SCIM_KEY_at },
  { SCIM_KEY_ampersand,           SCIM_KEY_asciicircum },
  { SCIM_KEY_parenleft,           SCIM_KEY_asterisk },
  { SCIM_KEY_parenright,          SCIM_KEY_parenleft },
  { SCIM_KEY_asterisk,            SCIM_KEY_numbersign },
  { SCIM_KEY_plus,                SCIM_KEY_exclam },
  { SCIM_KEY_slash,               SCIM_KEY_ampersand },
  { SCIM_KEY_colon,               SCIM_KEY_greater },
  { SCIM_KEY_semicolon,           SCIM_KEY_less },
  { SCIM_KEY_equal,               SCIM_KEY_parenright },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_y,                   SCIM_KEY_z },
  { SCIM_KEY_z,                   SCIM_KEY_y },
  { SCIM_KEY_sterling,            SCIM_KEY_bar },
  { SCIM_KEY_degree,              SCIM_KEY_asciitilde },
  { SCIM_KEY_Adiaeresis,          SCIM_KEY_quotedbl },
  { SCIM_KEY_Ccedilla,            SCIM_KEY_dollar },
  { SCIM_KEY_Odiaeresis,          SCIM_KEY_colon },
  { SCIM_KEY_Udiaeresis,          SCIM_KEY_braceleft },
  { SCIM_KEY_dead_grave,          SCIM_KEY_plus },
};

static __Uint16Pair __us_to_french_switzerland_caps_shift [] = {
  { SCIM_KEY_exclam,              SCIM_KEY_plus },
  { SCIM_KEY_quotedbl,            SCIM_KEY_Adiaeresis },
  { SCIM_KEY_numbersign,          SCIM_KEY_asterisk },
  { SCIM_KEY_dollar,              SCIM_KEY_Ccedilla },
  { SCIM_KEY_ampersand,           SCIM_KEY_slash },
  { SCIM_KEY_parenleft,           SCIM_KEY_parenright },
  { SCIM_KEY_parenright,          SCIM_KEY_equal },
  { SCIM_KEY_asterisk,            SCIM_KEY_parenleft },
  { SCIM_KEY_plus,                SCIM_KEY_dead_grave },
  { SCIM_KEY_colon,               SCIM_KEY_Odiaeresis },
  { SCIM_KEY_less,                SCIM_KEY_semicolon },
  { SCIM_KEY_greater,             SCIM_KEY_colon },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_at,                  SCIM_KEY_quotedbl },
  { SCIM_KEY_asciicircum,         SCIM_KEY_ampersand },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_y,                   SCIM_KEY_z },
  { SCIM_KEY_z,                   SCIM_KEY_y },
  { SCIM_KEY_braceleft,           SCIM_KEY_Udiaeresis },
  { SCIM_KEY_bar,                 SCIM_KEY_sterling },
  { SCIM_KEY_braceright,          SCIM_KEY_exclam },
  { SCIM_KEY_asciitilde,          SCIM_KEY_degree },
};

static __Uint16Pair __german_deadkeys_to_us_normal [] = {
  { SCIM_KEY_numbersign,          SCIM_KEY_backslash },
  { SCIM_KEY_plus,                SCIM_KEY_bracketright },
  { SCIM_KEY_minus,               SCIM_KEY_slash },
  { SCIM_KEY_y,                   SCIM_KEY_z },
  { SCIM_KEY_z,                   SCIM_KEY_y },
  { SCIM_KEY_ssharp,              SCIM_KEY_minus },
  { SCIM_KEY_adiaeresis,          SCIM_KEY_apostrophe },
  { SCIM_KEY_odiaeresis,          SCIM_KEY_semicolon },
  { SCIM_KEY_udiaeresis,          SCIM_KEY_bracketleft },
  { SCIM_KEY_dead_acute,          SCIM_KEY_equal },
  { SCIM_KEY_dead_circumflex,     SCIM_KEY_grave },
};

static __Uint16Pair __us_to_german_deadkeys_normal [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_adiaeresis },
  { SCIM_KEY_minus,               SCIM_KEY_ssharp },
  { SCIM_KEY_slash,               SCIM_KEY_minus },
  { SCIM_KEY_semicolon,           SCIM_KEY_odiaeresis },
  { SCIM_KEY_equal,               SCIM_KEY_dead_acute },
  { SCIM_KEY_bracketleft,         SCIM_KEY_udiaeresis },
  { SCIM_KEY_backslash,           SCIM_KEY_numbersign },
  { SCIM_KEY_bracketright,        SCIM_KEY_plus },
  { SCIM_KEY_grave,               SCIM_KEY_dead_circumflex },
  { SCIM_KEY_y,                   SCIM_KEY_z },
  { SCIM_KEY_z,                   SCIM_KEY_y },
};

static __Uint16Pair __german_deadkeys_to_us_caps [] = {
  { SCIM_KEY_numbersign,          SCIM_KEY_backslash },
  { SCIM_KEY_plus,                SCIM_KEY_bracketright },
  { SCIM_KEY_minus,               SCIM_KEY_slash },
  { SCIM_KEY_Y,                   SCIM_KEY_Z },
  { SCIM_KEY_Z,                   SCIM_KEY_Y },
  { SCIM_KEY_Adiaeresis,          SCIM_KEY_apostrophe },
  { SCIM_KEY_Odiaeresis,          SCIM_KEY_semicolon },
  { SCIM_KEY_Udiaeresis,          SCIM_KEY_bracketleft },
  { SCIM_KEY_ssharp,              SCIM_KEY_minus },
  { SCIM_KEY_dead_acute,          SCIM_KEY_equal },
  { SCIM_KEY_dead_circumflex,     SCIM_KEY_grave },
};

static __Uint16Pair __us_to_german_deadkeys_caps [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_Adiaeresis },
  { SCIM_KEY_minus,               SCIM_KEY_ssharp },
  { SCIM_KEY_slash,               SCIM_KEY_minus },
  { SCIM_KEY_semicolon,           SCIM_KEY_Odiaeresis },
  { SCIM_KEY_equal,               SCIM_KEY_dead_acute },
  { SCIM_KEY_Y,                   SCIM_KEY_Z },
  { SCIM_KEY_Z,                   SCIM_KEY_Y },
  { SCIM_KEY_bracketleft,         SCIM_KEY_Udiaeresis },
  { SCIM_KEY_backslash,           SCIM_KEY_numbersign },
  { SCIM_KEY_bracketright,        SCIM_KEY_plus },
  { SCIM_KEY_grave,               SCIM_KEY_dead_circumflex },
};

static __Uint16Pair __german_deadkeys_to_us_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_at },
  { SCIM_KEY_ampersand,           SCIM_KEY_asciicircum },
  { SCIM_KEY_apostrophe,          SCIM_KEY_bar },
  { SCIM_KEY_parenleft,           SCIM_KEY_asterisk },
  { SCIM_KEY_parenright,          SCIM_KEY_parenleft },
  { SCIM_KEY_asterisk,            SCIM_KEY_braceright },
  { SCIM_KEY_slash,               SCIM_KEY_ampersand },
  { SCIM_KEY_colon,               SCIM_KEY_greater },
  { SCIM_KEY_semicolon,           SCIM_KEY_less },
  { SCIM_KEY_equal,               SCIM_KEY_parenright },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_Y,                   SCIM_KEY_Z },
  { SCIM_KEY_Z,                   SCIM_KEY_Y },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_section,             SCIM_KEY_numbersign },
  { SCIM_KEY_degree,              SCIM_KEY_asciitilde },
  { SCIM_KEY_Adiaeresis,          SCIM_KEY_quotedbl },
  { SCIM_KEY_Odiaeresis,          SCIM_KEY_colon },
  { SCIM_KEY_Udiaeresis,          SCIM_KEY_braceleft },
  { SCIM_KEY_dead_grave,          SCIM_KEY_plus },
};

static __Uint16Pair __us_to_german_deadkeys_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_Adiaeresis },
  { SCIM_KEY_numbersign,          SCIM_KEY_section },
  { SCIM_KEY_ampersand,           SCIM_KEY_slash },
  { SCIM_KEY_parenleft,           SCIM_KEY_parenright },
  { SCIM_KEY_parenright,          SCIM_KEY_equal },
  { SCIM_KEY_asterisk,            SCIM_KEY_parenleft },
  { SCIM_KEY_plus,                SCIM_KEY_dead_grave },
  { SCIM_KEY_colon,               SCIM_KEY_Odiaeresis },
  { SCIM_KEY_less,                SCIM_KEY_semicolon },
  { SCIM_KEY_greater,             SCIM_KEY_colon },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_at,                  SCIM_KEY_quotedbl },
  { SCIM_KEY_Y,                   SCIM_KEY_Z },
  { SCIM_KEY_Z,                   SCIM_KEY_Y },
  { SCIM_KEY_asciicircum,         SCIM_KEY_ampersand },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_braceleft,           SCIM_KEY_Udiaeresis },
  { SCIM_KEY_bar,                 SCIM_KEY_apostrophe },
  { SCIM_KEY_braceright,          SCIM_KEY_asterisk },
  { SCIM_KEY_asciitilde,          SCIM_KEY_degree },
};

static __Uint16Pair __german_deadkeys_to_us_caps_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_at },
  { SCIM_KEY_ampersand,           SCIM_KEY_asciicircum },
  { SCIM_KEY_apostrophe,          SCIM_KEY_bar },
  { SCIM_KEY_parenleft,           SCIM_KEY_asterisk },
  { SCIM_KEY_parenright,          SCIM_KEY_parenleft },
  { SCIM_KEY_asterisk,            SCIM_KEY_braceright },
  { SCIM_KEY_slash,               SCIM_KEY_ampersand },
  { SCIM_KEY_colon,               SCIM_KEY_greater },
  { SCIM_KEY_semicolon,           SCIM_KEY_less },
  { SCIM_KEY_equal,               SCIM_KEY_parenright },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_y,                   SCIM_KEY_z },
  { SCIM_KEY_z,                   SCIM_KEY_y },
  { SCIM_KEY_section,             SCIM_KEY_numbersign },
  { SCIM_KEY_degree,              SCIM_KEY_asciitilde },
  { SCIM_KEY_adiaeresis,          SCIM_KEY_quotedbl },
  { SCIM_KEY_odiaeresis,          SCIM_KEY_colon },
  { SCIM_KEY_udiaeresis,          SCIM_KEY_braceleft },
  { SCIM_KEY_dead_grave,          SCIM_KEY_plus },
};

static __Uint16Pair __us_to_german_deadkeys_caps_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_adiaeresis },
  { SCIM_KEY_numbersign,          SCIM_KEY_section },
  { SCIM_KEY_ampersand,           SCIM_KEY_slash },
  { SCIM_KEY_parenleft,           SCIM_KEY_parenright },
  { SCIM_KEY_parenright,          SCIM_KEY_equal },
  { SCIM_KEY_asterisk,            SCIM_KEY_parenleft },
  { SCIM_KEY_plus,                SCIM_KEY_dead_grave },
  { SCIM_KEY_colon,               SCIM_KEY_odiaeresis },
  { SCIM_KEY_less,                SCIM_KEY_semicolon },
  { SCIM_KEY_greater,             SCIM_KEY_colon },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_at,                  SCIM_KEY_quotedbl },
  { SCIM_KEY_asciicircum,         SCIM_KEY_ampersand },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_y,                   SCIM_KEY_z },
  { SCIM_KEY_z,                   SCIM_KEY_y },
  { SCIM_KEY_braceleft,           SCIM_KEY_udiaeresis },
  { SCIM_KEY_bar,                 SCIM_KEY_apostrophe },
  { SCIM_KEY_braceright,          SCIM_KEY_asterisk },
  { SCIM_KEY_asciitilde,          SCIM_KEY_degree },
};

static __Uint16Pair __german_to_us_normal [] = {
  { SCIM_KEY_numbersign,          SCIM_KEY_backslash },
  { SCIM_KEY_plus,                SCIM_KEY_bracketright },
  { SCIM_KEY_minus,               SCIM_KEY_slash },
  { SCIM_KEY_asciicircum,         SCIM_KEY_grave },
  { SCIM_KEY_y,                   SCIM_KEY_z },
  { SCIM_KEY_z,                   SCIM_KEY_y },
  { SCIM_KEY_acute,               SCIM_KEY_equal },
  { SCIM_KEY_ssharp,              SCIM_KEY_minus },
  { SCIM_KEY_adiaeresis,          SCIM_KEY_apostrophe },
  { SCIM_KEY_odiaeresis,          SCIM_KEY_semicolon },
  { SCIM_KEY_udiaeresis,          SCIM_KEY_bracketleft },
};

static __Uint16Pair __us_to_german_normal [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_adiaeresis },
  { SCIM_KEY_minus,               SCIM_KEY_ssharp },
  { SCIM_KEY_slash,               SCIM_KEY_minus },
  { SCIM_KEY_semicolon,           SCIM_KEY_odiaeresis },
  { SCIM_KEY_equal,               SCIM_KEY_acute },
  { SCIM_KEY_bracketleft,         SCIM_KEY_udiaeresis },
  { SCIM_KEY_backslash,           SCIM_KEY_numbersign },
  { SCIM_KEY_bracketright,        SCIM_KEY_plus },
  { SCIM_KEY_grave,               SCIM_KEY_asciicircum },
  { SCIM_KEY_y,                   SCIM_KEY_z },
  { SCIM_KEY_z,                   SCIM_KEY_y },
};

static __Uint16Pair __german_to_us_caps [] = {
  { SCIM_KEY_numbersign,          SCIM_KEY_backslash },
  { SCIM_KEY_plus,                SCIM_KEY_bracketright },
  { SCIM_KEY_minus,               SCIM_KEY_slash },
  { SCIM_KEY_Y,                   SCIM_KEY_Z },
  { SCIM_KEY_Z,                   SCIM_KEY_Y },
  { SCIM_KEY_asciicircum,         SCIM_KEY_grave },
  { SCIM_KEY_acute,               SCIM_KEY_equal },
  { SCIM_KEY_Adiaeresis,          SCIM_KEY_apostrophe },
  { SCIM_KEY_Odiaeresis,          SCIM_KEY_semicolon },
  { SCIM_KEY_Udiaeresis,          SCIM_KEY_bracketleft },
  { SCIM_KEY_ssharp,              SCIM_KEY_minus },
};

static __Uint16Pair __us_to_german_caps [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_Adiaeresis },
  { SCIM_KEY_minus,               SCIM_KEY_ssharp },
  { SCIM_KEY_slash,               SCIM_KEY_minus },
  { SCIM_KEY_semicolon,           SCIM_KEY_Odiaeresis },
  { SCIM_KEY_equal,               SCIM_KEY_acute },
  { SCIM_KEY_Y,                   SCIM_KEY_Z },
  { SCIM_KEY_Z,                   SCIM_KEY_Y },
  { SCIM_KEY_bracketleft,         SCIM_KEY_Udiaeresis },
  { SCIM_KEY_backslash,           SCIM_KEY_numbersign },
  { SCIM_KEY_bracketright,        SCIM_KEY_plus },
  { SCIM_KEY_grave,               SCIM_KEY_asciicircum },
};

static __Uint16Pair __german_to_us_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_at },
  { SCIM_KEY_ampersand,           SCIM_KEY_asciicircum },
  { SCIM_KEY_apostrophe,          SCIM_KEY_bar },
  { SCIM_KEY_parenleft,           SCIM_KEY_asterisk },
  { SCIM_KEY_parenright,          SCIM_KEY_parenleft },
  { SCIM_KEY_asterisk,            SCIM_KEY_braceright },
  { SCIM_KEY_slash,               SCIM_KEY_ampersand },
  { SCIM_KEY_colon,               SCIM_KEY_greater },
  { SCIM_KEY_semicolon,           SCIM_KEY_less },
  { SCIM_KEY_equal,               SCIM_KEY_parenright },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_Y,                   SCIM_KEY_Z },
  { SCIM_KEY_Z,                   SCIM_KEY_Y },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_grave,               SCIM_KEY_plus },
  { SCIM_KEY_section,             SCIM_KEY_numbersign },
  { SCIM_KEY_degree,              SCIM_KEY_asciitilde },
  { SCIM_KEY_Adiaeresis,          SCIM_KEY_quotedbl },
  { SCIM_KEY_Odiaeresis,          SCIM_KEY_colon },
  { SCIM_KEY_Udiaeresis,          SCIM_KEY_braceleft },
};

static __Uint16Pair __us_to_german_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_Adiaeresis },
  { SCIM_KEY_numbersign,          SCIM_KEY_section },
  { SCIM_KEY_ampersand,           SCIM_KEY_slash },
  { SCIM_KEY_parenleft,           SCIM_KEY_parenright },
  { SCIM_KEY_parenright,          SCIM_KEY_equal },
  { SCIM_KEY_asterisk,            SCIM_KEY_parenleft },
  { SCIM_KEY_plus,                SCIM_KEY_grave },
  { SCIM_KEY_colon,               SCIM_KEY_Odiaeresis },
  { SCIM_KEY_less,                SCIM_KEY_semicolon },
  { SCIM_KEY_greater,             SCIM_KEY_colon },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_at,                  SCIM_KEY_quotedbl },
  { SCIM_KEY_Y,                   SCIM_KEY_Z },
  { SCIM_KEY_Z,                   SCIM_KEY_Y },
  { SCIM_KEY_asciicircum,         SCIM_KEY_ampersand },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_braceleft,           SCIM_KEY_Udiaeresis },
  { SCIM_KEY_bar,                 SCIM_KEY_apostrophe },
  { SCIM_KEY_braceright,          SCIM_KEY_asterisk },
  { SCIM_KEY_asciitilde,          SCIM_KEY_degree },
};

static __Uint16Pair __german_to_us_caps_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_at },
  { SCIM_KEY_ampersand,           SCIM_KEY_asciicircum },
  { SCIM_KEY_apostrophe,          SCIM_KEY_bar },
  { SCIM_KEY_parenleft,           SCIM_KEY_asterisk },
  { SCIM_KEY_parenright,          SCIM_KEY_parenleft },
  { SCIM_KEY_asterisk,            SCIM_KEY_braceright },
  { SCIM_KEY_slash,               SCIM_KEY_ampersand },
  { SCIM_KEY_colon,               SCIM_KEY_greater },
  { SCIM_KEY_semicolon,           SCIM_KEY_less },
  { SCIM_KEY_equal,               SCIM_KEY_parenright },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_grave,               SCIM_KEY_plus },
  { SCIM_KEY_y,                   SCIM_KEY_z },
  { SCIM_KEY_z,                   SCIM_KEY_y },
  { SCIM_KEY_section,             SCIM_KEY_numbersign },
  { SCIM_KEY_degree,              SCIM_KEY_asciitilde },
  { SCIM_KEY_adiaeresis,          SCIM_KEY_quotedbl },
  { SCIM_KEY_odiaeresis,          SCIM_KEY_colon },
  { SCIM_KEY_udiaeresis,          SCIM_KEY_braceleft },
};

static __Uint16Pair __us_to_german_caps_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_adiaeresis },
  { SCIM_KEY_numbersign,          SCIM_KEY_section },
  { SCIM_KEY_ampersand,           SCIM_KEY_slash },
  { SCIM_KEY_parenleft,           SCIM_KEY_parenright },
  { SCIM_KEY_parenright,          SCIM_KEY_equal },
  { SCIM_KEY_asterisk,            SCIM_KEY_parenleft },
  { SCIM_KEY_plus,                SCIM_KEY_grave },
  { SCIM_KEY_colon,               SCIM_KEY_odiaeresis },
  { SCIM_KEY_less,                SCIM_KEY_semicolon },
  { SCIM_KEY_greater,             SCIM_KEY_colon },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_at,                  SCIM_KEY_quotedbl },
  { SCIM_KEY_asciicircum,         SCIM_KEY_ampersand },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_y,                   SCIM_KEY_z },
  { SCIM_KEY_z,                   SCIM_KEY_y },
  { SCIM_KEY_braceleft,           SCIM_KEY_udiaeresis },
  { SCIM_KEY_bar,                 SCIM_KEY_apostrophe },
  { SCIM_KEY_braceright,          SCIM_KEY_asterisk },
  { SCIM_KEY_asciitilde,          SCIM_KEY_degree },
};

static __Uint16Pair __german_swiss_to_us_normal [] = {
  { SCIM_KEY_dollar,              SCIM_KEY_backslash },
  { SCIM_KEY_apostrophe,          SCIM_KEY_minus },
  { SCIM_KEY_minus,               SCIM_KEY_slash },
  { SCIM_KEY_y,                   SCIM_KEY_z },
  { SCIM_KEY_z,                   SCIM_KEY_y },
  { SCIM_KEY_section,             SCIM_KEY_grave },
  { SCIM_KEY_adiaeresis,          SCIM_KEY_apostrophe },
  { SCIM_KEY_odiaeresis,          SCIM_KEY_semicolon },
  { SCIM_KEY_udiaeresis,          SCIM_KEY_bracketleft },
  { SCIM_KEY_dead_circumflex,     SCIM_KEY_equal },
  { SCIM_KEY_dead_diaeresis,      SCIM_KEY_bracketright },
};

static __Uint16Pair __us_to_german_swiss_normal [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_adiaeresis },
  { SCIM_KEY_minus,               SCIM_KEY_apostrophe },
  { SCIM_KEY_slash,               SCIM_KEY_minus },
  { SCIM_KEY_semicolon,           SCIM_KEY_odiaeresis },
  { SCIM_KEY_equal,               SCIM_KEY_dead_circumflex },
  { SCIM_KEY_bracketleft,         SCIM_KEY_udiaeresis },
  { SCIM_KEY_backslash,           SCIM_KEY_dollar },
  { SCIM_KEY_bracketright,        SCIM_KEY_dead_diaeresis },
  { SCIM_KEY_grave,               SCIM_KEY_section },
  { SCIM_KEY_y,                   SCIM_KEY_z },
  { SCIM_KEY_z,                   SCIM_KEY_y },
};

static __Uint16Pair __german_swiss_to_us_caps [] = {
  { SCIM_KEY_dollar,              SCIM_KEY_backslash },
  { SCIM_KEY_apostrophe,          SCIM_KEY_minus },
  { SCIM_KEY_minus,               SCIM_KEY_slash },
  { SCIM_KEY_Y,                   SCIM_KEY_Z },
  { SCIM_KEY_Z,                   SCIM_KEY_Y },
  { SCIM_KEY_section,             SCIM_KEY_grave },
  { SCIM_KEY_Adiaeresis,          SCIM_KEY_apostrophe },
  { SCIM_KEY_Odiaeresis,          SCIM_KEY_semicolon },
  { SCIM_KEY_Udiaeresis,          SCIM_KEY_bracketleft },
  { SCIM_KEY_dead_circumflex,     SCIM_KEY_equal },
  { SCIM_KEY_dead_diaeresis,      SCIM_KEY_bracketright },
};

static __Uint16Pair __us_to_german_swiss_caps [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_Adiaeresis },
  { SCIM_KEY_minus,               SCIM_KEY_apostrophe },
  { SCIM_KEY_slash,               SCIM_KEY_minus },
  { SCIM_KEY_semicolon,           SCIM_KEY_Odiaeresis },
  { SCIM_KEY_equal,               SCIM_KEY_dead_circumflex },
  { SCIM_KEY_Y,                   SCIM_KEY_Z },
  { SCIM_KEY_Z,                   SCIM_KEY_Y },
  { SCIM_KEY_bracketleft,         SCIM_KEY_Udiaeresis },
  { SCIM_KEY_backslash,           SCIM_KEY_dollar },
  { SCIM_KEY_bracketright,        SCIM_KEY_dead_diaeresis },
  { SCIM_KEY_grave,               SCIM_KEY_section },
};

static __Uint16Pair __german_swiss_to_us_shift [] = {
  { SCIM_KEY_exclam,              SCIM_KEY_braceright },
  { SCIM_KEY_quotedbl,            SCIM_KEY_at },
  { SCIM_KEY_ampersand,           SCIM_KEY_asciicircum },
  { SCIM_KEY_parenleft,           SCIM_KEY_asterisk },
  { SCIM_KEY_parenright,          SCIM_KEY_parenleft },
  { SCIM_KEY_asterisk,            SCIM_KEY_numbersign },
  { SCIM_KEY_plus,                SCIM_KEY_exclam },
  { SCIM_KEY_slash,               SCIM_KEY_ampersand },
  { SCIM_KEY_colon,               SCIM_KEY_greater },
  { SCIM_KEY_semicolon,           SCIM_KEY_less },
  { SCIM_KEY_equal,               SCIM_KEY_parenright },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_Y,                   SCIM_KEY_Z },
  { SCIM_KEY_Z,                   SCIM_KEY_Y },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_sterling,            SCIM_KEY_bar },
  { SCIM_KEY_degree,              SCIM_KEY_asciitilde },
  { SCIM_KEY_agrave,              SCIM_KEY_quotedbl },
  { SCIM_KEY_ccedilla,            SCIM_KEY_dollar },
  { SCIM_KEY_egrave,              SCIM_KEY_braceleft },
  { SCIM_KEY_eacute,              SCIM_KEY_colon },
  { SCIM_KEY_dead_grave,          SCIM_KEY_plus },
};

static __Uint16Pair __us_to_german_swiss_shift [] = {
  { SCIM_KEY_exclam,              SCIM_KEY_plus },
  { SCIM_KEY_quotedbl,            SCIM_KEY_agrave },
  { SCIM_KEY_numbersign,          SCIM_KEY_asterisk },
  { SCIM_KEY_dollar,              SCIM_KEY_ccedilla },
  { SCIM_KEY_ampersand,           SCIM_KEY_slash },
  { SCIM_KEY_parenleft,           SCIM_KEY_parenright },
  { SCIM_KEY_parenright,          SCIM_KEY_equal },
  { SCIM_KEY_asterisk,            SCIM_KEY_parenleft },
  { SCIM_KEY_plus,                SCIM_KEY_dead_grave },
  { SCIM_KEY_colon,               SCIM_KEY_eacute },
  { SCIM_KEY_less,                SCIM_KEY_semicolon },
  { SCIM_KEY_greater,             SCIM_KEY_colon },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_at,                  SCIM_KEY_quotedbl },
  { SCIM_KEY_Y,                   SCIM_KEY_Z },
  { SCIM_KEY_Z,                   SCIM_KEY_Y },
  { SCIM_KEY_asciicircum,         SCIM_KEY_ampersand },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_braceleft,           SCIM_KEY_egrave },
  { SCIM_KEY_bar,                 SCIM_KEY_sterling },
  { SCIM_KEY_braceright,          SCIM_KEY_exclam },
  { SCIM_KEY_asciitilde,          SCIM_KEY_degree },
};

static __Uint16Pair __german_swiss_to_us_caps_shift [] = {
  { SCIM_KEY_exclam,              SCIM_KEY_braceright },
  { SCIM_KEY_quotedbl,            SCIM_KEY_at },
  { SCIM_KEY_ampersand,           SCIM_KEY_asciicircum },
  { SCIM_KEY_parenleft,           SCIM_KEY_asterisk },
  { SCIM_KEY_parenright,          SCIM_KEY_parenleft },
  { SCIM_KEY_asterisk,            SCIM_KEY_numbersign },
  { SCIM_KEY_plus,                SCIM_KEY_exclam },
  { SCIM_KEY_slash,               SCIM_KEY_ampersand },
  { SCIM_KEY_colon,               SCIM_KEY_greater },
  { SCIM_KEY_semicolon,           SCIM_KEY_less },
  { SCIM_KEY_equal,               SCIM_KEY_parenright },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_y,                   SCIM_KEY_z },
  { SCIM_KEY_z,                   SCIM_KEY_y },
  { SCIM_KEY_sterling,            SCIM_KEY_bar },
  { SCIM_KEY_degree,              SCIM_KEY_asciitilde },
  { SCIM_KEY_Agrave,              SCIM_KEY_quotedbl },
  { SCIM_KEY_Ccedilla,            SCIM_KEY_dollar },
  { SCIM_KEY_Egrave,              SCIM_KEY_braceleft },
  { SCIM_KEY_Eacute,              SCIM_KEY_colon },
  { SCIM_KEY_dead_grave,          SCIM_KEY_plus },
};

static __Uint16Pair __us_to_german_swiss_caps_shift [] = {
  { SCIM_KEY_exclam,              SCIM_KEY_plus },
  { SCIM_KEY_quotedbl,            SCIM_KEY_Agrave },
  { SCIM_KEY_numbersign,          SCIM_KEY_asterisk },
  { SCIM_KEY_dollar,              SCIM_KEY_Ccedilla },
  { SCIM_KEY_ampersand,           SCIM_KEY_slash },
  { SCIM_KEY_parenleft,           SCIM_KEY_parenright },
  { SCIM_KEY_parenright,          SCIM_KEY_equal },
  { SCIM_KEY_asterisk,            SCIM_KEY_parenleft },
  { SCIM_KEY_plus,                SCIM_KEY_dead_grave },
  { SCIM_KEY_colon,               SCIM_KEY_Eacute },
  { SCIM_KEY_less,                SCIM_KEY_semicolon },
  { SCIM_KEY_greater,             SCIM_KEY_colon },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_at,                  SCIM_KEY_quotedbl },
  { SCIM_KEY_asciicircum,         SCIM_KEY_ampersand },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_y,                   SCIM_KEY_z },
  { SCIM_KEY_z,                   SCIM_KEY_y },
  { SCIM_KEY_braceleft,           SCIM_KEY_Egrave },
  { SCIM_KEY_bar,                 SCIM_KEY_sterling },
  { SCIM_KEY_braceright,          SCIM_KEY_exclam },
  { SCIM_KEY_asciitilde,          SCIM_KEY_degree },
};

static __Uint16Pair __hungarian_to_us_normal [] = {
  { SCIM_KEY_minus,               SCIM_KEY_slash },
  { SCIM_KEY_0,                   SCIM_KEY_grave },
  { SCIM_KEY_y,                   SCIM_KEY_z },
  { SCIM_KEY_z,                   SCIM_KEY_y },
  { SCIM_KEY_aacute,              SCIM_KEY_apostrophe },
  { SCIM_KEY_eacute,              SCIM_KEY_semicolon },
  { SCIM_KEY_oacute,              SCIM_KEY_equal },
  { SCIM_KEY_odiaeresis,          SCIM_KEY_0 },
  { SCIM_KEY_uacute,              SCIM_KEY_bracketright },
  { SCIM_KEY_udiaeresis,          SCIM_KEY_minus },
  { SCIM_KEY_odoubleacute,        SCIM_KEY_bracketleft },
  { SCIM_KEY_udoubleacute,        SCIM_KEY_backslash },
};

static __Uint16Pair __us_to_hungarian_normal [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_aacute },
  { SCIM_KEY_minus,               SCIM_KEY_udiaeresis },
  { SCIM_KEY_slash,               SCIM_KEY_minus },
  { SCIM_KEY_0,                   SCIM_KEY_odiaeresis },
  { SCIM_KEY_semicolon,           SCIM_KEY_eacute },
  { SCIM_KEY_equal,               SCIM_KEY_oacute },
  { SCIM_KEY_bracketleft,         SCIM_KEY_odoubleacute },
  { SCIM_KEY_backslash,           SCIM_KEY_udoubleacute },
  { SCIM_KEY_bracketright,        SCIM_KEY_uacute },
  { SCIM_KEY_grave,               SCIM_KEY_0 },
  { SCIM_KEY_y,                   SCIM_KEY_z },
  { SCIM_KEY_z,                   SCIM_KEY_y },
};

static __Uint16Pair __hungarian_to_us_caps [] = {
  { SCIM_KEY_minus,               SCIM_KEY_slash },
  { SCIM_KEY_0,                   SCIM_KEY_grave },
  { SCIM_KEY_Y,                   SCIM_KEY_Z },
  { SCIM_KEY_Z,                   SCIM_KEY_Y },
  { SCIM_KEY_Aacute,              SCIM_KEY_apostrophe },
  { SCIM_KEY_Eacute,              SCIM_KEY_semicolon },
  { SCIM_KEY_Oacute,              SCIM_KEY_equal },
  { SCIM_KEY_Odiaeresis,          SCIM_KEY_0 },
  { SCIM_KEY_Uacute,              SCIM_KEY_bracketright },
  { SCIM_KEY_Udiaeresis,          SCIM_KEY_minus },
  { SCIM_KEY_Odoubleacute,        SCIM_KEY_bracketleft },
  { SCIM_KEY_Udoubleacute,        SCIM_KEY_backslash },
};

static __Uint16Pair __us_to_hungarian_caps [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_Aacute },
  { SCIM_KEY_minus,               SCIM_KEY_Udiaeresis },
  { SCIM_KEY_slash,               SCIM_KEY_minus },
  { SCIM_KEY_0,                   SCIM_KEY_Odiaeresis },
  { SCIM_KEY_semicolon,           SCIM_KEY_Eacute },
  { SCIM_KEY_equal,               SCIM_KEY_Oacute },
  { SCIM_KEY_Y,                   SCIM_KEY_Z },
  { SCIM_KEY_Z,                   SCIM_KEY_Y },
  { SCIM_KEY_bracketleft,         SCIM_KEY_Odoubleacute },
  { SCIM_KEY_backslash,           SCIM_KEY_Udoubleacute },
  { SCIM_KEY_bracketright,        SCIM_KEY_Uacute },
  { SCIM_KEY_grave,               SCIM_KEY_0 },
};

static __Uint16Pair __hungarian_to_us_shift [] = {
  { SCIM_KEY_exclam,              SCIM_KEY_dollar },
  { SCIM_KEY_quotedbl,            SCIM_KEY_at },
  { SCIM_KEY_apostrophe,          SCIM_KEY_exclam },
  { SCIM_KEY_parenleft,           SCIM_KEY_asterisk },
  { SCIM_KEY_parenright,          SCIM_KEY_parenleft },
  { SCIM_KEY_plus,                SCIM_KEY_numbersign },
  { SCIM_KEY_slash,               SCIM_KEY_asciicircum },
  { SCIM_KEY_colon,               SCIM_KEY_greater },
  { SCIM_KEY_equal,               SCIM_KEY_ampersand },
  { SCIM_KEY_question,            SCIM_KEY_less },
  { SCIM_KEY_Y,                   SCIM_KEY_Z },
  { SCIM_KEY_Z,                   SCIM_KEY_Y },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_section,             SCIM_KEY_asciitilde },
  { SCIM_KEY_Aacute,              SCIM_KEY_quotedbl },
  { SCIM_KEY_Eacute,              SCIM_KEY_colon },
  { SCIM_KEY_Oacute,              SCIM_KEY_plus },
  { SCIM_KEY_Odiaeresis,          SCIM_KEY_parenright },
  { SCIM_KEY_Uacute,              SCIM_KEY_braceright },
  { SCIM_KEY_Udiaeresis,          SCIM_KEY_underscore },
  { SCIM_KEY_Odoubleacute,        SCIM_KEY_braceleft },
  { SCIM_KEY_Udoubleacute,        SCIM_KEY_bar },
};

static __Uint16Pair __us_to_hungarian_shift [] = {
  { SCIM_KEY_exclam,              SCIM_KEY_apostrophe },
  { SCIM_KEY_quotedbl,            SCIM_KEY_Aacute },
  { SCIM_KEY_numbersign,          SCIM_KEY_plus },
  { SCIM_KEY_dollar,              SCIM_KEY_exclam },
  { SCIM_KEY_ampersand,           SCIM_KEY_equal },
  { SCIM_KEY_parenleft,           SCIM_KEY_parenright },
  { SCIM_KEY_parenright,          SCIM_KEY_Odiaeresis },
  { SCIM_KEY_asterisk,            SCIM_KEY_parenleft },
  { SCIM_KEY_plus,                SCIM_KEY_Oacute },
  { SCIM_KEY_colon,               SCIM_KEY_Eacute },
  { SCIM_KEY_less,                SCIM_KEY_question },
  { SCIM_KEY_greater,             SCIM_KEY_colon },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_at,                  SCIM_KEY_quotedbl },
  { SCIM_KEY_Y,                   SCIM_KEY_Z },
  { SCIM_KEY_Z,                   SCIM_KEY_Y },
  { SCIM_KEY_asciicircum,         SCIM_KEY_slash },
  { SCIM_KEY_underscore,          SCIM_KEY_Udiaeresis },
  { SCIM_KEY_braceleft,           SCIM_KEY_Odoubleacute },
  { SCIM_KEY_bar,                 SCIM_KEY_Udoubleacute },
  { SCIM_KEY_braceright,          SCIM_KEY_Uacute },
  { SCIM_KEY_asciitilde,          SCIM_KEY_section },
};

static __Uint16Pair __hungarian_to_us_caps_shift [] = {
  { SCIM_KEY_exclam,              SCIM_KEY_dollar },
  { SCIM_KEY_quotedbl,            SCIM_KEY_at },
  { SCIM_KEY_apostrophe,          SCIM_KEY_exclam },
  { SCIM_KEY_parenleft,           SCIM_KEY_asterisk },
  { SCIM_KEY_parenright,          SCIM_KEY_parenleft },
  { SCIM_KEY_plus,                SCIM_KEY_numbersign },
  { SCIM_KEY_slash,               SCIM_KEY_asciicircum },
  { SCIM_KEY_colon,               SCIM_KEY_greater },
  { SCIM_KEY_equal,               SCIM_KEY_ampersand },
  { SCIM_KEY_question,            SCIM_KEY_less },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_y,                   SCIM_KEY_z },
  { SCIM_KEY_z,                   SCIM_KEY_y },
  { SCIM_KEY_section,             SCIM_KEY_asciitilde },
  { SCIM_KEY_aacute,              SCIM_KEY_quotedbl },
  { SCIM_KEY_eacute,              SCIM_KEY_colon },
  { SCIM_KEY_oacute,              SCIM_KEY_plus },
  { SCIM_KEY_odiaeresis,          SCIM_KEY_parenright },
  { SCIM_KEY_uacute,              SCIM_KEY_braceright },
  { SCIM_KEY_udiaeresis,          SCIM_KEY_underscore },
  { SCIM_KEY_odoubleacute,        SCIM_KEY_braceleft },
  { SCIM_KEY_udoubleacute,        SCIM_KEY_bar },
};

static __Uint16Pair __us_to_hungarian_caps_shift [] = {
  { SCIM_KEY_exclam,              SCIM_KEY_apostrophe },
  { SCIM_KEY_quotedbl,            SCIM_KEY_aacute },
  { SCIM_KEY_numbersign,          SCIM_KEY_plus },
  { SCIM_KEY_dollar,              SCIM_KEY_exclam },
  { SCIM_KEY_ampersand,           SCIM_KEY_equal },
  { SCIM_KEY_parenleft,           SCIM_KEY_parenright },
  { SCIM_KEY_parenright,          SCIM_KEY_odiaeresis },
  { SCIM_KEY_asterisk,            SCIM_KEY_parenleft },
  { SCIM_KEY_plus,                SCIM_KEY_oacute },
  { SCIM_KEY_colon,               SCIM_KEY_eacute },
  { SCIM_KEY_less,                SCIM_KEY_question },
  { SCIM_KEY_greater,             SCIM_KEY_colon },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_at,                  SCIM_KEY_quotedbl },
  { SCIM_KEY_asciicircum,         SCIM_KEY_slash },
  { SCIM_KEY_underscore,          SCIM_KEY_udiaeresis },
  { SCIM_KEY_y,                   SCIM_KEY_z },
  { SCIM_KEY_z,                   SCIM_KEY_y },
  { SCIM_KEY_braceleft,           SCIM_KEY_odoubleacute },
  { SCIM_KEY_bar,                 SCIM_KEY_udoubleacute },
  { SCIM_KEY_braceright,          SCIM_KEY_uacute },
  { SCIM_KEY_asciitilde,          SCIM_KEY_section },
};

static __Uint16Pair __italian_to_us_normal [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_minus },
  { SCIM_KEY_plus,                SCIM_KEY_bracketright },
  { SCIM_KEY_minus,               SCIM_KEY_slash },
  { SCIM_KEY_backslash,           SCIM_KEY_grave },
  { SCIM_KEY_agrave,              SCIM_KEY_apostrophe },
  { SCIM_KEY_egrave,              SCIM_KEY_bracketleft },
  { SCIM_KEY_igrave,              SCIM_KEY_equal },
  { SCIM_KEY_ograve,              SCIM_KEY_semicolon },
  { SCIM_KEY_ugrave,              SCIM_KEY_backslash },
};

static __Uint16Pair __us_to_italian_normal [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_agrave },
  { SCIM_KEY_minus,               SCIM_KEY_apostrophe },
  { SCIM_KEY_slash,               SCIM_KEY_minus },
  { SCIM_KEY_semicolon,           SCIM_KEY_ograve },
  { SCIM_KEY_equal,               SCIM_KEY_igrave },
  { SCIM_KEY_bracketleft,         SCIM_KEY_egrave },
  { SCIM_KEY_backslash,           SCIM_KEY_ugrave },
  { SCIM_KEY_bracketright,        SCIM_KEY_plus },
  { SCIM_KEY_grave,               SCIM_KEY_backslash },
};

static __Uint16Pair __italian_to_us_caps [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_minus },
  { SCIM_KEY_plus,                SCIM_KEY_bracketright },
  { SCIM_KEY_minus,               SCIM_KEY_slash },
  { SCIM_KEY_backslash,           SCIM_KEY_grave },
  { SCIM_KEY_Agrave,              SCIM_KEY_apostrophe },
  { SCIM_KEY_Egrave,              SCIM_KEY_bracketleft },
  { SCIM_KEY_Igrave,              SCIM_KEY_equal },
  { SCIM_KEY_Ograve,              SCIM_KEY_semicolon },
  { SCIM_KEY_Ugrave,              SCIM_KEY_backslash },
};

static __Uint16Pair __us_to_italian_caps [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_Agrave },
  { SCIM_KEY_minus,               SCIM_KEY_apostrophe },
  { SCIM_KEY_slash,               SCIM_KEY_minus },
  { SCIM_KEY_semicolon,           SCIM_KEY_Ograve },
  { SCIM_KEY_equal,               SCIM_KEY_Igrave },
  { SCIM_KEY_bracketleft,         SCIM_KEY_Egrave },
  { SCIM_KEY_backslash,           SCIM_KEY_Ugrave },
  { SCIM_KEY_bracketright,        SCIM_KEY_plus },
  { SCIM_KEY_grave,               SCIM_KEY_backslash },
};

static __Uint16Pair __italian_to_us_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_at },
  { SCIM_KEY_ampersand,           SCIM_KEY_asciicircum },
  { SCIM_KEY_parenleft,           SCIM_KEY_asterisk },
  { SCIM_KEY_parenright,          SCIM_KEY_parenleft },
  { SCIM_KEY_asterisk,            SCIM_KEY_braceright },
  { SCIM_KEY_slash,               SCIM_KEY_ampersand },
  { SCIM_KEY_colon,               SCIM_KEY_greater },
  { SCIM_KEY_semicolon,           SCIM_KEY_less },
  { SCIM_KEY_equal,               SCIM_KEY_parenright },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_asciicircum,         SCIM_KEY_plus },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_bar,                 SCIM_KEY_asciitilde },
  { SCIM_KEY_sterling,            SCIM_KEY_numbersign },
  { SCIM_KEY_section,             SCIM_KEY_bar },
  { SCIM_KEY_degree,              SCIM_KEY_quotedbl },
  { SCIM_KEY_ccedilla,            SCIM_KEY_colon },
  { SCIM_KEY_eacute,              SCIM_KEY_braceleft },
};

static __Uint16Pair __us_to_italian_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_degree },
  { SCIM_KEY_numbersign,          SCIM_KEY_sterling },
  { SCIM_KEY_ampersand,           SCIM_KEY_slash },
  { SCIM_KEY_parenleft,           SCIM_KEY_parenright },
  { SCIM_KEY_parenright,          SCIM_KEY_equal },
  { SCIM_KEY_asterisk,            SCIM_KEY_parenleft },
  { SCIM_KEY_plus,                SCIM_KEY_asciicircum },
  { SCIM_KEY_colon,               SCIM_KEY_ccedilla },
  { SCIM_KEY_less,                SCIM_KEY_semicolon },
  { SCIM_KEY_greater,             SCIM_KEY_colon },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_at,                  SCIM_KEY_quotedbl },
  { SCIM_KEY_asciicircum,         SCIM_KEY_ampersand },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_braceleft,           SCIM_KEY_eacute },
  { SCIM_KEY_bar,                 SCIM_KEY_section },
  { SCIM_KEY_braceright,          SCIM_KEY_asterisk },
  { SCIM_KEY_asciitilde,          SCIM_KEY_bar },
};

static __Uint16Pair __italian_to_us_caps_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_at },
  { SCIM_KEY_ampersand,           SCIM_KEY_asciicircum },
  { SCIM_KEY_parenleft,           SCIM_KEY_asterisk },
  { SCIM_KEY_parenright,          SCIM_KEY_parenleft },
  { SCIM_KEY_asterisk,            SCIM_KEY_braceright },
  { SCIM_KEY_slash,               SCIM_KEY_ampersand },
  { SCIM_KEY_colon,               SCIM_KEY_greater },
  { SCIM_KEY_semicolon,           SCIM_KEY_less },
  { SCIM_KEY_equal,               SCIM_KEY_parenright },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_asciicircum,         SCIM_KEY_plus },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_bar,                 SCIM_KEY_asciitilde },
  { SCIM_KEY_sterling,            SCIM_KEY_numbersign },
  { SCIM_KEY_section,             SCIM_KEY_bar },
  { SCIM_KEY_degree,              SCIM_KEY_quotedbl },
  { SCIM_KEY_Ccedilla,            SCIM_KEY_colon },
  { SCIM_KEY_Eacute,              SCIM_KEY_braceleft },
};

static __Uint16Pair __us_to_italian_caps_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_degree },
  { SCIM_KEY_numbersign,          SCIM_KEY_sterling },
  { SCIM_KEY_ampersand,           SCIM_KEY_slash },
  { SCIM_KEY_parenleft,           SCIM_KEY_parenright },
  { SCIM_KEY_parenright,          SCIM_KEY_equal },
  { SCIM_KEY_asterisk,            SCIM_KEY_parenleft },
  { SCIM_KEY_plus,                SCIM_KEY_asciicircum },
  { SCIM_KEY_colon,               SCIM_KEY_Ccedilla },
  { SCIM_KEY_less,                SCIM_KEY_semicolon },
  { SCIM_KEY_greater,             SCIM_KEY_colon },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_at,                  SCIM_KEY_quotedbl },
  { SCIM_KEY_asciicircum,         SCIM_KEY_ampersand },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_braceleft,           SCIM_KEY_Eacute },
  { SCIM_KEY_bar,                 SCIM_KEY_section },
  { SCIM_KEY_braceright,          SCIM_KEY_asterisk },
  { SCIM_KEY_asciitilde,          SCIM_KEY_bar },
};

static __Uint16Pair __japanese_to_us_normal [] = {
  { SCIM_KEY_colon,               SCIM_KEY_apostrophe },
  { SCIM_KEY_at,                  SCIM_KEY_bracketleft },
  { SCIM_KEY_bracketleft,         SCIM_KEY_bracketright },
  { SCIM_KEY_bracketright,        SCIM_KEY_backslash },
  { SCIM_KEY_asciicircum,         SCIM_KEY_equal },
  { SCIM_KEY_Zenkaku_Hankaku,     SCIM_KEY_grave },
};

static __Uint16Pair __us_to_japanese_normal [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_colon },
  { SCIM_KEY_equal,               SCIM_KEY_asciicircum },
  { SCIM_KEY_bracketleft,         SCIM_KEY_at },
  { SCIM_KEY_backslash,           SCIM_KEY_bracketright },
  { SCIM_KEY_bracketright,        SCIM_KEY_bracketleft },
  { SCIM_KEY_grave,               SCIM_KEY_Zenkaku_Hankaku },
};

static __Uint16Pair __japanese_to_us_caps [] = {
  { SCIM_KEY_colon,               SCIM_KEY_apostrophe },
  { SCIM_KEY_at,                  SCIM_KEY_bracketleft },
  { SCIM_KEY_bracketleft,         SCIM_KEY_bracketright },
  { SCIM_KEY_bracketright,        SCIM_KEY_backslash },
  { SCIM_KEY_asciicircum,         SCIM_KEY_equal },
  { SCIM_KEY_Zenkaku_Hankaku,     SCIM_KEY_grave },
};

static __Uint16Pair __us_to_japanese_caps [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_colon },
  { SCIM_KEY_equal,               SCIM_KEY_asciicircum },
  { SCIM_KEY_bracketleft,         SCIM_KEY_at },
  { SCIM_KEY_backslash,           SCIM_KEY_bracketright },
  { SCIM_KEY_bracketright,        SCIM_KEY_bracketleft },
  { SCIM_KEY_grave,               SCIM_KEY_Zenkaku_Hankaku },
};

static __Uint16Pair __japanese_to_us_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_at },
  { SCIM_KEY_ampersand,           SCIM_KEY_asciicircum },
  { SCIM_KEY_apostrophe,          SCIM_KEY_ampersand },
  { SCIM_KEY_parenleft,           SCIM_KEY_asterisk },
  { SCIM_KEY_parenright,          SCIM_KEY_parenleft },
  { SCIM_KEY_asterisk,            SCIM_KEY_quotedbl },
  { SCIM_KEY_plus,                SCIM_KEY_colon },
  { SCIM_KEY_equal,               SCIM_KEY_underscore },
  { SCIM_KEY_grave,               SCIM_KEY_braceleft },
  { SCIM_KEY_braceleft,           SCIM_KEY_braceright },
  { SCIM_KEY_braceright,          SCIM_KEY_bar },
  { SCIM_KEY_asciitilde,          SCIM_KEY_parenright },
  { SCIM_KEY_asciitilde,          SCIM_KEY_plus },
  { SCIM_KEY_Zenkaku_Hankaku,     SCIM_KEY_asciitilde },
};

static __Uint16Pair __us_to_japanese_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_asterisk },
  { SCIM_KEY_ampersand,           SCIM_KEY_apostrophe },
  { SCIM_KEY_parenleft,           SCIM_KEY_parenright },
  { SCIM_KEY_parenright,          SCIM_KEY_asciitilde },
  { SCIM_KEY_asterisk,            SCIM_KEY_parenleft },
  { SCIM_KEY_plus,                SCIM_KEY_asciitilde },
  { SCIM_KEY_colon,               SCIM_KEY_plus },
  { SCIM_KEY_at,                  SCIM_KEY_quotedbl },
  { SCIM_KEY_asciicircum,         SCIM_KEY_ampersand },
  { SCIM_KEY_underscore,          SCIM_KEY_equal },
  { SCIM_KEY_braceleft,           SCIM_KEY_grave },
  { SCIM_KEY_bar,                 SCIM_KEY_braceright },
  { SCIM_KEY_braceright,          SCIM_KEY_braceleft },
  { SCIM_KEY_asciitilde,          SCIM_KEY_Zenkaku_Hankaku },
};

static __Uint16Pair __japanese_to_us_caps_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_at },
  { SCIM_KEY_ampersand,           SCIM_KEY_asciicircum },
  { SCIM_KEY_apostrophe,          SCIM_KEY_ampersand },
  { SCIM_KEY_parenleft,           SCIM_KEY_asterisk },
  { SCIM_KEY_parenright,          SCIM_KEY_parenleft },
  { SCIM_KEY_asterisk,            SCIM_KEY_quotedbl },
  { SCIM_KEY_plus,                SCIM_KEY_colon },
  { SCIM_KEY_equal,               SCIM_KEY_underscore },
  { SCIM_KEY_grave,               SCIM_KEY_braceleft },
  { SCIM_KEY_braceleft,           SCIM_KEY_braceright },
  { SCIM_KEY_braceright,          SCIM_KEY_bar },
  { SCIM_KEY_asciitilde,          SCIM_KEY_parenright },
  { SCIM_KEY_asciitilde,          SCIM_KEY_plus },
  { SCIM_KEY_Zenkaku_Hankaku,     SCIM_KEY_asciitilde },
};

static __Uint16Pair __us_to_japanese_caps_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_asterisk },
  { SCIM_KEY_ampersand,           SCIM_KEY_apostrophe },
  { SCIM_KEY_parenleft,           SCIM_KEY_parenright },
  { SCIM_KEY_parenright,          SCIM_KEY_asciitilde },
  { SCIM_KEY_asterisk,            SCIM_KEY_parenleft },
  { SCIM_KEY_plus,                SCIM_KEY_asciitilde },
  { SCIM_KEY_colon,               SCIM_KEY_plus },
  { SCIM_KEY_at,                  SCIM_KEY_quotedbl },
  { SCIM_KEY_asciicircum,         SCIM_KEY_ampersand },
  { SCIM_KEY_underscore,          SCIM_KEY_equal },
  { SCIM_KEY_braceleft,           SCIM_KEY_grave },
  { SCIM_KEY_bar,                 SCIM_KEY_braceright },
  { SCIM_KEY_braceright,          SCIM_KEY_braceleft },
  { SCIM_KEY_asciitilde,          SCIM_KEY_Zenkaku_Hankaku },
};

static __Uint16Pair __norwegian_to_us_normal [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_backslash },
  { SCIM_KEY_plus,                SCIM_KEY_minus },
  { SCIM_KEY_minus,               SCIM_KEY_slash },
  { SCIM_KEY_backslash,           SCIM_KEY_equal },
  { SCIM_KEY_bar,                 SCIM_KEY_grave },
  { SCIM_KEY_aring,               SCIM_KEY_bracketleft },
  { SCIM_KEY_ae,                  SCIM_KEY_apostrophe },
  { SCIM_KEY_oslash,              SCIM_KEY_semicolon },
  { SCIM_KEY_dead_diaeresis,      SCIM_KEY_bracketright },
};

static __Uint16Pair __us_to_norwegian_normal [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_ae },
  { SCIM_KEY_minus,               SCIM_KEY_plus },
  { SCIM_KEY_slash,               SCIM_KEY_minus },
  { SCIM_KEY_semicolon,           SCIM_KEY_oslash },
  { SCIM_KEY_equal,               SCIM_KEY_backslash },
  { SCIM_KEY_bracketleft,         SCIM_KEY_aring },
  { SCIM_KEY_backslash,           SCIM_KEY_apostrophe },
  { SCIM_KEY_bracketright,        SCIM_KEY_dead_diaeresis },
  { SCIM_KEY_grave,               SCIM_KEY_bar },
};

static __Uint16Pair __norwegian_to_us_caps [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_backslash },
  { SCIM_KEY_plus,                SCIM_KEY_minus },
  { SCIM_KEY_minus,               SCIM_KEY_slash },
  { SCIM_KEY_backslash,           SCIM_KEY_equal },
  { SCIM_KEY_bar,                 SCIM_KEY_grave },
  { SCIM_KEY_Aring,               SCIM_KEY_bracketleft },
  { SCIM_KEY_AE,                  SCIM_KEY_apostrophe },
  { SCIM_KEY_Ooblique,            SCIM_KEY_semicolon },
  { SCIM_KEY_dead_diaeresis,      SCIM_KEY_bracketright },
};

static __Uint16Pair __us_to_norwegian_caps [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_AE },
  { SCIM_KEY_minus,               SCIM_KEY_plus },
  { SCIM_KEY_slash,               SCIM_KEY_minus },
  { SCIM_KEY_semicolon,           SCIM_KEY_Ooblique },
  { SCIM_KEY_equal,               SCIM_KEY_backslash },
  { SCIM_KEY_bracketleft,         SCIM_KEY_Aring },
  { SCIM_KEY_backslash,           SCIM_KEY_apostrophe },
  { SCIM_KEY_bracketright,        SCIM_KEY_dead_diaeresis },
  { SCIM_KEY_grave,               SCIM_KEY_bar },
};

static __Uint16Pair __norwegian_to_us_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_at },
  { SCIM_KEY_ampersand,           SCIM_KEY_asciicircum },
  { SCIM_KEY_parenleft,           SCIM_KEY_asterisk },
  { SCIM_KEY_parenright,          SCIM_KEY_parenleft },
  { SCIM_KEY_asterisk,            SCIM_KEY_bar },
  { SCIM_KEY_slash,               SCIM_KEY_ampersand },
  { SCIM_KEY_colon,               SCIM_KEY_greater },
  { SCIM_KEY_semicolon,           SCIM_KEY_less },
  { SCIM_KEY_equal,               SCIM_KEY_parenright },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_currency,            SCIM_KEY_dollar },
  { SCIM_KEY_section,             SCIM_KEY_asciitilde },
  { SCIM_KEY_Aring,               SCIM_KEY_braceleft },
  { SCIM_KEY_AE,                  SCIM_KEY_quotedbl },
  { SCIM_KEY_Ooblique,            SCIM_KEY_colon },
  { SCIM_KEY_dead_grave,          SCIM_KEY_plus },
  { SCIM_KEY_dead_circumflex,     SCIM_KEY_braceright },
};

static __Uint16Pair __us_to_norwegian_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_AE },
  { SCIM_KEY_dollar,              SCIM_KEY_currency },
  { SCIM_KEY_ampersand,           SCIM_KEY_slash },
  { SCIM_KEY_parenleft,           SCIM_KEY_parenright },
  { SCIM_KEY_parenright,          SCIM_KEY_equal },
  { SCIM_KEY_asterisk,            SCIM_KEY_parenleft },
  { SCIM_KEY_plus,                SCIM_KEY_dead_grave },
  { SCIM_KEY_colon,               SCIM_KEY_Ooblique },
  { SCIM_KEY_less,                SCIM_KEY_semicolon },
  { SCIM_KEY_greater,             SCIM_KEY_colon },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_at,                  SCIM_KEY_quotedbl },
  { SCIM_KEY_asciicircum,         SCIM_KEY_ampersand },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_braceleft,           SCIM_KEY_Aring },
  { SCIM_KEY_bar,                 SCIM_KEY_asterisk },
  { SCIM_KEY_braceright,          SCIM_KEY_dead_circumflex },
  { SCIM_KEY_asciitilde,          SCIM_KEY_section },
};

static __Uint16Pair __norwegian_to_us_caps_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_at },
  { SCIM_KEY_ampersand,           SCIM_KEY_asciicircum },
  { SCIM_KEY_parenleft,           SCIM_KEY_asterisk },
  { SCIM_KEY_parenright,          SCIM_KEY_parenleft },
  { SCIM_KEY_asterisk,            SCIM_KEY_bar },
  { SCIM_KEY_slash,               SCIM_KEY_ampersand },
  { SCIM_KEY_colon,               SCIM_KEY_greater },
  { SCIM_KEY_semicolon,           SCIM_KEY_less },
  { SCIM_KEY_equal,               SCIM_KEY_parenright },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_currency,            SCIM_KEY_dollar },
  { SCIM_KEY_section,             SCIM_KEY_asciitilde },
  { SCIM_KEY_aring,               SCIM_KEY_braceleft },
  { SCIM_KEY_ae,                  SCIM_KEY_quotedbl },
  { SCIM_KEY_oslash,              SCIM_KEY_colon },
  { SCIM_KEY_dead_grave,          SCIM_KEY_plus },
  { SCIM_KEY_dead_circumflex,     SCIM_KEY_braceright },
};

static __Uint16Pair __us_to_norwegian_caps_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_ae },
  { SCIM_KEY_dollar,              SCIM_KEY_currency },
  { SCIM_KEY_ampersand,           SCIM_KEY_slash },
  { SCIM_KEY_parenleft,           SCIM_KEY_parenright },
  { SCIM_KEY_parenright,          SCIM_KEY_equal },
  { SCIM_KEY_asterisk,            SCIM_KEY_parenleft },
  { SCIM_KEY_plus,                SCIM_KEY_dead_grave },
  { SCIM_KEY_colon,               SCIM_KEY_oslash },
  { SCIM_KEY_less,                SCIM_KEY_semicolon },
  { SCIM_KEY_greater,             SCIM_KEY_colon },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_at,                  SCIM_KEY_quotedbl },
  { SCIM_KEY_asciicircum,         SCIM_KEY_ampersand },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_braceleft,           SCIM_KEY_aring },
  { SCIM_KEY_bar,                 SCIM_KEY_asterisk },
  { SCIM_KEY_braceright,          SCIM_KEY_dead_circumflex },
  { SCIM_KEY_asciitilde,          SCIM_KEY_section },
};

static __Uint16Pair __portuguese_brazil_to_us_normal [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_grave },
  { SCIM_KEY_semicolon,           SCIM_KEY_slash },
  { SCIM_KEY_bracketleft,         SCIM_KEY_bracketright },
  { SCIM_KEY_bracketright,        SCIM_KEY_backslash },
  { SCIM_KEY_ccedilla,            SCIM_KEY_semicolon },
  { SCIM_KEY_dead_acute,          SCIM_KEY_bracketleft },
  { SCIM_KEY_dead_tilde,          SCIM_KEY_apostrophe },
};

static __Uint16Pair __us_to_portuguese_brazil_normal [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_dead_tilde },
  { SCIM_KEY_slash,               SCIM_KEY_semicolon },
  { SCIM_KEY_semicolon,           SCIM_KEY_ccedilla },
  { SCIM_KEY_bracketleft,         SCIM_KEY_dead_acute },
  { SCIM_KEY_backslash,           SCIM_KEY_bracketright },
  { SCIM_KEY_bracketright,        SCIM_KEY_bracketleft },
  { SCIM_KEY_grave,               SCIM_KEY_apostrophe },
};

static __Uint16Pair __portuguese_brazil_to_us_caps [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_grave },
  { SCIM_KEY_semicolon,           SCIM_KEY_slash },
  { SCIM_KEY_bracketleft,         SCIM_KEY_bracketright },
  { SCIM_KEY_bracketright,        SCIM_KEY_backslash },
  { SCIM_KEY_Ccedilla,            SCIM_KEY_semicolon },
  { SCIM_KEY_dead_acute,          SCIM_KEY_bracketleft },
  { SCIM_KEY_dead_tilde,          SCIM_KEY_apostrophe },
};

static __Uint16Pair __us_to_portuguese_brazil_caps [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_dead_tilde },
  { SCIM_KEY_slash,               SCIM_KEY_semicolon },
  { SCIM_KEY_semicolon,           SCIM_KEY_Ccedilla },
  { SCIM_KEY_bracketleft,         SCIM_KEY_dead_acute },
  { SCIM_KEY_backslash,           SCIM_KEY_bracketright },
  { SCIM_KEY_bracketright,        SCIM_KEY_bracketleft },
  { SCIM_KEY_grave,               SCIM_KEY_apostrophe },
};

static __Uint16Pair __portuguese_brazil_to_us_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_asciitilde },
  { SCIM_KEY_colon,               SCIM_KEY_question },
  { SCIM_KEY_braceleft,           SCIM_KEY_braceright },
  { SCIM_KEY_braceright,          SCIM_KEY_bar },
  { SCIM_KEY_Ccedilla,            SCIM_KEY_colon },
  { SCIM_KEY_dead_grave,          SCIM_KEY_braceleft },
  { SCIM_KEY_dead_circumflex,     SCIM_KEY_quotedbl },
  { SCIM_KEY_dead_diaeresis,      SCIM_KEY_asciicircum },
};

static __Uint16Pair __us_to_portuguese_brazil_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_dead_circumflex },
  { SCIM_KEY_colon,               SCIM_KEY_Ccedilla },
  { SCIM_KEY_question,            SCIM_KEY_colon },
  { SCIM_KEY_asciicircum,         SCIM_KEY_dead_diaeresis },
  { SCIM_KEY_braceleft,           SCIM_KEY_dead_grave },
  { SCIM_KEY_bar,                 SCIM_KEY_braceright },
  { SCIM_KEY_braceright,          SCIM_KEY_braceleft },
  { SCIM_KEY_asciitilde,          SCIM_KEY_quotedbl },
};

static __Uint16Pair __portuguese_brazil_to_us_caps_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_asciitilde },
  { SCIM_KEY_colon,               SCIM_KEY_question },
  { SCIM_KEY_braceleft,           SCIM_KEY_braceright },
  { SCIM_KEY_braceright,          SCIM_KEY_bar },
  { SCIM_KEY_ccedilla,            SCIM_KEY_colon },
  { SCIM_KEY_dead_grave,          SCIM_KEY_braceleft },
  { SCIM_KEY_dead_circumflex,     SCIM_KEY_quotedbl },
  { SCIM_KEY_dead_diaeresis,      SCIM_KEY_asciicircum },
};

static __Uint16Pair __us_to_portuguese_brazil_caps_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_dead_circumflex },
  { SCIM_KEY_colon,               SCIM_KEY_ccedilla },
  { SCIM_KEY_question,            SCIM_KEY_colon },
  { SCIM_KEY_asciicircum,         SCIM_KEY_dead_diaeresis },
  { SCIM_KEY_braceleft,           SCIM_KEY_dead_grave },
  { SCIM_KEY_bar,                 SCIM_KEY_braceright },
  { SCIM_KEY_braceright,          SCIM_KEY_braceleft },
  { SCIM_KEY_asciitilde,          SCIM_KEY_quotedbl },
};

static __Uint16Pair __portuguese_brazil_us_accents_to_us_normal [] = {
  { SCIM_KEY_dead_grave,          SCIM_KEY_grave },
  { SCIM_KEY_dead_acute,          SCIM_KEY_apostrophe },
};

static __Uint16Pair __us_to_portuguese_brazil_us_accents_normal [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_dead_acute },
  { SCIM_KEY_grave,               SCIM_KEY_dead_grave },
};

static __Uint16Pair __portuguese_brazil_us_accents_to_us_caps [] = {
  { SCIM_KEY_dead_grave,          SCIM_KEY_grave },
  { SCIM_KEY_dead_acute,          SCIM_KEY_apostrophe },
};

static __Uint16Pair __us_to_portuguese_brazil_us_accents_caps [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_dead_acute },
  { SCIM_KEY_grave,               SCIM_KEY_dead_grave },
};

static __Uint16Pair __portuguese_brazil_us_accents_to_us_shift [] = {
  { SCIM_KEY_dead_circumflex,     SCIM_KEY_asciicircum },
  { SCIM_KEY_dead_tilde,          SCIM_KEY_asciitilde },
  { SCIM_KEY_dead_diaeresis,      SCIM_KEY_quotedbl },
};

static __Uint16Pair __us_to_portuguese_brazil_us_accents_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_dead_diaeresis },
  { SCIM_KEY_asciicircum,         SCIM_KEY_dead_circumflex },
  { SCIM_KEY_asciitilde,          SCIM_KEY_dead_tilde },
};

static __Uint16Pair __portuguese_brazil_us_accents_to_us_caps_shift [] = {
  { SCIM_KEY_dead_circumflex,     SCIM_KEY_asciicircum },
  { SCIM_KEY_dead_tilde,          SCIM_KEY_asciitilde },
  { SCIM_KEY_dead_diaeresis,      SCIM_KEY_quotedbl },
};

static __Uint16Pair __us_to_portuguese_brazil_us_accents_caps_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_dead_diaeresis },
  { SCIM_KEY_asciicircum,         SCIM_KEY_dead_circumflex },
  { SCIM_KEY_asciitilde,          SCIM_KEY_dead_tilde },
};

static __Uint16Pair __portuguese_to_us_normal [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_minus },
  { SCIM_KEY_plus,                SCIM_KEY_bracketleft },
  { SCIM_KEY_minus,               SCIM_KEY_slash },
  { SCIM_KEY_backslash,           SCIM_KEY_grave },
  { SCIM_KEY_asciitilde,          SCIM_KEY_backslash },
  { SCIM_KEY_guillemotleft,       SCIM_KEY_equal },
  { SCIM_KEY_acute,               SCIM_KEY_bracketright },
  { SCIM_KEY_masculine,           SCIM_KEY_apostrophe },
  { SCIM_KEY_ccedilla,            SCIM_KEY_semicolon },
};

static __Uint16Pair __us_to_portuguese_normal [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_masculine },
  { SCIM_KEY_minus,               SCIM_KEY_apostrophe },
  { SCIM_KEY_slash,               SCIM_KEY_minus },
  { SCIM_KEY_semicolon,           SCIM_KEY_ccedilla },
  { SCIM_KEY_equal,               SCIM_KEY_guillemotleft },
  { SCIM_KEY_bracketleft,         SCIM_KEY_plus },
  { SCIM_KEY_backslash,           SCIM_KEY_asciitilde },
  { SCIM_KEY_bracketright,        SCIM_KEY_acute },
  { SCIM_KEY_grave,               SCIM_KEY_backslash },
};

static __Uint16Pair __portuguese_to_us_caps [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_minus },
  { SCIM_KEY_plus,                SCIM_KEY_bracketleft },
  { SCIM_KEY_minus,               SCIM_KEY_slash },
  { SCIM_KEY_backslash,           SCIM_KEY_grave },
  { SCIM_KEY_asciitilde,          SCIM_KEY_backslash },
  { SCIM_KEY_guillemotleft,       SCIM_KEY_equal },
  { SCIM_KEY_acute,               SCIM_KEY_bracketright },
  { SCIM_KEY_masculine,           SCIM_KEY_apostrophe },
  { SCIM_KEY_Ccedilla,            SCIM_KEY_semicolon },
};

static __Uint16Pair __us_to_portuguese_caps [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_masculine },
  { SCIM_KEY_minus,               SCIM_KEY_apostrophe },
  { SCIM_KEY_slash,               SCIM_KEY_minus },
  { SCIM_KEY_semicolon,           SCIM_KEY_Ccedilla },
  { SCIM_KEY_equal,               SCIM_KEY_guillemotleft },
  { SCIM_KEY_bracketleft,         SCIM_KEY_plus },
  { SCIM_KEY_backslash,           SCIM_KEY_asciitilde },
  { SCIM_KEY_bracketright,        SCIM_KEY_acute },
  { SCIM_KEY_grave,               SCIM_KEY_backslash },
};

static __Uint16Pair __portuguese_to_us_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_at },
  { SCIM_KEY_ampersand,           SCIM_KEY_asciicircum },
  { SCIM_KEY_parenleft,           SCIM_KEY_asterisk },
  { SCIM_KEY_parenright,          SCIM_KEY_parenleft },
  { SCIM_KEY_asterisk,            SCIM_KEY_braceleft },
  { SCIM_KEY_slash,               SCIM_KEY_ampersand },
  { SCIM_KEY_colon,               SCIM_KEY_greater },
  { SCIM_KEY_semicolon,           SCIM_KEY_less },
  { SCIM_KEY_equal,               SCIM_KEY_parenright },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_asciicircum,         SCIM_KEY_bar },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_grave,               SCIM_KEY_braceright },
  { SCIM_KEY_bar,                 SCIM_KEY_asciitilde },
  { SCIM_KEY_ordfeminine,         SCIM_KEY_quotedbl },
  { SCIM_KEY_guillemotright,      SCIM_KEY_plus },
  { SCIM_KEY_Ccedilla,            SCIM_KEY_colon },
};

static __Uint16Pair __us_to_portuguese_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_ordfeminine },
  { SCIM_KEY_ampersand,           SCIM_KEY_slash },
  { SCIM_KEY_parenleft,           SCIM_KEY_parenright },
  { SCIM_KEY_parenright,          SCIM_KEY_equal },
  { SCIM_KEY_asterisk,            SCIM_KEY_parenleft },
  { SCIM_KEY_plus,                SCIM_KEY_guillemotright },
  { SCIM_KEY_colon,               SCIM_KEY_Ccedilla },
  { SCIM_KEY_less,                SCIM_KEY_semicolon },
  { SCIM_KEY_greater,             SCIM_KEY_colon },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_at,                  SCIM_KEY_quotedbl },
  { SCIM_KEY_asciicircum,         SCIM_KEY_ampersand },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_braceleft,           SCIM_KEY_asterisk },
  { SCIM_KEY_bar,                 SCIM_KEY_asciicircum },
  { SCIM_KEY_braceright,          SCIM_KEY_grave },
  { SCIM_KEY_asciitilde,          SCIM_KEY_bar },
};

static __Uint16Pair __portuguese_to_us_caps_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_at },
  { SCIM_KEY_ampersand,           SCIM_KEY_asciicircum },
  { SCIM_KEY_parenleft,           SCIM_KEY_asterisk },
  { SCIM_KEY_parenright,          SCIM_KEY_parenleft },
  { SCIM_KEY_asterisk,            SCIM_KEY_braceleft },
  { SCIM_KEY_slash,               SCIM_KEY_ampersand },
  { SCIM_KEY_colon,               SCIM_KEY_greater },
  { SCIM_KEY_semicolon,           SCIM_KEY_less },
  { SCIM_KEY_equal,               SCIM_KEY_parenright },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_asciicircum,         SCIM_KEY_bar },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_grave,               SCIM_KEY_braceright },
  { SCIM_KEY_bar,                 SCIM_KEY_asciitilde },
  { SCIM_KEY_ordfeminine,         SCIM_KEY_quotedbl },
  { SCIM_KEY_guillemotright,      SCIM_KEY_plus },
  { SCIM_KEY_ccedilla,            SCIM_KEY_colon },
};

static __Uint16Pair __us_to_portuguese_caps_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_ordfeminine },
  { SCIM_KEY_ampersand,           SCIM_KEY_slash },
  { SCIM_KEY_parenleft,           SCIM_KEY_parenright },
  { SCIM_KEY_parenright,          SCIM_KEY_equal },
  { SCIM_KEY_asterisk,            SCIM_KEY_parenleft },
  { SCIM_KEY_plus,                SCIM_KEY_guillemotright },
  { SCIM_KEY_colon,               SCIM_KEY_ccedilla },
  { SCIM_KEY_less,                SCIM_KEY_semicolon },
  { SCIM_KEY_greater,             SCIM_KEY_colon },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_at,                  SCIM_KEY_quotedbl },
  { SCIM_KEY_asciicircum,         SCIM_KEY_ampersand },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_braceleft,           SCIM_KEY_asterisk },
  { SCIM_KEY_bar,                 SCIM_KEY_asciicircum },
  { SCIM_KEY_braceright,          SCIM_KEY_grave },
  { SCIM_KEY_asciitilde,          SCIM_KEY_bar },
};

static __Uint16Pair __slovak_to_us_normal [] = {
  { SCIM_KEY_plus,                SCIM_KEY_1 },
  { SCIM_KEY_minus,               SCIM_KEY_slash },
  { SCIM_KEY_semicolon,           SCIM_KEY_grave },
  { SCIM_KEY_equal,               SCIM_KEY_minus },
  { SCIM_KEY_y,                   SCIM_KEY_z },
  { SCIM_KEY_z,                   SCIM_KEY_y },
  { SCIM_KEY_section,             SCIM_KEY_apostrophe },
  { SCIM_KEY_aacute,              SCIM_KEY_8 },
  { SCIM_KEY_adiaeresis,          SCIM_KEY_bracketright },
  { SCIM_KEY_eacute,              SCIM_KEY_0 },
  { SCIM_KEY_iacute,              SCIM_KEY_9 },
  { SCIM_KEY_ocircumflex,         SCIM_KEY_semicolon },
  { SCIM_KEY_uacute,              SCIM_KEY_bracketleft },
  { SCIM_KEY_yacute,              SCIM_KEY_7 },
  { SCIM_KEY_lcaron,              SCIM_KEY_2 },
  { SCIM_KEY_scaron,              SCIM_KEY_3 },
  { SCIM_KEY_tcaron,              SCIM_KEY_5 },
  { SCIM_KEY_zcaron,              SCIM_KEY_6 },
  { SCIM_KEY_ccaron,              SCIM_KEY_4 },
  { SCIM_KEY_ncaron,              SCIM_KEY_backslash },
  { SCIM_KEY_dead_acute,          SCIM_KEY_equal },
};

static __Uint16Pair __us_to_slovak_normal [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_section },
  { SCIM_KEY_minus,               SCIM_KEY_equal },
  { SCIM_KEY_slash,               SCIM_KEY_minus },
  { SCIM_KEY_0,                   SCIM_KEY_eacute },
  { SCIM_KEY_1,                   SCIM_KEY_plus },
  { SCIM_KEY_2,                   SCIM_KEY_lcaron },
  { SCIM_KEY_3,                   SCIM_KEY_scaron },
  { SCIM_KEY_4,                   SCIM_KEY_ccaron },
  { SCIM_KEY_5,                   SCIM_KEY_tcaron },
  { SCIM_KEY_6,                   SCIM_KEY_zcaron },
  { SCIM_KEY_7,                   SCIM_KEY_yacute },
  { SCIM_KEY_8,                   SCIM_KEY_aacute },
  { SCIM_KEY_9,                   SCIM_KEY_iacute },
  { SCIM_KEY_semicolon,           SCIM_KEY_ocircumflex },
  { SCIM_KEY_equal,               SCIM_KEY_dead_acute },
  { SCIM_KEY_bracketleft,         SCIM_KEY_uacute },
  { SCIM_KEY_backslash,           SCIM_KEY_ncaron },
  { SCIM_KEY_bracketright,        SCIM_KEY_adiaeresis },
  { SCIM_KEY_grave,               SCIM_KEY_semicolon },
  { SCIM_KEY_y,                   SCIM_KEY_z },
  { SCIM_KEY_z,                   SCIM_KEY_y },
};

static __Uint16Pair __slovak_to_us_caps [] = {
  { SCIM_KEY_plus,                SCIM_KEY_1 },
  { SCIM_KEY_minus,               SCIM_KEY_slash },
  { SCIM_KEY_semicolon,           SCIM_KEY_grave },
  { SCIM_KEY_equal,               SCIM_KEY_minus },
  { SCIM_KEY_Y,                   SCIM_KEY_Z },
  { SCIM_KEY_Z,                   SCIM_KEY_Y },
  { SCIM_KEY_section,             SCIM_KEY_apostrophe },
  { SCIM_KEY_Aacute,              SCIM_KEY_8 },
  { SCIM_KEY_Adiaeresis,          SCIM_KEY_bracketright },
  { SCIM_KEY_Eacute,              SCIM_KEY_0 },
  { SCIM_KEY_Iacute,              SCIM_KEY_9 },
  { SCIM_KEY_Ocircumflex,         SCIM_KEY_semicolon },
  { SCIM_KEY_Uacute,              SCIM_KEY_bracketleft },
  { SCIM_KEY_Yacute,              SCIM_KEY_7 },
  { SCIM_KEY_Lcaron,              SCIM_KEY_2 },
  { SCIM_KEY_Scaron,              SCIM_KEY_3 },
  { SCIM_KEY_Tcaron,              SCIM_KEY_5 },
  { SCIM_KEY_Zcaron,              SCIM_KEY_6 },
  { SCIM_KEY_Ccaron,              SCIM_KEY_4 },
  { SCIM_KEY_Ncaron,              SCIM_KEY_backslash },
  { SCIM_KEY_dead_acute,          SCIM_KEY_equal },
};

static __Uint16Pair __us_to_slovak_caps [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_section },
  { SCIM_KEY_minus,               SCIM_KEY_equal },
  { SCIM_KEY_slash,               SCIM_KEY_minus },
  { SCIM_KEY_0,                   SCIM_KEY_Eacute },
  { SCIM_KEY_1,                   SCIM_KEY_plus },
  { SCIM_KEY_2,                   SCIM_KEY_Lcaron },
  { SCIM_KEY_3,                   SCIM_KEY_Scaron },
  { SCIM_KEY_4,                   SCIM_KEY_Ccaron },
  { SCIM_KEY_5,                   SCIM_KEY_Tcaron },
  { SCIM_KEY_6,                   SCIM_KEY_Zcaron },
  { SCIM_KEY_7,                   SCIM_KEY_Yacute },
  { SCIM_KEY_8,                   SCIM_KEY_Aacute },
  { SCIM_KEY_9,                   SCIM_KEY_Iacute },
  { SCIM_KEY_semicolon,           SCIM_KEY_Ocircumflex },
  { SCIM_KEY_equal,               SCIM_KEY_dead_acute },
  { SCIM_KEY_Y,                   SCIM_KEY_Z },
  { SCIM_KEY_Z,                   SCIM_KEY_Y },
  { SCIM_KEY_bracketleft,         SCIM_KEY_Uacute },
  { SCIM_KEY_backslash,           SCIM_KEY_Ncaron },
  { SCIM_KEY_bracketright,        SCIM_KEY_Adiaeresis },
  { SCIM_KEY_grave,               SCIM_KEY_semicolon },
};

static __Uint16Pair __slovak_to_us_shift [] = {
  { SCIM_KEY_exclam,              SCIM_KEY_quotedbl },
  { SCIM_KEY_quotedbl,            SCIM_KEY_colon },
  { SCIM_KEY_percent,             SCIM_KEY_underscore },
  { SCIM_KEY_parenleft,           SCIM_KEY_braceright },
  { SCIM_KEY_parenright,          SCIM_KEY_bar },
  { SCIM_KEY_slash,               SCIM_KEY_braceleft },
  { SCIM_KEY_0,                   SCIM_KEY_parenright },
  { SCIM_KEY_1,                   SCIM_KEY_exclam },
  { SCIM_KEY_2,                   SCIM_KEY_at },
  { SCIM_KEY_3,                   SCIM_KEY_numbersign },
  { SCIM_KEY_4,                   SCIM_KEY_dollar },
  { SCIM_KEY_5,                   SCIM_KEY_percent },
  { SCIM_KEY_6,                   SCIM_KEY_asciicircum },
  { SCIM_KEY_7,                   SCIM_KEY_ampersand },
  { SCIM_KEY_8,                   SCIM_KEY_asterisk },
  { SCIM_KEY_9,                   SCIM_KEY_parenleft },
  { SCIM_KEY_colon,               SCIM_KEY_greater },
  { SCIM_KEY_question,            SCIM_KEY_less },
  { SCIM_KEY_Y,                   SCIM_KEY_Z },
  { SCIM_KEY_Z,                   SCIM_KEY_Y },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_dead_abovering,      SCIM_KEY_asciitilde },
  { SCIM_KEY_dead_caron,          SCIM_KEY_plus },
};

static __Uint16Pair __us_to_slovak_shift [] = {
  { SCIM_KEY_exclam,              SCIM_KEY_1 },
  { SCIM_KEY_quotedbl,            SCIM_KEY_exclam },
  { SCIM_KEY_numbersign,          SCIM_KEY_3 },
  { SCIM_KEY_dollar,              SCIM_KEY_4 },
  { SCIM_KEY_percent,             SCIM_KEY_5 },
  { SCIM_KEY_ampersand,           SCIM_KEY_7 },
  { SCIM_KEY_parenleft,           SCIM_KEY_9 },
  { SCIM_KEY_parenright,          SCIM_KEY_0 },
  { SCIM_KEY_asterisk,            SCIM_KEY_8 },
  { SCIM_KEY_plus,                SCIM_KEY_dead_caron },
  { SCIM_KEY_colon,               SCIM_KEY_quotedbl },
  { SCIM_KEY_less,                SCIM_KEY_question },
  { SCIM_KEY_greater,             SCIM_KEY_colon },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_at,                  SCIM_KEY_2 },
  { SCIM_KEY_Y,                   SCIM_KEY_Z },
  { SCIM_KEY_Z,                   SCIM_KEY_Y },
  { SCIM_KEY_asciicircum,         SCIM_KEY_6 },
  { SCIM_KEY_underscore,          SCIM_KEY_percent },
  { SCIM_KEY_braceleft,           SCIM_KEY_slash },
  { SCIM_KEY_bar,                 SCIM_KEY_parenright },
  { SCIM_KEY_braceright,          SCIM_KEY_parenleft },
  { SCIM_KEY_asciitilde,          SCIM_KEY_dead_abovering },
};

static __Uint16Pair __slovak_to_us_caps_shift [] = {
  { SCIM_KEY_exclam,              SCIM_KEY_quotedbl },
  { SCIM_KEY_quotedbl,            SCIM_KEY_colon },
  { SCIM_KEY_percent,             SCIM_KEY_underscore },
  { SCIM_KEY_parenleft,           SCIM_KEY_braceright },
  { SCIM_KEY_parenright,          SCIM_KEY_bar },
  { SCIM_KEY_slash,               SCIM_KEY_braceleft },
  { SCIM_KEY_0,                   SCIM_KEY_parenright },
  { SCIM_KEY_1,                   SCIM_KEY_exclam },
  { SCIM_KEY_2,                   SCIM_KEY_at },
  { SCIM_KEY_3,                   SCIM_KEY_numbersign },
  { SCIM_KEY_4,                   SCIM_KEY_dollar },
  { SCIM_KEY_5,                   SCIM_KEY_percent },
  { SCIM_KEY_6,                   SCIM_KEY_asciicircum },
  { SCIM_KEY_7,                   SCIM_KEY_ampersand },
  { SCIM_KEY_8,                   SCIM_KEY_asterisk },
  { SCIM_KEY_9,                   SCIM_KEY_parenleft },
  { SCIM_KEY_colon,               SCIM_KEY_greater },
  { SCIM_KEY_question,            SCIM_KEY_less },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_y,                   SCIM_KEY_z },
  { SCIM_KEY_z,                   SCIM_KEY_y },
  { SCIM_KEY_dead_abovering,      SCIM_KEY_asciitilde },
  { SCIM_KEY_dead_caron,          SCIM_KEY_plus },
};

static __Uint16Pair __us_to_slovak_caps_shift [] = {
  { SCIM_KEY_exclam,              SCIM_KEY_1 },
  { SCIM_KEY_quotedbl,            SCIM_KEY_exclam },
  { SCIM_KEY_numbersign,          SCIM_KEY_3 },
  { SCIM_KEY_dollar,              SCIM_KEY_4 },
  { SCIM_KEY_percent,             SCIM_KEY_5 },
  { SCIM_KEY_ampersand,           SCIM_KEY_7 },
  { SCIM_KEY_parenleft,           SCIM_KEY_9 },
  { SCIM_KEY_parenright,          SCIM_KEY_0 },
  { SCIM_KEY_asterisk,            SCIM_KEY_8 },
  { SCIM_KEY_plus,                SCIM_KEY_dead_caron },
  { SCIM_KEY_colon,               SCIM_KEY_quotedbl },
  { SCIM_KEY_less,                SCIM_KEY_question },
  { SCIM_KEY_greater,             SCIM_KEY_colon },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_at,                  SCIM_KEY_2 },
  { SCIM_KEY_asciicircum,         SCIM_KEY_6 },
  { SCIM_KEY_underscore,          SCIM_KEY_percent },
  { SCIM_KEY_y,                   SCIM_KEY_z },
  { SCIM_KEY_z,                   SCIM_KEY_y },
  { SCIM_KEY_braceleft,           SCIM_KEY_slash },
  { SCIM_KEY_bar,                 SCIM_KEY_parenright },
  { SCIM_KEY_braceright,          SCIM_KEY_parenleft },
  { SCIM_KEY_asciitilde,          SCIM_KEY_dead_abovering },
};

static __Uint16Pair __slovak_qwerty_to_us_normal [] = {
  { SCIM_KEY_plus,                SCIM_KEY_1 },
  { SCIM_KEY_minus,               SCIM_KEY_slash },
  { SCIM_KEY_semicolon,           SCIM_KEY_grave },
  { SCIM_KEY_equal,               SCIM_KEY_minus },
  { SCIM_KEY_section,             SCIM_KEY_apostrophe },
  { SCIM_KEY_aacute,              SCIM_KEY_8 },
  { SCIM_KEY_adiaeresis,          SCIM_KEY_bracketright },
  { SCIM_KEY_eacute,              SCIM_KEY_0 },
  { SCIM_KEY_iacute,              SCIM_KEY_9 },
  { SCIM_KEY_ocircumflex,         SCIM_KEY_semicolon },
  { SCIM_KEY_uacute,              SCIM_KEY_bracketleft },
  { SCIM_KEY_yacute,              SCIM_KEY_7 },
  { SCIM_KEY_lcaron,              SCIM_KEY_2 },
  { SCIM_KEY_scaron,              SCIM_KEY_3 },
  { SCIM_KEY_tcaron,              SCIM_KEY_5 },
  { SCIM_KEY_zcaron,              SCIM_KEY_6 },
  { SCIM_KEY_ccaron,              SCIM_KEY_4 },
  { SCIM_KEY_ncaron,              SCIM_KEY_backslash },
  { SCIM_KEY_dead_acute,          SCIM_KEY_equal },
};

static __Uint16Pair __us_to_slovak_qwerty_normal [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_section },
  { SCIM_KEY_minus,               SCIM_KEY_equal },
  { SCIM_KEY_slash,               SCIM_KEY_minus },
  { SCIM_KEY_0,                   SCIM_KEY_eacute },
  { SCIM_KEY_1,                   SCIM_KEY_plus },
  { SCIM_KEY_2,                   SCIM_KEY_lcaron },
  { SCIM_KEY_3,                   SCIM_KEY_scaron },
  { SCIM_KEY_4,                   SCIM_KEY_ccaron },
  { SCIM_KEY_5,                   SCIM_KEY_tcaron },
  { SCIM_KEY_6,                   SCIM_KEY_zcaron },
  { SCIM_KEY_7,                   SCIM_KEY_yacute },
  { SCIM_KEY_8,                   SCIM_KEY_aacute },
  { SCIM_KEY_9,                   SCIM_KEY_iacute },
  { SCIM_KEY_semicolon,           SCIM_KEY_ocircumflex },
  { SCIM_KEY_equal,               SCIM_KEY_dead_acute },
  { SCIM_KEY_bracketleft,         SCIM_KEY_uacute },
  { SCIM_KEY_backslash,           SCIM_KEY_ncaron },
  { SCIM_KEY_bracketright,        SCIM_KEY_adiaeresis },
  { SCIM_KEY_grave,               SCIM_KEY_semicolon },
};

static __Uint16Pair __slovak_qwerty_to_us_caps [] = {
  { SCIM_KEY_plus,                SCIM_KEY_1 },
  { SCIM_KEY_minus,               SCIM_KEY_slash },
  { SCIM_KEY_semicolon,           SCIM_KEY_grave },
  { SCIM_KEY_equal,               SCIM_KEY_minus },
  { SCIM_KEY_section,             SCIM_KEY_apostrophe },
  { SCIM_KEY_Aacute,              SCIM_KEY_8 },
  { SCIM_KEY_Adiaeresis,          SCIM_KEY_bracketright },
  { SCIM_KEY_Eacute,              SCIM_KEY_0 },
  { SCIM_KEY_Iacute,              SCIM_KEY_9 },
  { SCIM_KEY_Ocircumflex,         SCIM_KEY_semicolon },
  { SCIM_KEY_Uacute,              SCIM_KEY_bracketleft },
  { SCIM_KEY_Yacute,              SCIM_KEY_7 },
  { SCIM_KEY_Lcaron,              SCIM_KEY_2 },
  { SCIM_KEY_Scaron,              SCIM_KEY_3 },
  { SCIM_KEY_Tcaron,              SCIM_KEY_5 },
  { SCIM_KEY_Zcaron,              SCIM_KEY_6 },
  { SCIM_KEY_Ccaron,              SCIM_KEY_4 },
  { SCIM_KEY_Ncaron,              SCIM_KEY_backslash },
  { SCIM_KEY_dead_acute,          SCIM_KEY_equal },
};

static __Uint16Pair __us_to_slovak_qwerty_caps [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_section },
  { SCIM_KEY_minus,               SCIM_KEY_equal },
  { SCIM_KEY_slash,               SCIM_KEY_minus },
  { SCIM_KEY_0,                   SCIM_KEY_Eacute },
  { SCIM_KEY_1,                   SCIM_KEY_plus },
  { SCIM_KEY_2,                   SCIM_KEY_Lcaron },
  { SCIM_KEY_3,                   SCIM_KEY_Scaron },
  { SCIM_KEY_4,                   SCIM_KEY_Ccaron },
  { SCIM_KEY_5,                   SCIM_KEY_Tcaron },
  { SCIM_KEY_6,                   SCIM_KEY_Zcaron },
  { SCIM_KEY_7,                   SCIM_KEY_Yacute },
  { SCIM_KEY_8,                   SCIM_KEY_Aacute },
  { SCIM_KEY_9,                   SCIM_KEY_Iacute },
  { SCIM_KEY_semicolon,           SCIM_KEY_Ocircumflex },
  { SCIM_KEY_equal,               SCIM_KEY_dead_acute },
  { SCIM_KEY_bracketleft,         SCIM_KEY_Uacute },
  { SCIM_KEY_backslash,           SCIM_KEY_Ncaron },
  { SCIM_KEY_bracketright,        SCIM_KEY_Adiaeresis },
  { SCIM_KEY_grave,               SCIM_KEY_semicolon },
};

static __Uint16Pair __slovak_qwerty_to_us_shift [] = {
  { SCIM_KEY_exclam,              SCIM_KEY_quotedbl },
  { SCIM_KEY_quotedbl,            SCIM_KEY_colon },
  { SCIM_KEY_percent,             SCIM_KEY_underscore },
  { SCIM_KEY_parenleft,           SCIM_KEY_braceright },
  { SCIM_KEY_parenright,          SCIM_KEY_bar },
  { SCIM_KEY_slash,               SCIM_KEY_braceleft },
  { SCIM_KEY_0,                   SCIM_KEY_parenright },
  { SCIM_KEY_1,                   SCIM_KEY_exclam },
  { SCIM_KEY_2,                   SCIM_KEY_at },
  { SCIM_KEY_3,                   SCIM_KEY_numbersign },
  { SCIM_KEY_4,                   SCIM_KEY_dollar },
  { SCIM_KEY_5,                   SCIM_KEY_percent },
  { SCIM_KEY_6,                   SCIM_KEY_asciicircum },
  { SCIM_KEY_7,                   SCIM_KEY_ampersand },
  { SCIM_KEY_8,                   SCIM_KEY_asterisk },
  { SCIM_KEY_9,                   SCIM_KEY_parenleft },
  { SCIM_KEY_colon,               SCIM_KEY_greater },
  { SCIM_KEY_question,            SCIM_KEY_less },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_dead_abovering,      SCIM_KEY_asciitilde },
  { SCIM_KEY_dead_caron,          SCIM_KEY_plus },
};

static __Uint16Pair __us_to_slovak_qwerty_shift [] = {
  { SCIM_KEY_exclam,              SCIM_KEY_1 },
  { SCIM_KEY_quotedbl,            SCIM_KEY_exclam },
  { SCIM_KEY_numbersign,          SCIM_KEY_3 },
  { SCIM_KEY_dollar,              SCIM_KEY_4 },
  { SCIM_KEY_percent,             SCIM_KEY_5 },
  { SCIM_KEY_ampersand,           SCIM_KEY_7 },
  { SCIM_KEY_parenleft,           SCIM_KEY_9 },
  { SCIM_KEY_parenright,          SCIM_KEY_0 },
  { SCIM_KEY_asterisk,            SCIM_KEY_8 },
  { SCIM_KEY_plus,                SCIM_KEY_dead_caron },
  { SCIM_KEY_colon,               SCIM_KEY_quotedbl },
  { SCIM_KEY_less,                SCIM_KEY_question },
  { SCIM_KEY_greater,             SCIM_KEY_colon },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_at,                  SCIM_KEY_2 },
  { SCIM_KEY_asciicircum,         SCIM_KEY_6 },
  { SCIM_KEY_underscore,          SCIM_KEY_percent },
  { SCIM_KEY_braceleft,           SCIM_KEY_slash },
  { SCIM_KEY_bar,                 SCIM_KEY_parenright },
  { SCIM_KEY_braceright,          SCIM_KEY_parenleft },
  { SCIM_KEY_asciitilde,          SCIM_KEY_dead_abovering },
};

static __Uint16Pair __slovak_qwerty_to_us_caps_shift [] = {
  { SCIM_KEY_exclam,              SCIM_KEY_quotedbl },
  { SCIM_KEY_quotedbl,            SCIM_KEY_colon },
  { SCIM_KEY_percent,             SCIM_KEY_underscore },
  { SCIM_KEY_parenleft,           SCIM_KEY_braceright },
  { SCIM_KEY_parenright,          SCIM_KEY_bar },
  { SCIM_KEY_slash,               SCIM_KEY_braceleft },
  { SCIM_KEY_0,                   SCIM_KEY_parenright },
  { SCIM_KEY_1,                   SCIM_KEY_exclam },
  { SCIM_KEY_2,                   SCIM_KEY_at },
  { SCIM_KEY_3,                   SCIM_KEY_numbersign },
  { SCIM_KEY_4,                   SCIM_KEY_dollar },
  { SCIM_KEY_5,                   SCIM_KEY_percent },
  { SCIM_KEY_6,                   SCIM_KEY_asciicircum },
  { SCIM_KEY_7,                   SCIM_KEY_ampersand },
  { SCIM_KEY_8,                   SCIM_KEY_asterisk },
  { SCIM_KEY_9,                   SCIM_KEY_parenleft },
  { SCIM_KEY_colon,               SCIM_KEY_greater },
  { SCIM_KEY_question,            SCIM_KEY_less },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_dead_abovering,      SCIM_KEY_asciitilde },
  { SCIM_KEY_dead_caron,          SCIM_KEY_plus },
};

static __Uint16Pair __us_to_slovak_qwerty_caps_shift [] = {
  { SCIM_KEY_exclam,              SCIM_KEY_1 },
  { SCIM_KEY_quotedbl,            SCIM_KEY_exclam },
  { SCIM_KEY_numbersign,          SCIM_KEY_3 },
  { SCIM_KEY_dollar,              SCIM_KEY_4 },
  { SCIM_KEY_percent,             SCIM_KEY_5 },
  { SCIM_KEY_ampersand,           SCIM_KEY_7 },
  { SCIM_KEY_parenleft,           SCIM_KEY_9 },
  { SCIM_KEY_parenright,          SCIM_KEY_0 },
  { SCIM_KEY_asterisk,            SCIM_KEY_8 },
  { SCIM_KEY_plus,                SCIM_KEY_dead_caron },
  { SCIM_KEY_colon,               SCIM_KEY_quotedbl },
  { SCIM_KEY_less,                SCIM_KEY_question },
  { SCIM_KEY_greater,             SCIM_KEY_colon },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_at,                  SCIM_KEY_2 },
  { SCIM_KEY_asciicircum,         SCIM_KEY_6 },
  { SCIM_KEY_underscore,          SCIM_KEY_percent },
  { SCIM_KEY_braceleft,           SCIM_KEY_slash },
  { SCIM_KEY_bar,                 SCIM_KEY_parenright },
  { SCIM_KEY_braceright,          SCIM_KEY_parenleft },
  { SCIM_KEY_asciitilde,          SCIM_KEY_dead_abovering },
};

static __Uint16Pair __spanish_cp850_to_us_normal [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_minus },
  { SCIM_KEY_plus,                SCIM_KEY_bracketright },
  { SCIM_KEY_minus,               SCIM_KEY_slash },
  { SCIM_KEY_exclamdown,          SCIM_KEY_equal },
  { SCIM_KEY_masculine,           SCIM_KEY_grave },
  { SCIM_KEY_ccedilla,            SCIM_KEY_backslash },
  { SCIM_KEY_ntilde,              SCIM_KEY_semicolon },
  { SCIM_KEY_dead_grave,          SCIM_KEY_bracketleft },
  { SCIM_KEY_dead_acute,          SCIM_KEY_apostrophe },
};

static __Uint16Pair __us_to_spanish_cp850_normal [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_dead_acute },
  { SCIM_KEY_minus,               SCIM_KEY_apostrophe },
  { SCIM_KEY_slash,               SCIM_KEY_minus },
  { SCIM_KEY_semicolon,           SCIM_KEY_ntilde },
  { SCIM_KEY_equal,               SCIM_KEY_exclamdown },
  { SCIM_KEY_bracketleft,         SCIM_KEY_dead_grave },
  { SCIM_KEY_backslash,           SCIM_KEY_ccedilla },
  { SCIM_KEY_bracketright,        SCIM_KEY_plus },
  { SCIM_KEY_grave,               SCIM_KEY_masculine },
};

static __Uint16Pair __spanish_cp850_to_us_caps [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_minus },
  { SCIM_KEY_plus,                SCIM_KEY_bracketright },
  { SCIM_KEY_minus,               SCIM_KEY_slash },
  { SCIM_KEY_exclamdown,          SCIM_KEY_equal },
  { SCIM_KEY_masculine,           SCIM_KEY_grave },
  { SCIM_KEY_Ccedilla,            SCIM_KEY_backslash },
  { SCIM_KEY_Ntilde,              SCIM_KEY_semicolon },
  { SCIM_KEY_dead_grave,          SCIM_KEY_bracketleft },
  { SCIM_KEY_dead_acute,          SCIM_KEY_apostrophe },
};

static __Uint16Pair __us_to_spanish_cp850_caps [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_dead_acute },
  { SCIM_KEY_minus,               SCIM_KEY_apostrophe },
  { SCIM_KEY_slash,               SCIM_KEY_minus },
  { SCIM_KEY_semicolon,           SCIM_KEY_Ntilde },
  { SCIM_KEY_equal,               SCIM_KEY_exclamdown },
  { SCIM_KEY_bracketleft,         SCIM_KEY_dead_grave },
  { SCIM_KEY_backslash,           SCIM_KEY_Ccedilla },
  { SCIM_KEY_bracketright,        SCIM_KEY_plus },
  { SCIM_KEY_grave,               SCIM_KEY_masculine },
};

static __Uint16Pair __spanish_cp850_to_us_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_at },
  { SCIM_KEY_ampersand,           SCIM_KEY_asciicircum },
  { SCIM_KEY_parenleft,           SCIM_KEY_asterisk },
  { SCIM_KEY_parenright,          SCIM_KEY_parenleft },
  { SCIM_KEY_asterisk,            SCIM_KEY_braceright },
  { SCIM_KEY_slash,               SCIM_KEY_ampersand },
  { SCIM_KEY_colon,               SCIM_KEY_greater },
  { SCIM_KEY_semicolon,           SCIM_KEY_less },
  { SCIM_KEY_equal,               SCIM_KEY_parenright },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_ordfeminine,         SCIM_KEY_asciitilde },
  { SCIM_KEY_periodcentered,      SCIM_KEY_numbersign },
  { SCIM_KEY_questiondown,        SCIM_KEY_plus },
  { SCIM_KEY_Ccedilla,            SCIM_KEY_bar },
  { SCIM_KEY_Ntilde,              SCIM_KEY_colon },
  { SCIM_KEY_dead_circumflex,     SCIM_KEY_braceleft },
  { SCIM_KEY_dead_diaeresis,      SCIM_KEY_quotedbl },
};

static __Uint16Pair __us_to_spanish_cp850_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_dead_diaeresis },
  { SCIM_KEY_numbersign,          SCIM_KEY_periodcentered },
  { SCIM_KEY_ampersand,           SCIM_KEY_slash },
  { SCIM_KEY_parenleft,           SCIM_KEY_parenright },
  { SCIM_KEY_parenright,          SCIM_KEY_equal },
  { SCIM_KEY_asterisk,            SCIM_KEY_parenleft },
  { SCIM_KEY_plus,                SCIM_KEY_questiondown },
  { SCIM_KEY_colon,               SCIM_KEY_Ntilde },
  { SCIM_KEY_less,                SCIM_KEY_semicolon },
  { SCIM_KEY_greater,             SCIM_KEY_colon },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_at,                  SCIM_KEY_quotedbl },
  { SCIM_KEY_asciicircum,         SCIM_KEY_ampersand },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_braceleft,           SCIM_KEY_dead_circumflex },
  { SCIM_KEY_bar,                 SCIM_KEY_Ccedilla },
  { SCIM_KEY_braceright,          SCIM_KEY_asterisk },
  { SCIM_KEY_asciitilde,          SCIM_KEY_ordfeminine },
};

static __Uint16Pair __spanish_cp850_to_us_caps_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_at },
  { SCIM_KEY_ampersand,           SCIM_KEY_asciicircum },
  { SCIM_KEY_parenleft,           SCIM_KEY_asterisk },
  { SCIM_KEY_parenright,          SCIM_KEY_parenleft },
  { SCIM_KEY_asterisk,            SCIM_KEY_braceright },
  { SCIM_KEY_slash,               SCIM_KEY_ampersand },
  { SCIM_KEY_colon,               SCIM_KEY_greater },
  { SCIM_KEY_semicolon,           SCIM_KEY_less },
  { SCIM_KEY_equal,               SCIM_KEY_parenright },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_ordfeminine,         SCIM_KEY_asciitilde },
  { SCIM_KEY_periodcentered,      SCIM_KEY_numbersign },
  { SCIM_KEY_questiondown,        SCIM_KEY_plus },
  { SCIM_KEY_ccedilla,            SCIM_KEY_bar },
  { SCIM_KEY_ntilde,              SCIM_KEY_colon },
  { SCIM_KEY_dead_circumflex,     SCIM_KEY_braceleft },
  { SCIM_KEY_dead_diaeresis,      SCIM_KEY_quotedbl },
};

static __Uint16Pair __us_to_spanish_cp850_caps_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_dead_diaeresis },
  { SCIM_KEY_numbersign,          SCIM_KEY_periodcentered },
  { SCIM_KEY_ampersand,           SCIM_KEY_slash },
  { SCIM_KEY_parenleft,           SCIM_KEY_parenright },
  { SCIM_KEY_parenright,          SCIM_KEY_equal },
  { SCIM_KEY_asterisk,            SCIM_KEY_parenleft },
  { SCIM_KEY_plus,                SCIM_KEY_questiondown },
  { SCIM_KEY_colon,               SCIM_KEY_ntilde },
  { SCIM_KEY_less,                SCIM_KEY_semicolon },
  { SCIM_KEY_greater,             SCIM_KEY_colon },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_at,                  SCIM_KEY_quotedbl },
  { SCIM_KEY_asciicircum,         SCIM_KEY_ampersand },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_braceleft,           SCIM_KEY_dead_circumflex },
  { SCIM_KEY_bar,                 SCIM_KEY_ccedilla },
  { SCIM_KEY_braceright,          SCIM_KEY_asterisk },
  { SCIM_KEY_asciitilde,          SCIM_KEY_ordfeminine },
};

static __Uint16Pair __spanish_to_us_normal [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_minus },
  { SCIM_KEY_plus,                SCIM_KEY_bracketright },
  { SCIM_KEY_minus,               SCIM_KEY_slash },
  { SCIM_KEY_exclamdown,          SCIM_KEY_equal },
  { SCIM_KEY_masculine,           SCIM_KEY_grave },
  { SCIM_KEY_ccedilla,            SCIM_KEY_backslash },
  { SCIM_KEY_ntilde,              SCIM_KEY_semicolon },
  { SCIM_KEY_dead_grave,          SCIM_KEY_bracketleft },
  { SCIM_KEY_dead_acute,          SCIM_KEY_apostrophe },
};

static __Uint16Pair __us_to_spanish_normal [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_dead_acute },
  { SCIM_KEY_minus,               SCIM_KEY_apostrophe },
  { SCIM_KEY_slash,               SCIM_KEY_minus },
  { SCIM_KEY_semicolon,           SCIM_KEY_ntilde },
  { SCIM_KEY_equal,               SCIM_KEY_exclamdown },
  { SCIM_KEY_bracketleft,         SCIM_KEY_dead_grave },
  { SCIM_KEY_backslash,           SCIM_KEY_ccedilla },
  { SCIM_KEY_bracketright,        SCIM_KEY_plus },
  { SCIM_KEY_grave,               SCIM_KEY_masculine },
};

static __Uint16Pair __spanish_to_us_caps [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_minus },
  { SCIM_KEY_plus,                SCIM_KEY_bracketright },
  { SCIM_KEY_minus,               SCIM_KEY_slash },
  { SCIM_KEY_exclamdown,          SCIM_KEY_equal },
  { SCIM_KEY_masculine,           SCIM_KEY_grave },
  { SCIM_KEY_Ccedilla,            SCIM_KEY_backslash },
  { SCIM_KEY_Ntilde,              SCIM_KEY_semicolon },
  { SCIM_KEY_dead_grave,          SCIM_KEY_bracketleft },
  { SCIM_KEY_dead_acute,          SCIM_KEY_apostrophe },
};

static __Uint16Pair __us_to_spanish_caps [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_dead_acute },
  { SCIM_KEY_minus,               SCIM_KEY_apostrophe },
  { SCIM_KEY_slash,               SCIM_KEY_minus },
  { SCIM_KEY_semicolon,           SCIM_KEY_Ntilde },
  { SCIM_KEY_equal,               SCIM_KEY_exclamdown },
  { SCIM_KEY_bracketleft,         SCIM_KEY_dead_grave },
  { SCIM_KEY_backslash,           SCIM_KEY_Ccedilla },
  { SCIM_KEY_bracketright,        SCIM_KEY_plus },
  { SCIM_KEY_grave,               SCIM_KEY_masculine },
};

static __Uint16Pair __spanish_to_us_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_at },
  { SCIM_KEY_ampersand,           SCIM_KEY_asciicircum },
  { SCIM_KEY_parenleft,           SCIM_KEY_asterisk },
  { SCIM_KEY_parenright,          SCIM_KEY_parenleft },
  { SCIM_KEY_asterisk,            SCIM_KEY_braceright },
  { SCIM_KEY_slash,               SCIM_KEY_ampersand },
  { SCIM_KEY_colon,               SCIM_KEY_greater },
  { SCIM_KEY_semicolon,           SCIM_KEY_less },
  { SCIM_KEY_equal,               SCIM_KEY_parenright },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_ordfeminine,         SCIM_KEY_asciitilde },
  { SCIM_KEY_periodcentered,      SCIM_KEY_numbersign },
  { SCIM_KEY_questiondown,        SCIM_KEY_plus },
  { SCIM_KEY_Ccedilla,            SCIM_KEY_bar },
  { SCIM_KEY_Ntilde,              SCIM_KEY_colon },
  { SCIM_KEY_dead_circumflex,     SCIM_KEY_braceleft },
  { SCIM_KEY_dead_diaeresis,      SCIM_KEY_quotedbl },
};

static __Uint16Pair __us_to_spanish_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_dead_diaeresis },
  { SCIM_KEY_numbersign,          SCIM_KEY_periodcentered },
  { SCIM_KEY_ampersand,           SCIM_KEY_slash },
  { SCIM_KEY_parenleft,           SCIM_KEY_parenright },
  { SCIM_KEY_parenright,          SCIM_KEY_equal },
  { SCIM_KEY_asterisk,            SCIM_KEY_parenleft },
  { SCIM_KEY_plus,                SCIM_KEY_questiondown },
  { SCIM_KEY_colon,               SCIM_KEY_Ntilde },
  { SCIM_KEY_less,                SCIM_KEY_semicolon },
  { SCIM_KEY_greater,             SCIM_KEY_colon },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_at,                  SCIM_KEY_quotedbl },
  { SCIM_KEY_asciicircum,         SCIM_KEY_ampersand },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_braceleft,           SCIM_KEY_dead_circumflex },
  { SCIM_KEY_bar,                 SCIM_KEY_Ccedilla },
  { SCIM_KEY_braceright,          SCIM_KEY_asterisk },
  { SCIM_KEY_asciitilde,          SCIM_KEY_ordfeminine },
};

static __Uint16Pair __spanish_to_us_caps_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_at },
  { SCIM_KEY_ampersand,           SCIM_KEY_asciicircum },
  { SCIM_KEY_parenleft,           SCIM_KEY_asterisk },
  { SCIM_KEY_parenright,          SCIM_KEY_parenleft },
  { SCIM_KEY_asterisk,            SCIM_KEY_braceright },
  { SCIM_KEY_slash,               SCIM_KEY_ampersand },
  { SCIM_KEY_colon,               SCIM_KEY_greater },
  { SCIM_KEY_semicolon,           SCIM_KEY_less },
  { SCIM_KEY_equal,               SCIM_KEY_parenright },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_ordfeminine,         SCIM_KEY_asciitilde },
  { SCIM_KEY_periodcentered,      SCIM_KEY_numbersign },
  { SCIM_KEY_questiondown,        SCIM_KEY_plus },
  { SCIM_KEY_ccedilla,            SCIM_KEY_bar },
  { SCIM_KEY_ntilde,              SCIM_KEY_colon },
  { SCIM_KEY_dead_circumflex,     SCIM_KEY_braceleft },
  { SCIM_KEY_dead_diaeresis,      SCIM_KEY_quotedbl },
};

static __Uint16Pair __us_to_spanish_caps_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_dead_diaeresis },
  { SCIM_KEY_numbersign,          SCIM_KEY_periodcentered },
  { SCIM_KEY_ampersand,           SCIM_KEY_slash },
  { SCIM_KEY_parenleft,           SCIM_KEY_parenright },
  { SCIM_KEY_parenright,          SCIM_KEY_equal },
  { SCIM_KEY_asterisk,            SCIM_KEY_parenleft },
  { SCIM_KEY_plus,                SCIM_KEY_questiondown },
  { SCIM_KEY_colon,               SCIM_KEY_ntilde },
  { SCIM_KEY_less,                SCIM_KEY_semicolon },
  { SCIM_KEY_greater,             SCIM_KEY_colon },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_at,                  SCIM_KEY_quotedbl },
  { SCIM_KEY_asciicircum,         SCIM_KEY_ampersand },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_braceleft,           SCIM_KEY_dead_circumflex },
  { SCIM_KEY_bar,                 SCIM_KEY_ccedilla },
  { SCIM_KEY_braceright,          SCIM_KEY_asterisk },
  { SCIM_KEY_asciitilde,          SCIM_KEY_ordfeminine },
};

static __Uint16Pair __spanish_latin_america_to_us_normal [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_minus },
  { SCIM_KEY_plus,                SCIM_KEY_bracketright },
  { SCIM_KEY_minus,               SCIM_KEY_slash },
  { SCIM_KEY_exclamdown,          SCIM_KEY_equal },
  { SCIM_KEY_masculine,           SCIM_KEY_grave },
  { SCIM_KEY_ccedilla,            SCIM_KEY_backslash },
  { SCIM_KEY_ntilde,              SCIM_KEY_semicolon },
  { SCIM_KEY_dead_grave,          SCIM_KEY_bracketleft },
  { SCIM_KEY_dead_acute,          SCIM_KEY_apostrophe },
};

static __Uint16Pair __us_to_spanish_latin_america_normal [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_dead_acute },
  { SCIM_KEY_minus,               SCIM_KEY_apostrophe },
  { SCIM_KEY_slash,               SCIM_KEY_minus },
  { SCIM_KEY_semicolon,           SCIM_KEY_ntilde },
  { SCIM_KEY_equal,               SCIM_KEY_exclamdown },
  { SCIM_KEY_bracketleft,         SCIM_KEY_dead_grave },
  { SCIM_KEY_backslash,           SCIM_KEY_ccedilla },
  { SCIM_KEY_bracketright,        SCIM_KEY_plus },
  { SCIM_KEY_grave,               SCIM_KEY_masculine },
};

static __Uint16Pair __spanish_latin_america_to_us_caps [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_minus },
  { SCIM_KEY_plus,                SCIM_KEY_bracketright },
  { SCIM_KEY_minus,               SCIM_KEY_slash },
  { SCIM_KEY_exclamdown,          SCIM_KEY_equal },
  { SCIM_KEY_masculine,           SCIM_KEY_grave },
  { SCIM_KEY_Ccedilla,            SCIM_KEY_backslash },
  { SCIM_KEY_Ntilde,              SCIM_KEY_semicolon },
  { SCIM_KEY_dead_grave,          SCIM_KEY_bracketleft },
  { SCIM_KEY_dead_acute,          SCIM_KEY_apostrophe },
};

static __Uint16Pair __us_to_spanish_latin_america_caps [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_dead_acute },
  { SCIM_KEY_minus,               SCIM_KEY_apostrophe },
  { SCIM_KEY_slash,               SCIM_KEY_minus },
  { SCIM_KEY_semicolon,           SCIM_KEY_Ntilde },
  { SCIM_KEY_equal,               SCIM_KEY_exclamdown },
  { SCIM_KEY_bracketleft,         SCIM_KEY_dead_grave },
  { SCIM_KEY_backslash,           SCIM_KEY_Ccedilla },
  { SCIM_KEY_bracketright,        SCIM_KEY_plus },
  { SCIM_KEY_grave,               SCIM_KEY_masculine },
};

static __Uint16Pair __spanish_latin_america_to_us_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_at },
  { SCIM_KEY_ampersand,           SCIM_KEY_asciicircum },
  { SCIM_KEY_parenleft,           SCIM_KEY_asterisk },
  { SCIM_KEY_parenright,          SCIM_KEY_parenleft },
  { SCIM_KEY_asterisk,            SCIM_KEY_braceright },
  { SCIM_KEY_slash,               SCIM_KEY_ampersand },
  { SCIM_KEY_colon,               SCIM_KEY_greater },
  { SCIM_KEY_semicolon,           SCIM_KEY_less },
  { SCIM_KEY_equal,               SCIM_KEY_parenright },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_ordfeminine,         SCIM_KEY_asciitilde },
  { SCIM_KEY_periodcentered,      SCIM_KEY_numbersign },
  { SCIM_KEY_questiondown,        SCIM_KEY_plus },
  { SCIM_KEY_Ccedilla,            SCIM_KEY_bar },
  { SCIM_KEY_Ntilde,              SCIM_KEY_colon },
  { SCIM_KEY_dead_circumflex,     SCIM_KEY_braceleft },
  { SCIM_KEY_dead_diaeresis,      SCIM_KEY_quotedbl },
};

static __Uint16Pair __us_to_spanish_latin_america_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_dead_diaeresis },
  { SCIM_KEY_numbersign,          SCIM_KEY_periodcentered },
  { SCIM_KEY_ampersand,           SCIM_KEY_slash },
  { SCIM_KEY_parenleft,           SCIM_KEY_parenright },
  { SCIM_KEY_parenright,          SCIM_KEY_equal },
  { SCIM_KEY_asterisk,            SCIM_KEY_parenleft },
  { SCIM_KEY_plus,                SCIM_KEY_questiondown },
  { SCIM_KEY_colon,               SCIM_KEY_Ntilde },
  { SCIM_KEY_less,                SCIM_KEY_semicolon },
  { SCIM_KEY_greater,             SCIM_KEY_colon },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_at,                  SCIM_KEY_quotedbl },
  { SCIM_KEY_asciicircum,         SCIM_KEY_ampersand },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_braceleft,           SCIM_KEY_dead_circumflex },
  { SCIM_KEY_bar,                 SCIM_KEY_Ccedilla },
  { SCIM_KEY_braceright,          SCIM_KEY_asterisk },
  { SCIM_KEY_asciitilde,          SCIM_KEY_ordfeminine },
};

static __Uint16Pair __spanish_latin_america_to_us_caps_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_at },
  { SCIM_KEY_ampersand,           SCIM_KEY_asciicircum },
  { SCIM_KEY_parenleft,           SCIM_KEY_asterisk },
  { SCIM_KEY_parenright,          SCIM_KEY_parenleft },
  { SCIM_KEY_asterisk,            SCIM_KEY_braceright },
  { SCIM_KEY_slash,               SCIM_KEY_ampersand },
  { SCIM_KEY_colon,               SCIM_KEY_greater },
  { SCIM_KEY_semicolon,           SCIM_KEY_less },
  { SCIM_KEY_equal,               SCIM_KEY_parenright },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_ordfeminine,         SCIM_KEY_asciitilde },
  { SCIM_KEY_periodcentered,      SCIM_KEY_numbersign },
  { SCIM_KEY_questiondown,        SCIM_KEY_plus },
  { SCIM_KEY_ccedilla,            SCIM_KEY_bar },
  { SCIM_KEY_ntilde,              SCIM_KEY_colon },
  { SCIM_KEY_dead_circumflex,     SCIM_KEY_braceleft },
  { SCIM_KEY_dead_diaeresis,      SCIM_KEY_quotedbl },
};

static __Uint16Pair __us_to_spanish_latin_america_caps_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_dead_diaeresis },
  { SCIM_KEY_numbersign,          SCIM_KEY_periodcentered },
  { SCIM_KEY_ampersand,           SCIM_KEY_slash },
  { SCIM_KEY_parenleft,           SCIM_KEY_parenright },
  { SCIM_KEY_parenright,          SCIM_KEY_equal },
  { SCIM_KEY_asterisk,            SCIM_KEY_parenleft },
  { SCIM_KEY_plus,                SCIM_KEY_questiondown },
  { SCIM_KEY_colon,               SCIM_KEY_ntilde },
  { SCIM_KEY_less,                SCIM_KEY_semicolon },
  { SCIM_KEY_greater,             SCIM_KEY_colon },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_at,                  SCIM_KEY_quotedbl },
  { SCIM_KEY_asciicircum,         SCIM_KEY_ampersand },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_braceleft,           SCIM_KEY_dead_circumflex },
  { SCIM_KEY_bar,                 SCIM_KEY_ccedilla },
  { SCIM_KEY_braceright,          SCIM_KEY_asterisk },
  { SCIM_KEY_asciitilde,          SCIM_KEY_ordfeminine },
};

static __Uint16Pair __swedish_to_us_normal [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_backslash },
  { SCIM_KEY_plus,                SCIM_KEY_minus },
  { SCIM_KEY_minus,               SCIM_KEY_slash },
  { SCIM_KEY_section,             SCIM_KEY_grave },
  { SCIM_KEY_adiaeresis,          SCIM_KEY_apostrophe },
  { SCIM_KEY_aring,               SCIM_KEY_bracketleft },
  { SCIM_KEY_odiaeresis,          SCIM_KEY_semicolon },
  { SCIM_KEY_dead_acute,          SCIM_KEY_equal },
  { SCIM_KEY_dead_diaeresis,      SCIM_KEY_bracketright },
};

static __Uint16Pair __us_to_swedish_normal [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_adiaeresis },
  { SCIM_KEY_minus,               SCIM_KEY_plus },
  { SCIM_KEY_slash,               SCIM_KEY_minus },
  { SCIM_KEY_semicolon,           SCIM_KEY_odiaeresis },
  { SCIM_KEY_equal,               SCIM_KEY_dead_acute },
  { SCIM_KEY_bracketleft,         SCIM_KEY_aring },
  { SCIM_KEY_backslash,           SCIM_KEY_apostrophe },
  { SCIM_KEY_bracketright,        SCIM_KEY_dead_diaeresis },
  { SCIM_KEY_grave,               SCIM_KEY_section },
};

static __Uint16Pair __swedish_to_us_caps [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_backslash },
  { SCIM_KEY_plus,                SCIM_KEY_minus },
  { SCIM_KEY_minus,               SCIM_KEY_slash },
  { SCIM_KEY_section,             SCIM_KEY_grave },
  { SCIM_KEY_Adiaeresis,          SCIM_KEY_apostrophe },
  { SCIM_KEY_Aring,               SCIM_KEY_bracketleft },
  { SCIM_KEY_Odiaeresis,          SCIM_KEY_semicolon },
  { SCIM_KEY_dead_acute,          SCIM_KEY_equal },
  { SCIM_KEY_dead_diaeresis,      SCIM_KEY_bracketright },
};

static __Uint16Pair __us_to_swedish_caps [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_Adiaeresis },
  { SCIM_KEY_minus,               SCIM_KEY_plus },
  { SCIM_KEY_slash,               SCIM_KEY_minus },
  { SCIM_KEY_semicolon,           SCIM_KEY_Odiaeresis },
  { SCIM_KEY_equal,               SCIM_KEY_dead_acute },
  { SCIM_KEY_bracketleft,         SCIM_KEY_Aring },
  { SCIM_KEY_backslash,           SCIM_KEY_apostrophe },
  { SCIM_KEY_bracketright,        SCIM_KEY_dead_diaeresis },
  { SCIM_KEY_grave,               SCIM_KEY_section },
};

static __Uint16Pair __swedish_to_us_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_at },
  { SCIM_KEY_ampersand,           SCIM_KEY_asciicircum },
  { SCIM_KEY_parenleft,           SCIM_KEY_asterisk },
  { SCIM_KEY_parenright,          SCIM_KEY_parenleft },
  { SCIM_KEY_asterisk,            SCIM_KEY_bar },
  { SCIM_KEY_slash,               SCIM_KEY_ampersand },
  { SCIM_KEY_colon,               SCIM_KEY_greater },
  { SCIM_KEY_semicolon,           SCIM_KEY_less },
  { SCIM_KEY_equal,               SCIM_KEY_parenright },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_currency,            SCIM_KEY_dollar },
  { SCIM_KEY_onehalf,             SCIM_KEY_asciitilde },
  { SCIM_KEY_Adiaeresis,          SCIM_KEY_quotedbl },
  { SCIM_KEY_Aring,               SCIM_KEY_braceleft },
  { SCIM_KEY_Odiaeresis,          SCIM_KEY_colon },
  { SCIM_KEY_dead_grave,          SCIM_KEY_plus },
  { SCIM_KEY_dead_circumflex,     SCIM_KEY_braceright },
};

static __Uint16Pair __us_to_swedish_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_Adiaeresis },
  { SCIM_KEY_dollar,              SCIM_KEY_currency },
  { SCIM_KEY_ampersand,           SCIM_KEY_slash },
  { SCIM_KEY_parenleft,           SCIM_KEY_parenright },
  { SCIM_KEY_parenright,          SCIM_KEY_equal },
  { SCIM_KEY_asterisk,            SCIM_KEY_parenleft },
  { SCIM_KEY_plus,                SCIM_KEY_dead_grave },
  { SCIM_KEY_colon,               SCIM_KEY_Odiaeresis },
  { SCIM_KEY_less,                SCIM_KEY_semicolon },
  { SCIM_KEY_greater,             SCIM_KEY_colon },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_at,                  SCIM_KEY_quotedbl },
  { SCIM_KEY_asciicircum,         SCIM_KEY_ampersand },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_braceleft,           SCIM_KEY_Aring },
  { SCIM_KEY_bar,                 SCIM_KEY_asterisk },
  { SCIM_KEY_braceright,          SCIM_KEY_dead_circumflex },
  { SCIM_KEY_asciitilde,          SCIM_KEY_onehalf },
};

static __Uint16Pair __swedish_to_us_caps_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_at },
  { SCIM_KEY_ampersand,           SCIM_KEY_asciicircum },
  { SCIM_KEY_parenleft,           SCIM_KEY_asterisk },
  { SCIM_KEY_parenright,          SCIM_KEY_parenleft },
  { SCIM_KEY_asterisk,            SCIM_KEY_bar },
  { SCIM_KEY_slash,               SCIM_KEY_ampersand },
  { SCIM_KEY_colon,               SCIM_KEY_greater },
  { SCIM_KEY_semicolon,           SCIM_KEY_less },
  { SCIM_KEY_equal,               SCIM_KEY_parenright },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_currency,            SCIM_KEY_dollar },
  { SCIM_KEY_onehalf,             SCIM_KEY_asciitilde },
  { SCIM_KEY_adiaeresis,          SCIM_KEY_quotedbl },
  { SCIM_KEY_aring,               SCIM_KEY_braceleft },
  { SCIM_KEY_odiaeresis,          SCIM_KEY_colon },
  { SCIM_KEY_dead_grave,          SCIM_KEY_plus },
  { SCIM_KEY_dead_circumflex,     SCIM_KEY_braceright },
};

static __Uint16Pair __us_to_swedish_caps_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_adiaeresis },
  { SCIM_KEY_dollar,              SCIM_KEY_currency },
  { SCIM_KEY_ampersand,           SCIM_KEY_slash },
  { SCIM_KEY_parenleft,           SCIM_KEY_parenright },
  { SCIM_KEY_parenright,          SCIM_KEY_equal },
  { SCIM_KEY_asterisk,            SCIM_KEY_parenleft },
  { SCIM_KEY_plus,                SCIM_KEY_dead_grave },
  { SCIM_KEY_colon,               SCIM_KEY_odiaeresis },
  { SCIM_KEY_less,                SCIM_KEY_semicolon },
  { SCIM_KEY_greater,             SCIM_KEY_colon },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_at,                  SCIM_KEY_quotedbl },
  { SCIM_KEY_asciicircum,         SCIM_KEY_ampersand },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_braceleft,           SCIM_KEY_aring },
  { SCIM_KEY_bar,                 SCIM_KEY_asterisk },
  { SCIM_KEY_braceright,          SCIM_KEY_dead_circumflex },
  { SCIM_KEY_asciitilde,          SCIM_KEY_onehalf },
};

static __Uint16Pair __turkish_to_us_normal [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_grave },
  { SCIM_KEY_asterisk,            SCIM_KEY_minus },
  { SCIM_KEY_comma,               SCIM_KEY_backslash },
  { SCIM_KEY_minus,               SCIM_KEY_equal },
  { SCIM_KEY_period,              SCIM_KEY_slash },
  { SCIM_KEY_i,                   SCIM_KEY_apostrophe },
  { SCIM_KEY_ccedilla,            SCIM_KEY_period },
  { SCIM_KEY_odiaeresis,          SCIM_KEY_comma },
  { SCIM_KEY_udiaeresis,          SCIM_KEY_bracketright },
  { SCIM_KEY_scedilla,            SCIM_KEY_semicolon },
  { SCIM_KEY_idotless,            SCIM_KEY_i },
  { SCIM_KEY_gbreve,              SCIM_KEY_bracketleft },
};

static __Uint16Pair __us_to_turkish_normal [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_i },
  { SCIM_KEY_comma,               SCIM_KEY_odiaeresis },
  { SCIM_KEY_minus,               SCIM_KEY_asterisk },
  { SCIM_KEY_period,              SCIM_KEY_ccedilla },
  { SCIM_KEY_slash,               SCIM_KEY_period },
  { SCIM_KEY_semicolon,           SCIM_KEY_scedilla },
  { SCIM_KEY_equal,               SCIM_KEY_minus },
  { SCIM_KEY_bracketleft,         SCIM_KEY_gbreve },
  { SCIM_KEY_backslash,           SCIM_KEY_comma },
  { SCIM_KEY_bracketright,        SCIM_KEY_udiaeresis },
  { SCIM_KEY_grave,               SCIM_KEY_quotedbl },
  { SCIM_KEY_i,                   SCIM_KEY_idotless },
};

static __Uint16Pair __turkish_to_us_caps [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_grave },
  { SCIM_KEY_asterisk,            SCIM_KEY_minus },
  { SCIM_KEY_comma,               SCIM_KEY_backslash },
  { SCIM_KEY_minus,               SCIM_KEY_equal },
  { SCIM_KEY_period,              SCIM_KEY_slash },
  { SCIM_KEY_I,                   SCIM_KEY_apostrophe },
  { SCIM_KEY_Ccedilla,            SCIM_KEY_period },
  { SCIM_KEY_Odiaeresis,          SCIM_KEY_comma },
  { SCIM_KEY_Udiaeresis,          SCIM_KEY_bracketright },
  { SCIM_KEY_Scedilla,            SCIM_KEY_semicolon },
  { SCIM_KEY_Gbreve,              SCIM_KEY_bracketleft },
  { SCIM_KEY_idotless,            SCIM_KEY_I },
};

static __Uint16Pair __us_to_turkish_caps [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_I },
  { SCIM_KEY_comma,               SCIM_KEY_Odiaeresis },
  { SCIM_KEY_minus,               SCIM_KEY_asterisk },
  { SCIM_KEY_period,              SCIM_KEY_Ccedilla },
  { SCIM_KEY_slash,               SCIM_KEY_period },
  { SCIM_KEY_semicolon,           SCIM_KEY_Scedilla },
  { SCIM_KEY_equal,               SCIM_KEY_minus },
  { SCIM_KEY_I,                   SCIM_KEY_idotless },
  { SCIM_KEY_bracketleft,         SCIM_KEY_Gbreve },
  { SCIM_KEY_backslash,           SCIM_KEY_comma },
  { SCIM_KEY_bracketright,        SCIM_KEY_Udiaeresis },
  { SCIM_KEY_grave,               SCIM_KEY_quotedbl },
};

static __Uint16Pair __turkish_to_us_shift [] = {
  { SCIM_KEY_ampersand,           SCIM_KEY_asciicircum },
  { SCIM_KEY_apostrophe,          SCIM_KEY_at },
  { SCIM_KEY_parenleft,           SCIM_KEY_asterisk },
  { SCIM_KEY_parenright,          SCIM_KEY_parenleft },
  { SCIM_KEY_plus,                SCIM_KEY_dollar },
  { SCIM_KEY_slash,               SCIM_KEY_ampersand },
  { SCIM_KEY_colon,               SCIM_KEY_question },
  { SCIM_KEY_semicolon,           SCIM_KEY_bar },
  { SCIM_KEY_equal,               SCIM_KEY_parenright },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_backslash,           SCIM_KEY_asciitilde },
  { SCIM_KEY_asciicircum,         SCIM_KEY_numbersign },
  { SCIM_KEY_underscore,          SCIM_KEY_plus },
  { SCIM_KEY_Ccedilla,            SCIM_KEY_greater },
  { SCIM_KEY_Odiaeresis,          SCIM_KEY_less },
  { SCIM_KEY_Udiaeresis,          SCIM_KEY_braceright },
  { SCIM_KEY_Scedilla,            SCIM_KEY_colon },
  { SCIM_KEY_Iabovedot,           SCIM_KEY_quotedbl },
  { SCIM_KEY_Gbreve,              SCIM_KEY_braceleft },
};

static __Uint16Pair __us_to_turkish_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_Iabovedot },
  { SCIM_KEY_numbersign,          SCIM_KEY_asciicircum },
  { SCIM_KEY_dollar,              SCIM_KEY_plus },
  { SCIM_KEY_ampersand,           SCIM_KEY_slash },
  { SCIM_KEY_parenleft,           SCIM_KEY_parenright },
  { SCIM_KEY_parenright,          SCIM_KEY_equal },
  { SCIM_KEY_asterisk,            SCIM_KEY_parenleft },
  { SCIM_KEY_plus,                SCIM_KEY_underscore },
  { SCIM_KEY_colon,               SCIM_KEY_Scedilla },
  { SCIM_KEY_less,                SCIM_KEY_Odiaeresis },
  { SCIM_KEY_greater,             SCIM_KEY_Ccedilla },
  { SCIM_KEY_question,            SCIM_KEY_colon },
  { SCIM_KEY_at,                  SCIM_KEY_apostrophe },
  { SCIM_KEY_asciicircum,         SCIM_KEY_ampersand },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_braceleft,           SCIM_KEY_Gbreve },
  { SCIM_KEY_bar,                 SCIM_KEY_semicolon },
  { SCIM_KEY_braceright,          SCIM_KEY_Udiaeresis },
  { SCIM_KEY_asciitilde,          SCIM_KEY_backslash },
};

static __Uint16Pair __turkish_to_us_caps_shift [] = {
  { SCIM_KEY_ampersand,           SCIM_KEY_asciicircum },
  { SCIM_KEY_apostrophe,          SCIM_KEY_at },
  { SCIM_KEY_parenleft,           SCIM_KEY_asterisk },
  { SCIM_KEY_parenright,          SCIM_KEY_parenleft },
  { SCIM_KEY_plus,                SCIM_KEY_dollar },
  { SCIM_KEY_slash,               SCIM_KEY_ampersand },
  { SCIM_KEY_colon,               SCIM_KEY_question },
  { SCIM_KEY_semicolon,           SCIM_KEY_bar },
  { SCIM_KEY_equal,               SCIM_KEY_parenright },
  { SCIM_KEY_question,            SCIM_KEY_underscore },
  { SCIM_KEY_I,                   SCIM_KEY_i },
  { SCIM_KEY_backslash,           SCIM_KEY_asciitilde },
  { SCIM_KEY_asciicircum,         SCIM_KEY_numbersign },
  { SCIM_KEY_underscore,          SCIM_KEY_plus },
  { SCIM_KEY_ccedilla,            SCIM_KEY_greater },
  { SCIM_KEY_odiaeresis,          SCIM_KEY_less },
  { SCIM_KEY_udiaeresis,          SCIM_KEY_braceright },
  { SCIM_KEY_scedilla,            SCIM_KEY_colon },
  { SCIM_KEY_Iabovedot,           SCIM_KEY_quotedbl },
  { SCIM_KEY_gbreve,              SCIM_KEY_braceleft },
};

static __Uint16Pair __us_to_turkish_caps_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_Iabovedot },
  { SCIM_KEY_numbersign,          SCIM_KEY_asciicircum },
  { SCIM_KEY_dollar,              SCIM_KEY_plus },
  { SCIM_KEY_ampersand,           SCIM_KEY_slash },
  { SCIM_KEY_parenleft,           SCIM_KEY_parenright },
  { SCIM_KEY_parenright,          SCIM_KEY_equal },
  { SCIM_KEY_asterisk,            SCIM_KEY_parenleft },
  { SCIM_KEY_plus,                SCIM_KEY_underscore },
  { SCIM_KEY_colon,               SCIM_KEY_scedilla },
  { SCIM_KEY_less,                SCIM_KEY_odiaeresis },
  { SCIM_KEY_greater,             SCIM_KEY_ccedilla },
  { SCIM_KEY_question,            SCIM_KEY_colon },
  { SCIM_KEY_at,                  SCIM_KEY_apostrophe },
  { SCIM_KEY_asciicircum,         SCIM_KEY_ampersand },
  { SCIM_KEY_underscore,          SCIM_KEY_question },
  { SCIM_KEY_i,                   SCIM_KEY_I },
  { SCIM_KEY_braceleft,           SCIM_KEY_gbreve },
  { SCIM_KEY_bar,                 SCIM_KEY_semicolon },
  { SCIM_KEY_braceright,          SCIM_KEY_udiaeresis },
  { SCIM_KEY_asciitilde,          SCIM_KEY_backslash },
};

static __Uint16Pair __uk_to_us_normal [] = {
  { SCIM_KEY_numbersign,          SCIM_KEY_backslash },
};

static __Uint16Pair __us_to_uk_normal [] = {
  { SCIM_KEY_backslash,           SCIM_KEY_numbersign },
};

static __Uint16Pair __uk_to_us_caps [] = {
  { SCIM_KEY_numbersign,          SCIM_KEY_backslash },
};

static __Uint16Pair __us_to_uk_caps [] = {
  { SCIM_KEY_backslash,           SCIM_KEY_numbersign },
};

static __Uint16Pair __uk_to_us_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_at },
  { SCIM_KEY_at,                  SCIM_KEY_quotedbl },
  { SCIM_KEY_asciitilde,          SCIM_KEY_bar },
  { SCIM_KEY_sterling,            SCIM_KEY_numbersign },
  { SCIM_KEY_notsign,             SCIM_KEY_asciitilde },
};

static __Uint16Pair __us_to_uk_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_at },
  { SCIM_KEY_numbersign,          SCIM_KEY_sterling },
  { SCIM_KEY_at,                  SCIM_KEY_quotedbl },
  { SCIM_KEY_bar,                 SCIM_KEY_asciitilde },
  { SCIM_KEY_asciitilde,          SCIM_KEY_notsign },
};

static __Uint16Pair __uk_to_us_caps_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_at },
  { SCIM_KEY_at,                  SCIM_KEY_quotedbl },
  { SCIM_KEY_asciitilde,          SCIM_KEY_bar },
  { SCIM_KEY_sterling,            SCIM_KEY_numbersign },
  { SCIM_KEY_notsign,             SCIM_KEY_asciitilde },
};

static __Uint16Pair __us_to_uk_caps_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_at },
  { SCIM_KEY_numbersign,          SCIM_KEY_sterling },
  { SCIM_KEY_at,                  SCIM_KEY_quotedbl },
  { SCIM_KEY_bar,                 SCIM_KEY_asciitilde },
  { SCIM_KEY_asciitilde,          SCIM_KEY_notsign },
};

static __Uint16Pair __icelandic_to_us_normal [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_bracketright },
  { SCIM_KEY_plus,                SCIM_KEY_backslash },
  { SCIM_KEY_minus,               SCIM_KEY_equal },
  { SCIM_KEY_degree,              SCIM_KEY_grave },
  { SCIM_KEY_ae,                  SCIM_KEY_semicolon },
  { SCIM_KEY_eth,                 SCIM_KEY_bracketleft },
  { SCIM_KEY_odiaeresis,          SCIM_KEY_minus },
  { SCIM_KEY_thorn,               SCIM_KEY_slash },
  { SCIM_KEY_dead_acute,          SCIM_KEY_apostrophe },
};

static __Uint16Pair __us_to_icelandic_normal [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_dead_acute },
  { SCIM_KEY_minus,               SCIM_KEY_odiaeresis },
  { SCIM_KEY_slash,               SCIM_KEY_thorn },
  { SCIM_KEY_semicolon,           SCIM_KEY_ae },
  { SCIM_KEY_equal,               SCIM_KEY_minus },
  { SCIM_KEY_bracketleft,         SCIM_KEY_eth },
  { SCIM_KEY_backslash,           SCIM_KEY_plus },
  { SCIM_KEY_bracketright,        SCIM_KEY_apostrophe },
  { SCIM_KEY_grave,               SCIM_KEY_degree },
};

static __Uint16Pair __icelandic_to_us_caps [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_bracketright },
  { SCIM_KEY_plus,                SCIM_KEY_backslash },
  { SCIM_KEY_minus,               SCIM_KEY_equal },
  { SCIM_KEY_degree,              SCIM_KEY_grave },
  { SCIM_KEY_AE,                  SCIM_KEY_semicolon },
  { SCIM_KEY_ETH,                 SCIM_KEY_bracketleft },
  { SCIM_KEY_Odiaeresis,          SCIM_KEY_minus },
  { SCIM_KEY_THORN,               SCIM_KEY_slash },
  { SCIM_KEY_dead_acute,          SCIM_KEY_apostrophe },
};

static __Uint16Pair __us_to_icelandic_caps [] = {
  { SCIM_KEY_apostrophe,          SCIM_KEY_dead_acute },
  { SCIM_KEY_minus,               SCIM_KEY_Odiaeresis },
  { SCIM_KEY_slash,               SCIM_KEY_THORN },
  { SCIM_KEY_semicolon,           SCIM_KEY_AE },
  { SCIM_KEY_equal,               SCIM_KEY_minus },
  { SCIM_KEY_bracketleft,         SCIM_KEY_ETH },
  { SCIM_KEY_backslash,           SCIM_KEY_plus },
  { SCIM_KEY_bracketright,        SCIM_KEY_apostrophe },
  { SCIM_KEY_grave,               SCIM_KEY_degree },
};

static __Uint16Pair __icelandic_to_us_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_at },
  { SCIM_KEY_ampersand,           SCIM_KEY_asciicircum },
  { SCIM_KEY_parenleft,           SCIM_KEY_asterisk },
  { SCIM_KEY_parenright,          SCIM_KEY_parenleft },
  { SCIM_KEY_asterisk,            SCIM_KEY_bar },
  { SCIM_KEY_slash,               SCIM_KEY_ampersand },
  { SCIM_KEY_colon,               SCIM_KEY_greater },
  { SCIM_KEY_semicolon,           SCIM_KEY_less },
  { SCIM_KEY_equal,               SCIM_KEY_parenright },
  { SCIM_KEY_question,            SCIM_KEY_braceright },
  { SCIM_KEY_underscore,          SCIM_KEY_plus },
  { SCIM_KEY_diaeresis,           SCIM_KEY_asciitilde },
  { SCIM_KEY_Adiaeresis,          SCIM_KEY_quotedbl },
  { SCIM_KEY_AE,                  SCIM_KEY_colon },
  { SCIM_KEY_ETH,                 SCIM_KEY_braceleft },
  { SCIM_KEY_Odiaeresis,          SCIM_KEY_underscore },
  { SCIM_KEY_THORN,               SCIM_KEY_question },
};

static __Uint16Pair __us_to_icelandic_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_Adiaeresis },
  { SCIM_KEY_ampersand,           SCIM_KEY_slash },
  { SCIM_KEY_parenleft,           SCIM_KEY_parenright },
  { SCIM_KEY_parenright,          SCIM_KEY_equal },
  { SCIM_KEY_asterisk,            SCIM_KEY_parenleft },
  { SCIM_KEY_plus,                SCIM_KEY_underscore },
  { SCIM_KEY_colon,               SCIM_KEY_AE },
  { SCIM_KEY_less,                SCIM_KEY_semicolon },
  { SCIM_KEY_greater,             SCIM_KEY_colon },
  { SCIM_KEY_question,            SCIM_KEY_THORN },
  { SCIM_KEY_at,                  SCIM_KEY_quotedbl },
  { SCIM_KEY_asciicircum,         SCIM_KEY_ampersand },
  { SCIM_KEY_underscore,          SCIM_KEY_Odiaeresis },
  { SCIM_KEY_braceleft,           SCIM_KEY_ETH },
  { SCIM_KEY_bar,                 SCIM_KEY_asterisk },
  { SCIM_KEY_braceright,          SCIM_KEY_question },
  { SCIM_KEY_asciitilde,          SCIM_KEY_diaeresis },
};

static __Uint16Pair __icelandic_to_us_caps_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_at },
  { SCIM_KEY_ampersand,           SCIM_KEY_asciicircum },
  { SCIM_KEY_parenleft,           SCIM_KEY_asterisk },
  { SCIM_KEY_parenright,          SCIM_KEY_parenleft },
  { SCIM_KEY_asterisk,            SCIM_KEY_bar },
  { SCIM_KEY_slash,               SCIM_KEY_ampersand },
  { SCIM_KEY_colon,               SCIM_KEY_greater },
  { SCIM_KEY_semicolon,           SCIM_KEY_less },
  { SCIM_KEY_equal,               SCIM_KEY_parenright },
  { SCIM_KEY_question,            SCIM_KEY_braceright },
  { SCIM_KEY_underscore,          SCIM_KEY_plus },
  { SCIM_KEY_diaeresis,           SCIM_KEY_asciitilde },
  { SCIM_KEY_Adiaeresis,          SCIM_KEY_quotedbl },
  { SCIM_KEY_ae,                  SCIM_KEY_colon },
  { SCIM_KEY_eth,                 SCIM_KEY_braceleft },
  { SCIM_KEY_odiaeresis,          SCIM_KEY_underscore },
  { SCIM_KEY_thorn,               SCIM_KEY_question },
};

static __Uint16Pair __us_to_icelandic_caps_shift [] = {
  { SCIM_KEY_quotedbl,            SCIM_KEY_Adiaeresis },
  { SCIM_KEY_ampersand,           SCIM_KEY_slash },
  { SCIM_KEY_parenleft,           SCIM_KEY_parenright },
  { SCIM_KEY_parenright,          SCIM_KEY_equal },
  { SCIM_KEY_asterisk,            SCIM_KEY_parenleft },
  { SCIM_KEY_plus,                SCIM_KEY_underscore },
  { SCIM_KEY_colon,               SCIM_KEY_ae },
  { SCIM_KEY_less,                SCIM_KEY_semicolon },
  { SCIM_KEY_greater,             SCIM_KEY_colon },
  { SCIM_KEY_question,            SCIM_KEY_thorn },
  { SCIM_KEY_at,                  SCIM_KEY_quotedbl },
  { SCIM_KEY_asciicircum,         SCIM_KEY_ampersand },
  { SCIM_KEY_underscore,          SCIM_KEY_odiaeresis },
  { SCIM_KEY_braceleft,           SCIM_KEY_eth },
  { SCIM_KEY_bar,                 SCIM_KEY_asterisk },
  { SCIM_KEY_braceright,          SCIM_KEY_question },
  { SCIM_KEY_asciitilde,          SCIM_KEY_diaeresis },
};


// KeyEvent remapping map
static __KeyCodeMap __normal_map [] =
{
    { 0, 0 },
    { 0, 0 },
    { sizeof(__belgian_to_us_normal) / sizeof (__Uint16Pair), __belgian_to_us_normal },
    { 0, 0 }, // Croatian
    { sizeof(__czech_to_us_normal) / sizeof (__Uint16Pair), __czech_to_us_normal },
    { sizeof(__czech_qwerty_to_us_normal) / sizeof (__Uint16Pair), __czech_qwerty_to_us_normal },
    { sizeof(__danish_to_us_normal) / sizeof (__Uint16Pair), __danish_to_us_normal },
    { 0, 0 }, // Dutch
    { sizeof(__dvorak_to_us_normal) / sizeof (__Uint16Pair), __dvorak_to_us_normal },
    { sizeof(__estonian_to_us_normal) / sizeof (__Uint16Pair), __estonian_to_us_normal },
    { sizeof(__finnish_to_us_normal) / sizeof (__Uint16Pair), __finnish_to_us_normal },
    { sizeof(__french_to_us_normal) / sizeof (__Uint16Pair), __french_to_us_normal },
    { 0, 0 }, // French Canadian
    { sizeof(__french_switzerland_to_us_normal) / sizeof (__Uint16Pair), __french_switzerland_to_us_normal },
    { sizeof(__german_to_us_normal) / sizeof (__Uint16Pair), __german_to_us_normal },
    { sizeof(__german_deadkeys_to_us_normal) / sizeof (__Uint16Pair), __german_deadkeys_to_us_normal },
    { sizeof(__german_swiss_to_us_normal) / sizeof (__Uint16Pair), __german_swiss_to_us_normal },
    { 0, 0 }, // Greek
    { sizeof(__hungarian_to_us_normal) / sizeof (__Uint16Pair), __hungarian_to_us_normal },
    { sizeof(__italian_to_us_normal) / sizeof (__Uint16Pair), __italian_to_us_normal },
    { sizeof(__japanese_to_us_normal) / sizeof (__Uint16Pair), __japanese_to_us_normal },
    { sizeof(__norwegian_to_us_normal) / sizeof (__Uint16Pair), __norwegian_to_us_normal },
    { 0, 0 }, // Polish
    { sizeof(__portuguese_to_us_normal) / sizeof (__Uint16Pair), __portuguese_to_us_normal },
    { sizeof(__portuguese_brazil_to_us_normal) / sizeof (__Uint16Pair), __portuguese_brazil_to_us_normal },
    { sizeof(__portuguese_brazil_us_accents_to_us_normal) / sizeof (__Uint16Pair), __portuguese_brazil_us_accents_to_us_normal },
    { 0, 0 }, // Russian
    { sizeof(__slovak_to_us_normal) / sizeof (__Uint16Pair), __slovak_to_us_normal },
    { sizeof(__slovak_qwerty_to_us_normal) / sizeof (__Uint16Pair), __slovak_qwerty_to_us_normal },
    { 0, 0 }, // Slovene
    { sizeof(__spanish_to_us_normal) / sizeof (__Uint16Pair), __spanish_to_us_normal },
    { sizeof(__spanish_cp850_to_us_normal) / sizeof (__Uint16Pair), __spanish_cp850_to_us_normal },
    { sizeof(__spanish_latin_america_to_us_normal) / sizeof (__Uint16Pair), __spanish_latin_america_to_us_normal },
    { sizeof(__swedish_to_us_normal) / sizeof (__Uint16Pair), __swedish_to_us_normal },
    { sizeof(__turkish_to_us_normal) / sizeof (__Uint16Pair), __turkish_to_us_normal },
    { sizeof(__uk_to_us_normal) / sizeof (__Uint16Pair), __uk_to_us_normal },
    { sizeof(__icelandic_to_us_normal) / sizeof (__Uint16Pair), __icelandic_to_us_normal },
    { 0, 0 }, // Icelandic
    { 0, 0 }, // Ukrainian
};

static __KeyCodeMap __normal_invert_map [] =
{
    { 0, 0 },
    { 0, 0 },
    { sizeof(__us_to_belgian_normal) / sizeof (__Uint16Pair), __us_to_belgian_normal },
    { 0, 0 }, // Croatian
    { sizeof(__us_to_czech_normal) / sizeof (__Uint16Pair), __us_to_czech_normal },
    { sizeof(__us_to_czech_qwerty_normal) / sizeof (__Uint16Pair), __us_to_czech_qwerty_normal },
    { sizeof(__us_to_danish_normal) / sizeof (__Uint16Pair), __us_to_danish_normal },
    { 0, 0 }, // Dutch
    { sizeof(__us_to_dvorak_normal) / sizeof (__Uint16Pair), __us_to_dvorak_normal },
    { sizeof(__us_to_estonian_normal) / sizeof (__Uint16Pair), __us_to_estonian_normal },
    { sizeof(__us_to_finnish_normal) / sizeof (__Uint16Pair), __us_to_finnish_normal },
    { sizeof(__us_to_french_normal) / sizeof (__Uint16Pair), __us_to_french_normal },
    { 0, 0 }, // French Canadian
    { sizeof(__us_to_french_switzerland_normal) / sizeof (__Uint16Pair), __us_to_french_switzerland_normal },
    { sizeof(__us_to_german_normal) / sizeof (__Uint16Pair), __us_to_german_normal },
    { sizeof(__us_to_german_deadkeys_normal) / sizeof (__Uint16Pair), __us_to_german_deadkeys_normal },
    { sizeof(__us_to_german_swiss_normal) / sizeof (__Uint16Pair), __us_to_german_swiss_normal },
    { 0, 0 }, // Greek
    { sizeof(__us_to_hungarian_normal) / sizeof (__Uint16Pair), __us_to_hungarian_normal },
    { sizeof(__us_to_italian_normal) / sizeof (__Uint16Pair), __us_to_italian_normal },
    { sizeof(__us_to_japanese_normal) / sizeof (__Uint16Pair), __us_to_japanese_normal },
    { sizeof(__us_to_norwegian_normal) / sizeof (__Uint16Pair), __us_to_norwegian_normal },
    { 0, 0 }, // Polish
    { sizeof(__us_to_portuguese_normal) / sizeof (__Uint16Pair), __us_to_portuguese_normal },
    { sizeof(__us_to_portuguese_brazil_normal) / sizeof (__Uint16Pair), __us_to_portuguese_brazil_normal },
    { sizeof(__us_to_portuguese_brazil_us_accents_normal) / sizeof (__Uint16Pair), __us_to_portuguese_brazil_us_accents_normal },
    { 0, 0 }, // Russian
    { sizeof(__us_to_slovak_normal) / sizeof (__Uint16Pair), __us_to_slovak_normal },
    { sizeof(__us_to_slovak_qwerty_normal) / sizeof (__Uint16Pair), __us_to_slovak_qwerty_normal },
    { 0, 0 }, // Slovene
    { sizeof(__us_to_spanish_normal) / sizeof (__Uint16Pair), __us_to_spanish_normal },
    { sizeof(__us_to_spanish_cp850_normal) / sizeof (__Uint16Pair), __us_to_spanish_cp850_normal },
    { sizeof(__us_to_spanish_latin_america_normal) / sizeof (__Uint16Pair), __us_to_spanish_latin_america_normal },
    { sizeof(__us_to_swedish_normal) / sizeof (__Uint16Pair), __us_to_swedish_normal },
    { sizeof(__us_to_turkish_normal) / sizeof (__Uint16Pair), __us_to_turkish_normal },
    { sizeof(__us_to_uk_normal) / sizeof (__Uint16Pair), __us_to_uk_normal },
    { sizeof(__us_to_icelandic_normal) / sizeof (__Uint16Pair), __us_to_icelandic_normal },
    { 0, 0 }, // Icelandic
    { 0, 0 }, // Ukrainian
};

static __KeyCodeMap __caps_map [] =
{
    { 0, 0 },
    { 0, 0 },
    { sizeof(__belgian_to_us_caps) / sizeof (__Uint16Pair), __belgian_to_us_caps },
    { 0, 0 }, // Croatian
    { sizeof(__czech_to_us_caps) / sizeof (__Uint16Pair), __czech_to_us_caps },
    { sizeof(__czech_qwerty_to_us_caps) / sizeof (__Uint16Pair), __czech_qwerty_to_us_caps },
    { sizeof(__danish_to_us_caps) / sizeof (__Uint16Pair), __danish_to_us_caps },
    { 0, 0 }, // Dutch
    { sizeof(__dvorak_to_us_caps) / sizeof (__Uint16Pair), __dvorak_to_us_caps },
    { sizeof(__estonian_to_us_caps) / sizeof (__Uint16Pair), __estonian_to_us_caps },
    { sizeof(__finnish_to_us_caps) / sizeof (__Uint16Pair), __finnish_to_us_caps },
    { sizeof(__french_to_us_caps) / sizeof (__Uint16Pair), __french_to_us_caps },
    { 0, 0 }, // French Canadian
    { sizeof(__french_switzerland_to_us_caps) / sizeof (__Uint16Pair), __french_switzerland_to_us_caps },
    { sizeof(__german_to_us_caps) / sizeof (__Uint16Pair), __german_to_us_caps },
    { sizeof(__german_deadkeys_to_us_caps) / sizeof (__Uint16Pair), __german_deadkeys_to_us_caps },
    { sizeof(__german_swiss_to_us_caps) / sizeof (__Uint16Pair), __german_swiss_to_us_caps },
    { 0, 0 }, // Greek
    { sizeof(__hungarian_to_us_caps) / sizeof (__Uint16Pair), __hungarian_to_us_caps },
    { sizeof(__italian_to_us_caps) / sizeof (__Uint16Pair), __italian_to_us_caps },
    { sizeof(__japanese_to_us_caps) / sizeof (__Uint16Pair), __japanese_to_us_caps },
    { sizeof(__norwegian_to_us_caps) / sizeof (__Uint16Pair), __norwegian_to_us_caps },
    { 0, 0 }, // Polish
    { sizeof(__portuguese_to_us_caps) / sizeof (__Uint16Pair), __portuguese_to_us_caps },
    { sizeof(__portuguese_brazil_to_us_caps) / sizeof (__Uint16Pair), __portuguese_brazil_to_us_caps },
    { sizeof(__portuguese_brazil_us_accents_to_us_caps) / sizeof (__Uint16Pair), __portuguese_brazil_us_accents_to_us_caps },
    { 0, 0 }, // Russian
    { sizeof(__slovak_to_us_caps) / sizeof (__Uint16Pair), __slovak_to_us_caps },
    { sizeof(__slovak_qwerty_to_us_caps) / sizeof (__Uint16Pair), __slovak_qwerty_to_us_caps },
    { 0, 0 }, // Slovene
    { sizeof(__spanish_to_us_caps) / sizeof (__Uint16Pair), __spanish_to_us_caps },
    { sizeof(__spanish_cp850_to_us_caps) / sizeof (__Uint16Pair), __spanish_cp850_to_us_caps },
    { sizeof(__spanish_latin_america_to_us_caps) / sizeof (__Uint16Pair), __spanish_latin_america_to_us_caps },
    { sizeof(__swedish_to_us_caps) / sizeof (__Uint16Pair), __swedish_to_us_caps },
    { sizeof(__turkish_to_us_caps) / sizeof (__Uint16Pair), __turkish_to_us_caps },
    { sizeof(__uk_to_us_caps) / sizeof (__Uint16Pair), __uk_to_us_caps },
    { sizeof(__icelandic_to_us_caps) / sizeof (__Uint16Pair), __icelandic_to_us_caps },
    { 0, 0 }, // Icelandic
    { 0, 0 }, // Ukrainian
};

static __KeyCodeMap __caps_invert_map [] =
{
    { 0, 0 },
    { 0, 0 },
    { sizeof(__us_to_belgian_caps) / sizeof (__Uint16Pair), __us_to_belgian_caps },
    { 0, 0 }, // Croatian
    { sizeof(__us_to_czech_caps) / sizeof (__Uint16Pair), __us_to_czech_caps },
    { sizeof(__us_to_czech_qwerty_caps) / sizeof (__Uint16Pair), __us_to_czech_qwerty_caps },
    { sizeof(__us_to_danish_caps) / sizeof (__Uint16Pair), __us_to_danish_caps },
    { 0, 0 }, // Dutch
    { sizeof(__us_to_dvorak_caps) / sizeof (__Uint16Pair), __us_to_dvorak_caps },
    { sizeof(__us_to_estonian_caps) / sizeof (__Uint16Pair), __us_to_estonian_caps },
    { sizeof(__us_to_finnish_caps) / sizeof (__Uint16Pair), __us_to_finnish_caps },
    { sizeof(__us_to_french_caps) / sizeof (__Uint16Pair), __us_to_french_caps },
    { 0, 0 }, // French Canadian
    { sizeof(__us_to_french_switzerland_caps) / sizeof (__Uint16Pair), __us_to_french_switzerland_caps },
    { sizeof(__us_to_german_caps) / sizeof (__Uint16Pair), __us_to_german_caps },
    { sizeof(__us_to_german_deadkeys_caps) / sizeof (__Uint16Pair), __us_to_german_deadkeys_caps },
    { sizeof(__us_to_german_swiss_caps) / sizeof (__Uint16Pair), __us_to_german_swiss_caps },
    { 0, 0 }, // Greek
    { sizeof(__us_to_hungarian_caps) / sizeof (__Uint16Pair), __us_to_hungarian_caps },
    { sizeof(__us_to_italian_caps) / sizeof (__Uint16Pair), __us_to_italian_caps },
    { sizeof(__us_to_japanese_caps) / sizeof (__Uint16Pair), __us_to_japanese_caps },
    { sizeof(__us_to_norwegian_caps) / sizeof (__Uint16Pair), __us_to_norwegian_caps },
    { 0, 0 }, // Polish
    { sizeof(__us_to_portuguese_caps) / sizeof (__Uint16Pair), __us_to_portuguese_caps },
    { sizeof(__us_to_portuguese_brazil_caps) / sizeof (__Uint16Pair), __us_to_portuguese_brazil_caps },
    { sizeof(__us_to_portuguese_brazil_us_accents_caps) / sizeof (__Uint16Pair), __us_to_portuguese_brazil_us_accents_caps },
    { 0, 0 }, // Russian
    { sizeof(__us_to_slovak_caps) / sizeof (__Uint16Pair), __us_to_slovak_caps },
    { sizeof(__us_to_slovak_qwerty_caps) / sizeof (__Uint16Pair), __us_to_slovak_qwerty_caps },
    { 0, 0 }, // Slovene
    { sizeof(__us_to_spanish_caps) / sizeof (__Uint16Pair), __us_to_spanish_caps },
    { sizeof(__us_to_spanish_cp850_caps) / sizeof (__Uint16Pair), __us_to_spanish_cp850_caps },
    { sizeof(__us_to_spanish_latin_america_caps) / sizeof (__Uint16Pair), __us_to_spanish_latin_america_caps },
    { sizeof(__us_to_swedish_caps) / sizeof (__Uint16Pair), __us_to_swedish_caps },
    { sizeof(__us_to_turkish_caps) / sizeof (__Uint16Pair), __us_to_turkish_caps },
    { sizeof(__us_to_uk_caps) / sizeof (__Uint16Pair), __us_to_uk_caps },
    { sizeof(__us_to_icelandic_caps) / sizeof (__Uint16Pair), __us_to_icelandic_caps },
    { 0, 0 }, // Icelandic
    { 0, 0 }, // Ukrainian
};

static __KeyCodeMap __shift_map [] =
{
    { 0, 0 },
    { 0, 0 },
    { sizeof(__belgian_to_us_shift) / sizeof (__Uint16Pair), __belgian_to_us_shift },
    { 0, 0 }, // Croatian
    { sizeof(__czech_to_us_shift) / sizeof (__Uint16Pair), __czech_to_us_shift },
    { sizeof(__czech_qwerty_to_us_shift) / sizeof (__Uint16Pair), __czech_qwerty_to_us_shift },
    { sizeof(__danish_to_us_shift) / sizeof (__Uint16Pair), __danish_to_us_shift },
    { 0, 0 }, // Dutch
    { sizeof(__dvorak_to_us_shift) / sizeof (__Uint16Pair), __dvorak_to_us_shift },
    { sizeof(__estonian_to_us_shift) / sizeof (__Uint16Pair), __estonian_to_us_shift },
    { sizeof(__finnish_to_us_shift) / sizeof (__Uint16Pair), __finnish_to_us_shift },
    { sizeof(__french_to_us_shift) / sizeof (__Uint16Pair), __french_to_us_shift },
    { 0, 0 }, // French Canadian
    { sizeof(__french_switzerland_to_us_shift) / sizeof (__Uint16Pair), __french_switzerland_to_us_shift },
    { sizeof(__german_to_us_shift) / sizeof (__Uint16Pair), __german_to_us_shift },
    { sizeof(__german_deadkeys_to_us_shift) / sizeof (__Uint16Pair), __german_deadkeys_to_us_shift },
    { sizeof(__german_swiss_to_us_shift) / sizeof (__Uint16Pair), __german_swiss_to_us_shift },
    { 0, 0 }, // Greek
    { sizeof(__hungarian_to_us_shift) / sizeof (__Uint16Pair), __hungarian_to_us_shift },
    { sizeof(__italian_to_us_shift) / sizeof (__Uint16Pair), __italian_to_us_shift },
    { sizeof(__japanese_to_us_shift) / sizeof (__Uint16Pair), __japanese_to_us_shift },
    { sizeof(__norwegian_to_us_shift) / sizeof (__Uint16Pair), __norwegian_to_us_shift },
    { 0, 0 }, // Polish
    { sizeof(__portuguese_to_us_shift) / sizeof (__Uint16Pair), __portuguese_to_us_shift },
    { sizeof(__portuguese_brazil_to_us_shift) / sizeof (__Uint16Pair), __portuguese_brazil_to_us_shift },
    { sizeof(__portuguese_brazil_us_accents_to_us_shift) / sizeof (__Uint16Pair), __portuguese_brazil_us_accents_to_us_shift },
    { 0, 0 }, // Russian
    { sizeof(__slovak_to_us_shift) / sizeof (__Uint16Pair), __slovak_to_us_shift },
    { sizeof(__slovak_qwerty_to_us_shift) / sizeof (__Uint16Pair), __slovak_qwerty_to_us_shift },
    { 0, 0 }, // Slovene
    { sizeof(__spanish_to_us_shift) / sizeof (__Uint16Pair), __spanish_to_us_shift },
    { sizeof(__spanish_cp850_to_us_shift) / sizeof (__Uint16Pair), __spanish_cp850_to_us_shift },
    { sizeof(__spanish_latin_america_to_us_shift) / sizeof (__Uint16Pair), __spanish_latin_america_to_us_shift },
    { sizeof(__swedish_to_us_shift) / sizeof (__Uint16Pair), __swedish_to_us_shift },
    { sizeof(__turkish_to_us_shift) / sizeof (__Uint16Pair), __turkish_to_us_shift },
    { sizeof(__uk_to_us_shift) / sizeof (__Uint16Pair), __uk_to_us_shift },
    { sizeof(__icelandic_to_us_shift) / sizeof (__Uint16Pair), __icelandic_to_us_shift },
    { 0, 0 }, // Icelandic
    { 0, 0 }, // Ukrainian
};

static __KeyCodeMap __shift_invert_map [] =
{
    { 0, 0 },
    { 0, 0 },
    { sizeof(__us_to_belgian_shift) / sizeof (__Uint16Pair), __us_to_belgian_shift },
    { 0, 0 }, // Croatian
    { sizeof(__us_to_czech_shift) / sizeof (__Uint16Pair), __us_to_czech_shift },
    { sizeof(__us_to_czech_qwerty_shift) / sizeof (__Uint16Pair), __us_to_czech_qwerty_shift },
    { sizeof(__us_to_danish_shift) / sizeof (__Uint16Pair), __us_to_danish_shift },
    { 0, 0 }, // Dutch
    { sizeof(__us_to_dvorak_shift) / sizeof (__Uint16Pair), __us_to_dvorak_shift },
    { sizeof(__us_to_estonian_shift) / sizeof (__Uint16Pair), __us_to_estonian_shift },
    { sizeof(__us_to_finnish_shift) / sizeof (__Uint16Pair), __us_to_finnish_shift },
    { sizeof(__us_to_french_shift) / sizeof (__Uint16Pair), __us_to_french_shift },
    { 0, 0 }, // French Canadian
    { sizeof(__us_to_french_switzerland_shift) / sizeof (__Uint16Pair), __us_to_french_switzerland_shift },
    { sizeof(__us_to_german_shift) / sizeof (__Uint16Pair), __us_to_german_shift },
    { sizeof(__us_to_german_deadkeys_shift) / sizeof (__Uint16Pair), __us_to_german_deadkeys_shift },
    { sizeof(__us_to_german_swiss_shift) / sizeof (__Uint16Pair), __us_to_german_swiss_shift },
    { 0, 0 }, // Greek
    { sizeof(__us_to_hungarian_shift) / sizeof (__Uint16Pair), __us_to_hungarian_shift },
    { sizeof(__us_to_italian_shift) / sizeof (__Uint16Pair), __us_to_italian_shift },
    { sizeof(__us_to_japanese_shift) / sizeof (__Uint16Pair), __us_to_japanese_shift },
    { sizeof(__us_to_norwegian_shift) / sizeof (__Uint16Pair), __us_to_norwegian_shift },
    { 0, 0 }, // Polish
    { sizeof(__us_to_portuguese_shift) / sizeof (__Uint16Pair), __us_to_portuguese_shift },
    { sizeof(__us_to_portuguese_brazil_shift) / sizeof (__Uint16Pair), __us_to_portuguese_brazil_shift },
    { sizeof(__us_to_portuguese_brazil_us_accents_shift) / sizeof (__Uint16Pair), __us_to_portuguese_brazil_us_accents_shift },
    { 0, 0 }, // Russian
    { sizeof(__us_to_slovak_shift) / sizeof (__Uint16Pair), __us_to_slovak_shift },
    { sizeof(__us_to_slovak_qwerty_shift) / sizeof (__Uint16Pair), __us_to_slovak_qwerty_shift },
    { 0, 0 }, // Slovene
    { sizeof(__us_to_spanish_shift) / sizeof (__Uint16Pair), __us_to_spanish_shift },
    { sizeof(__us_to_spanish_cp850_shift) / sizeof (__Uint16Pair), __us_to_spanish_cp850_shift },
    { sizeof(__us_to_spanish_latin_america_shift) / sizeof (__Uint16Pair), __us_to_spanish_latin_america_shift },
    { sizeof(__us_to_swedish_shift) / sizeof (__Uint16Pair), __us_to_swedish_shift },
    { sizeof(__us_to_turkish_shift) / sizeof (__Uint16Pair), __us_to_turkish_shift },
    { sizeof(__us_to_uk_shift) / sizeof (__Uint16Pair), __us_to_uk_shift },
    { sizeof(__us_to_icelandic_shift) / sizeof (__Uint16Pair), __us_to_icelandic_shift },
    { 0, 0 }, // Icelandic
    { 0, 0 }, // Ukrainian
};

static __KeyCodeMap __caps_shift_map [] =
{
    { 0, 0 },
    { 0, 0 },
    { sizeof(__belgian_to_us_caps_shift) / sizeof (__Uint16Pair), __belgian_to_us_caps_shift },
    { 0, 0 }, // Croatian
    { sizeof(__czech_to_us_caps_shift) / sizeof (__Uint16Pair), __czech_to_us_caps_shift },
    { sizeof(__czech_qwerty_to_us_caps_shift) / sizeof (__Uint16Pair), __czech_qwerty_to_us_caps_shift },
    { sizeof(__danish_to_us_caps_shift) / sizeof (__Uint16Pair), __danish_to_us_caps_shift },
    { 0, 0 }, // Dutch
    { sizeof(__dvorak_to_us_caps_shift) / sizeof (__Uint16Pair), __dvorak_to_us_caps_shift },
    { sizeof(__estonian_to_us_caps_shift) / sizeof (__Uint16Pair), __estonian_to_us_caps_shift },
    { sizeof(__finnish_to_us_caps_shift) / sizeof (__Uint16Pair), __finnish_to_us_caps_shift },
    { sizeof(__french_to_us_caps_shift) / sizeof (__Uint16Pair), __french_to_us_caps_shift },
    { 0, 0 }, // French Canadian
    { sizeof(__french_switzerland_to_us_caps_shift) / sizeof (__Uint16Pair), __french_switzerland_to_us_caps_shift },
    { sizeof(__german_to_us_caps_shift) / sizeof (__Uint16Pair), __german_to_us_caps_shift },
    { sizeof(__german_deadkeys_to_us_caps_shift) / sizeof (__Uint16Pair), __german_deadkeys_to_us_caps_shift },
    { sizeof(__german_swiss_to_us_caps_shift) / sizeof (__Uint16Pair), __german_swiss_to_us_caps_shift },
    { 0, 0 }, // Greek
    { sizeof(__hungarian_to_us_caps_shift) / sizeof (__Uint16Pair), __hungarian_to_us_caps_shift },
    { sizeof(__italian_to_us_caps_shift) / sizeof (__Uint16Pair), __italian_to_us_caps_shift },
    { sizeof(__japanese_to_us_caps_shift) / sizeof (__Uint16Pair), __japanese_to_us_caps_shift },
    { sizeof(__norwegian_to_us_caps_shift) / sizeof (__Uint16Pair), __norwegian_to_us_caps_shift },
    { 0, 0 }, // Polish
    { sizeof(__portuguese_to_us_caps_shift) / sizeof (__Uint16Pair), __portuguese_to_us_caps_shift },
    { sizeof(__portuguese_brazil_to_us_caps_shift) / sizeof (__Uint16Pair), __portuguese_brazil_to_us_caps_shift },
    { sizeof(__portuguese_brazil_us_accents_to_us_caps_shift) / sizeof (__Uint16Pair), __portuguese_brazil_us_accents_to_us_caps_shift },
    { 0, 0 }, // Russian
    { sizeof(__slovak_to_us_caps_shift) / sizeof (__Uint16Pair), __slovak_to_us_caps_shift },
    { sizeof(__slovak_qwerty_to_us_caps_shift) / sizeof (__Uint16Pair), __slovak_qwerty_to_us_caps_shift },
    { 0, 0 }, // Slovene
    { sizeof(__spanish_to_us_caps_shift) / sizeof (__Uint16Pair), __spanish_to_us_caps_shift },
    { sizeof(__spanish_cp850_to_us_caps_shift) / sizeof (__Uint16Pair), __spanish_cp850_to_us_caps_shift },
    { sizeof(__spanish_latin_america_to_us_caps_shift) / sizeof (__Uint16Pair), __spanish_latin_america_to_us_caps_shift },
    { sizeof(__swedish_to_us_caps_shift) / sizeof (__Uint16Pair), __swedish_to_us_caps_shift },
    { sizeof(__turkish_to_us_caps_shift) / sizeof (__Uint16Pair), __turkish_to_us_caps_shift },
    { sizeof(__uk_to_us_caps_shift) / sizeof (__Uint16Pair), __uk_to_us_caps_shift },
    { sizeof(__icelandic_to_us_caps_shift) / sizeof (__Uint16Pair), __icelandic_to_us_caps_shift },
    { 0, 0 }, // Icelandic
    { 0, 0 }, // Ukrainian
};

static __KeyCodeMap __caps_shift_invert_map [] =
{
    { 0, 0 },
    { 0, 0 },
    { sizeof(__us_to_belgian_caps_shift) / sizeof (__Uint16Pair), __us_to_belgian_caps_shift },
    { 0, 0 }, // Croatian
    { sizeof(__us_to_czech_caps_shift) / sizeof (__Uint16Pair), __us_to_czech_caps_shift },
    { sizeof(__us_to_czech_qwerty_caps_shift) / sizeof (__Uint16Pair), __us_to_czech_qwerty_caps_shift },
    { sizeof(__us_to_danish_caps_shift) / sizeof (__Uint16Pair), __us_to_danish_caps_shift },
    { 0, 0 }, // Dutch
    { sizeof(__us_to_dvorak_caps_shift) / sizeof (__Uint16Pair), __us_to_dvorak_caps_shift },
    { sizeof(__us_to_estonian_caps_shift) / sizeof (__Uint16Pair), __us_to_estonian_caps_shift },
    { sizeof(__us_to_finnish_caps_shift) / sizeof (__Uint16Pair), __us_to_finnish_caps_shift },
    { sizeof(__us_to_french_caps_shift) / sizeof (__Uint16Pair), __us_to_french_caps_shift },
    { 0, 0 }, // French Canadian
    { sizeof(__us_to_french_switzerland_caps_shift) / sizeof (__Uint16Pair), __us_to_french_switzerland_caps_shift },
    { sizeof(__us_to_german_caps_shift) / sizeof (__Uint16Pair), __us_to_german_caps_shift },
    { sizeof(__us_to_german_deadkeys_caps_shift) / sizeof (__Uint16Pair), __us_to_german_deadkeys_caps_shift },
    { sizeof(__us_to_german_swiss_caps_shift) / sizeof (__Uint16Pair), __us_to_german_swiss_caps_shift },
    { 0, 0 }, // Greek
    { sizeof(__us_to_hungarian_caps_shift) / sizeof (__Uint16Pair), __us_to_hungarian_caps_shift },
    { sizeof(__us_to_italian_caps_shift) / sizeof (__Uint16Pair), __us_to_italian_caps_shift },
    { sizeof(__us_to_japanese_caps_shift) / sizeof (__Uint16Pair), __us_to_japanese_caps_shift },
    { sizeof(__us_to_norwegian_caps_shift) / sizeof (__Uint16Pair), __us_to_norwegian_caps_shift },
    { 0, 0 }, // Polish
    { sizeof(__us_to_portuguese_caps_shift) / sizeof (__Uint16Pair), __us_to_portuguese_caps_shift },
    { sizeof(__us_to_portuguese_brazil_caps_shift) / sizeof (__Uint16Pair), __us_to_portuguese_brazil_caps_shift },
    { sizeof(__us_to_portuguese_brazil_us_accents_caps_shift) / sizeof (__Uint16Pair), __us_to_portuguese_brazil_us_accents_caps_shift },
    { 0, 0 }, // Russian
    { sizeof(__us_to_slovak_caps_shift) / sizeof (__Uint16Pair), __us_to_slovak_caps_shift },
    { sizeof(__us_to_slovak_qwerty_caps_shift) / sizeof (__Uint16Pair), __us_to_slovak_qwerty_caps_shift },
    { 0, 0 }, // Slovene
    { sizeof(__us_to_spanish_caps_shift) / sizeof (__Uint16Pair), __us_to_spanish_caps_shift },
    { sizeof(__us_to_spanish_cp850_caps_shift) / sizeof (__Uint16Pair), __us_to_spanish_cp850_caps_shift },
    { sizeof(__us_to_spanish_latin_america_caps_shift) / sizeof (__Uint16Pair), __us_to_spanish_latin_america_caps_shift },
    { sizeof(__us_to_swedish_caps_shift) / sizeof (__Uint16Pair), __us_to_swedish_caps_shift },
    { sizeof(__us_to_turkish_caps_shift) / sizeof (__Uint16Pair), __us_to_turkish_caps_shift },
    { sizeof(__us_to_uk_caps_shift) / sizeof (__Uint16Pair), __us_to_uk_caps_shift },
    { sizeof(__us_to_icelandic_caps_shift) / sizeof (__Uint16Pair), __us_to_icelandic_caps_shift },
    { 0, 0 }, // Icelandic
    { 0, 0 }, // Ukrainian
};

// Keyboard Layout string IDs sorted by code.
static __KeyName __scim_keyboard_layout_ids_by_code [] = 
{
    {SCIM_KEYBOARD_Unknown                      ,"Unknown"},
    {SCIM_KEYBOARD_Default                      ,"US_Default"},
    {SCIM_KEYBOARD_Belgian                      ,"Belgian"},
    {SCIM_KEYBOARD_Croatian                     ,"Croatian"},
    {SCIM_KEYBOARD_Czech                        ,"Czech"},
    {SCIM_KEYBOARD_Czech_Qwerty                 ,"Czech_Qwerty"},
    {SCIM_KEYBOARD_Danish                       ,"Danish"},
    {SCIM_KEYBOARD_Dutch                        ,"Dutch"},
    {SCIM_KEYBOARD_Dvorak                       ,"Dvorak"},
    {SCIM_KEYBOARD_Estonian                     ,"Estonian"},
    {SCIM_KEYBOARD_Finnish                      ,"Finnish"},
    {SCIM_KEYBOARD_French                       ,"French"},
    {SCIM_KEYBOARD_French_Canadian              ,"French_Canadian"},
    {SCIM_KEYBOARD_French_Switzerland           ,"French_Switzerland"},
    {SCIM_KEYBOARD_German                       ,"German"},
    {SCIM_KEYBOARD_German_Deadkeys              ,"German_Deadkeys"},
    {SCIM_KEYBOARD_German_Swiss                 ,"German_Swiss"},
    {SCIM_KEYBOARD_Greek                        ,"Greek"},
    {SCIM_KEYBOARD_Hungarian                    ,"Hungarian"},
    {SCIM_KEYBOARD_Italian                      ,"Italian"},
    {SCIM_KEYBOARD_Japanese                     ,"Japanese"},
    {SCIM_KEYBOARD_Norwegian                    ,"Norwegian"},
    {SCIM_KEYBOARD_Polish                       ,"Polish"},
    {SCIM_KEYBOARD_Portuguese                   ,"Portuguese"},
    {SCIM_KEYBOARD_Portuguese_Brazil            ,"Portuguese_Brazil"},
    {SCIM_KEYBOARD_Portuguese_Brazil_US_Accents ,"Portuguese_Brazil_US_Accents"},
    {SCIM_KEYBOARD_Russian                      ,"Russian"},
    {SCIM_KEYBOARD_Slovak                       ,"Slovak"},
    {SCIM_KEYBOARD_Slovak_Qwerty                ,"Slovak_Qwerty"},
    {SCIM_KEYBOARD_Slovene                      ,"Slovene"},
    {SCIM_KEYBOARD_Spanish                      ,"Spanish"},
    {SCIM_KEYBOARD_Spanish_CP850                ,"Spanish_CP850"},
    {SCIM_KEYBOARD_Spanish_Latin_America        ,"Spanish_Latin_America"},
    {SCIM_KEYBOARD_Swedish                      ,"Swedish"},
    {SCIM_KEYBOARD_Turkish                      ,"Turkish"},
    {SCIM_KEYBOARD_UK                           ,"UK"},
    {SCIM_KEYBOARD_Icelandic                    ,"Icelandic"},
    {SCIM_KEYBOARD_Lithuanian                   ,"Lithuanian"},
    {SCIM_KEYBOARD_Ukrainian                    ,"Ukrainian"},
};

// Keyboard Layout string IDs sorted by name.
static __KeyName __scim_keyboard_layout_ids_by_name [] =
{
    {SCIM_KEYBOARD_Unknown                      ,"Unknown"},
    {SCIM_KEYBOARD_Default                      ,"US_Default"},
    {SCIM_KEYBOARD_Belgian                      ,"Belgian"},
    {SCIM_KEYBOARD_Croatian                     ,"Croatian"},
    {SCIM_KEYBOARD_Czech                        ,"Czech"},
    {SCIM_KEYBOARD_Czech_Qwerty                 ,"Czech_Qwerty"},
    {SCIM_KEYBOARD_Danish                       ,"Danish"},
    {SCIM_KEYBOARD_Dutch                        ,"Dutch"},
    {SCIM_KEYBOARD_Dvorak                       ,"Dvorak"},
    {SCIM_KEYBOARD_Estonian                     ,"Estonian"},
    {SCIM_KEYBOARD_Finnish                      ,"Finnish"},
    {SCIM_KEYBOARD_French                       ,"French"},
    {SCIM_KEYBOARD_French_Canadian              ,"French_Canadian"},
    {SCIM_KEYBOARD_French_Switzerland           ,"French_Switzerland"},
    {SCIM_KEYBOARD_German                       ,"German"},
    {SCIM_KEYBOARD_German_Deadkeys              ,"German_Deadkeys"},
    {SCIM_KEYBOARD_German_Swiss                 ,"German_Swiss"},
    {SCIM_KEYBOARD_Greek                        ,"Greek"},
    {SCIM_KEYBOARD_Hungarian                    ,"Hungarian"},
    {SCIM_KEYBOARD_Icelandic                    ,"Icelandic"},
    {SCIM_KEYBOARD_Italian                      ,"Italian"},
    {SCIM_KEYBOARD_Japanese                     ,"Japanese"},
    {SCIM_KEYBOARD_Lithuanian                   ,"Lithuanian"},
    {SCIM_KEYBOARD_Norwegian                    ,"Norwegian"},
    {SCIM_KEYBOARD_Polish                       ,"Polish"},
    {SCIM_KEYBOARD_Portuguese                   ,"Portuguese"},
    {SCIM_KEYBOARD_Portuguese_Brazil            ,"Portuguese_Brazil"},
    {SCIM_KEYBOARD_Portuguese_Brazil_US_Accents ,"Portuguese_Brazil_US_Accents"},
    {SCIM_KEYBOARD_Russian                      ,"Russian"},
    {SCIM_KEYBOARD_Slovak                       ,"Slovak"},
    {SCIM_KEYBOARD_Slovak_Qwerty                ,"Slovak_Qwerty"},
    {SCIM_KEYBOARD_Slovene                      ,"Slovene"},
    {SCIM_KEYBOARD_Spanish                      ,"Spanish"},
    {SCIM_KEYBOARD_Spanish_CP850                ,"Spanish_CP850"},
    {SCIM_KEYBOARD_Spanish_Latin_America        ,"Spanish_Latin_America"},
    {SCIM_KEYBOARD_Swedish                      ,"Swedish"},
    {SCIM_KEYBOARD_Turkish                      ,"Turkish"},
    {SCIM_KEYBOARD_UK                           ,"UK"},
    {SCIM_KEYBOARD_Ukrainian                    ,"Ukrainian"},
};


// Keyboard Layout display names.
static char *__scim_keyboard_layout_names [] = 
{
    N_("Unknown"),
    N_("English (US)"),
    N_("Belgian"),
    N_("Croatian"),
    N_("Czech"),
    N_("Czech (qwerty)"),
    N_("Danish"),
    N_("Dutch"),
    N_("Dvorak"),
    N_("Estonian"),
    N_("Finnish"),
    N_("French"),
    N_("French (Canadian)"),
    N_("French (Switzerland)"),
    N_("German"),
    N_("German (with deadkeys)"),
    N_("German (Swiss)"),
    N_("Greek"),
    N_("Hungarian"),
    N_("Italian"),
    N_("Japanese"),
    N_("Norwegian"),
    N_("Polish"),
    N_("Portuguese"),
    N_("Portuguese (Brazil)"),
    N_("Portuguese (Brazil US accents)"),
    N_("Russian"),
    N_("Slovak"),
    N_("Slovak (qwerty)"),
    N_("Slovenian"),
    N_("Spanish"),
    N_("Spanish (CP 850)"),
    N_("Spanish (Latin America)"),
    N_("Swedish"),
    N_("Turkish"),
    N_("English (UK)"),
    N_("Icelandic"),
    N_("Lithuanian"),
    N_("Ukrainian"),
};

/*
vi:ts=4:nowrap:ai:expandtab
*/

