/** @file scim_pinyin_imengine_setup.cpp
 * implementation of Setup Module of Pinyin IMEngine.
 */

/*
 * Smart Pinyin Input Method
 * 
 * Copyright (c) 2005 James Su <suzhe@tsinghua.org.cn>
 *
 * $Id: scim_pinyin_imengine_setup.cpp,v 1.2 2005/03/03 23:53:27 suzhe Exp $
 *
 */

#define Uses_SCIM_CONFIG_BASE

#include <gtk/gtk.h>

#include <scim.h>
#include <gtk/scimkeyselection.h>
#include <hildon/hildon.h>
#include "scim_pinyin_private.h"
#include "scim_pinyin.h"
#include "scim_pinyin_imengine_config_keys.h"

using namespace scim;

#define scim_module_init pinyin_imengine_setup_LTX_scim_module_init
#define scim_module_exit pinyin_imengine_setup_LTX_scim_module_exit

#define scim_setup_module_create_ui       pinyin_imengine_setup_LTX_scim_setup_module_create_ui
#define scim_setup_module_get_category    pinyin_imengine_setup_LTX_scim_setup_module_get_category
#define scim_setup_module_get_name        pinyin_imengine_setup_LTX_scim_setup_module_get_name
#define scim_setup_module_get_description pinyin_imengine_setup_LTX_scim_setup_module_get_description
#define scim_setup_module_load_config     pinyin_imengine_setup_LTX_scim_setup_module_load_config
#define scim_setup_module_save_config     pinyin_imengine_setup_LTX_scim_setup_module_save_config
#define scim_setup_module_query_changed   pinyin_imengine_setup_LTX_scim_setup_module_query_changed


static GtkWidget * __create_setup_window ();
static void        __load_config (const ConfigPointer &config);
static void        __save_config (const ConfigPointer &config);
static ConfigPointer config_pointer;

// Module Interface.
extern "C" {
    void scim_module_init (void)
    {
        bindtextdomain (GETTEXT_PACKAGE, SCIM_PINYIN_LOCALEDIR);
        bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
    }

    void scim_module_exit (void)
    {
    }

    GtkWidget * scim_setup_module_create_ui (void)
    {
        return __create_setup_window ();
    }

    String scim_setup_module_get_category (void)
    {
        return String ("IMEngine");
    }

    String scim_setup_module_get_name (void)
    {
        return String (_("Smart Pinyin Setup"));
    }

    String scim_setup_module_get_description (void)
    {
        return String (_("An IMEngine Module for Chinese which utilizes pinyin input method."));
    }

    void scim_setup_module_load_config (const ConfigPointer &config)
    {
        __load_config (config);
        config_pointer = config;
    }

    void scim_setup_module_save_config (const ConfigPointer &config)
    {
        __save_config (config);
    }

    bool scim_setup_module_query_changed ()
    {
        return true;
    }
} // extern "C"

// Internal data declaration.
static bool   __config_dynamic_adjust         = true;
static int    __config_pinyin_scheme          = 0;
static bool   __config_tone                   = false;
//static bool   __config_simp_chinese           = true;
static bool   __config_ambiguities [SCIM_PINYIN_AmbLast+1] =
{
    false,
    false, false, false,
    false, false, false,
    false, false, false
};

static char * __ambiguity_config_keys [SCIM_PINYIN_AmbLast+1] =
{
    SCIM_CONFIG_IMENGINE_PINYIN_AMBIGUITY_ANY,
    SCIM_CONFIG_IMENGINE_PINYIN_AMBIGUITY_ZhiZi,
    SCIM_CONFIG_IMENGINE_PINYIN_AMBIGUITY_ChiCi,
    SCIM_CONFIG_IMENGINE_PINYIN_AMBIGUITY_ShiSi,
    SCIM_CONFIG_IMENGINE_PINYIN_AMBIGUITY_NeLe,
    SCIM_CONFIG_IMENGINE_PINYIN_AMBIGUITY_LeRi,
    SCIM_CONFIG_IMENGINE_PINYIN_AMBIGUITY_FoHe,
    SCIM_CONFIG_IMENGINE_PINYIN_AMBIGUITY_AnAng,
    SCIM_CONFIG_IMENGINE_PINYIN_AMBIGUITY_EnEng,
    SCIM_CONFIG_IMENGINE_PINYIN_AMBIGUITY_InIng
};

static char * __ambiguity_ui_strings [SCIM_PINYIN_AmbLast+1] =
{
    N_("Ambiguities"),
    N_("Zh and Z"),
    N_("Ch and C"),
    N_("Sh and S"),
    N_("N and L"),
    N_("L and R"),
    N_("F and H"),
    N_("An and Ang"),
    N_("En and Eng"),
    N_("In and Ing")
};

static bool __have_changed                 = false;


static GtkWidget * __widget_dynamic_adjust         = 0;
static GtkWidget * __widget_tone                   = 0;
//static GtkWidget * __widget_simp_chinese           = 0;
//static GtkWidget * __widget_trad_chinese           = 0;
static GtkWidget * __widget_scheme                 = 0;
static GtkWidget * __widget_scheme_selector        = 0;

static char * __pinyin_scheme_names [7] =
{
   "全拼",
   "双拼-中文之星/四通利方",
   "双拼-自然码",
   "双拼-微软拼音",
   "双拼-紫光拼音",
   "双拼-智能ABC",
   "双拼-刘氏"
};

static GtkWidget * __widget_ambiguities [SCIM_PINYIN_AmbLast+1] = 
{
    NULL,
    NULL, NULL, NULL,
    NULL, NULL, NULL,
    NULL, NULL, NULL
};


// Function implementations.
static GtkWidget *
__create_setup_window ()
{
    static GtkWidget *dialog = 0;

    dialog = gtk_dialog_new_with_buttons(
                    _("Smart Pinyin Setup"),
                    0, 
                    (GtkDialogFlags)(GTK_DIALOG_MODAL | GTK_DIALOG_NO_SEPARATOR),                
                    GTK_STOCK_SAVE,
                    GTK_RESPONSE_OK,
                    GTK_STOCK_CANCEL,
                    GTK_RESPONSE_CANCEL,
                    NULL);
    GtkWidget *panarea;
    GtkWidget *box;
    gint response;
    panarea = hildon_pannable_area_new ();
    box = gtk_vbox_new (FALSE, 0);

    hildon_pannable_area_add_with_viewport (HILDON_PANNABLE_AREA (panarea),
                box);

    g_object_set (G_OBJECT (panarea), "height-request", 300, NULL);
/*
    GtkWidget * hbox = gtk_hbox_new (TRUE, 0);
    __widget_simp_chinese = hildon_gtk_radio_button_new_from_widget(
                    HILDON_SIZE_FINGER_HEIGHT, NULL);
    gtk_button_set_label (GTK_BUTTON(__widget_simp_chinese),
                    N_("Simp. Chinese"));
    gtk_toggle_button_set_mode ((GtkToggleButton *)__widget_simp_chinese, FALSE);
    gtk_box_pack_start (GTK_BOX (hbox),__widget_simp_chinese,TRUE,TRUE,0);
    
    __widget_trad_chinese = hildon_gtk_radio_button_new_from_widget(
                    HILDON_SIZE_FINGER_HEIGHT, (GtkRadioButton *)__widget_simp_chinese);
    gtk_button_set_label (GTK_BUTTON(__widget_trad_chinese),
                    N_("Trad. Chinese"));
    gtk_toggle_button_set_mode ((GtkToggleButton *)__widget_trad_chinese, FALSE);
    gtk_box_pack_start (GTK_BOX (hbox),__widget_trad_chinese,TRUE,TRUE,0);
    gtk_box_pack_start (GTK_BOX (box), hbox, TRUE, TRUE, 0);

    if (__config_simp_chinese)
        gtk_toggle_button_set_active(
                        (GtkToggleButton *)__widget_simp_chinese,TRUE);
    else
       gtk_toggle_button_set_active(
                       (GtkToggleButton *)__widget_trad_chinese,TRUE);
*/    
    __widget_scheme = hildon_picker_button_new(
                    HILDON_SIZE_FINGER_HEIGHT,
                    HILDON_BUTTON_ARRANGEMENT_VERTICAL);
    hildon_button_set_title(HILDON_BUTTON(__widget_scheme),
                    N_("Pinyin Scheme"));
    __widget_scheme_selector = hildon_touch_selector_new_text();
    for (int i=0;i<7;i++)
        hildon_touch_selector_append_text((HildonTouchSelector *)__widget_scheme_selector,
                   __pinyin_scheme_names[i]);
    hildon_picker_button_set_selector((HildonPickerButton*)__widget_scheme,
                    (HildonTouchSelector *)__widget_scheme_selector);
    /*g_signal_connect (G_OBJECT (__widget_scheme), "value-changed",
                      G_CALLBACK (ui_factory_button_click_cb),
                      NULL);
    */
    gtk_button_set_alignment (GTK_BUTTON (__widget_scheme), 0.0, 0.0);
    hildon_picker_button_set_active((HildonPickerButton*)__widget_scheme,
                    __config_pinyin_scheme);
    gtk_box_pack_start(GTK_BOX(box),__widget_scheme,FALSE,FALSE,0);
    __widget_dynamic_adjust = hildon_check_button_new(HILDON_SIZE_FINGER_HEIGHT);
    gtk_button_set_label (GTK_BUTTON(__widget_dynamic_adjust),
                    N_("Dynamic adjust"));
    hildon_check_button_set_active((HildonCheckButton*)__widget_dynamic_adjust,
                    __config_dynamic_adjust);
    gtk_box_pack_start(GTK_BOX(box),__widget_dynamic_adjust,FALSE,FALSE,0);
    
    __widget_tone = hildon_check_button_new(HILDON_SIZE_FINGER_HEIGHT);
    gtk_button_set_label (GTK_BUTTON(__widget_tone),
                    N_("Use tone"));
    hildon_check_button_set_active((HildonCheckButton*)__widget_tone,
                    __config_tone);
    gtk_box_pack_start(GTK_BOX(box),__widget_tone,FALSE,FALSE,0);
    
    GtkWidget * table = gtk_table_new (3, 3, FALSE);
    
    for (int i=1; i <= SCIM_PINYIN_AmbLast; ++i) {
        __widget_ambiguities[i] = hildon_check_button_new(HILDON_SIZE_FINGER_HEIGHT);
        hildon_check_button_set_active((HildonCheckButton*)__widget_ambiguities[i],
                    __config_ambiguities[i]);
        gtk_button_set_label (GTK_BUTTON(__widget_ambiguities[i]),
                        __ambiguity_ui_strings[i]);
        gtk_table_attach (GTK_TABLE (table), __widget_ambiguities [i],
                           (i-1) / 3, ((i-1) / 3) + 1, (i-1) % 3, ((i-1) % 3) + 1,
                           (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                           (GtkAttachOptions) (0), 0, 0);
    }

    GtkWidget *frame =gtk_frame_new(__ambiguity_ui_strings[0]);
    gtk_frame_set_label_align(GTK_FRAME(frame),0.0,0.2);
    gtk_container_add(GTK_CONTAINER(frame),table);
    gtk_box_pack_start(GTK_BOX(box),frame,FALSE,FALSE,0);
     
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),panarea,TRUE,TRUE,0);
    gtk_widget_show_all(GTK_DIALOG(dialog)->vbox);
    response = gtk_dialog_run(GTK_DIALOG(dialog));
    if (response == GTK_RESPONSE_OK)
    {
//       __config_simp_chinese =
//            gtk_toggle_button_get_active(
//                  (GtkToggleButton *)__widget_simp_chinese);
       __config_dynamic_adjust =
            hildon_check_button_get_active((HildonCheckButton*)__widget_dynamic_adjust); 
       __config_tone = 
            hildon_check_button_get_active((HildonCheckButton*)__widget_tone);
       for (int i=1; i <= SCIM_PINYIN_AmbLast; ++i) {
         __config_ambiguities[i] = hildon_check_button_get_active(
                        (HildonCheckButton*)__widget_ambiguities[i]);     
       }
       __config_pinyin_scheme = hildon_picker_button_get_active(
                       (HildonPickerButton *)__widget_scheme);
       __save_config(config_pointer);
    }
    gtk_widget_destroy(GTK_WIDGET(dialog));
    return 0;
}


static void
__load_config (const ConfigPointer &config)
{
    if (!config.null ()) {
        int i;

        __config_pinyin_scheme =
            config->read (String(SCIM_CONFIG_IMENGINE_PINYIN_SHUANG_PIN_SCHEME),
                            0);
//        __config_simp_chinese = 
//            config->read(String(SCIM_CONFIG_IMENGINE_SIMP_CHINESE),
//                            true);
        
        __config_dynamic_adjust =
            config->read (String (SCIM_CONFIG_IMENGINE_PINYIN_DYNAMIC_ADJUST),
                          __config_dynamic_adjust);

        __config_tone =
            config->read (String (SCIM_CONFIG_IMENGINE_PINYIN_TONE),
                          __config_tone);


        for (i = 0; i <= SCIM_PINYIN_AmbLast; ++ i) {
            __config_ambiguities [i] = 
                config->read (__ambiguity_config_keys [i], __config_ambiguities [i]);
        }

    }
}

static void
__save_config (const ConfigPointer &config)
{
    if (!config.null ()) {
        int i;

        config->write (String (SCIM_CONFIG_IMENGINE_PINYIN_SHUANG_PIN_SCHEME),
                      __config_pinyin_scheme);
//        config->write (String(SCIM_CONFIG_IMENGINE_SIMP_CHINESE),
//                      __config_simp_chinese);
        config->write (String (SCIM_CONFIG_IMENGINE_PINYIN_DYNAMIC_ADJUST),
                      __config_dynamic_adjust);
        config->write (String (SCIM_CONFIG_IMENGINE_PINYIN_TONE),
                      __config_tone);


        for (int i = 0; i <= SCIM_PINYIN_AmbLast; ++ i) {
            config->write (__ambiguity_config_keys [i], __config_ambiguities [i]);
        }

        __have_changed = false;
    }
}


/*
vi:ts=4:nowrap:expandtab
*/
