/** @file scim_chewing_imengine_setup.cpp
 * implementation of SetupUI Module of chewing imengine module.
 */

/*
 * SCIM-chewing -
 *	Intelligent Chinese Phonetic IM Engine for SCIM.
 *
 * Copyright (c) 2005, 2006, 2008
 *	SCIM-chewing Developers. See ChangeLog for details.
 *
 * See the file "COPYING" for information on usage and redistribution
 * of this file.
 */

#define Uses_SCIM_CONFIG_BASE

#include <gtk/gtk.h>

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif

#ifdef HAVE_GETTEXT
  #include <libintl.h>
  #define _(String) dgettext(GETTEXT_PACKAGE,String)
  #define N_(String) (String)
#else
  #define _(String) (String)
  #define N_(String) (String)
  #define bindtextdomain(Package,Directory)
  #define textdomain(domain)
  #define bind_textdomain_codeset(domain,codeset)
#endif

#include <scim.h>
#include <gtk/scimkeyselection.h>
#include <hildon/hildon.h>
#include <chewing/chewing.h>
#include "scim_chewing_config_entry.h"
#include "scim_color_button.h"

#include <cstring>

using namespace scim;

#define scim_module_init chewing_imengine_setup_LTX_scim_module_init
#define scim_module_exit chewing_imengine_setup_LTX_scim_module_exit

#define scim_setup_module_create_ui       chewing_imengine_setup_LTX_scim_setup_module_create_ui
#define scim_setup_module_get_category    chewing_imengine_setup_LTX_scim_setup_module_get_category
#define scim_setup_module_get_name        chewing_imengine_setup_LTX_scim_setup_module_get_name
#define scim_setup_module_get_description chewing_imengine_setup_LTX_scim_setup_module_get_description
#define scim_setup_module_load_config     chewing_imengine_setup_LTX_scim_setup_module_load_config
#define scim_setup_module_save_config     chewing_imengine_setup_LTX_scim_setup_module_save_config
#define scim_setup_module_query_changed   chewing_imengine_setup_LTX_scim_setup_module_query_changed

static GtkWidget * create_setup_window();
static void load_config( const ConfigPointer &config );
static void save_config( const ConfigPointer &config );
static ConfigPointer config_pointer;

// Module Interface.
extern "C" {

	void scim_module_init()
	{
		bindtextdomain( GETTEXT_PACKAGE, SCIM_CHEWING_LOCALEDIR );
		bind_textdomain_codeset( GETTEXT_PACKAGE, "UTF-8" );
	}

	void scim_module_exit()
	{
	}

	GtkWidget * scim_setup_module_create_ui()
	{
		return create_setup_window();
	}

	String scim_setup_module_get_category()
	{
		return String( "IMEngine" );
	}

	String scim_setup_module_get_name()
	{
		return String( _( "Chewing Setup" ) );
	}

	String scim_setup_module_get_description()
	{
		return String( _( "An Intelligent Chinese Phonetic IMEngine Module." ) );
	}

	void scim_setup_module_load_config( const ConfigPointer &config )
	{
		load_config( config );
		config_pointer = config;
	}

	void scim_setup_module_save_config( const ConfigPointer &config )
	{
		save_config( config );
	}

	bool scim_setup_module_query_changed()
	{
		return true;
		//return query_changed();
	}
} // extern "C"



// Internal data declaration.
// static bool __config_use_capslock          = true;
/*
static bool __config_add_phrase_forward = false;
static bool __config_phrase_choice_rearward = true;
static bool __config_auto_shift_cursor = true;
static bool __config_esc_clean_all_buffer = false;
static bool __config_space_as_selection = true;
*/
// static bool __config_show_candidate_comment= true;
static String __config_kb_type_data = "KB_DEFAULT";
static String __config_kb_type_data_translated;
static int    index_keymap          = 0;
/*
static String __config_selKey_type_data;
static String __config_selKey_num_data;
static String __config_chieng_mode_data;
static bool __have_changed                 = false;
*/
/*
// static GtkWidget    * __widget_use_capslock          = 0;
static GtkWidget    * __widget_add_phrase_forward = 0;
static GtkWidget    * __widget_phrase_choice_rearward = 0;
static GtkWidget    * __widget_auto_shift_cursor = 0;
static GtkWidget    * __widget_esc_clean_all_buffer = 0;
static GtkWidget    * __widget_space_as_selection = 0;
static GtkWidget    * __widget_kb_type = 0;
static GtkWidget    * __radio_builtin = 0;
static GtkWidget    * __radio_external = 0;
static GtkWidget    * __file_btn = 0;
static GList *kb_type_list = 0;
static GtkWidget    * __widget_selKey_type = 0;
static GtkWidget    * __widget_selKey_num = 0;
static GtkWidget    * __widget_chieng_mode = 0;
static GList *selKey_type_list = 0;
static GList *selKey_num_list = 0;
static GList *chieng_mode_list = 0;
// static GtkWidget    * __widget_show_candidate_comment= 0;
static GtkTooltips  * __widget_tooltips              = 0;
*/
static GtkWidget * __widget_scheme                 = 0;
static GtkWidget * __widget_scheme_selector        = 0;

/* XXX: It should be a pair of fg/bg colors */
#define FG_COLOR_DEFAULT "#000000"
#define FG_COLOR ""


// Declaration of internal functions.




// Function implementations.

struct _builtin_keymap {
	const char *entry;
	String translated_name;
} builtin_keymaps[] = {
		{ 
			"KB_DEFAULT",
			String( _( "Default Keyboard" ) ) },
		{       
			"KB_HSU",
			String( _( "Hsu's Keyboard" ) ) },
		{
			"KB_IBM",
			String( _( "IBM Keyboard" ) ) },
		{       
			"KB_GIN_YEIH",
			String( _( "Gin-Yieh Keyboard" ) ) },
		{
			"KB_ET",
			String( _( "ETen Keyboard" ) ) },
		{
			"KB_ET26",
			String( _( "ETen 26-key Keyboard" ) ) },
		{
			"KB_DVORAK",
			String( _( "Dvorak Keyboard" ) ) },
		{
			"KB_DVORAK_HSU",
			String( _( "Dvorak Keyboard with Hsu's support" ) ) },
		{
			"KB_DACHEN_CP26",
			String( _( "DACHEN_CP26 Keyboard") ) },
		{
			"KB_HANYU_PINYIN",
			String( _( "Han-Yu PinYin Keyboard" ) ) }
};

static const char *builtin_selectkeys[] = {
	SCIM_CONFIG_IMENGINE_CHEWING_SELECTION_KEYS,
	"asdfghjkl;",
	"asdfzxcv89",
	"asdfjkl789",
	"aoeuhtn789",
	"1234qweras",
};

static const char *builtin_selectkeys_num[] = {
	"10",
	"9",
	"8",
	"7",
	"6",
	"5"
};

static const char *builtin_chieng_mode[] = {
	"Chi",
	"Eng"
};



static GtkWidget *create_setup_window()
{
    static GtkWidget *dialog = 0;

    dialog = gtk_dialog_new_with_buttons(
                    _("Chewing Setup"),
                    0,
                    (GtkDialogFlags)(GTK_DIALOG_MODAL |                         GTK_DIALOG_NO_SEPARATOR),
                    GTK_STOCK_SAVE,
                    GTK_RESPONSE_OK,
                    GTK_STOCK_CANCEL,
                    GTK_RESPONSE_CANCEL,
                    NULL);
    GtkWidget *panarea;
    GtkWidget *box;
    gint response;
    panarea = hildon_pannable_area_new ();
    box = gtk_vbox_new (FALSE, 0);

    hildon_pannable_area_add_with_viewport (HILDON_PANNABLE_AREA (panarea),
                box);
    g_object_set (G_OBJECT (panarea), "height-request", 300, NULL);
    __widget_scheme = hildon_picker_button_new(
                    HILDON_SIZE_FINGER_HEIGHT,
                    HILDON_BUTTON_ARRANGEMENT_VERTICAL);
    hildon_button_set_title(HILDON_BUTTON(__widget_scheme),
                    N_("Use Keyboard Type"));
    __widget_scheme_selector = hildon_touch_selector_new_text();
    index_keymap = 0;
    for (int i=0;i<10;i++) {
        hildon_touch_selector_append_text((HildonTouchSelector *                
)__widget_scheme_selector,
                   builtin_keymaps[i].translated_name.c_str());
	if (builtin_keymaps[i].entry == __config_kb_type_data) {
		index_keymap = i;
	}
    }
    hildon_picker_button_set_selector((HildonPickerButton*)__widget_scheme,
                    (HildonTouchSelector *)__widget_scheme_selector);    /*g_signal_connect (G_OBJECT (__widget_scheme), "value-changed",
                      G_CALLBACK (ui_factory_button_click_cb),
                      NULL);
    */
    gtk_button_set_alignment (GTK_BUTTON (__widget_scheme), 0.0, 0.0);
    hildon_picker_button_set_active((HildonPickerButton*)__widget_scheme,
                    index_keymap);
    gtk_box_pack_start(GTK_BOX(box),__widget_scheme,FALSE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),panarea,TRUE,TRUE,0);
    gtk_widget_show_all(GTK_DIALOG(dialog)->vbox);
    response = gtk_dialog_run(GTK_DIALOG(dialog));
    if (response == GTK_RESPONSE_OK)
    {
	index_keymap = hildon_picker_button_get_active(
                       (HildonPickerButton *)__widget_scheme);
        save_config(config_pointer);
    }
    gtk_widget_destroy(GTK_WIDGET(dialog));
    return 0;
}


void load_config( const ConfigPointer &config )
{
	if (!config.null ()) {
		/*
		__config_add_phrase_forward =
			config->read( String( SCIM_CONFIG_IMENGINE_CHEWING_ADD_PHRASE_FORWARD ),
				__config_add_phrase_forward );

		__config_phrase_choice_rearward =
			config->read( String( SCIM_CONFIG_IMENGINE_CHEWING_PHRASE_CHOICE_REARWARD ),
				__config_phrase_choice_rearward );

		__config_auto_shift_cursor =
			config->read( String( SCIM_CONFIG_IMENGINE_CHEWING_AUTO_SHIFT_CURSOR ),
				__config_auto_shift_cursor );

		__config_esc_clean_all_buffer =
			config->read( String( SCIM_CONFIG_IMENGINE_CHEWING_ESC_CLEAN_ALL_BUFFER ),
				__config_esc_clean_all_buffer );

		__config_space_as_selection =
			config->read( String( SCIM_CONFIG_IMENGINE_CHEWING_SPACE_AS_SELECTION ),
				__config_space_as_selection );
		*/
		__config_kb_type_data = 
			config->read( String( SCIM_CONFIG_IMENGINE_CHEWING_USER_KB_TYPE ),
				__config_kb_type_data);
		/*
		__config_selKey_type_data =
			config->read( String( SCIM_CONFIG_IMENGINE_CHEWING_USER_SELECTION_KEYS ),
					__config_selKey_type_data);

		__config_selKey_num_data =
			config->read( String( SCIM_CHEWING_SELECTION_KEYS_NUM ),
					__config_selKey_num_data);

		__config_chieng_mode_data =
			config->read( String( SCIM_CONFIG_IMENGINE_CHEWING_CHI_ENG_MODE ),
					__config_chieng_mode_data);


		for (int i = 0; __config_keyboards[ i ].key; ++ i) {
			__config_keyboards[ i ].data =
				config->read( String( __config_keyboards [ i ].key ),
						__config_keyboards[ i ].data);
		}

		for (unsigned int i = 0;
		     i < (sizeof(config_color_common) / sizeof((config_color_common)[0])); i++) {
			ColorConfigData &entry = config_color_common[i];
			entry.bg_value = config->read (String (entry.bg_key), entry.bg_value);
		}

		setup_widget_value ();
		*/
	}
}

void save_config( const ConfigPointer &config )
{
	if ( ! config.null() ) {
		/*
		config->write( String( SCIM_CONFIG_IMENGINE_CHEWING_ADD_PHRASE_FORWARD ),
				__config_add_phrase_forward );

		config->write( String( SCIM_CONFIG_IMENGINE_CHEWING_PHRASE_CHOICE_REARWARD ),
				__config_phrase_choice_rearward );

		config->write( String( SCIM_CONFIG_IMENGINE_CHEWING_AUTO_SHIFT_CURSOR ),
				__config_auto_shift_cursor );

		config->write( String( SCIM_CONFIG_IMENGINE_CHEWING_ESC_CLEAN_ALL_BUFFER ),
				__config_esc_clean_all_buffer );

		config->write( String( SCIM_CONFIG_IMENGINE_CHEWING_SPACE_AS_SELECTION ),
				__config_space_as_selection );

		// SCIM_CONFIG_IMENGINE_CHEWING_USER_KB_TYPE
		int index_keymap = 
			(sizeof(builtin_keymaps) / sizeof(_builtin_keymap)) - 1;
		for ( ; index_keymap >= 0;  index_keymap--) {
			if (__config_kb_type_data_translated == 
				builtin_keymaps[index_keymap].translated_name ) {
				break;
			}
		}
		if (index_keymap < 0)
			index_keymap = 0;
		*/
		__config_kb_type_data = builtin_keymaps[index_keymap].entry;

		config->write (String (SCIM_CONFIG_IMENGINE_CHEWING_USER_KB_TYPE),
			__config_kb_type_data);
		/*
		// SCIM_CONFIG_IMENGINE_CHEWING_USER_SELECTION_KEYS
		int index_selectkeys =
			sizeof(builtin_selectkeys) / sizeof(builtin_selectkeys[0]) - 1;
		for ( ; index_selectkeys >= 0; index_selectkeys--) {
			if (__config_selKey_type_data ==
			    builtin_selectkeys[index_selectkeys]) {
				break;
			}
		}
		if (index_selectkeys < 0)
			index_selectkeys = 0;
		__config_selKey_type_data =
			builtin_selectkeys[index_selectkeys];

		config->write (String (SCIM_CONFIG_IMENGINE_CHEWING_USER_SELECTION_KEYS),
				__config_selKey_type_data);

		// SCIM_CHEWING_SELECTION_KEYS_NUM
		int index_selectkeys_num =
			sizeof(builtin_selectkeys_num) / sizeof(builtin_selectkeys_num[0]) - 1;
		for ( ; index_selectkeys_num >= 0; index_selectkeys_num--) {
			if (__config_selKey_num_data ==
			    builtin_selectkeys_num[index_selectkeys_num]) {
				break;
			}
		}
		if (index_selectkeys_num < 0)
			index_selectkeys_num = 0;
		__config_selKey_num_data =
			builtin_selectkeys_num[index_selectkeys_num];

		config->write (String (SCIM_CHEWING_SELECTION_KEYS_NUM),
		               __config_selKey_num_data);

		// SCIM_CONFIG_IMENGINE_CHEWING_CHI_ENG_MODE
		int index_chieng_mode =
			sizeof(builtin_chieng_mode) / sizeof(builtin_chieng_mode[0]) - 1;
		for ( ; index_chieng_mode >= 0; index_chieng_mode--) {
			if (__config_chieng_mode_data ==
			    builtin_chieng_mode[index_chieng_mode]) {
				break;
			}
		}
		if (index_chieng_mode < 0)
			index_chieng_mode = 0;
		__config_chieng_mode_data =
			builtin_chieng_mode[index_chieng_mode];

		config->write (String (SCIM_CONFIG_IMENGINE_CHEWING_CHI_ENG_MODE)		               , __config_chieng_mode_data);

		for (int i = 0; __config_keyboards [i].key; ++ i) {
			config->write (String (__config_keyboards [i].key),
					__config_keyboards [i].data);
		}

		for (unsigned int i = 0;
		     i < (sizeof(config_color_common) / sizeof((config_color_common)[0])); i++) {
			ColorConfigData &entry = config_color_common[i];
			if (entry.changed) {
				entry.bg_value = config->write (String (entry.bg_key),
						entry.bg_value);
			}
			entry.changed = false;
		}

		*/
	}
}

