#ifndef UIACCOUNTSETTINGS_H
#define UIACCOUNTSETTINGS_H

#include <QDialog>

#include "datatypes/account.h"
#include "datatypes/driverinfo.h"
#include "uiaddaccount.h"
#include <servicemgr.h>

namespace Ui {
    class UIAccountSettings;
}

/**
  \brief Account Settings form.

  This form shows list of registered accounts and allows to add new account,
  remove an existing account or reconnect an existing account.
  The list of accounts gets from Service Manager (see \a ServiceMgr).
  For fast account creation you can call \a UIAccountSettings::addNewAccount method.

  \see ServiceMgr
  \see UIAddAccount
  \see Account
  */
class UIAccountSettings : public QDialog
{
    Q_OBJECT

public:
    /**
      \brief Account settings form constructor.

      The constructor creates form with list of accounts. If you need
      to create an account then after that call \sa addNewAccount.
      You should call show() or \a addNewAccount to show form.

      \param sm Pointer to Service Manager (see \a ServiceMgr).

      \param parent The parent widget.
      */
    explicit UIAccountSettings(ServiceMgr *sm, QWidget *parent = 0);
    ~UIAccountSettings();

    /**
     @brief Shows settings page with add new account form.

     This function creates a new instance of \a UIAddAccount form and shows it.

    */
    void addNewAccount();

private:
    Ui::UIAccountSettings *ui;

    ServiceMgr *sm;
    QString lastSelectedAccountId;

private slots:
    void on_btnAddNew_clicked();

    void updateAccounts(QString accountName, AccountList name);

    void selectAccount();

    void on_btnRemove_clicked();

    void on_btnReconnect_clicked();

    void on_btnDisable_clicked();
};

#endif // UIACCOUNTSETTINGS_H
