#ifndef QTOPPANEL_H
#define QTOPPANEL_H

#include <QWidget>
#include <QLabel>
#include <QPushButton>
#include <QHBoxLayout>
#include <QMouseEvent>

namespace Ui {
    class QTopPanel;
}

class QTopPanel : public QWidget
{
    Q_OBJECT

public:
    explicit QTopPanel(QWidget *parent = 0);
    ~QTopPanel();

    void setPixmap(QPixmap icon);
    void setText(QString text);
    void setRefreshIcon(QIcon icon);
    void setBackIcon(QIcon icon);

    //! Set information widget

    //! \param infoWidget Widget that would be shown on mouse click.
    //!        QTop panel reparents infoWidget to itself
    void setInfoWidget(QWidget *infoWidget);
    void setBackVisible(bool visible);

private:
    QPushButton *back;
    QPushButton *refresh;
    QLabel *icon;
    QLabel *text;

    QWidget *infoWidget;

protected:
    void mousePressEvent(QMouseEvent *);

signals:
    void clicked();
    void backPressed();
    void refreshPressed();

public slots:
    void hideInfoWidget();
    void showInfoWidget();
    void toggleInfoWidget();
};

#endif // QTOPPANEL_H
