#ifndef REGIONSET_H
#define REGIONSET_H

#include <QtCore/QSharedData>
#include <QtCore/QSharedDataPointer>
#include <QtCore/QVariant>

class QPoint;
class QRect;
class RegionMapData;

//! Class for storing map from QRect to QVariant
//! Supports searching value by QPoint
class RegionMap
{
public:
    //! Default constructor
    RegionMap();

    //! Copy constructor
    RegionMap(const RegionMap&);

    //! Assignment operator
    RegionMap& operator=(const RegionMap&);

    //! Destructor
    ~RegionMap();

    //! Add new rectangle to map

    //! \param rect Rectangle
    //! \param data Value
    void addRegion(const QRect& rect, const QVariant& data);

    //! Get value assotiated with rectangle that contains given point

    //! \param p point
    //! \return value from rectangle that contains point or invalid QVariant if no
    //! rectangle contains point
    QVariant value(const QPoint& p) const;

    //! Clear region map
    void clear();

private:
    QSharedDataPointer<RegionMapData> d;
};

Q_DECLARE_METATYPE(RegionMap)

#endif // REGIONSET_H
