# -------------------------------------------------
# Project created by QtCreator 2010-08-12T14:46:35
# -------------------------------------------------
QT = core \
    gui \
    xml \
    network \
    webkit

TARGET_NAME = msaqtwidgets

unix: { 
    TARGET = $${TARGET_NAME}
} else {
    TARGET = $$qtLibraryTarget($$TARGET_NAME)
}

VERSION = 1.0.0

TEMPLATE = lib

# include private developer settings
exists(../devel.pri):include(../devel.pri)

CONFIG += link_pkgconfig \
    thread

PKGCONFIG += mysocials-core

DEFINES += msaqtwidgets_LIBRARY

OBJECTS_DIR = build

isEmpty(ENABLE_DEBUG): CONFIG += release
!isEmpty(ENABLE_DEBUG): CONFIG += debug

!isEmpty(ENABLE_DEBUG): DEFINES += DEBUG

DEFINES += LOCALDATADIR=\\\"/.msa/\\\"

isEmpty(PREFIX):PREFIX = $$[QT_INSTALL_PREFIX]
message(prefix is $$PREFIX)

DATAPREFIX = $$PREFIX/share
DEFINES += DATAPREFIX=\\\"$$DATAPREFIX\\\"
message(dataprefix is $$DATAPREFIX)
BINDIR = $$PREFIX/bin
LIBDIR = $$PREFIX/lib
!maemo5:contains(QMAKE_HOST.arch, x86_64)::LIBDIR = $$PREFIX/lib64
INCLUDEDIR = $$PREFIX/include
DATADIR = $$PREFIX/share

# meego harmattan sdk defines
exists($$QMAKE_INCDIR_QT"/../qmsystem2/qmkeys.h"):!contains(MEEGO_EDITION,harmattan): {
  MEEGO_VERSION_MAJOR     = 1
  MEEGO_VERSION_MINOR     = 2
  MEEGO_VERSION_PATCH     = 0
  MEEGO_EDITION           = harmattan
  DEFINES += MEEGO_EDITION_HARMATTAN
}

SOURCES += utils/hintedit.cpp \
    utils/QProgressIndicator.cpp \
    widgets/qmousetrackingview.cpp \
    widgets/qcommentwidget.cpp \
    widgets/qaddcomment.cpp \
    widgets/qimageviewer.cpp \
    widgets/uiaccountsettings.cpp \
    widgets/uiaddaccount.cpp \
    widgets/uihelp.cpp \
    widgets/uinetworksettings.cpp \
    widgets/qdriverslist.cpp \
    widgets/profilebrowser.cpp \
    widgets/messagebrowser.cpp \
    panels/imagebrowserpanel.cpp \
    panels/profilebrowserpanel.cpp \
    panels/messagebrowserpanel.cpp \
    widgets/qtoppanel.cpp \
    widgets/messagecomposer.cpp \
    widgets/qphotouploader.cpp \
    widgets/friends/qfriendlistwidget.cpp \
    widgets/friends/qfriendlistmodel.cpp \
    widgets/friends/qfrienddelegate.cpp \
    widgets/filter/filterpanel.cpp \
    widgets/messages/qmessagelistwidget.cpp \
    widgets/messages/qmessagedelegate.cpp \
    widgets/messages/qmessagelistmodel.cpp \
    widgets/albuminfowidget.cpp \
    widgets/qstatwidget.cpp \
    widgets/feed/feeddelegate.cpp \
    widgets/feed/feedmodel.cpp \
    panels/newsbrowserpanel.cpp \
    widgets/feed/feedview.cpp \
    widgets/feed/regionmap.cpp \
    widgets/albumlistwidget.cpp \
    widgets/photolistwidget.cpp \
    widgets/albumselectdialog.cpp

HEADER_WIDGETS_FILTER = widgets/filter/filterpanel.h

HEADER_CORE = config.h

HEADER_UTILS = utils/hintedit.h \
    utils/QProgressIndicator.h \
    utils/fullscreenexitbutton.h

HEADER_WIDGETS = widgets/qmousetrackingview.h \
    widgets/qcommentwidget.h \
    widgets/qaddcomment.h \
    widgets/qimageviewer.h \
    widgets/uiaccountsettings.h \
    widgets/uiaddaccount.h \
    widgets/uihelp.h \
    widgets/uinetworksettings.h \
    widgets/qdriverslist.h \
    widgets/qtoppanel.h \
    widgets/profilebrowser.h \
    widgets/messagebrowser.h \
    widgets/messagecomposer.h \
    widgets/qphotouploader.h \
    widgets/albuminfowidget.h \
    widgets/qstatwidget.h \
    widgets/albumlistwidget.h \
    widgets/photolistwidget.h

HEADER_WIDGETS_FRIENDS = widgets/friends/qfrienddelegate.h \
    widgets/friends/qfriendlistmodel.h \
    widgets/friends/qfriendlistwidget.h

HEADER_WIDGETS_MESSAGES = widgets/messages/qmessagelistwidget.h \
    widgets/messages/qmessagedelegate.h \
    widgets/messages/qmessagelistmodel.h

HEADER_WIDGETS_FEED = widgets/feed/feeddelegate.h \
    widgets/feed/feedmodel.h \
    widgets/feed/feedview.h \
    widgets/feed/regionmap.h

HEADER_PANELS = panels/imagebrowserpanel.h \
    panels/profilebrowserpanel.h \
    panels/messagebrowserpanel.h \
    panels/newsbrowserpanel.h

HEADERS += $$HEADER_UTILS \
    $$HEADER_CORE \
    $$HEADER_WIDGETS \
    $$HEADER_WIDGETS_FRIENDS \
    $$HEADER_WIDGETS_MESSAGES \
    $$HEADER_PANELS \
    $$HEADER_WIDGETS_FILTER \
    $$HEADER_WIDGETS_FEED \
    widgets/albumselectdialog.h

FORMS += widgets/qaddcomment.ui \
    widgets/uiaccountsettings.ui \
    widgets/uiaddaccount.ui \
    widgets/uihelp.ui \
    widgets/uinetworksettings.ui \
    widgets/qdriverslist.ui \
    widgets/profilebrowser.ui \
    widgets/messagebrowser.ui \
    panels/imagebrowserpanel.ui \
    panels/profilebrowserpanel.ui \
    panels/messagebrowserpanel.ui \
    widgets/messagecomposer.ui \
    widgets/qphotouploader.ui \
    widgets/friends/qfriendlistwidget.ui \
    widgets/messages/qmessagelistwidget.ui \
    widgets/qstatwidget.ui \
    widgets/albumselectdialog.ui

CODECFORSRC = UTF-8

TRANSLATIONS = ../translations/$${TARGET_NAME}_ru.ts

system("sed -e 's:@prefix@:$$PREFIX:g;s:@exec_prefix@:$$BINDIR:g;s:@libdir@:$$LIBDIR:g;s:@includedir@:$$INCLUDEDIR/mysocials/qtwidgets:g;s:@VERSION@:$$VERSION:g' ../data/msaqtwidgets.pc.in >../data/msaqtwidgets.pc")

# make install
INSTALLS += target \
    pkgconfig \
    header_core \
    header_utils \
    header_widgets \
    header_panels \
    translations

target.path = $$LIBDIR

pkgconfig.path = $$LIBDIR/pkgconfig
pkgconfig.files = ../data/*.pc

translations.path = $$DATADIR/qt4/translations/
translations.files = ../translations/*.qm

header_core.path = $$INCLUDEDIR/mysocials/qtwidgets
header_core.files = $$HEADER_CORE

header_utils.path = $$INCLUDEDIR/mysocials/qtwidgets/utils
header_utils.files = $$HEADER_UTILS

header_widgets.path = $$INCLUDEDIR/mysocials/qtwidgets/widgets
header_widgets.files = $$HEADER_WIDGETS

header_panels.path = $$INCLUDEDIR/mysocials/qtwidgets/panels
header_panels.files = $$HEADER_PANELS

header_widgets_filter.path = $$INCLUDEDIR/mysocials/qtwidgets/widgets/filter
header_widgets_filter.files = $$HEADER_WIDGETS_FILTER
INSTALLS += header_widgets_filter

header_widgets_friends.path = $$INCLUDEDIR/mysocials/qtwidgets/widgets/friends
header_widgets_friends.files = $$HEADER_WIDGETS_FRIENDS
INSTALLS += header_widgets_friends

header_widgets_messages.path = $$INCLUDEDIR/mysocials/qtwidgets/widgets/messages
header_widgets_messages.files = $$HEADER_WIDGETS_MESSAGES
INSTALLS += header_widgets_messages

# library documentation
htmldocs.path = $$DATADIR/doc/msaqtwidgets
htmldocs.files = ../doc/html*
INSTALLS += htmldocs

qtdocs.path = $$DATADIR/qt4/doc/qch
qtdocs.files = ../doc/*.qch
INSTALLS += qtdocs

