#ifndef QMOUSETRACKINGWIDGET_H
#define QMOUSETRACKINGWIDGET_H

/**
  \file qmousetrackingview.h
  \author MySocials Team
  \date 2011-03-24
  */

#include <QWidget>
#include <QMouseEvent>
#include <QDebug>
#include <QGraphicsView>
#include <QApplication>
#include <QScrollBar>
#include <QMouseEvent>

/**
  \def NUM_MOVE_EVENTS
  \brief The minimum number of tracking events.

  This number used to define moving direction. The default value is 10.
  For mobile platform it is 5.
  */
#if defined(Q_WS_MAEMO_5) || defined(MEEGO_EDITION_HARMATTAN)
#define NUM_MOVE_EVENTS 5
#else
#define NUM_MOVE_EVENTS 10
#endif

/**
  \brief QGraphicsView with mouse tracking.

  This class implements mouse tracking on QGraphicsView.
It defines moving direction and double clicking.
  */
class QMouseTrackingView : public QGraphicsView
{
    Q_OBJECT

public:
    /**
      \brief The default constructor.

      \param scene The pointer to used scene.

      \param parent The pointer to parent widget.
      */
    QMouseTrackingView(QGraphicsScene *scene, QWidget *parent);

    /**
      \brief Reset mouse tracking.

      Ereases previous mouse moving.
      */
    void reset();

private:
    QList<QPoint> mousePoints;

    void getDirection();
    QMouseEvent lastMouseEvent;
    void storeMouseEvent(QMouseEvent *event);

signals:
    void mouseDragged(Qt::ArrowType);
    void mouseDoubleClick();

private slots:
    void mouseMoveEvent(QMouseEvent *);
    void mousePressEvent(QMouseEvent *);
    void mouseReleaseEvent(QMouseEvent *event);
    void mouseDoubleClickEvent(QMouseEvent *event);

};

#endif // QMOUSETRACKINGWIDGET_H
