#include "mainwindow.h"
#include "ui_mainwindow.h"

#include <QPushButton>
#include <QStringListModel>

#include <widgets/friends/qfriendlistwidget.h>

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    sm = new ServiceMgr(this);

    QFriendListWidget *wdt = new QFriendListWidget(sm, this);

    this->setCentralWidget(wdt);
    wdt->show();

//    connect(sm, SIGNAL(updateFriends(FriendList,bool)), this, SLOT(updateFriends(FriendList, bool)));
    connect(sm, SIGNAL(updateAccounts(QString,AccountList)), this, SLOT(updateAccounts(QString,AccountList)));

}

MainWindow::~MainWindow()
{
    delete ui;
}


//void MainWindow::updateFriends(FriendList list, bool isLastUpdate)
//{
//    model->setList(list);
//}

void MainWindow::updateAccounts(QString, AccountList)
{
    sm->getFriends(true, false);
}

/*
void MainWindow::itemSelected(const QModelIndex &in)
{
    Friend fr = in.data(Qt::UserRole).value<Friend>();

    qDebug() << "selected" << fr.name() << fr.ownerId;
    model->dataChanged(in);
}
*/
