#include "qstatwidget.h"
#include "ui_qstatwidget.h"

QStatWidget::QStatWidget(QFont textFont, ServiceMgr *smgr, QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::QStatWidget), sm(smgr)
{
    ui->setupUi(this);
    ui->totalLbl->setFont(textFont);
    ui->accountsLbl->setFont(textFont);
    updateStats();
}

QStatWidget::~QStatWidget()
{
    delete ui;
}

QString QStatWidget::userFriendlySize(long val)
{
    int count = 0;
    while(val > 1024)
    {
        val /= 1024;
        count++;
        if (count >= 4) break; //terabytes is enouth? -- no!
    }

    QString ret = QString::number(val) + " ";
    switch(count)
    {
    case 0: ret.append(tr("byte(s)")); break;
    case 1: ret.append(tr("kilobyte(s)")); break;
    case 2: ret.append(tr("megabyte(s)")); break;
    case 3: ret.append(tr("gigabyte(s)")); break;
    case 4: ret.append(tr("terabyte(s)")); break;
    default:
        ret.append("Unknown value(s)"); break;
    }

    return ret;
}

void QStatWidget::updateStats()
{
    QList<QStatInfo> stats = this->sm->getStats();
    QString txt = "<h2>" + tr("Common statistics") + "</h2><ul>";
    QString perAccount = "<h2>" + tr("Account statistics") + "</h2>";
    int requests = 0;
    int totalRequests = 0;
    long download = 0;
    long totalDownload = 0;
    long upload = 0;
    long totalUpload = 0;
    int errors = 0;
    int totalErrors = 0;

    for (int i = 0; i < stats.length(); i++)
    {
        requests += stats.at(i).requests();
        download += stats.at(i).download();
        upload += stats.at(i).upload();
        errors += stats.at(i).errors();

        QStatInfo ttlInfo = stats[i].getTotal();
        totalRequests += ttlInfo.requests();
        totalDownload += ttlInfo.download();
        totalUpload += ttlInfo.upload();
        totalErrors += ttlInfo.errors();

        perAccount.append("<h3>" + stats.at(i).accountId() + "</h3><ul>");
        perAccount.append("<li>" + tr("Requests") + ": " + QString::number(stats.at(i).requests()) + " (" + QString::number(ttlInfo.requests()) + ")");
        perAccount.append("<li>" + tr("Download") + ": " + userFriendlySize(stats.at(i).download()) + " (" + userFriendlySize(ttlInfo.download()) + ")");
        perAccount.append("<li>" + tr("Upload") + ": " + userFriendlySize(stats.at(i).upload()) + " (" + userFriendlySize(ttlInfo.upload()) + ")");
        perAccount.append("<li>" + tr("Errors") + ": " + QString::number(stats.at(i).errors()) + " (" + QString::number(ttlInfo.errors()) + ")");
        perAccount.append("</ul>");
    }

    txt.append("<li>" + tr("Requests") + ": " + QString::number(requests) + " (" + QString::number(totalRequests) + ")");
    txt.append("<li>" + tr("Download") + ": " + userFriendlySize(download) + " (" + userFriendlySize(totalDownload) + ")");
    txt.append("<li>" + tr("Upload") + ": " + userFriendlySize(upload) + " (" + userFriendlySize(totalUpload) + ")");
    txt.append("<li>" + tr("Errors") + ": " + QString::number(errors) + " (" + QString::number(totalErrors) + ")");
    txt.append("</ul>");

    qDebug() << txt;
    qDebug() << perAccount;
    this->ui->totalLbl->setText(txt);
    this->ui->accountsLbl->setText(perAccount);
}
