#ifndef QPHOTOUPLOADER_H
#define QPHOTOUPLOADER_H

#define ALWAYS_UPDATE
#include <QDialog>
#include <QFileDialog>
#include <QContextMenuEvent>
#include <QComboBox>

#include "datatypes/account.h"
#include "datatypes/driverinfo.h"
#include "uiaddaccount.h"

#include <servicemgr.h>

namespace Ui {
    class QPhotoUploader;
}


class QPhotoUploader : public QDialog
{
    Q_OBJECT

public:
    typedef struct _FileInfo {
        QString path;
        QString shotName;
        QString description;
        qint64 size;
    } FileInfo;


    explicit QPhotoUploader(ServiceMgr *sm, QWidget *parent = 0);
    ~QPhotoUploader();

    /**
     * @brief shows settings page with add new account form
     *
    */
    void addNewAccount();

signals:
    void startUploadSignal();
    void refreshPressed();

private:
    QAction *actionEdit;
    QAction *actionDelete;
    bool cancel;

    void updateAlbums();
    QString getHumanSize(qint64 size);
    QString getShotName(QString name);
    Ui::QPhotoUploader *ui;
    qint64 totalSize;
    bool refreshStarted;

    ServiceMgr *sm;
    QString accountId;
    QString albumId;

private slots:
    void on_addNewAlbumButton_clicked();
    void on_refreshAlbumsButton_clicked();
    void on_cancelButton_clicked();
    void on_uploadButton_clicked();
    void on_photoOpen_clicked();
    void enableUpload();
    void startUpload();
    void deleteItem();
    void editItem();
    void updateTotalSize();

    void setRefreshIcon(QIcon icon);
    void updateAccounts(AccountList);
    void updateAlbumList(QString,AlbumList,bool);
    void selectAccount(int);

    void uploaded(QString accountId, QString albumId, QString file_name, QString photoId);
    void errorOccured(QString, QTransport::Action);


public slots:
#ifndef ALWAYS_UPDATE
    void resizeEvent(QResizeEvent *);
#endif

};

#endif // QPHOTOUPLOADER_H
