/**
  \file messagecomposer.h
  \brief MessageComposer class description
  \author MySocials team
  \date 2011-03-23
  */
#ifndef MESSAGECOMPOSER_H
#define MESSAGECOMPOSER_H

#include <QWidget>
#include <QPushButton>

#include "datatypes/message.h"
#include "datatypes/friend.h"

#include "servicemgr.h"

namespace Ui {
    class MessageComposer;
}

/*!
 \class MessageComposer
 \brief Widget for creating messages.

 This class is using for creating new messages. Also it allows to save drafts of
 messages.

 \see Message
 */
class MessageComposer : public QWidget
{
    Q_OBJECT
public:
    /*!
     \brief A MessageComposer constructor.

     \param parent Pointer to parent widget.
     */
    explicit MessageComposer(QWidget *parent = 0);

    /*!
     \brief A MessageComposer constructor.

     \param sm Pointer to Service Manages.

     \param parent Pointer to parent widget.
     */
    explicit MessageComposer(ServiceMgr *sm, QWidget *parent = 0);

    //! A destructor.
    ~MessageComposer();

    /*!
     \brief Initialization function.

     Initialaizes UI elements of widget and connects signals.
     */
    void init();

    /*!
     \brief Clears all fields of message form.
     */
    void resetMessage();

    /*!
     \brief Sets recepient for message.

     \param fd Recepient.
     */
    void setRecepient(Friend fd);

    /*!
     \brief Sets recepient for message.

     \param fd ID of recepient.
     */
    void setRecepient(QString ownerId);

    /*!
     \brief Sets title of message.

     \param title Message title.
     */
    void setTitle(QString title);

    /*!
     \brief Sets body of message.

     \param text Text of message.
     */
    void setMessageBody(QString text);

    /*!
     \brief It is using for replying messa.

     \param msg Message on which we reply.
     */
    void replyMessage(Message msg);

signals:
    void messageSent();

    /*!
     This signal is emmited when user tries to save draft of message.

     \param msg Message which we wanna save
     */
    void saveMessage(Message msg);

public slots:

private:
    QPushButton *buttonSend;
    QPushButton *buttonSave;

    ServiceMgr *sm;
    Ui::MessageComposer *ui;

    void fillFriendList(FriendList fr);

private slots:
    void sendMessage();
    void saveMessage();
    void updateFriendList(FriendList list, bool isLastUpdate);

};

#endif // MESSAGECOMPOSER_H
