#include "albuminfowidget.h"

#include <QVBoxLayout>
#include <QDateTime>
#include <QtDebug>

AlbumInfoWidget::AlbumInfoWidget(QWidget *parent) :
    QWidget(parent)
{
    QVBoxLayout* layout = new QVBoxLayout;
    this->mLabel = new QLabel;
    layout->addWidget(this->mLabel);
    setLayout(layout);
}

void AlbumInfoWidget::setAlbum(Album album)
{
    QString txt = "<b>" + tr("Title:") + "</b> " + album.title();

    if (!album.description().isEmpty())
        txt.append("<br><b>" + tr("Description:") + "</b> " + album.description());

    if (!album.time_create().isEmpty())
        txt.append("<br><b>" + tr("Created:") + "</b> " + convertMsaDate(album.time_create()));

    if (!album.time_update().isEmpty())
        txt.append("<br><b>" + tr("Updated:") + "</b> " + convertMsaDate(album.time_create()));

    this->mLabel->setText(txt);
}

QString AlbumInfoWidget::convertMsaDate(const QString &date)
{
    QDateTime datetime = QDateTime::fromString(date, "dd.MM.yyyy HH:mm:ss");

    if (!datetime.isValid())
        return QString();
    else
        return datetime.toString();
}
