#include "uiaccountsettings.h"
#include "ui_uiaccountsettings.h"

UIAccountSettings::UIAccountSettings(ServiceMgr *sm, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::UIAccountSettings)
{
    ui->setupUi(this);
    this->sm = sm;

    AccountList acc = this->sm->getAccounts();
    this->updateAccounts(QString::null, acc);

    connect(this->sm, SIGNAL(updateAccounts(QString,AccountList)), this, SLOT(updateAccounts(QString,AccountList)));
    connect(this->ui->listSettings, SIGNAL(itemSelectionChanged()), this, SLOT(selectAccount()));
}

UIAccountSettings::~UIAccountSettings()
{
    delete ui;
}

void UIAccountSettings::on_btnAddNew_clicked() {
    UIAddAccount *drvForm = new UIAddAccount(this->sm, this);
    drvForm->setModal(true);
    drvForm->show();
}

void UIAccountSettings::updateAccounts(QString, AccountList acc)
{
    this->ui->listSettings->clear();
    for (int i = 0; i < acc.length(); i++) {
        DriverInfo *info = acc.at(i)->transport->getDriverInfo();
        Account *curAcc = acc.at(i);
        QString title = curAcc->transport->accountId() + " (" + info->name + ")\n" +
                        curAcc->getProfile(false).name();
        if (!curAcc->isNetworkEnabled && !curAcc->isDisabled())
            title += tr(" (offline mode)");
        if (acc.at(i)->isDisabled())
            title += " (" + tr("disabled") + ")";

        QListWidgetItem *item = new QListWidgetItem(title, this->ui->listSettings);
        QIcon curIcon(curAcc->getProfile(false).icon());
        if (curIcon.isNull())
            item->setIcon(info->icon);
        else
            item->setIcon(curIcon);
        QVariant v;
        v.setValue(curAcc);
        item->setData(Qt::UserRole, v);
        if (curAcc->accountId() == lastSelectedAccountId)
            item->setSelected(true);
    }
}

void UIAccountSettings::selectAccount()
{
    this->ui->btnRemove->setEnabled(true);
    this->ui->btnDisable->setEnabled(true);

    QList<QListWidgetItem *> selItems = this->ui->listSettings->selectedItems();
    for (int i = 0; i < selItems.length(); i++) {
        QVariant v = selItems[i]->data(Qt::UserRole);
        if (v.canConvert<Account *>()) {
            Account * fd = v.value<Account *>();
            lastSelectedAccountId = fd->accountId();
            if (!fd->isDisabled())
            {
                this->ui->btnReconnect->setEnabled(true);
                this->ui->btnDisable->setText(tr("Disable"));
            } else {
                this->ui->btnReconnect->setEnabled(false);
                this->ui->btnDisable->setText(tr("Enable"));
            }
            return;
        }
    }
}

void UIAccountSettings::on_btnRemove_clicked()
{
    QList<QListWidgetItem *> selItems = this->ui->listSettings->selectedItems();
    for (int i = 0; i < selItems.length(); i++) {
        QVariant v = selItems[i]->data(Qt::UserRole);
        if (v.canConvert<Account *>()) {
            Account * fd = v.value<Account *>();
            this->sm->deleteAccount(fd);
            return;
        }
    }
}

void UIAccountSettings::on_btnReconnect_clicked()
{
    QList<QListWidgetItem *> selItems = this->ui->listSettings->selectedItems();
    for (int i = 0; i < selItems.length(); i++) {
        QVariant v = selItems[i]->data(Qt::UserRole);
        if (v.canConvert<Account *>()) {
            Account * fd = v.value<Account *>();
            if (!fd->isDisabled())
            {
                fd->isFirstRequest = true;
                fd->getProfile(true);
            }
            return;
        }
    }
}

void UIAccountSettings::on_btnDisable_clicked()
{
    QList<QListWidgetItem *> selItems = this->ui->listSettings->selectedItems();
    for (int i = 0; i < selItems.length(); i++) {
        QVariant v = selItems[i]->data(Qt::UserRole);
        if (v.canConvert<Account *>()) {
            Account * fd = v.value<Account *>();
            fd->setDisabled(!fd->isDisabled());
            this->sm->updateAccount(fd);
            return;
        }
    }
}

void UIAccountSettings::addNewAccount()
{
    this->show();
    this->on_btnAddNew_clicked();
}
