#include "qfrienddelegate.h"

#include <QPainter>
#include <QDebug>
#include <QListView>
#include <datatypes/friend.h>

#include "config.h"

QFriendDelegate::QFriendDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
    this->online.load(":/res/online.png");
}

void QFriendDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const
{
    Friend fr = index.data(Qt::UserRole).value<Friend>();

    QRect r = option.rect.adjusted(2, 2, -2, -2);

    // highlght selected items
    if (option.state & QStyle::State_Selected)
        painter->fillRect(option.rect, option.palette.highlight());

    // show icon
    QPixmap im(fr.icon());
    if (im.isNull())
        im = QIcon::fromTheme("general_default_avatar", QIcon(":/res/general_default_avatar.png")).pixmap(50, 50);

    if (!im.isNull())
    {
        if (im.width() > im.height())
            im = im.copy((im.width() - im.height()) / 2, 0, im.height(), im.height());

        if (im.height() > im.width())
            im = im.copy(0, (im.height() - im.width()) / 2, im.width(), im.width());

        im = im.scaled(QSize(ITEM_HEIGHT, ITEM_HEIGHT), Qt::KeepAspectRatio, Qt::SmoothTransformation);

        painter->drawPixmap(r.left(), r.top(), im.width(), ITEM_HEIGHT, im);
        r = r.adjusted(ITEM_HEIGHT + 3, 0, 0, 0);
    }

    //calc vertical size
    int lines = 1;

    if (fr.online())
        lines++;

    float topPoint = (r.height() - lines * option.fontMetrics.height()) / 2 + r.top();

    // show name
    painter->drawText(r.left(), topPoint, r.width(),
                      option.fontMetrics.height(),
                      Qt::AlignVCenter|Qt::AlignLeft,
                      fr.name(), &r);

    topPoint += option.fontMetrics.height();

    if (fr.online())
    {
        QImage img(this->online);
        if (img.height() > option.fontMetrics.height())
              img = img.scaledToHeight(option.fontMetrics.height());

        painter->drawImage(r.left(), topPoint, img);

        painter->drawText(r.left() + img.width() + 2, topPoint, r.width(),
                          option.fontMetrics.height(),
                          Qt::AlignVCenter|Qt::AlignLeft,
                          tr("online"));
    }
}

QSize QFriendDelegate::sizeHint ( const QStyleOptionViewItem & option, const QModelIndex & index ) const
{
    float rw = float(((QListView*)parent())->viewport()->size().width());

    qDebug() << __FILE__ <<__LINE__ << __FUNCTION__ << " optionfont=" << option.font.pointSize();

    return QSize(rw > 200 ? rw : 200,
                 2 * option.fontMetrics.height() > ITEM_HEIGHT ? 2 * option.fontMetrics.height() : ITEM_HEIGHT + 4);
}

