 #ifndef NEWSBROWSERPANEL_H
#define NEWSBROWSERPANEL_H

#include <QtGui/QWidget>
#include <QtGui/QIcon>
#include <QtCore/QList>

#include "datatypes/qeventfeed.h"
#include "datatypes/photo.h"

class QLayout;
class QVBoxLayout;
class QHBoxLayout;
class ServiceMgr;
class QListView;
class QPushButton;
class QToolBar;
class QActionGroup;
class FeedModel;
class QLabel;

class NewsBrowserPanel : public QWidget
{
    Q_OBJECT

public:
    explicit NewsBrowserPanel(ServiceMgr* mgr, QWidget* parent = 0);
    ~NewsBrowserPanel();

    static QIcon getIconByFeedType(QEventFeed::FeedType feedType);

public slots:
    void reloadFeeds(bool update = true);
    void updateButtonIcon(QEventFeedList, QEventFeed::FeedType, bool isLastUpdate);
    void addFeedType(QEventFeed::FeedType);
    void setFeedTypeState(QAction* action);
    void setNewsCount(int count);

signals:
    void openImage(Photo photo);

private:
    void createLayouts();
    void createListView();
    void initializeModel();
    void createButtons();
    void createFilterPanel();

private:
    ServiceMgr* mServiceMgr;

    QVBoxLayout* mMainLayout;
    QLayout* mFiltersLayout;
    QLayout* mNewsLayout;
    QHBoxLayout* mTopLayout;
    QHBoxLayout* mBottomLayout;

    FeedModel* mModel;
    QListView* mNewsList;

    QPushButton* mReloadButton;
    QLabel* mCountLabel;

    const QIcon buttonIconRefresh;
    const QIcon buttonIconStop;

    QToolBar* mFiltersToolbar;
    QActionGroup* mFilterActions;
};

#endif // NEWSBROWSERPANEL_H
