#!/usr/bin/python

import pygame
import pygame.mixer
import pygame.locals
import threading
import time
import osso
import hildon

#import gtk
#import gobject

class mSaber():
  def __init__(self):
    pygame.init()
    
    print pygame.display.get_wm_info()
    
    self.screen = pygame.display.set_mode((800, 480),pygame.FULLSCREEN)
#    pygame.display.toggle_fullscreen()
    pygame.display.set_caption('mSaber')

    self.background = pygame.Surface(self.screen.get_size())
    self.background = self.background.convert()
    self.background.fill((0, 0, 0))
  
    self.screen.blit(self.background, (0, 0))
    pygame.display.flip()
 
    self.img_saber_on = pygame.image.load('/usr/lib/msaber/saber_on.png')
    self.img_saber_off = pygame.image.load('/usr/lib/msaber/saber_off.png')

    self.screen.blit(self.img_saber_off,(450,50))
    pygame.display.flip()
    
    #self.timer = gobject.timeout_add(50, self.update)
    self.x = None
    self.y = None
    self.z = None    
#    while(True):
#      self.update()
#      time.sleep(0.1)
    
    self.on = False
    
    self.poweron = pygame.mixer.Sound('/usr/lib/msaber/cb_ls_powerup.wav')
    self.poweroff = pygame.mixer.Sound('/usr/lib/msaber/cb_ls_powerdown.wav')
    
    self.short1 = pygame.mixer.Sound('/usr/lib/msaber/cb_ls_swingshrt1.wav')
    self.long1 = pygame.mixer.Sound('/usr/lib/msaber/cb_ls_swinglong1.wav')
    self.short2 = pygame.mixer.Sound('/usr/lib/msaber/cb_ls_swingshrt2.wav')
    self.long2 = pygame.mixer.Sound('/usr/lib/msaber/cb_ls_swinglong2.wav')
    self.short3 = pygame.mixer.Sound('/usr/lib/msaber/cb_ls_swingshrt3.wav')
    self.long3 = pygame.mixer.Sound('/usr/lib/msaber/cb_ls_swinglong3.wav')  

    self.bg_snd = pygame.mixer.Sound('/usr/lib/msaber/cb_ls_humgood.wav')

    self.loop()    
#    self.saber_off()

  def loop(self):
    clock = pygame.time.Clock()
    while 1:
      self.update()
      for event in pygame.event.get():
        if event.type == pygame.QUIT:
            return
        elif event.type == pygame.KEYDOWN and event.key == pygame.K_ESCAPE:
            return
        elif event.type == pygame.MOUSEBUTTONDOWN:
            if self.on==True:
              self.saber_off()
            else:
              self.saber_on()
    
      clock.tick(25) #25 frame per seconds (accelerometers limit)
  
  def saber_on(self):
    self.poweron.play()
    self.bg_snd.set_volume(0.5)
    self.bg_snd.play(-1)
    self.screen.blit(self.background, (0, 0))
    self.screen.blit(self.img_saber_on,(150,50))
    pygame.display.flip()

    self.on = True

  def saber_off(self):
    self.screen.blit(self.background, (0, 0))
    self.screen.blit(self.img_saber_off,(450,50))
    pygame.display.flip()
    self.poweroff.play()
    self.bg_snd.stop()

    self.on=False

  def get_rotation(self):
    f = open("/sys/class/i2c-adapter/i2c-3/3-001d/coord", 'r' )
    coords = [int(w) for w in f.readline().split()]
    f.close()
    return coords

  def get_move(self):
    try:
      x,y,z = self.get_rotation()
    except StandardError,e:
       print e
       import traceback
       print traceback.print_exc()
       x,y,z = (0,0,0)
    if self.x == None:
      self.x = x
      movx = 0
    else:
      movx = self.x - x
      self.x = x
      
    if self.y == None:
      self.y = y
      movy = 0
    else:
      movy = self.y - y
      self.y = y

    if self.z == None:
      self.z = z
      movz = 0  
    else:
      movz = self.z - z
      self.z = z
      
    return (movx,movy,movz)

  def update(self,*args):
    if self.on==True:
      x,y,z = self.get_move()
      if abs(x) > 750:
        self.short1.play()
      elif abs(x) > 200:
        self.long1.play()
      elif abs(y) > 750:
        self.short2.play()
      elif abs(y) > 200:
        self.long2.play()
      elif abs(z) > 750:
        self.short3.play()
      elif abs(z) > 200:
        self.long3.play()  
    return True

if __name__ == "__main__":
  pygame.mixer.init()
  m = mSaber()