#define CTF_LOG_FORMAT_USE_TIME
#define CTF_THROW_EXIT

#include "../CTF/src/ctf.h"
#include <drivers/vkontakte/driver.h>
#include <drivers/vkontakte/vkontakte.h>
#include <drivers/vkontakte/parser.h>
#include <kernel/general.h>
#include <kernel/dispatcher.h>
#include <msa_module.h>
#include <gconf/gconf-client.h>
#include <glib.h>

#define XML_RESPONSE_FILE "response.xml"
#define REQUEST_UPDATE_PROFILE "<Request class=\"profile\" function = \"updateProfile\"><Params></Params></Request>"
#define REQUEST_SET_SETTINGS "<Request class=\"settings\" function = \"setSettings\"><Params><string name=\"login\">email_vk@mail.ru</string><string name=\"password\">email_vk</string><string name=\"autoupdate\">10</string><string name=\"active\">1</string></Params></Request>"

#define JSON1 "[[86454,\"��������� �������\",\"http:\/\/cs02.vk470e7.jpg\",0],[30269836,\"������ �������\",\"http:\/\/cs1894.vkontakte.ru\/u30269836\/b_360d6e12.jpg\",0],[39578937,\"Raven Varikset\",\"http:\/\/cs734.vkontakte.ru\/u39578937\/b_d0a2d693.jpg\",0],[39662875,\"Panda Fake\",\"http:\/\/cs765.vkontakte.ru\/u39662875\/b_254479b0.jpg\",0]]"

GLOBAL_DECL();

CTF_TEST_DATA_FILE_NAME_DECL;
CTF_STAT_FILE_NAME_DECL;

CTF_TEST_CASE(network_test) {
    CTF_TEST_NAME("http_get_test");
    char* header = NULL;
    char* body = NULL;
    int code = 0;
    code = http_get(CTF_TEST_DATA("URL_TEST"), CTF_TEST_DATA("PROXY"), atoi(CTF_TEST_DATA("PORT")), &header, &body);
    CTF_CHECK(header != NULL);
    CTF_CHECK(body != NULL);
    CTF_CHECK(code != 0);
}

CTF_TEST_CASE(xml_request_test) {
     CTF_TEST_NAME("make_url_test1");
     char* url = NULL;
     xmlDocPtr reqXml;
     reqXml = xmlParseDoc(REQUEST_UPDATE_PROFILE);
     url = make_url(reqXml, CTF_TEST_DATA("MID"), CTF_TEST_DATA("SID"));
     CTF_CHECK(!strcmp(url, CTF_TEST_DATA("URL_PROFILE")));

     
     CTF_TEST_NAME("make_url_test2");
     url = NULL;
     url = make_url(NULL, CTF_TEST_DATA("MID"), CTF_TEST_DATA("SID"));
     CTF_CHECK(url == NULL);

     
    CTF_TEST_NAME("request_class_test1");
    char* class;
    char* function;
    reqXml = NULL;
    reqXml = xmlParseDoc(REQUEST_UPDATE_PROFILE);
    class = get_req_class(reqXml);
    function = get_req_function(reqXml);
    CTF_CHECK(!strcmp(class, CTF_TEST_DATA("CLASS_PROFILE")) );
    CTF_CHECK(!strcmp(function, CTF_TEST_DATA("FUNCTION_UPDATE_PROFILE")) );

    CTF_TEST_NAME("request_class_test2");
    reqXml = NULL;
    class = NULL;
    function = NULL;
    class = get_req_class(reqXml);
    function = get_req_function(reqXml);
    CTF_CHECK(class == NULL);
    CTF_CHECK(function == NULL);
    
}


CTF_TEST_CASE(init_test) {
    CTF_TEST_NAME("init_test");
    char* mid = NULL;
    char* sid = NULL;
    int res;
    g_type_init();

    GConfClient* client;
    client = gconf_client_get_default ();

    res = initialization(&mid, &sid);
    if(res == 0) {
        CTF_CHECK(mid != NULL);
        CTF_CHECK(sid != NULL);
    } else {
	CTF_CHECK(res == 1);
        mid = gconf_client_get_string (client, g_strconcat(PATH, REMIXMID, NULL), NULL);
        sid = gconf_client_get_string (client, g_strconcat(PATH, REMIXSID, NULL), NULL);
        CTF_CHECK(mid == NULL);
        CTF_CHECK(sid == NULL);
    }
}


CTF_TEST_CASE(get_binary_data_test){
    CTF_TEST_NAME("get_binary_data_test");
    char* response = NULL;
    char* url = NULL;
    xmlDocPtr reqXml;

    reqXml = xmlParseDoc("<Request class=\"binaryData\" function=\"getBinaryData\"><Params><img name=\"Img\" uri=\"http://cs02.vkontakte.ru/u86454/b_f1470e7.jpg\"/></Params></Request>");

    url = make_url(reqXml, CTF_TEST_DATA("MID"), CTF_TEST_DATA("SID"));

    g_debug(url);
    CTF_CHECK(strcmp(url, "http://cs02.vkontakte.ru/u86454/b_f1470e7.jpg") == 0);
    http_get(url, "proxy.karelia.ru", 81, NULL, &response);
    CTF_CHECK(response != NULL);

}

CTF_TEST_CASE(settings_test) {
    CTF_TEST_NAME("set_settings_test");
    g_type_init();
    char* login;
    char* passw;
    char* mid;
    char* sid;
    int autoupdate = 0;
    int active = 0;
    xmlDocPtr reqXml, doc;
    GConfClient* client;
    xmlNodePtr rootNode, childNode, node;
    
    client = gconf_client_get_default ();
    reqXml = xmlParseDoc(REQUEST_SET_SETTINGS);
    set_settings (reqXml, doc, NULL);
    login = gconf_client_get_string (client, g_strconcat(PATH, LOGIN, NULL), NULL);
    passw = gconf_client_get_string (client, g_strconcat(PATH, PASSWORD, NULL), NULL);
    active = gconf_client_get_int (client, g_strconcat(PATH, STATUS, NULL), NULL);
    autoupdate = gconf_client_get_int (client, g_strconcat(PATH, AUTOUPDATE, NULL) , NULL);
		 
    CTF_CHECK(!strcmp(login, CTF_TEST_DATA("LOGIN")) );
    CTF_CHECK(!strcmp(passw, CTF_TEST_DATA("PASSWORD")) );
    CTF_CHECK(active == 1);
    CTF_CHECK(autoupdate == 10);

    mid = NULL;
    sid = NULL;
    mid = gconf_client_get_string (client, g_strconcat(PATH, REMIXMID, NULL), NULL);
    sid = gconf_client_get_string (client, g_strconcat(PATH, REMIXSID, NULL), NULL);

    CTF_CHECK(mid == NULL);
    CTF_CHECK(sid == NULL);
    
}

CTF_TEST_CASE(check_json_test) {
    CTF_TEST_NAME("check_json_test");
    int status = 0;
    char* json;

    json = g_strdup(JSON1);
    status = check(json);
    CTF_CHECK(status == 0 );    
    
    status = check(CTF_TEST_DATA("JSON_1"));
    CTF_CHECK(status == 1 );

    status = check(CTF_TEST_DATA("JSON_2"));
    CTF_CHECK(status == 0)
    g_debug("status %d", status);
	    
    json = g_strdup(CTF_TEST_DATA("JSON_3"));
    status = check(json);
    CTF_CHECK(status == -2 );

    json = g_strdup(CTF_TEST_DATA("JSON_4"));
    status = check(json);
    CTF_CHECK(status == 0 );
}

CTF_TEST_CASE(authorization_test) {
    CTF_TEST_NAME("authorization_test1");
    char* mid;
    int code = 0;
    GConfClient* client;

	
    g_type_init();
    client = gconf_client_get_default ();

    if (authorize(CTF_TEST_DATA("LOGIN"), CTF_TEST_DATA("PASSWORD")) == 0) {
        mid = gconf_client_get_string (client, g_strconcat(PATH, REMIXMID, NULL), NULL);
        CTF_CHECK(!strcmp(mid, CTF_TEST_DATA("MID")));
    }

    CTF_TEST_NAME("authorization_test2");
    code = authorize(CTF_TEST_DATA("LOGIN"), CTF_TEST_DATA("LOGIN"));
        CTF_CHECK(code == 1);
}

CTF_TEST_CASE(parser_test){
    CTF_TEST_NAME("parser_new_messages_test");
    g_debug("TEST = %d",TEST );
    char* json = NULL;
    int nm = 0;
    nm = parser_new_messages(CTF_TEST_DATA("JSON_NEW_MESSAGES")); 
    CTF_CHECK(nm == 21);   

    CTF_TEST_NAME("parser_friends_test");
    xmlNodePtr rootNode, node;
    xmlDocPtr doc;
    doc = xmlNewDoc(BAD_CAST g_strdup("1.0"));
    rootNode = xmlNewDocNode(doc, NULL,  "Response", NULL);
    xmlDocSetRootElement(doc, rootNode);

    xmlSetProp(rootNode, CLASS, "friends");
    xmlSetProp(rootNode, FUNCTION, "updateListFriends");

    node = xmlNewDocNode(doc, NULL,   PARAMS,  NULL);
    xmlAddChild(rootNode, node);

    nm = parser_friends(JSON1,doc);
    CTF_CHECK(nm == 4);   
}
CTF_TEST_CASE(set_events_test){
    CTF_TEST_NAME("set_events_test");
     //g_type_init();
     msa_module_disp*  module;
     if (kernel_initialization() != 1) {
         module = malloc(sizeof(msa_module_disp));
         module->msa_mod = malloc(sizeof(msa_module));
         module->msa_mod->id = g_strdup_printf("vkontakte");
         module->msa_mod->type = DRIVER;
         module->msa_mod->set_events = handler_put_data;
         msa_module_init(module->msa_mod);
         g_debug("test");
         CTF_CHECK(init_event_manager(10) == 0);
     }
}



