#define CTF_LOG_FORMAT_USE_TIME
#define CTF_THROW_EXIT

#include "../CTF/src/ctf.h"

#include <gconf/gconf-client.h>
#include <glib.h>
#include "db/db_xml_functions.h"



GLOBAL_DECL();

CTF_TEST_DATA_FILE_NAME_DECL;
CTF_STAT_FILE_NAME_DECL;




CTF_TEST_CASE(db_get_nodeset_test) {

    CTF_TEST_NAME("db_get_nodeset_test");

    xmlDocPtr test_data = xmlParseDoc("<?xml version=\"1.0\"?><root><node /><node /><node /></root>");

    xmlXPathObjectPtr result =  db_get_nodeset(test_data, "//root/*", NULL);

    CTF_CHECK(result->nodesetval->nodeNr == 3);
    xmlNodeSetPtr nodeset = result->nodesetval;
    CTF_CHECK(!strcmp(nodeset->nodeTab[0]->name, "node"));
    CTF_CHECK(!strcmp(nodeset->nodeTab[1]->name, "node"));    
    CTF_CHECK(!strcmp(nodeset->nodeTab[2]->name, "node"));        


    CTF_TEST_NAME("db_get_nodeset_test(bad xpath)");

    test_data = xmlParseDoc("<?xml version=\"1.0\"?><root><node /><node /><node /></root>");

    result =  db_get_nodeset(test_data, "//rot/*", NULL);
    CTF_CHECK(result == NULL);

    CTF_TEST_NAME("db_get_nodeset_test(bad xpath)");

    test_data = xmlParseDoc("<?xml version=\"1.0\"?><root><node /><node /><node /></root>");
    result =  db_get_nodeset(test_data, "", NULL);
    CTF_CHECK(result == NULL);

    CTF_TEST_NAME("db_get_nodeset_test(xpath = NULL)");

    test_data = xmlParseDoc("<?xml version=\"1.0\"?><root><node /><node /><node /></root>");
    result =  db_get_nodeset(test_data, NULL, NULL);
    CTF_CHECK(result == NULL);

    CTF_TEST_NAME("db_get_nodeset_test(bad doc)");

    test_data = xmlParseDoc("<?xml version=\"1.0\"?><root>");
    result =  db_get_nodeset(test_data, "//root/*", NULL);
    CTF_CHECK(result == NULL);


    CTF_TEST_NAME("db_get_nodeset_test(bad doc)");

    test_data = xmlParseDoc("<?xml version=\"1.0\"?>");
    result =  db_get_nodeset(test_data, "//root/*", NULL);
    CTF_CHECK(result == NULL);

    CTF_TEST_NAME("db_get_nodeset_test(doc = NULL)");

    test_data = xmlParseDoc("<?xml version=\"1.0\"?><root>");
    result =  db_get_nodeset(NULL, "//root/*", NULL);
    CTF_CHECK(result == NULL);

}


CTF_TEST_CASE(db_check_nodes_equals_test) {

    CTF_TEST_NAME("db_check_nodes_equals_test");

    xmlNsPtr xmlNs1 = xmlNewNs(NULL, "http://one.ru", "pref1");
    xmlNodePtr node1 = xmlNewNode(xmlNs1, "node1");

    xmlNsPtr xmlNs2 = xmlNewNs(NULL, "http://one.ru", "pref1");
    xmlNodePtr node2 = xmlNewNode(xmlNs2, "node1");

    CTF_CHECK(db_check_nodes_equals(node1, node2, TRUE, TRUE) == TRUE);        

    CTF_TEST_NAME("db_check_nodes_equals_test");

    xmlNs1 = xmlNewNs(NULL, "http://one.ru", "pref1");
    node1 = xmlNewNode(xmlNs1, "node1");

    xmlNs2 = xmlNewNs(NULL, "http://one.ru", "pref1");
    node2 = xmlNewNode(xmlNs2, "node2");

    CTF_CHECK(db_check_nodes_equals(node1, node2, TRUE, TRUE) == FALSE);        



    CTF_TEST_NAME("db_check_nodes_equals_test(different prefixes)");

    xmlNs1 = xmlNewNs(NULL, "http://one.ru", "pref1");
    node1 = xmlNewNode(xmlNs1, "node1");

    xmlNs2 = xmlNewNs(NULL, "http://one.ru", "pref2");
    node2 = xmlNewNode(xmlNs2, "node1");

    CTF_CHECK(db_check_nodes_equals(node1, node2, TRUE, TRUE) == FALSE);        
    CTF_CHECK(db_check_nodes_equals(node1, node2, TRUE, FALSE) == TRUE);        


    CTF_TEST_NAME("db_check_nodes_equals_test(different ns)");

    xmlNs1 = xmlNewNs(NULL, "http://one1.ru", "pref1");
    node1 = xmlNewNode(xmlNs1, "node1");

    xmlNs2 = xmlNewNs(NULL, "http://one2.ru", "pref1");
    node2 = xmlNewNode(xmlNs2, "node1");

    CTF_CHECK(db_check_nodes_equals(node1, node2, TRUE, TRUE) == FALSE);        
    CTF_CHECK(db_check_nodes_equals(node1, node2, FALSE, TRUE) == TRUE);        


    CTF_TEST_NAME("db_check_nodes_equals_test(check NULL)");

    CTF_CHECK(db_check_nodes_equals(node1, NULL, FALSE, FALSE) == FALSE);
    CTF_CHECK(db_check_nodes_equals(NULL, NULL, FALSE, FALSE) == TRUE);                    
}


CTF_TEST_CASE(db_check_ns_equals_test) {

    CTF_TEST_NAME("db_ns_nodes_equals_test");

    xmlNsPtr xmlNs1 = xmlNewNs(NULL, "http://one.ru", "pref1");
    xmlNsPtr xmlNs2 = xmlNewNs(NULL, "http://one.ru", "pref1");
    CTF_CHECK(db_check_ns_equals(xmlNs1, xmlNs2, TRUE) == TRUE);
    

    CTF_TEST_NAME("db_check_ns_equals_test");
    xmlNs1 = xmlNewNs(NULL, "http://one.ru1", "pref1");
    xmlNs2 = xmlNewNs(NULL, "http://one.ru", "pref1");
    CTF_CHECK(db_check_ns_equals(xmlNs1, xmlNs2, TRUE) == FALSE);    


    CTF_TEST_NAME("db_check_ns_equals_test(different prefixes)");
    xmlNs1 = xmlNewNs(NULL, "http://one.ru", "pref1");
    xmlNs2 = xmlNewNs(NULL, "http://one.ru", "pref2");
    CTF_CHECK(db_check_ns_equals(xmlNs1, xmlNs2, TRUE) == FALSE);        
    CTF_CHECK(db_check_ns_equals(xmlNs1, xmlNs2, FALSE) == TRUE);        


    CTF_TEST_NAME("db_check_ns_equals_test(check NULL)");
    CTF_CHECK(db_check_ns_equals(xmlNs1, NULL, TRUE) == FALSE);        
    CTF_CHECK(db_check_ns_equals(NULL, NULL, FALSE) == TRUE);        
}





CTF_TEST_CASE(db_remove_node_by_xpath_test) {

    CTF_TEST_NAME("db_remove_node_by_xpath_test");

    xmlDocPtr test_data = xmlParseDoc("<?xml version=\"1.0\"?><root><node /><node /><node /></root>");

    db_remove_node_by_xpath(test_data, "//root/*", NULL);
    xmlXPathObjectPtr result =  db_get_nodeset(test_data, "//root/*", NULL);
    CTF_CHECK(result == NULL);


    CTF_TEST_NAME("db_remove_node_by_xpath_test");
    test_data = xmlParseDoc("<?xml version=\"1.0\"?><root><node /><node /><node /></root>");

    db_remove_node_by_xpath(test_data, "//rot/*", NULL);
    result =  db_get_nodeset(test_data, "//root/*", NULL);
    CTF_CHECK(result->nodesetval->nodeNr == 3);


    CTF_TEST_NAME("db_remove_node_by_xpath_test(xpath = NULL)");
    test_data = xmlParseDoc("<?xml version=\"1.0\"?><root><node /><node /><node /></root>");

    db_remove_node_by_xpath(test_data, NULL, NULL);
    result =  db_get_nodeset(test_data, "//root/*", NULL);
    CTF_CHECK(result->nodesetval->nodeNr == 3);


    CTF_TEST_NAME("db_remove_node_by_xpath_test(bad xpath)");
    test_data = xmlParseDoc("<?xml version=\"1.0\"?><root><node /><node /><node /></root>");

    db_remove_node_by_xpath(test_data, "", NULL);
    result =  db_get_nodeset(test_data, "//root/*", NULL);
    CTF_CHECK(result->nodesetval->nodeNr == 3);


}




CTF_TEST_CASE(db_get_nodes_count_test) {

    CTF_TEST_NAME("db_get_nodes_count_test_test");

    xmlDocPtr test_data = xmlParseDoc("<?xml version=\"1.0\"?><root><node /><node /><node /></root>");
    int count = db_get_nodes_count(test_data, "//root/*", NULL);
    CTF_CHECK(count == 3);

    count = db_get_nodes_count(test_data, "//rot/*", NULL);
    CTF_CHECK(count == 0);

    CTF_TEST_NAME("db_get_nodes_count_test_test(incorrect xpath)");
    count = db_get_nodes_count(test_data, NULL, NULL);
    CTF_CHECK(count == 0);
    
    count = db_get_nodes_count(test_data, "", NULL);
    CTF_CHECK(count == 0);

    CTF_TEST_NAME("db_get_nodes_count_test_test(incorrect doc)");
    test_data = xmlParseDoc("<?xml version=\"1.0\"?>");
    count = db_get_nodes_count(test_data, "//root/*", NULL);
    CTF_CHECK(count == 0);

    CTF_TEST_NAME("db_get_nodes_count_test_test(incorrect doc)");
    test_data = xmlParseDoc("<?xml version=\"1.0\"?><root>");
    count = db_get_nodes_count(test_data, "//root/*", NULL);
    CTF_CHECK(count == 0);

    CTF_TEST_NAME("db_get_nodes_count_test_test(doc = NULL)");
    count = db_get_nodes_count(NULL, "//root/*", NULL);
    CTF_CHECK(count == 0);

}

